/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.util.configuration;

import java.lang.invoke.MethodHandles;
import java.util.List;
import org.apache.solr.common.StringUtils;
import org.apache.solr.util.configuration.SSLCredentialProvider;
import org.apache.solr.util.configuration.SSLCredentialProviderFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SSLConfigurations {
    public static final String DEFAULT_STORE_PASSWORD = "secret";
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    protected final List<SSLCredentialProvider> credentialProviders;

    public SSLConfigurations(SSLCredentialProviderFactory sslCredentialProviderFactory) {
        this.credentialProviders = sslCredentialProviderFactory.getProviders();
    }

    public SSLConfigurations(List<SSLCredentialProvider> credentialProviders) {
        this.credentialProviders = credentialProviders;
    }

    public void init() {
        String clientKeystorePassword = this.getClientKeyStorePassword();
        String keystorePassword = this.getKeyStorePassword();
        String clientTruststorePassword = this.getClientTrustStorePassword();
        String truststorePassword = this.getTrustStorePassword();
        if (!(!this.isEmpty(System.getProperty("javax.net.ssl.keyStorePassword")) || this.isEmpty(clientKeystorePassword) && this.isEmpty(keystorePassword))) {
            log.info("Setting {}", (Object)"javax.net.ssl.keyStorePassword");
            System.setProperty("javax.net.ssl.keyStorePassword", clientKeystorePassword != null ? clientKeystorePassword : keystorePassword);
        }
        if (!(!this.isEmpty(System.getProperty("javax.net.ssl.trustStorePassword")) || this.isEmpty(clientTruststorePassword) && this.isEmpty(truststorePassword))) {
            log.info("Setting {}", (Object)"javax.net.ssl.trustStorePassword");
            System.setProperty("javax.net.ssl.trustStorePassword", clientTruststorePassword != null ? clientTruststorePassword : truststorePassword);
        }
    }

    public String getKeyStorePassword() {
        String keyStorePassword = this.getPassword(SSLCredentialProvider.CredentialType.SSL_KEY_STORE_PASSWORD);
        return keyStorePassword;
    }

    public String getTrustStorePassword() {
        String trustStorePassword = this.getPassword(SSLCredentialProvider.CredentialType.SSL_TRUST_STORE_PASSWORD);
        return trustStorePassword;
    }

    public String getClientKeyStorePassword() {
        String keyStorePassword = this.getPassword(SSLCredentialProvider.CredentialType.SSL_CLIENT_KEY_STORE_PASSWORD);
        return keyStorePassword;
    }

    public String getClientTrustStorePassword() {
        String trustStorePassword = this.getPassword(SSLCredentialProvider.CredentialType.SSL_CLIENT_TRUST_STORE_PASSWORD);
        return trustStorePassword;
    }

    protected String getPassword(SSLCredentialProvider.CredentialType type) {
        for (SSLCredentialProvider provider : this.credentialProviders) {
            String credential = provider.getCredential(type);
            if (credential == null) continue;
            return credential;
        }
        return null;
    }

    private boolean isEmpty(String str) {
        return StringUtils.isEmpty((String)str);
    }

    public static class SysProps {
        public static final String SSL_KEY_STORE_PASSWORD = "solr.jetty.keystore.password";
        public static final String SSL_TRUST_STORE_PASSWORD = "solr.jetty.truststore.password";
        public static final String SSL_CLIENT_KEY_STORE_PASSWORD = "javax.net.ssl.keyStorePassword";
        public static final String SSL_CLIENT_TRUST_STORE_PASSWORD = "javax.net.ssl.trustStorePassword";
    }
}

