/*
 * Decompiled with CFR 0.152.
 */
package org.rrd4j.data;

import java.util.ArrayList;
import java.util.Arrays;
import org.rrd4j.data.Aggregates;

class Aggregator {
    private final long[] timestamps;
    private final long step;
    private final double[] values;

    Aggregator(long[] timestamps, double[] values) {
        assert (timestamps.length == values.length) : "Incompatible timestamps/values arrays (unequal lengths)";
        assert (timestamps.length >= 2) : "At least two timestamps must be supplied";
        this.timestamps = timestamps;
        this.values = values;
        this.step = timestamps[1] - timestamps[0];
    }

    @Deprecated
    Aggregates getAggregates(long tStart, long tEnd) {
        Aggregates agg = new Aggregates();
        long totalSeconds = 0L;
        int cnt = 0;
        for (int i = 0; i < this.timestamps.length; ++i) {
            double value;
            long left = Math.max(this.timestamps[i] - this.step, tStart);
            long right = Math.min(this.timestamps[i], tEnd);
            long delta = right - left;
            if (delta <= 0L || Double.isNaN(value = this.values[i])) continue;
            totalSeconds += delta;
            if (++cnt == 1) {
                agg.min = agg.max = value;
                agg.total = agg.max;
                agg.first = agg.max;
                agg.last = agg.max;
                continue;
            }
            if (delta >= this.step) {
                agg.last = value;
            }
            agg.min = Math.min(agg.min, value);
            agg.max = Math.max(agg.max, value);
            agg.total += value;
        }
        if (cnt > 0) {
            agg.average = agg.total / (double)totalSeconds;
        }
        return agg;
    }

    double getPercentile(long tStart, long tEnd, double percentile) {
        ArrayList<Double> valueList = new ArrayList<Double>();
        for (int i = 0; i < this.timestamps.length; ++i) {
            long left = Math.max(this.timestamps[i] - this.step, tStart);
            long right = Math.min(this.timestamps[i], tEnd);
            if (right <= left || Double.isNaN(this.values[i])) continue;
            valueList.add(this.values[i]);
        }
        int count = valueList.size();
        if (count > 1) {
            double[] valuesCopy = new double[count];
            for (int i = 0; i < count; ++i) {
                valuesCopy[i] = (Double)valueList.get(i);
            }
            Arrays.sort(valuesCopy);
            double topPercentile = (100.0 - percentile) / 100.0;
            count -= (int)Math.ceil((double)count * topPercentile);
            if (count > 0) {
                return valuesCopy[count - 1];
            }
        }
        return Double.NaN;
    }
}

