/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.upgrade;

import java.util.function.BiConsumer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.action.Action;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.support.master.AcknowledgedResponse;
import org.elasticsearch.client.Client;
import org.elasticsearch.client.ParentTaskAssigningClient;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.ClusterStateTaskConfig;
import org.elasticsearch.cluster.ClusterStateUpdateTask;
import org.elasticsearch.cluster.block.ClusterBlocks;
import org.elasticsearch.cluster.metadata.IndexMetaData;
import org.elasticsearch.cluster.metadata.MetaData;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.index.IndexNotFoundException;
import org.elasticsearch.index.IndexSettings;
import org.elasticsearch.index.reindex.BulkByScrollResponse;
import org.elasticsearch.index.reindex.ReindexAction;
import org.elasticsearch.index.reindex.ReindexRequest;
import org.elasticsearch.script.Script;
import org.elasticsearch.tasks.TaskId;
import org.elasticsearch.transport.TransportResponse;
import org.elasticsearch.xpack.upgrade.Upgrade;

public class InternalIndexReindexer<T> {
    private static final Logger logger = LogManager.getLogger(InternalIndexReindexer.class);
    private final Client client;
    private final ClusterService clusterService;
    private final Script transformScript;
    private final String[] types;
    private final int version;
    private final BiConsumer<ClusterState, ActionListener<T>> preUpgrade;
    private final BiConsumer<T, ActionListener<TransportResponse.Empty>> postUpgrade;

    public InternalIndexReindexer(Client client, ClusterService clusterService, int version, Script transformScript, String[] types, BiConsumer<ClusterState, ActionListener<T>> preUpgrade, BiConsumer<T, ActionListener<TransportResponse.Empty>> postUpgrade) {
        this.client = client;
        this.clusterService = clusterService;
        this.transformScript = transformScript;
        this.types = types;
        this.version = version;
        this.preUpgrade = preUpgrade;
        this.postUpgrade = postUpgrade;
    }

    public void upgrade(TaskId task, String index, ClusterState clusterState, ActionListener<BulkByScrollResponse> listener) {
        ParentTaskAssigningClient parentAwareClient = new ParentTaskAssigningClient(this.client, task);
        this.preUpgrade.accept(clusterState, ActionListener.wrap(t -> this.innerUpgrade(parentAwareClient, index, clusterState, (ActionListener<BulkByScrollResponse>)ActionListener.wrap(response -> this.postUpgrade.accept(t, (ActionListener<TransportResponse.Empty>)ActionListener.wrap(empty -> listener.onResponse(response), arg_0 -> ((ActionListener)listener).onFailure(arg_0))), arg_0 -> ((ActionListener)listener).onFailure(arg_0))), arg_0 -> listener.onFailure(arg_0)));
    }

    private void innerUpgrade(ParentTaskAssigningClient parentAwareClient, String index, ClusterState clusterState, ActionListener<BulkByScrollResponse> listener) {
        String newIndex = index + "-" + this.version;
        logger.trace("upgrading index {} to new index {}", (Object)index, (Object)newIndex);
        try {
            this.checkMasterAndDataNodeVersion(clusterState);
            parentAwareClient.admin().indices().prepareCreate(newIndex).execute(ActionListener.wrap(createIndexResponse -> this.setReadOnlyBlock(index, (ActionListener<TransportResponse.Empty>)ActionListener.wrap(setReadOnlyResponse -> this.reindex(parentAwareClient, index, newIndex, (ActionListener<BulkByScrollResponse>)ActionListener.wrap(bulkByScrollResponse -> {
                if (bulkByScrollResponse.getBulkFailures() != null && !bulkByScrollResponse.getBulkFailures().isEmpty() || bulkByScrollResponse.getSearchFailures() != null && !bulkByScrollResponse.getSearchFailures().isEmpty()) {
                    ElasticsearchException ex = this.logAndThrowExceptionForFailures((BulkByScrollResponse)bulkByScrollResponse);
                    this.removeReadOnlyBlockOnReindexFailure(parentAwareClient, index, listener, (Exception)ex);
                } else {
                    this.removeReadOnlyBlock(parentAwareClient, index, (ActionListener<AcknowledgedResponse>)ActionListener.wrap(unsetReadOnlyResponse -> parentAwareClient.admin().indices().prepareAliases().removeIndex(index).addAlias(newIndex, index).execute(ActionListener.wrap(deleteIndexResponse -> listener.onResponse(bulkByScrollResponse), arg_0 -> ((ActionListener)listener).onFailure(arg_0))), arg_0 -> ((ActionListener)listener).onFailure(arg_0)));
                }
            }, e -> {
                logger.error("error occurred while reindexing", (Throwable)e);
                this.removeReadOnlyBlockOnReindexFailure(parentAwareClient, index, listener, (Exception)e);
            })), arg_0 -> ((ActionListener)listener).onFailure(arg_0))), arg_0 -> listener.onFailure(arg_0)));
        }
        catch (Exception ex) {
            logger.error("error occurred while upgrading index", (Throwable)ex);
            this.removeReadOnlyBlockOnReindexFailure(parentAwareClient, index, listener, ex);
            listener.onFailure(ex);
        }
    }

    private void removeReadOnlyBlockOnReindexFailure(ParentTaskAssigningClient parentAwareClient, String index, ActionListener<BulkByScrollResponse> listener, Exception ex) {
        this.removeReadOnlyBlock(parentAwareClient, index, (ActionListener<AcknowledgedResponse>)ActionListener.wrap(unsetReadOnlyResponse -> listener.onFailure(ex), e1 -> listener.onFailure(ex)));
    }

    private ElasticsearchException logAndThrowExceptionForFailures(BulkByScrollResponse bulkByScrollResponse) {
        String bulkFailures = bulkByScrollResponse.getBulkFailures() != null ? Strings.collectionToCommaDelimitedString((Iterable)bulkByScrollResponse.getBulkFailures()) : "";
        String searchFailures = bulkByScrollResponse.getSearchFailures() != null ? Strings.collectionToCommaDelimitedString((Iterable)bulkByScrollResponse.getSearchFailures()) : "";
        logger.error("error occurred while reindexing, bulk failures [{}], search failures [{}]", (Object)bulkFailures, (Object)searchFailures);
        return new ElasticsearchException("error occurred while reindexing, bulk failures [{}], search failures [{}]", new Object[]{bulkFailures, searchFailures});
    }

    private void checkMasterAndDataNodeVersion(ClusterState clusterState) {
        if (clusterState.nodes().getMinNodeVersion().before(Upgrade.UPGRADE_INTRODUCED)) {
            throw new IllegalStateException("All nodes should have at least version [" + Upgrade.UPGRADE_INTRODUCED + "] to upgrade");
        }
    }

    private void removeReadOnlyBlock(ParentTaskAssigningClient parentAwareClient, String index, ActionListener<AcknowledgedResponse> listener) {
        Settings settings = Settings.builder().put(IndexMetaData.INDEX_READ_ONLY_SETTING.getKey(), false).build();
        parentAwareClient.admin().indices().prepareUpdateSettings(new String[]{index}).setSettings(settings).execute(listener);
    }

    private void reindex(ParentTaskAssigningClient parentAwareClient, String index, String newIndex, ActionListener<BulkByScrollResponse> listener) {
        ReindexRequest reindexRequest = new ReindexRequest();
        reindexRequest.setSourceIndices(new String[]{index});
        reindexRequest.setSourceDocTypes(this.types);
        reindexRequest.setDestIndex(newIndex);
        reindexRequest.setRefresh(true);
        reindexRequest.setScript(this.transformScript);
        parentAwareClient.execute((Action)ReindexAction.INSTANCE, (ActionRequest)reindexRequest, listener);
    }

    private void setReadOnlyBlock(final String index, final ActionListener<TransportResponse.Empty> listener) {
        this.clusterService.submitStateUpdateTask("lock-index-for-upgrade", (ClusterStateTaskConfig)new ClusterStateUpdateTask(){

            public ClusterState execute(ClusterState currentState) throws Exception {
                IndexMetaData indexMetaData = currentState.metaData().index(index);
                if (indexMetaData == null) {
                    throw new IndexNotFoundException(index);
                }
                if (indexMetaData.getState() != IndexMetaData.State.OPEN) {
                    throw new IllegalStateException("unable to upgrade a closed index[" + index + "]");
                }
                if (currentState.blocks().hasIndexBlock(index, IndexMetaData.INDEX_READ_ONLY_BLOCK)) {
                    throw new IllegalStateException("unable to upgrade a read-only index[" + index + "]");
                }
                Settings indexSettingsBuilder = Settings.builder().put(indexMetaData.getSettings()).put(IndexMetaData.INDEX_READ_ONLY_SETTING.getKey(), true).build();
                IndexMetaData.Builder builder = IndexMetaData.builder((IndexMetaData)indexMetaData).settings(indexSettingsBuilder);
                assert (!IndexSettings.same((Settings)indexMetaData.getSettings(), (Settings)indexSettingsBuilder));
                builder.settingsVersion(1L + builder.settingsVersion());
                MetaData.Builder metaDataBuilder = MetaData.builder((MetaData)currentState.metaData()).put(builder);
                ClusterBlocks.Builder blocks = ClusterBlocks.builder().blocks(currentState.blocks()).addIndexBlock(index, IndexMetaData.INDEX_READ_ONLY_BLOCK);
                return ClusterState.builder((ClusterState)currentState).metaData(metaDataBuilder).blocks(blocks).build();
            }

            public void onFailure(String source, Exception e) {
                listener.onFailure(e);
            }

            public void clusterStateProcessed(String source, ClusterState oldState, ClusterState newState) {
                listener.onResponse((Object)TransportResponse.Empty.INSTANCE);
            }
        });
    }
}

