/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.watcher;

import java.io.IOException;
import java.time.Clock;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.elasticsearch.ElasticsearchParseException;
import org.elasticsearch.cluster.ClusterChangedEvent;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.ClusterStateListener;
import org.elasticsearch.cluster.block.ClusterBlockLevel;
import org.elasticsearch.cluster.metadata.IndexMetaData;
import org.elasticsearch.cluster.routing.AllocationId;
import org.elasticsearch.cluster.routing.IndexRoutingTable;
import org.elasticsearch.cluster.routing.Murmur3HashFunction;
import org.elasticsearch.cluster.routing.RoutingNode;
import org.elasticsearch.cluster.routing.ShardRouting;
import org.elasticsearch.cluster.routing.ShardRoutingState;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.component.AbstractComponent;
import org.elasticsearch.common.util.set.Sets;
import org.elasticsearch.common.xcontent.XContentType;
import org.elasticsearch.index.engine.Engine;
import org.elasticsearch.index.shard.IndexingOperationListener;
import org.elasticsearch.index.shard.ShardId;
import org.elasticsearch.xpack.core.watcher.watch.Watch;
import org.elasticsearch.xpack.watcher.WatcherLifeCycleService;
import org.elasticsearch.xpack.watcher.trigger.TriggerService;
import org.elasticsearch.xpack.watcher.watch.WatchParser;
import org.elasticsearch.xpack.watcher.watch.WatchStoreUtils;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;

final class WatcherIndexingListener
extends AbstractComponent
implements IndexingOperationListener,
ClusterStateListener {
    static final Configuration INACTIVE = new Configuration(null, Collections.emptyMap());
    private final WatchParser parser;
    private final Clock clock;
    private final TriggerService triggerService;
    private volatile Configuration configuration = INACTIVE;

    WatcherIndexingListener(WatchParser parser, Clock clock, TriggerService triggerService) {
        this.parser = parser;
        this.clock = clock;
        this.triggerService = triggerService;
    }

    Configuration getConfiguration() {
        return this.configuration;
    }

    void setConfiguration(Configuration configuration) {
        this.configuration = configuration;
    }

    public Engine.Index preIndex(ShardId shardId, Engine.Index operation) {
        if (this.isWatchDocument(shardId.getIndexName(), operation.type())) {
            DateTime now = new DateTime(this.clock.millis(), DateTimeZone.UTC);
            try {
                Watch watch = this.parser.parseWithSecrets(operation.id(), true, operation.source(), now, XContentType.JSON, operation.getIfSeqNo(), operation.getIfPrimaryTerm());
                watch.version(operation.version());
                ShardAllocationConfiguration shardAllocationConfiguration = this.configuration.localShards.get(shardId);
                if (shardAllocationConfiguration == null) {
                    this.logger.debug("no distributed watch execution info found for watch [{}] on shard [{}], got configuration for {}", (Object)watch.id(), (Object)shardId, this.configuration.localShards.keySet());
                    return operation;
                }
                boolean shouldBeTriggered = shardAllocationConfiguration.shouldBeTriggered(watch.id());
                if (shouldBeTriggered) {
                    if (watch.status().state().isActive()) {
                        this.logger.debug("adding watch [{}] to trigger service", (Object)watch.id());
                        this.triggerService.add(watch);
                    } else {
                        this.logger.debug("removing watch [{}] to trigger service", (Object)watch.id());
                        this.triggerService.remove(watch.id());
                    }
                } else {
                    this.logger.debug("watch [{}] should not be triggered", (Object)watch.id());
                }
            }
            catch (IOException e) {
                throw new ElasticsearchParseException("Could not parse watch with id [{}]", (Throwable)e, new Object[]{operation.id()});
            }
        }
        return operation;
    }

    public void postIndex(ShardId shardId, Engine.Index index, Exception ex) {
        if (this.isWatchDocument(shardId.getIndexName(), index.type())) {
            this.logger.debug(() -> new ParameterizedMessage("removing watch [{}] from trigger", (Object)index.id()), (Throwable)ex);
            this.triggerService.remove(index.id());
        }
    }

    public Engine.Delete preDelete(ShardId shardId, Engine.Delete delete) {
        if (this.isWatchDocument(shardId.getIndexName(), delete.type())) {
            this.triggerService.remove(delete.id());
        }
        return delete;
    }

    private boolean isWatchDocument(String index, String docType) {
        return this.configuration.isIndexAndActive(index) && docType.equals("doc");
    }

    public void clusterChanged(ClusterChangedEvent event) {
        block7: {
            boolean isWatchExecutionDistributed = WatcherLifeCycleService.isWatchExecutionDistributed(event.state());
            if (isWatchExecutionDistributed) {
                if (Strings.isNullOrEmpty((String)event.state().nodes().getMasterNodeId()) || event.state().getBlocks().hasGlobalBlockWithLevel(ClusterBlockLevel.WRITE)) {
                    this.configuration = INACTIVE;
                    return;
                }
                if (event.state().nodes().getLocalNode().isDataNode() && event.metaDataChanged()) {
                    try {
                        IndexMetaData metaData = WatchStoreUtils.getConcreteIndex(".watches", event.state().metaData());
                        if (metaData == null) {
                            this.configuration = INACTIVE;
                            break block7;
                        }
                        this.checkWatchIndexHasChanged(metaData, event);
                    }
                    catch (IllegalStateException e) {
                        this.logger.error("error loading watches index: [{}]", (Object)e.getMessage());
                        this.configuration = INACTIVE;
                    }
                }
            } else {
                this.configuration = INACTIVE;
            }
        }
    }

    private void checkWatchIndexHasChanged(IndexMetaData metaData, ClusterChangedEvent event) {
        String watchIndex = metaData.getIndex().getName();
        ClusterState state = event.state();
        String localNodeId = state.nodes().getLocalNode().getId();
        RoutingNode routingNode = state.getRoutingNodes().node(localNodeId);
        List localShardRouting = routingNode.shardsWithState(watchIndex, new ShardRoutingState[]{ShardRoutingState.STARTED, ShardRoutingState.RELOCATING});
        if (localShardRouting.isEmpty()) {
            this.configuration = INACTIVE;
        } else {
            this.reloadConfiguration(watchIndex, localShardRouting, event);
        }
    }

    private void reloadConfiguration(String watchIndex, List<ShardRouting> localShardRouting, ClusterChangedEvent event) {
        boolean isAliasChanged;
        boolean bl = isAliasChanged = !watchIndex.equals(this.configuration.index);
        if (isAliasChanged || this.hasShardAllocationIdChanged(watchIndex, event.state())) {
            IndexRoutingTable watchIndexRoutingTable = event.state().routingTable().index(watchIndex);
            Map<ShardId, ShardAllocationConfiguration> ids = this.getLocalShardAllocationIds(localShardRouting, watchIndexRoutingTable);
            this.configuration = new Configuration(watchIndex, ids);
        }
    }

    private boolean hasShardAllocationIdChanged(String watchIndex, ClusterState state) {
        HashSet<ShardId> configuredLocalShardIds;
        List allStartedRelocatedShards = state.getRoutingTable().index(watchIndex).shardsWithState(ShardRoutingState.STARTED);
        allStartedRelocatedShards.addAll(state.getRoutingTable().index(watchIndex).shardsWithState(ShardRoutingState.RELOCATING));
        if (!allStartedRelocatedShards.isEmpty() && this.configuration == INACTIVE) {
            return true;
        }
        String localNodeId = state.nodes().getLocalNodeId();
        Set clusterStateLocalShardIds = state.getRoutingNodes().node(localNodeId).shardsWithState(watchIndex, new ShardRoutingState[]{ShardRoutingState.STARTED, ShardRoutingState.RELOCATING}).stream().map(ShardRouting::shardId).collect(Collectors.toSet());
        Set differenceSet = Sets.difference(clusterStateLocalShardIds, configuredLocalShardIds = new HashSet<ShardId>(this.configuration.localShards.keySet()));
        if (!differenceSet.isEmpty()) {
            return true;
        }
        Map<ShardId, List> shards = allStartedRelocatedShards.stream().collect(Collectors.groupingBy(ShardRouting::shardId, Collectors.mapping(sr -> sr.allocationId().getId(), Collectors.toCollection(ArrayList::new))));
        shards.values().forEach(Collections::sort);
        for (Map.Entry<ShardId, ShardAllocationConfiguration> entry : this.configuration.localShards.entrySet()) {
            if (!shards.containsKey(entry.getKey())) {
                return true;
            }
            Collection allocationIds = shards.get(entry.getKey());
            if (allocationIds.equals(entry.getValue().allocationIds)) continue;
            return true;
        }
        return false;
    }

    Map<ShardId, ShardAllocationConfiguration> getLocalShardAllocationIds(List<ShardRouting> localShards, IndexRoutingTable routingTable) {
        HashMap<ShardId, ShardAllocationConfiguration> data = new HashMap<ShardId, ShardAllocationConfiguration>(localShards.size());
        for (ShardRouting shardRouting : localShards) {
            ShardId shardId = shardRouting.shardId();
            List<String> allocationIds = routingTable.shard(shardId.getId()).getActiveShards().stream().map(ShardRouting::allocationId).map(AllocationId::getId).collect(Collectors.toList());
            Collections.sort(allocationIds);
            String allocationId = shardRouting.allocationId().getId();
            int idx = allocationIds.indexOf(allocationId);
            data.put(shardId, new ShardAllocationConfiguration(idx, allocationIds.size(), allocationIds));
        }
        return data;
    }

    static final class ShardAllocationConfiguration {
        final int index;
        final int shardCount;
        final List<String> allocationIds;

        ShardAllocationConfiguration(int index, int shardCount, List<String> allocationIds) {
            this.index = index;
            this.shardCount = shardCount;
            this.allocationIds = allocationIds;
        }

        public boolean shouldBeTriggered(String id) {
            int hash = Murmur3HashFunction.hash((String)id);
            int shardIndex = Math.floorMod(hash, this.shardCount);
            return shardIndex == this.index;
        }
    }

    static final class Configuration {
        final Map<ShardId, ShardAllocationConfiguration> localShards;
        final boolean active;
        final String index;

        Configuration(String index, Map<ShardId, ShardAllocationConfiguration> localShards) {
            this.active = !localShards.isEmpty();
            this.index = index;
            this.localShards = Collections.unmodifiableMap(localShards);
        }

        public boolean isIndexAndActive(String index) {
            return this.active && index.equals(this.index);
        }
    }
}

