/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml.datafeed.extractor.chunked;

import java.util.Objects;
import org.elasticsearch.client.Client;
import org.elasticsearch.common.xcontent.NamedXContentRegistry;
import org.elasticsearch.xpack.core.ml.datafeed.DatafeedConfig;
import org.elasticsearch.xpack.core.ml.datafeed.extractor.DataExtractor;
import org.elasticsearch.xpack.core.ml.job.config.Job;
import org.elasticsearch.xpack.core.ml.utils.Intervals;
import org.elasticsearch.xpack.ml.datafeed.extractor.DataExtractorFactory;
import org.elasticsearch.xpack.ml.datafeed.extractor.chunked.ChunkedDataExtractor;
import org.elasticsearch.xpack.ml.datafeed.extractor.chunked.ChunkedDataExtractorContext;

public class ChunkedDataExtractorFactory
implements DataExtractorFactory {
    private final Client client;
    private final DatafeedConfig datafeedConfig;
    private final Job job;
    private final DataExtractorFactory dataExtractorFactory;
    private final NamedXContentRegistry xContentRegistry;

    public ChunkedDataExtractorFactory(Client client, DatafeedConfig datafeedConfig, Job job, NamedXContentRegistry xContentRegistry, DataExtractorFactory dataExtractorFactory) {
        this.client = Objects.requireNonNull(client);
        this.datafeedConfig = Objects.requireNonNull(datafeedConfig);
        this.job = Objects.requireNonNull(job);
        this.dataExtractorFactory = Objects.requireNonNull(dataExtractorFactory);
        this.xContentRegistry = xContentRegistry;
    }

    @Override
    public DataExtractor newExtractor(long start, long end) {
        ChunkedDataExtractorContext.TimeAligner timeAligner = this.newTimeAligner();
        ChunkedDataExtractorContext dataExtractorContext = new ChunkedDataExtractorContext(this.job.getId(), this.job.getDataDescription().getTimeField(), this.datafeedConfig.getIndices(), this.datafeedConfig.getTypes(), this.datafeedConfig.getParsedQuery(this.xContentRegistry), this.datafeedConfig.getScrollSize(), timeAligner.alignToCeil(start), timeAligner.alignToFloor(end), this.datafeedConfig.getChunkingConfig().getTimeSpan(), timeAligner, this.datafeedConfig.getHeaders(), this.datafeedConfig.hasAggregations(), this.datafeedConfig.hasAggregations() ? Long.valueOf(this.datafeedConfig.getHistogramIntervalMillis(this.xContentRegistry)) : null);
        return new ChunkedDataExtractor(this.client, this.dataExtractorFactory, dataExtractorContext);
    }

    private ChunkedDataExtractorContext.TimeAligner newTimeAligner() {
        if (this.datafeedConfig.hasAggregations()) {
            return ChunkedDataExtractorFactory.newIntervalTimeAligner(this.datafeedConfig.getHistogramIntervalMillis(this.xContentRegistry));
        }
        return ChunkedDataExtractorFactory.newIdentityTimeAligner();
    }

    static ChunkedDataExtractorContext.TimeAligner newIdentityTimeAligner() {
        return new ChunkedDataExtractorContext.TimeAligner(){

            @Override
            public long alignToFloor(long value) {
                return value;
            }

            @Override
            public long alignToCeil(long value) {
                return value;
            }
        };
    }

    static ChunkedDataExtractorContext.TimeAligner newIntervalTimeAligner(final long interval) {
        return new ChunkedDataExtractorContext.TimeAligner(){

            @Override
            public long alignToFloor(long value) {
                return Intervals.alignToFloor((long)value, (long)interval);
            }

            @Override
            public long alignToCeil(long value) {
                return Intervals.alignToCeil((long)value, (long)interval);
            }
        };
    }
}

