/*
 * Decompiled with CFR 0.152.
 */
package net.sf.gogui.thumbnail;

import java.io.File;
import java.io.PrintStream;
import java.util.ArrayList;
import net.sf.gogui.thumbnail.Thumbnail;
import net.sf.gogui.utils.Options;
import net.sf.gogui.utils.StringUtils;
import net.sf.gogui.version.Version;

public final class Main {
    public static void main(String[] stringArray) {
        try {
            int n;
            Thumbnail thumbnail;
            String[] stringArray2 = new String[]{"config:", "help", "size:", "verbose", "version"};
            Options options = Options.parse(stringArray, stringArray2);
            if (options.isSet("help")) {
                Main.printUsage(System.out);
                System.exit(0);
            }
            if (options.isSet("version")) {
                System.out.println("SgfThumbnail " + Version.get());
                System.exit(0);
            }
            boolean bl = options.isSet("verbose");
            ArrayList arrayList = options.getArguments();
            if (arrayList.size() == 0 || arrayList.size() > 2) {
                Main.printUsage(System.err);
                System.exit(-1);
            }
            File file = new File((String)arrayList.get(0));
            File file2 = null;
            if (arrayList.size() == 2) {
                file2 = new File((String)arrayList.get(1));
            }
            if (!(thumbnail = new Thumbnail(bl)).create(file, file2, n = options.getInteger("size", 128, 1), true)) {
                System.err.println(thumbnail.getLastError());
                System.exit(-1);
            }
        }
        catch (Throwable throwable) {
            StringUtils.printException(throwable);
            System.exit(-1);
        }
    }

    private Main() {
    }

    private static void printUsage(PrintStream printStream) {
        String string = "Usage: java -jar sgfthumbnail.jar [options] input [output]\nOptions:\n-help         Print help and exit\n-verbose      Print logging messages to stderr\n-version      Print version and exit\n";
        printStream.print(string);
    }
}

