/*
 * Decompiled with CFR 0.152.
 */
package jd.core.process.analyzer.classfile.reconstructor;

import java.util.List;
import jd.core.model.instruction.bytecode.instruction.ALoad;
import jd.core.model.instruction.bytecode.instruction.DupLoad;
import jd.core.model.instruction.bytecode.instruction.DupStore;
import jd.core.model.instruction.bytecode.instruction.Instruction;
import jd.core.model.instruction.bytecode.instruction.MonitorEnter;
import jd.core.process.analyzer.classfile.visitor.ReplaceDupLoadVisitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DupStoreThisReconstructor {
    public static void Reconstruct(List<Instruction> list) {
        int dupStoreIndex = 0;
        while (dupStoreIndex < list.size()) {
            block5: {
                DupStore dupStore;
                block6: {
                    if (list.get((int)dupStoreIndex).opcode != 264) break block5;
                    dupStore = (DupStore)list.get(dupStoreIndex);
                    if (dupStore.objectref.opcode != 25 || ((ALoad)dupStore.objectref).index != 0) break block5;
                    if (dupStoreIndex + 2 >= list.size()) break block6;
                    Instruction instruction = list.get(dupStoreIndex + 2);
                    if (instruction.opcode != 194) break block6;
                    MonitorEnter me = (MonitorEnter)instruction;
                    if (me.objectref.opcode == 263 && ((DupLoad)me.objectref).dupStore == dupStore) break block5;
                }
                ReplaceDupLoadVisitor visitor = new ReplaceDupLoadVisitor(dupStore, dupStore.objectref);
                int length = list.size();
                int index = dupStoreIndex + 1;
                while (index < length) {
                    visitor.visit(list.get(index));
                    if (visitor.getParentFound() != null) break;
                    ++index;
                }
                visitor.init(dupStore, dupStore.objectref);
                while (index < length) {
                    visitor.visit(list.get(index));
                    if (visitor.getParentFound() != null) break;
                    ++index;
                }
                list.remove(dupStoreIndex--);
            }
            ++dupStoreIndex;
        }
    }
}

