/*
 * Decompiled with CFR 0.152.
 */
package lts;

import java.util.BitSet;
import java.util.Enumeration;
import java.util.Stack;
import java.util.Vector;
import lts.CompactState;
import lts.EventState;
import lts.LTSOutput;

public class ConnectedComponent {
    public static boolean fairFlag = true;
    private CompactState mach;
    private int[] val;
    private Stack stack;
    int id = 0;
    int ncomp = 0;
    LTSOutput output;
    int acceptLabel;
    boolean violation = false;

    public ConnectedComponent(CompactState compactState, LTSOutput lTSOutput) {
        this.mach = compactState;
        this.val = new int[this.mach.maxStates + 1];
        this.stack = new Stack();
        this.output = lTSOutput;
        this.acceptLabel = this.mach.acceptLabel();
        this.visitCC(0);
        if (!this.violation) {
            this.output.outln("No liveness property violations detected.");
        }
    }

    public int numberComponents() {
        return this.ncomp;
    }

    private int visitCC(int n) {
        int n2;
        this.val[n] = ++this.id;
        int n3 = n2 = this.id;
        this.stack.push(new Integer(n));
        if (this.mach.states[n] != null) {
            Enumeration enumeration = this.mach.states[n].elements();
            while (enumeration.hasMoreElements()) {
                EventState eventState = (EventState)enumeration.nextElement();
                if (eventState.next == -1) {
                    n3 = this.mach.maxStates + 1;
                } else {
                    int n4 = n3 = this.val[eventState.next] == 0 ? this.visitCC(eventState.next) : this.val[eventState.next];
                }
                if (n3 >= n2) continue;
                n2 = n3;
            }
        }
        if (n2 == this.val[n]) {
            ++this.ncomp;
            boolean bl = false;
            int n5 = 0;
            Stack stack = new Stack();
            do {
                stack.push(this.stack.pop());
                n3 = (Integer)stack.peek();
                ++n5;
                if (this.acceptLabel > 0 && !bl) {
                    bl = EventState.hasEvent(this.mach.states[n3], this.acceptLabel);
                }
                this.val[n3] = this.mach.maxStates + 1;
            } while (n3 != n);
            if (bl && (n5 > 1 || EventState.countStates(this.mach.states[n3], n3) > 1)) {
                if (fairFlag) {
                    if (this.terminalComponent(stack)) {
                        this.printCycle(stack);
                    }
                } else {
                    this.printCycle(stack);
                }
            }
        }
        return n2;
    }

    private boolean terminalComponent(Vector vector) {
        Object object;
        BitSet bitSet = new BitSet(this.mach.maxStates);
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            object = (Integer)enumeration.nextElement();
            bitSet.set((Integer)object);
        }
        object = vector.elements();
        while (object.hasMoreElements()) {
            int n = (Integer)object.nextElement();
            Enumeration enumeration2 = this.mach.states[n].elements();
            while (enumeration2.hasMoreElements()) {
                EventState eventState = (EventState)enumeration2.nextElement();
                if (bitSet.get(eventState.next)) continue;
                return false;
            }
        }
        return true;
    }

    private void printCycle(Stack stack) {
        int n;
        int n2;
        this.violation = true;
        this.output.outln("Violation of Liveness Property: " + this.mach.alphabet[this.acceptLabel]);
        int n3 = n2 = ((Integer)stack.pop()).intValue();
        this.printPath(n2, "path to Cycle:");
        this.output.outln("Cycle:");
        while (!stack.empty()) {
            n = EventState.toState(this.mach.states[n3], n2);
            if (n >= 0 && n != this.acceptLabel) {
                this.output.outln("\t" + this.mach.alphabet[n]);
                return;
            }
            int n4 = (Integer)stack.pop();
            n = EventState.toState(this.mach.states[n3], n4);
            if (n < 0) {
                this.output.outln("\t ...got lost!");
                return;
            }
            this.output.outln("\t" + this.mach.alphabet[n]);
            n3 = n4;
        }
        n = EventState.toState(this.mach.states[n3], n2);
        if (n >= 0) {
            this.output.outln("\t" + this.mach.alphabet[n]);
        } else {
            this.output.outln("\t ...got lost!");
        }
    }

    private void printPath(int n, String string) {
        EventState eventState = new EventState(0, 0);
        int n2 = EventState.search(eventState, this.mach.states, n, -99999);
        Vector vector = EventState.getPath(eventState.path, this.mach.alphabet);
        this.output.outln(string);
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            this.output.outln("\t" + (String)enumeration.nextElement());
        }
    }
}

