/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ic.doc.scenebeans;

import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.geom.Area;
import java.util.ArrayList;
import java.util.List;
import uk.ac.ic.doc.scenebeans.CompositeNode;
import uk.ac.ic.doc.scenebeans.PrimitiveBase;
import uk.ac.ic.doc.scenebeans.SceneGraph;
import uk.ac.ic.doc.scenebeans.cag.CAGDirty;
import uk.ac.ic.doc.scenebeans.cag.CAGProcessor;
import uk.ac.ic.doc.scenebeans.cag.CAGSetDirty;

public abstract class CAGComposite
extends PrimitiveBase
implements CompositeNode {
    private Area _area;
    private List _args = new ArrayList();

    public void draw(Graphics2D graphics2D) {
        super.draw(graphics2D);
        CAGSetDirty.setChildrenDirty(this, false);
    }

    public Shape getShape(Graphics2D graphics2D) {
        if (this._area == null || this.isDirty()) {
            this._area = this.calculateArea(graphics2D);
        }
        return this._area;
    }

    public boolean isDirty() {
        return super.isDirty() || CAGDirty.areChildrenDirty(this);
    }

    public int getSubgraphCount() {
        return this._args.size();
    }

    public SceneGraph getSubgraph(int n) {
        return (SceneGraph)this._args.get(n);
    }

    public int getVisibleSubgraphCount() {
        return 0;
    }

    public SceneGraph getVisibleSubgraph(int n) {
        throw new IndexOutOfBoundsException("subgraph index out of range");
    }

    public int getLastDrawnSubgraphCount() {
        return 0;
    }

    public SceneGraph getLastDrawnSubgraph(int n) {
        throw new IndexOutOfBoundsException("last-drawn subgraph index out of range");
    }

    public void addSubgraph(SceneGraph sceneGraph) {
        this._args.add(sceneGraph);
        this.setDirty(true);
    }

    public void removeSubgraph(SceneGraph sceneGraph) {
        this._args.remove(sceneGraph);
        this.setDirty(true);
    }

    public void removeSubgraph(int n) {
        this._args.remove(n);
        this.setDirty(true);
    }

    private Area calculateArea(Graphics2D graphics2D) {
        CAGProcessor cAGProcessor = this.newCAGProcessor(graphics2D);
        int n = 0;
        while (n < this.getSubgraphCount()) {
            this.getSubgraph(n).accept(cAGProcessor);
            ++n;
        }
        return cAGProcessor.getArea();
    }

    protected abstract CAGProcessor newCAGProcessor(Graphics2D var1);
}

