/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ic.doc.scenebeans;

import java.awt.Color;
import java.awt.GradientPaint;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.geom.Point2D;
import java.io.Serializable;
import uk.ac.ic.doc.scenebeans.ColorBehaviourListener;
import uk.ac.ic.doc.scenebeans.PointBehaviourListener;
import uk.ac.ic.doc.scenebeans.Style;
import uk.ac.ic.doc.scenebeans.StyleBase;

public class Gradient
extends StyleBase {
    private boolean _is_cyclic = false;
    private Point2D _from_pt;
    private Point2D _to_pt;
    private Color _from_col;
    private Color _to_col;

    public boolean isCyclic() {
        return this._is_cyclic;
    }

    public void setCyclic(boolean bl) {
        this._is_cyclic = true;
        this.setDirty(true);
    }

    public Point2D getFromPoint() {
        return this._from_pt;
    }

    public void setFromPoint(Point2D point2D) {
        this._from_pt = point2D;
        this.setDirty(true);
    }

    public Color getFromColor() {
        return this._from_col;
    }

    public void setFromColor(Color color) {
        this._from_col = color;
        this.setDirty(true);
    }

    public Point2D getToPoint() {
        return this._to_pt;
    }

    public void setToPoint(Point2D point2D) {
        this._to_pt = point2D;
        this.setDirty(true);
    }

    public Color getToColor() {
        return this._to_col;
    }

    public void setToColor(Color color) {
        this._to_col = color;
        this.setDirty(true);
    }

    public Style.Change changeStyle(Graphics2D graphics2D) {
        final Paint paint = graphics2D.getPaint();
        final GradientPaint gradientPaint = new GradientPaint(this._from_pt, this._from_col, this._to_pt, this._to_col, this._is_cyclic);
        graphics2D.setPaint(gradientPaint);
        return new Style.Change(){

            public void restoreStyle(Graphics2D graphics2D) {
                graphics2D.setPaint(paint);
            }

            public void reapplyStyle(Graphics2D graphics2D) {
                graphics2D.setPaint(gradientPaint);
            }
        };
    }

    public final FromPointAdapter newFromPointAdapter() {
        return new FromPointAdapter();
    }

    public final ToPointAdapter newToPointAdapter() {
        return new ToPointAdapter();
    }

    public final FromColorAdapter newFromColorAdapter() {
        return new FromColorAdapter();
    }

    public final ToColorAdapter newToColorAdapter() {
        return new ToColorAdapter();
    }

    class ToColorAdapter
    implements ColorBehaviourListener,
    Serializable {
        ToColorAdapter() {
        }

        public void behaviourUpdated(Color color) {
            Gradient.this.setToColor(color);
        }
    }

    class FromColorAdapter
    implements ColorBehaviourListener,
    Serializable {
        FromColorAdapter() {
        }

        public void behaviourUpdated(Color color) {
            Gradient.this.setFromColor(color);
        }
    }

    class ToPointAdapter
    implements PointBehaviourListener,
    Serializable {
        ToPointAdapter() {
        }

        public void behaviourUpdated(Point2D point2D) {
            Gradient.this.setToPoint(point2D);
        }
    }

    class FromPointAdapter
    implements PointBehaviourListener,
    Serializable {
        FromPointAdapter() {
        }

        public void behaviourUpdated(Point2D point2D) {
            Gradient.this.setFromPoint(point2D);
        }
    }
}

