/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ic.doc.scenebeans;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.io.Serializable;
import uk.ac.ic.doc.scenebeans.ColorBehaviourListener;
import uk.ac.ic.doc.scenebeans.DoubleBehaviourListener;
import uk.ac.ic.doc.scenebeans.SceneGraph;
import uk.ac.ic.doc.scenebeans.Style;
import uk.ac.ic.doc.scenebeans.StyleBase;

public class RGBAColor
extends StyleBase {
    private float _r;
    private float _g;
    private float _b;
    private float _a;

    public RGBAColor() {
        this._b = 0.5f;
        this._g = 0.5f;
        this._r = 0.5f;
        this._a = 1.0f;
    }

    public RGBAColor(double d, double d2, double d3, double d4, SceneGraph sceneGraph) {
        super(sceneGraph);
        this._r = (float)d;
        this._g = (float)d2;
        this._b = (float)d3;
        this._a = (float)d4;
    }

    public RGBAColor(Color color, SceneGraph sceneGraph) {
        super(sceneGraph);
        this.setColor(color);
    }

    public Color getColor() {
        return new Color(this._r, this._g, this._b, this._a);
    }

    public void setColor(Color color) {
        this._r = (float)((double)color.getRed() / 255.0);
        this._g = (float)((double)color.getGreen() / 255.0);
        this._b = (float)((double)color.getBlue() / 255.0);
        this._a = (float)((double)color.getAlpha() / 255.0);
        this.setDirty(true);
    }

    public double getRed() {
        return this._r;
    }

    public void setRed(double d) {
        this._r = (float)d;
        this.setDirty(true);
    }

    public double getGreen() {
        return this._g;
    }

    public void setGreen(double d) {
        this._g = (float)d;
        this.setDirty(true);
    }

    public double getBlue() {
        return this._b;
    }

    public void setBlue(double d) {
        this._b = (float)d;
        this.setDirty(true);
    }

    public double getAlpha() {
        return this._a;
    }

    public void setAlpha(double d) {
        this._a = (float)d;
        this.setDirty(true);
    }

    public Style.Change changeStyle(Graphics2D graphics2D) {
        final Paint paint = graphics2D.getPaint();
        final Color color = this.getColor();
        graphics2D.setPaint(this.getColor());
        return new Style.Change(){

            public void restoreStyle(Graphics2D graphics2D) {
                graphics2D.setPaint(paint);
            }

            public void reapplyStyle(Graphics2D graphics2D) {
                graphics2D.setPaint(color);
            }
        };
    }

    public final ColorAdapter newColorAdapter() {
        return new ColorAdapter();
    }

    public final RedAdapter newRedAdapter() {
        return new RedAdapter();
    }

    public final GreenAdapter newGreenAdapter() {
        return new GreenAdapter();
    }

    public final BlueAdapter newBlueAdapter() {
        return new BlueAdapter();
    }

    public final AlphaAdapter newAlphaAdapter() {
        return new AlphaAdapter();
    }

    public class AlphaAdapter
    implements DoubleBehaviourListener,
    Serializable {
        public void behaviourUpdated(double d) {
            RGBAColor.this.setAlpha(d);
        }
    }

    public class BlueAdapter
    implements DoubleBehaviourListener,
    Serializable {
        public void behaviourUpdated(double d) {
            RGBAColor.this.setBlue(d);
        }
    }

    public class GreenAdapter
    implements DoubleBehaviourListener,
    Serializable {
        public void behaviourUpdated(double d) {
            RGBAColor.this.setGreen(d);
        }
    }

    public class RedAdapter
    implements DoubleBehaviourListener,
    Serializable {
        public void behaviourUpdated(double d) {
            RGBAColor.this.setRed(d);
        }
    }

    public class ColorAdapter
    implements ColorBehaviourListener,
    Serializable {
        public void behaviourUpdated(Color color) {
            RGBAColor.this.setColor(color);
        }
    }
}

