/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ic.doc.scenebeans.activity;

import java.util.ArrayList;
import java.util.List;
import uk.ac.ic.doc.scenebeans.activity.Activity;
import uk.ac.ic.doc.scenebeans.activity.CompositeActivity;
import uk.ac.ic.doc.scenebeans.event.AnimationEvent;
import uk.ac.ic.doc.scenebeans.event.AnimationListener;

public class SequentialActivity
extends CompositeActivity
implements AnimationListener {
    private List _activities = new ArrayList();
    int _current = 0;

    public synchronized void reset() {
        this._current = 0;
        int n = this._activities.size() - 1;
        while (n >= 0) {
            ((Activity)this._activities.get(n)).reset();
            --n;
        }
    }

    public synchronized void addActivity(Activity activity) {
        if (!activity.isFinite()) {
            throw new IllegalArgumentException("infinite activity added to sequence");
        }
        activity.setActivityRunner(this);
        activity.addAnimationListener(this);
        this._activities.add(activity);
    }

    public synchronized void removeActivity(Activity activity) {
        activity.setActivityRunner(null);
        this._activities.remove(activity);
    }

    public synchronized void performActivity(double d) {
        if (this._current < this._activities.size()) {
            ((Activity)this._activities.get(this._current)).performActivity(d);
        }
    }

    public void animationEvent(AnimationEvent animationEvent) {
        ++this._current;
        if (this._current == this._activities.size()) {
            this.postActivityComplete();
        }
    }
}

