/* $Id$
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 */

/// @file CitRetract_.hpp
/// Data storage class.
///
/// This file was generated by application DATATOOL
/// using the following specifications:
/// 'biblio.asn'.
///
/// ATTENTION:
///   Don't edit or commit this file into CVS as this file will
///   be overridden (by DATATOOL) without warning!

#ifndef OBJECTS_BIBLIO_CITRETRACT_BASE_HPP
#define OBJECTS_BIBLIO_CITRETRACT_BASE_HPP

// standard includes
#include <serial/serialbase.hpp>

// generated includes
#include <string>

BEGIN_NCBI_SCOPE

#ifndef BEGIN_objects_SCOPE
#  define BEGIN_objects_SCOPE BEGIN_SCOPE(objects)
#  define END_objects_SCOPE END_SCOPE(objects)
#endif
BEGIN_objects_SCOPE // namespace ncbi::objects::


// generated classes

/////////////////////////////////////////////////////////////////////////////
class NCBI_BIBLIO_EXPORT CCitRetract_Base : public CSerialObject
{
    typedef CSerialObject Tparent;
public:
    // constructor
    CCitRetract_Base(void);
    // destructor
    virtual ~CCitRetract_Base(void);

    // type info
    DECLARE_INTERNAL_TYPE_INFO();

    /// retraction of an entry
    enum EType {
        eType_retracted = 1,  ///< this citation retracted
        eType_notice    = 2,  ///< this citation is a retraction notice
        eType_in_error  = 3,  ///< an erratum was published about this
        eType_erratum   = 4  ///< this is a published erratum
    };
    
    /// Access to EType's attributes (values, names) as defined in spec
    static const NCBI_NS_NCBI::CEnumeratedTypeValues* ENUM_METHOD_NAME(EType)(void);
    
    // types
    typedef EType TType;
    typedef string TExp;

    // member index
    enum class E_memberIndex {
        e__allMandatory = 0,
        e_type,
        e_exp
    };
    typedef Tparent::CMemberIndex<E_memberIndex, 3> TmemberIndex;

    // getters
    // setters

    /// mandatory
    /// typedef EType TType
    ///  Check whether the Type data member has been assigned a value.
    bool IsSetType(void) const;
    /// Check whether it is safe or not to call GetType method.
    bool CanGetType(void) const;
    void ResetType(void);
    TType GetType(void) const;
    void SetType(TType value);
    TType& SetType(void);

    /// citation and/or explanation
    /// optional
    /// typedef string TExp
    ///  Check whether the Exp data member has been assigned a value.
    bool IsSetExp(void) const;
    /// Check whether it is safe or not to call GetExp method.
    bool CanGetExp(void) const;
    void ResetExp(void);
    const TExp& GetExp(void) const;
    void SetExp(const TExp& value);
    void SetExp(TExp&& value);
    TExp& SetExp(void);

    /// Reset the whole object
    virtual void Reset(void);


private:
    // Prohibit copy constructor and assignment operator
    CCitRetract_Base(const CCitRetract_Base&);
    CCitRetract_Base& operator=(const CCitRetract_Base&);

    // data
    Uint4 m_set_State[1];
    EType m_Type;
    string m_Exp;
};






///////////////////////////////////////////////////////////
///////////////////// inline methods //////////////////////
///////////////////////////////////////////////////////////
inline
bool CCitRetract_Base::IsSetType(void) const
{
    return ((m_set_State[0] & 0x3) != 0);
}

inline
bool CCitRetract_Base::CanGetType(void) const
{
    return IsSetType();
}

inline
void CCitRetract_Base::ResetType(void)
{
    m_Type = (EType)(0);
    m_set_State[0] &= ~0x3;
}

inline
CCitRetract_Base::TType CCitRetract_Base::GetType(void) const
{
    if (!CanGetType()) {
        ThrowUnassigned(0);
    }
    return m_Type;
}

inline
void CCitRetract_Base::SetType(CCitRetract_Base::TType value)
{
    m_Type = value;
    m_set_State[0] |= 0x3;
}

inline
CCitRetract_Base::TType& CCitRetract_Base::SetType(void)
{
#ifdef _DEBUG
    if (!IsSetType()) {
        memset(&m_Type,UnassignedByte(),sizeof(m_Type));
    }
#endif
    m_set_State[0] |= 0x1;
    return m_Type;
}

inline
bool CCitRetract_Base::IsSetExp(void) const
{
    return ((m_set_State[0] & 0xc) != 0);
}

inline
bool CCitRetract_Base::CanGetExp(void) const
{
    return IsSetExp();
}

inline
const CCitRetract_Base::TExp& CCitRetract_Base::GetExp(void) const
{
    if (!CanGetExp()) {
        ThrowUnassigned(1);
    }
    return m_Exp;
}

inline
void CCitRetract_Base::SetExp(const CCitRetract_Base::TExp& value)
{
    m_Exp = value;
    m_set_State[0] |= 0xc;
}

inline
void CCitRetract_Base::SetExp(CCitRetract_Base::TExp&& value)
{
    m_Exp = std::forward<CCitRetract_Base::TExp>(value);
    m_set_State[0] |= 0xc;
}

inline
CCitRetract_Base::TExp& CCitRetract_Base::SetExp(void)
{
#ifdef _DEBUG
    if (!IsSetExp()) {
        m_Exp = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x4;
    return m_Exp;
}

///////////////////////////////////////////////////////////
////////////////// end of inline methods //////////////////
///////////////////////////////////////////////////////////





END_objects_SCOPE // namespace ncbi::objects::

END_NCBI_SCOPE


#endif // OBJECTS_BIBLIO_CITRETRACT_BASE_HPP
