/* $Id$
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 */

/// @file Blast4_seqtech_.hpp
/// Data storage class.
///
/// This file was generated by application DATATOOL
/// using the following specifications:
/// 'blast.asn'.
///
/// ATTENTION:
///   Don't edit or commit this file into CVS as this file will
///   be overridden (by DATATOOL) without warning!

#ifndef OBJECTS_BLAST_BLAST4_SEQTECH_BASE_HPP
#define OBJECTS_BLAST_BLAST4_SEQTECH_BASE_HPP

// standard includes
#include <serial/serialbase.hpp>
BEGIN_NCBI_SCOPE

#ifndef BEGIN_objects_SCOPE
#  define BEGIN_objects_SCOPE BEGIN_SCOPE(objects)
#  define END_objects_SCOPE END_SCOPE(objects)
#endif
BEGIN_objects_SCOPE // namespace ncbi::objects::


// generated classes

/// Borrowed from seq.asn
enum EBlast4_seqtech {
    eBlast4_seqtech_unknown          =   0,
    eBlast4_seqtech_standard         =   1,  ///< standard sequencing
    eBlast4_seqtech_est              =   2,  ///< Expressed Sequence Tag
    eBlast4_seqtech_sts              =   3,  ///< Sequence Tagged Site
    eBlast4_seqtech_survey           =   4,  ///< one-pass genomic sequence
    eBlast4_seqtech_genemap          =   5,  ///< from genetic mapping techniques
    eBlast4_seqtech_physmap          =   6,  ///< from physical mapping techniques
    eBlast4_seqtech_derived          =   7,  ///< derived from other data, not a primary entity
    eBlast4_seqtech_concept_trans    =   8,  ///< conceptual translation
    eBlast4_seqtech_seq_pept         =   9,  ///< peptide was sequenced
    eBlast4_seqtech_both             =  10,  ///< concept transl. w/ partial pept. seq.
    eBlast4_seqtech_seq_pept_overlap =  11,  ///< sequenced peptide, ordered by overlap
    eBlast4_seqtech_seq_pept_homol   =  12,  ///< sequenced peptide, ordered by homology
    eBlast4_seqtech_concept_trans_a  =  13,  ///< conceptual transl. supplied by author
    eBlast4_seqtech_htgs_1           =  14,  ///< unordered High Throughput sequence contig
    eBlast4_seqtech_htgs_2           =  15,  ///< ordered High Throughput sequence contig
    eBlast4_seqtech_htgs_3           =  16,  ///< finished High Throughput sequence
    eBlast4_seqtech_fli_cdna         =  17,  ///< full length insert cDNA
    eBlast4_seqtech_htgs_0           =  18,  ///< single genomic reads for coordination
    eBlast4_seqtech_htc              =  19,  ///< high throughput cDNA
    eBlast4_seqtech_wgs              =  20,  ///< whole genome shotgun sequencing
    eBlast4_seqtech_other            = 255  ///< use Source.techexp
};

/// Access to EBlast4_seqtech's attributes (values, names) as defined in spec
NCBI_BLAST_EXPORT const NCBI_NS_NCBI::CEnumeratedTypeValues* ENUM_METHOD_NAME(EBlast4_seqtech)(void);


END_objects_SCOPE // namespace ncbi::objects::

END_NCBI_SCOPE


#endif // OBJECTS_BLAST_BLAST4_SEQTECH_BASE_HPP
