/* $Id$
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 */

/// @file Cn3d_color_scheme_.hpp
/// Data storage class.
///
/// This file was generated by application DATATOOL
/// using the following specifications:
/// 'cn3d.asn'.
///
/// ATTENTION:
///   Don't edit or commit this file into CVS as this file will
///   be overridden (by DATATOOL) without warning!

#ifndef OBJECTS_CN3D_CN3D_COLOR_SCHEME_BASE_HPP
#define OBJECTS_CN3D_CN3D_COLOR_SCHEME_BASE_HPP

// standard includes
#include <serial/serialbase.hpp>
BEGIN_NCBI_SCOPE

#ifndef BEGIN_objects_SCOPE
#  define BEGIN_objects_SCOPE BEGIN_SCOPE(objects)
#  define END_objects_SCOPE END_SCOPE(objects)
#endif
BEGIN_objects_SCOPE // namespace ncbi::objects::


// generated classes

/// available color schemes (not all
/// necessarily applicable to all objects)
enum ECn3d_color_scheme {
    eCn3d_color_scheme_element             =  1,
    eCn3d_color_scheme_object              =  2,
    eCn3d_color_scheme_molecule            =  3,
    eCn3d_color_scheme_domain              =  4,
    eCn3d_color_scheme_residue             = 20,
    eCn3d_color_scheme_secondary_structure =  5,
    eCn3d_color_scheme_user_select         =  6,
    eCn3d_color_scheme_aligned             =  7,  ///< different alignment conservation coloring (currently only for proteins)
    eCn3d_color_scheme_identity            =  8,
    eCn3d_color_scheme_variety             =  9,
    eCn3d_color_scheme_weighted_variety    = 10,
    eCn3d_color_scheme_information_content = 11,
    eCn3d_color_scheme_fit                 = 12,
    eCn3d_color_scheme_block_fit           = 17,
    eCn3d_color_scheme_block_z_fit         = 18,
    eCn3d_color_scheme_block_row_fit       = 19,
    eCn3d_color_scheme_temperature         = 13,  ///< other schemes
    eCn3d_color_scheme_hydrophobicity      = 14,
    eCn3d_color_scheme_charge              = 15,
    eCn3d_color_scheme_rainbow             = 16
};

/// Access to ECn3d_color_scheme's attributes (values, names) as defined in spec
NCBI_CN3D_EXPORT const NCBI_NS_NCBI::CEnumeratedTypeValues* ENUM_METHOD_NAME(ECn3d_color_scheme)(void);


END_objects_SCOPE // namespace ncbi::objects::

END_NCBI_SCOPE


#endif // OBJECTS_CN3D_CN3D_COLOR_SCHEME_BASE_HPP
