/* $Id$
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 */

/// @file Cn3d_general_style_.hpp
/// Data storage class.
///
/// This file was generated by application DATATOOL
/// using the following specifications:
/// 'cn3d.asn'.
///
/// ATTENTION:
///   Don't edit or commit this file into CVS as this file will
///   be overridden (by DATATOOL) without warning!

#ifndef OBJECTS_CN3D_CN3D_GENERAL_STYLE_BASE_HPP
#define OBJECTS_CN3D_CN3D_GENERAL_STYLE_BASE_HPP

// standard includes
#include <serial/serialbase.hpp>

// generated includes
#include <objects/cn3d/Cn3d_color_scheme.hpp>
#include <objects/cn3d/Cn3d_drawing_style.hpp>

BEGIN_NCBI_SCOPE

#ifndef BEGIN_objects_SCOPE
#  define BEGIN_objects_SCOPE BEGIN_SCOPE(objects)
#  define END_objects_SCOPE END_SCOPE(objects)
#endif
BEGIN_objects_SCOPE // namespace ncbi::objects::


// forward declarations
class CCn3d_color;


// generated classes

/////////////////////////////////////////////////////////////////////////////
/// style blob for other objects
class NCBI_CN3D_EXPORT CCn3d_general_style_Base : public CSerialObject
{
    typedef CSerialObject Tparent;
public:
    // constructor
    CCn3d_general_style_Base(void);
    // destructor
    virtual ~CCn3d_general_style_Base(void);

    // type info
    DECLARE_INTERNAL_TYPE_INFO();

    // types
    typedef bool TIs_on;
    typedef ECn3d_drawing_style TStyle;
    typedef ECn3d_color_scheme TColor_scheme;
    typedef CCn3d_color TUser_color;

    // member index
    enum class E_memberIndex {
        e__allMandatory = 0,
        e_is_on,
        e_style,
        e_color_scheme,
        e_user_color
    };
    typedef Tparent::CMemberIndex<E_memberIndex, 5> TmemberIndex;

    // getters
    // setters

    /// mandatory
    /// typedef bool TIs_on
    ///  Check whether the Is_on data member has been assigned a value.
    bool IsSetIs_on(void) const;
    /// Check whether it is safe or not to call GetIs_on method.
    bool CanGetIs_on(void) const;
    void ResetIs_on(void);
    TIs_on GetIs_on(void) const;
    void SetIs_on(TIs_on value);
    TIs_on& SetIs_on(void);

    /// mandatory
    /// typedef ECn3d_drawing_style TStyle
    ///  Check whether the Style data member has been assigned a value.
    bool IsSetStyle(void) const;
    /// Check whether it is safe or not to call GetStyle method.
    bool CanGetStyle(void) const;
    void ResetStyle(void);
    TStyle GetStyle(void) const;
    void SetStyle(TStyle value);
    TStyle& SetStyle(void);

    /// mandatory
    /// typedef ECn3d_color_scheme TColor_scheme
    ///  Check whether the Color_scheme data member has been assigned a value.
    bool IsSetColor_scheme(void) const;
    /// Check whether it is safe or not to call GetColor_scheme method.
    bool CanGetColor_scheme(void) const;
    void ResetColor_scheme(void);
    TColor_scheme GetColor_scheme(void) const;
    void SetColor_scheme(TColor_scheme value);
    TColor_scheme& SetColor_scheme(void);

    /// mandatory
    /// typedef CCn3d_color TUser_color
    ///  Check whether the User_color data member has been assigned a value.
    bool IsSetUser_color(void) const;
    /// Check whether it is safe or not to call GetUser_color method.
    bool CanGetUser_color(void) const;
    void ResetUser_color(void);
    const TUser_color& GetUser_color(void) const;
    void SetUser_color(TUser_color& value);
    TUser_color& SetUser_color(void);

    /// Reset the whole object
    virtual void Reset(void);


private:
    // Prohibit copy constructor and assignment operator
    CCn3d_general_style_Base(const CCn3d_general_style_Base&);
    CCn3d_general_style_Base& operator=(const CCn3d_general_style_Base&);

    // data
    Uint4 m_set_State[1];
    bool m_Is_on;
    ECn3d_drawing_style m_Style;
    ECn3d_color_scheme m_Color_scheme;
    CRef< TUser_color > m_User_color;
};






///////////////////////////////////////////////////////////
///////////////////// inline methods //////////////////////
///////////////////////////////////////////////////////////
inline
bool CCn3d_general_style_Base::IsSetIs_on(void) const
{
    return ((m_set_State[0] & 0x3) != 0);
}

inline
bool CCn3d_general_style_Base::CanGetIs_on(void) const
{
    return IsSetIs_on();
}

inline
void CCn3d_general_style_Base::ResetIs_on(void)
{
    m_Is_on = 0;
    m_set_State[0] &= ~0x3;
}

inline
CCn3d_general_style_Base::TIs_on CCn3d_general_style_Base::GetIs_on(void) const
{
    if (!CanGetIs_on()) {
        ThrowUnassigned(0);
    }
    return m_Is_on;
}

inline
void CCn3d_general_style_Base::SetIs_on(CCn3d_general_style_Base::TIs_on value)
{
    m_Is_on = value;
    m_set_State[0] |= 0x3;
}

inline
CCn3d_general_style_Base::TIs_on& CCn3d_general_style_Base::SetIs_on(void)
{
#ifdef _DEBUG
    if (!IsSetIs_on()) {
        memset(&m_Is_on,UnassignedByte(),sizeof(m_Is_on));
    }
#endif
    m_set_State[0] |= 0x1;
    return m_Is_on;
}

inline
bool CCn3d_general_style_Base::IsSetStyle(void) const
{
    return ((m_set_State[0] & 0xc) != 0);
}

inline
bool CCn3d_general_style_Base::CanGetStyle(void) const
{
    return IsSetStyle();
}

inline
void CCn3d_general_style_Base::ResetStyle(void)
{
    m_Style = (ncbi::objects::ECn3d_drawing_style)(0);
    m_set_State[0] &= ~0xc;
}

inline
CCn3d_general_style_Base::TStyle CCn3d_general_style_Base::GetStyle(void) const
{
    if (!CanGetStyle()) {
        ThrowUnassigned(1);
    }
    return m_Style;
}

inline
void CCn3d_general_style_Base::SetStyle(CCn3d_general_style_Base::TStyle value)
{
    m_Style = value;
    m_set_State[0] |= 0xc;
}

inline
CCn3d_general_style_Base::TStyle& CCn3d_general_style_Base::SetStyle(void)
{
#ifdef _DEBUG
    if (!IsSetStyle()) {
        memset(&m_Style,UnassignedByte(),sizeof(m_Style));
    }
#endif
    m_set_State[0] |= 0x4;
    return m_Style;
}

inline
bool CCn3d_general_style_Base::IsSetColor_scheme(void) const
{
    return ((m_set_State[0] & 0x30) != 0);
}

inline
bool CCn3d_general_style_Base::CanGetColor_scheme(void) const
{
    return IsSetColor_scheme();
}

inline
void CCn3d_general_style_Base::ResetColor_scheme(void)
{
    m_Color_scheme = (ncbi::objects::ECn3d_color_scheme)(0);
    m_set_State[0] &= ~0x30;
}

inline
CCn3d_general_style_Base::TColor_scheme CCn3d_general_style_Base::GetColor_scheme(void) const
{
    if (!CanGetColor_scheme()) {
        ThrowUnassigned(2);
    }
    return m_Color_scheme;
}

inline
void CCn3d_general_style_Base::SetColor_scheme(CCn3d_general_style_Base::TColor_scheme value)
{
    m_Color_scheme = value;
    m_set_State[0] |= 0x30;
}

inline
CCn3d_general_style_Base::TColor_scheme& CCn3d_general_style_Base::SetColor_scheme(void)
{
#ifdef _DEBUG
    if (!IsSetColor_scheme()) {
        memset(&m_Color_scheme,UnassignedByte(),sizeof(m_Color_scheme));
    }
#endif
    m_set_State[0] |= 0x10;
    return m_Color_scheme;
}

inline
bool CCn3d_general_style_Base::IsSetUser_color(void) const
{
    return m_User_color.NotEmpty();
}

inline
bool CCn3d_general_style_Base::CanGetUser_color(void) const
{
    return true;
}

inline
const CCn3d_general_style_Base::TUser_color& CCn3d_general_style_Base::GetUser_color(void) const
{
    if ( !m_User_color ) {
        const_cast<CCn3d_general_style_Base*>(this)->ResetUser_color();
    }
    return (*m_User_color);
}

inline
CCn3d_general_style_Base::TUser_color& CCn3d_general_style_Base::SetUser_color(void)
{
    if ( !m_User_color ) {
        ResetUser_color();
    }
    return (*m_User_color);
}

///////////////////////////////////////////////////////////
////////////////// end of inline methods //////////////////
///////////////////////////////////////////////////////////





END_objects_SCOPE // namespace ncbi::objects::

END_NCBI_SCOPE


#endif // OBJECTS_CN3D_CN3D_GENERAL_STYLE_BASE_HPP
