/* $Id$
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 */

/// @file Entrez2_limits_.hpp
/// Data storage class.
///
/// This file was generated by application DATATOOL
/// using the following specifications:
/// 'entrez2.asn'.
///
/// ATTENTION:
///   Don't edit or commit this file into CVS as this file will
///   be overridden (by DATATOOL) without warning!

#ifndef OBJECTS_ENTREZ2_ENTREZ2_LIMITS_BASE_HPP
#define OBJECTS_ENTREZ2_ENTREZ2_LIMITS_BASE_HPP

// standard includes
#include <serial/serialbase.hpp>
BEGIN_NCBI_SCOPE

#ifndef BEGIN_objects_SCOPE
#  define BEGIN_objects_SCOPE BEGIN_SCOPE(objects)
#  define END_objects_SCOPE END_SCOPE(objects)
#endif
BEGIN_objects_SCOPE // namespace ncbi::objects::


// forward declarations
class CEntrez2_dt_filter;


// generated classes

/////////////////////////////////////////////////////////////////////////////
/// date limits
class NCBI_ENTREZ2_EXPORT CEntrez2_limits_Base : public CSerialObject
{
    typedef CSerialObject Tparent;
public:
    // constructor
    CEntrez2_limits_Base(void);
    // destructor
    virtual ~CEntrez2_limits_Base(void);

    // type info
    DECLARE_INTERNAL_TYPE_INFO();

    // types
    typedef CEntrez2_dt_filter TFilter_date;
    typedef int TMax_UIDs;
    typedef int TOffset_UIDs;

    // member index
    enum class E_memberIndex {
        e__allMandatory = 0,
        e_filter_date,
        e_max_UIDs,
        e_offset_UIDs
    };
    typedef Tparent::CMemberIndex<E_memberIndex, 4> TmemberIndex;

    // getters
    // setters

    /// optional
    /// typedef CEntrez2_dt_filter TFilter_date
    ///  Check whether the Filter_date data member has been assigned a value.
    bool IsSetFilter_date(void) const;
    /// Check whether it is safe or not to call GetFilter_date method.
    bool CanGetFilter_date(void) const;
    void ResetFilter_date(void);
    const TFilter_date& GetFilter_date(void) const;
    void SetFilter_date(TFilter_date& value);
    TFilter_date& SetFilter_date(void);

    /// max UIDs to return in list
    /// optional
    /// typedef int TMax_UIDs
    ///  Check whether the Max_UIDs data member has been assigned a value.
    bool IsSetMax_UIDs(void) const;
    /// Check whether it is safe or not to call GetMax_UIDs method.
    bool CanGetMax_UIDs(void) const;
    void ResetMax_UIDs(void);
    TMax_UIDs GetMax_UIDs(void) const;
    void SetMax_UIDs(TMax_UIDs value);
    TMax_UIDs& SetMax_UIDs(void);

    /// start partway into UID list
    /// optional
    /// typedef int TOffset_UIDs
    ///  Check whether the Offset_UIDs data member has been assigned a value.
    bool IsSetOffset_UIDs(void) const;
    /// Check whether it is safe or not to call GetOffset_UIDs method.
    bool CanGetOffset_UIDs(void) const;
    void ResetOffset_UIDs(void);
    TOffset_UIDs GetOffset_UIDs(void) const;
    void SetOffset_UIDs(TOffset_UIDs value);
    TOffset_UIDs& SetOffset_UIDs(void);

    /// Reset the whole object
    virtual void Reset(void);


private:
    // Prohibit copy constructor and assignment operator
    CEntrez2_limits_Base(const CEntrez2_limits_Base&);
    CEntrez2_limits_Base& operator=(const CEntrez2_limits_Base&);

    // data
    Uint4 m_set_State[1];
    CRef< TFilter_date > m_Filter_date;
    int m_Max_UIDs;
    int m_Offset_UIDs;
};






///////////////////////////////////////////////////////////
///////////////////// inline methods //////////////////////
///////////////////////////////////////////////////////////
inline
bool CEntrez2_limits_Base::IsSetFilter_date(void) const
{
    return m_Filter_date.NotEmpty();
}

inline
bool CEntrez2_limits_Base::CanGetFilter_date(void) const
{
    return IsSetFilter_date();
}

inline
const CEntrez2_limits_Base::TFilter_date& CEntrez2_limits_Base::GetFilter_date(void) const
{
    if (!CanGetFilter_date()) {
        ThrowUnassigned(0);
    }
    return (*m_Filter_date);
}

inline
bool CEntrez2_limits_Base::IsSetMax_UIDs(void) const
{
    return ((m_set_State[0] & 0xc) != 0);
}

inline
bool CEntrez2_limits_Base::CanGetMax_UIDs(void) const
{
    return IsSetMax_UIDs();
}

inline
void CEntrez2_limits_Base::ResetMax_UIDs(void)
{
    m_Max_UIDs = 0;
    m_set_State[0] &= ~0xc;
}

inline
CEntrez2_limits_Base::TMax_UIDs CEntrez2_limits_Base::GetMax_UIDs(void) const
{
    if (!CanGetMax_UIDs()) {
        ThrowUnassigned(1);
    }
    return m_Max_UIDs;
}

inline
void CEntrez2_limits_Base::SetMax_UIDs(CEntrez2_limits_Base::TMax_UIDs value)
{
    m_Max_UIDs = value;
    m_set_State[0] |= 0xc;
}

inline
CEntrez2_limits_Base::TMax_UIDs& CEntrez2_limits_Base::SetMax_UIDs(void)
{
#ifdef _DEBUG
    if (!IsSetMax_UIDs()) {
        memset(&m_Max_UIDs,UnassignedByte(),sizeof(m_Max_UIDs));
    }
#endif
    m_set_State[0] |= 0x4;
    return m_Max_UIDs;
}

inline
bool CEntrez2_limits_Base::IsSetOffset_UIDs(void) const
{
    return ((m_set_State[0] & 0x30) != 0);
}

inline
bool CEntrez2_limits_Base::CanGetOffset_UIDs(void) const
{
    return IsSetOffset_UIDs();
}

inline
void CEntrez2_limits_Base::ResetOffset_UIDs(void)
{
    m_Offset_UIDs = 0;
    m_set_State[0] &= ~0x30;
}

inline
CEntrez2_limits_Base::TOffset_UIDs CEntrez2_limits_Base::GetOffset_UIDs(void) const
{
    if (!CanGetOffset_UIDs()) {
        ThrowUnassigned(2);
    }
    return m_Offset_UIDs;
}

inline
void CEntrez2_limits_Base::SetOffset_UIDs(CEntrez2_limits_Base::TOffset_UIDs value)
{
    m_Offset_UIDs = value;
    m_set_State[0] |= 0x30;
}

inline
CEntrez2_limits_Base::TOffset_UIDs& CEntrez2_limits_Base::SetOffset_UIDs(void)
{
#ifdef _DEBUG
    if (!IsSetOffset_UIDs()) {
        memset(&m_Offset_UIDs,UnassignedByte(),sizeof(m_Offset_UIDs));
    }
#endif
    m_set_State[0] |= 0x10;
    return m_Offset_UIDs;
}

///////////////////////////////////////////////////////////
////////////////// end of inline methods //////////////////
///////////////////////////////////////////////////////////





END_objects_SCOPE // namespace ncbi::objects::

END_NCBI_SCOPE


#endif // OBJECTS_ENTREZ2_ENTREZ2_LIMITS_BASE_HPP
