/* $Id$
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 */

/// @file Entrez2_link_count_.hpp
/// Data storage class.
///
/// This file was generated by application DATATOOL
/// using the following specifications:
/// 'entrez2.asn'.
///
/// ATTENTION:
///   Don't edit or commit this file into CVS as this file will
///   be overridden (by DATATOOL) without warning!

#ifndef OBJECTS_ENTREZ2_ENTREZ2_LINK_COUNT_BASE_HPP
#define OBJECTS_ENTREZ2_ENTREZ2_LINK_COUNT_BASE_HPP

// standard includes
#include <serial/serialbase.hpp>

// generated includes
#include <objects/entrez2/Entrez2_link_id.hpp>

BEGIN_NCBI_SCOPE

#ifndef BEGIN_objects_SCOPE
#  define BEGIN_objects_SCOPE BEGIN_SCOPE(objects)
#  define END_objects_SCOPE END_SCOPE(objects)
#endif
BEGIN_objects_SCOPE // namespace ncbi::objects::


// generated classes

/////////////////////////////////////////////////////////////////////////////
/// link count of one type
class NCBI_ENTREZ2_EXPORT CEntrez2_link_count_Base : public CSerialObject
{
    typedef CSerialObject Tparent;
public:
    // constructor
    CEntrez2_link_count_Base(void);
    // destructor
    virtual ~CEntrez2_link_count_Base(void);

    // type info
    DECLARE_INTERNAL_TYPE_INFO();

    // types
    typedef CEntrez2_link_id TLink_type;
    typedef int TLink_count;

    // member index
    enum class E_memberIndex {
        e__allMandatory = 0,
        e_link_type,
        e_link_count
    };
    typedef Tparent::CMemberIndex<E_memberIndex, 3> TmemberIndex;

    // getters
    // setters

    /// mandatory
    /// typedef CEntrez2_link_id TLink_type
    ///  Check whether the Link_type data member has been assigned a value.
    bool IsSetLink_type(void) const;
    /// Check whether it is safe or not to call GetLink_type method.
    bool CanGetLink_type(void) const;
    void ResetLink_type(void);
    const TLink_type& GetLink_type(void) const;
    void SetLink_type(const TLink_type& value);
    TLink_type& SetLink_type(void);

    /// mandatory
    /// typedef int TLink_count
    ///  Check whether the Link_count data member has been assigned a value.
    bool IsSetLink_count(void) const;
    /// Check whether it is safe or not to call GetLink_count method.
    bool CanGetLink_count(void) const;
    void ResetLink_count(void);
    TLink_count GetLink_count(void) const;
    void SetLink_count(TLink_count value);
    TLink_count& SetLink_count(void);

    /// Reset the whole object
    virtual void Reset(void);


private:
    // Prohibit copy constructor and assignment operator
    CEntrez2_link_count_Base(const CEntrez2_link_count_Base&);
    CEntrez2_link_count_Base& operator=(const CEntrez2_link_count_Base&);

    // data
    Uint4 m_set_State[1];
    CEntrez2_link_id m_Link_type;
    int m_Link_count;
};






///////////////////////////////////////////////////////////
///////////////////// inline methods //////////////////////
///////////////////////////////////////////////////////////
inline
bool CEntrez2_link_count_Base::IsSetLink_type(void) const
{
    return ((m_set_State[0] & 0x3) != 0);
}

inline
bool CEntrez2_link_count_Base::CanGetLink_type(void) const
{
    return IsSetLink_type();
}

inline
const CEntrez2_link_count_Base::TLink_type& CEntrez2_link_count_Base::GetLink_type(void) const
{
    if (!CanGetLink_type()) {
        ThrowUnassigned(0);
    }
    return m_Link_type;
}

inline
void CEntrez2_link_count_Base::SetLink_type(const CEntrez2_link_count_Base::TLink_type& value)
{
    m_Link_type = value;
    m_set_State[0] |= 0x3;
}

inline
CEntrez2_link_count_Base::TLink_type& CEntrez2_link_count_Base::SetLink_type(void)
{
    m_set_State[0] |= 0x1;
    return m_Link_type;
}

inline
bool CEntrez2_link_count_Base::IsSetLink_count(void) const
{
    return ((m_set_State[0] & 0xc) != 0);
}

inline
bool CEntrez2_link_count_Base::CanGetLink_count(void) const
{
    return IsSetLink_count();
}

inline
void CEntrez2_link_count_Base::ResetLink_count(void)
{
    m_Link_count = 0;
    m_set_State[0] &= ~0xc;
}

inline
CEntrez2_link_count_Base::TLink_count CEntrez2_link_count_Base::GetLink_count(void) const
{
    if (!CanGetLink_count()) {
        ThrowUnassigned(1);
    }
    return m_Link_count;
}

inline
void CEntrez2_link_count_Base::SetLink_count(CEntrez2_link_count_Base::TLink_count value)
{
    m_Link_count = value;
    m_set_State[0] |= 0xc;
}

inline
CEntrez2_link_count_Base::TLink_count& CEntrez2_link_count_Base::SetLink_count(void)
{
#ifdef _DEBUG
    if (!IsSetLink_count()) {
        memset(&m_Link_count,UnassignedByte(),sizeof(m_Link_count));
    }
#endif
    m_set_State[0] |= 0x4;
    return m_Link_count;
}

///////////////////////////////////////////////////////////
////////////////// end of inline methods //////////////////
///////////////////////////////////////////////////////////





END_objects_SCOPE // namespace ncbi::objects::

END_NCBI_SCOPE


#endif // OBJECTS_ENTREZ2_ENTREZ2_LINK_COUNT_BASE_HPP
