/* $Id$
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 */

/// @file Maps_.hpp
/// Data storage class.
///
/// This file was generated by application DATATOOL
/// using the following specifications:
/// 'entrezgene.asn'.
///
/// ATTENTION:
///   Don't edit or commit this file into CVS as this file will
///   be overridden (by DATATOOL) without warning!

#ifndef OBJECTS_ENTREZGENE_MAPS_BASE_HPP
#define OBJECTS_ENTREZGENE_MAPS_BASE_HPP

// standard includes
#include <serial/serialbase.hpp>

// generated includes
#include <string>

BEGIN_NCBI_SCOPE

#ifndef BEGIN_objects_SCOPE
#  define BEGIN_objects_SCOPE BEGIN_SCOPE(objects)
#  define END_objects_SCOPE END_SCOPE(objects)
#endif
BEGIN_objects_SCOPE // namespace ncbi::objects::


// generated classes

/////////////////////////////////////////////////////////////////////////////
class NCBI_ENTREZGENE_EXPORT CMaps_Base : public CSerialObject
{
    typedef CSerialObject Tparent;
public:
    // constructor
    CMaps_Base(void);
    // destructor
    virtual ~CMaps_Base(void);

    // type info
    DECLARE_INTERNAL_TYPE_INFO();

    /////////////////////////////////////////////////////////////////////////////
    class NCBI_ENTREZGENE_EXPORT C_Method : public CSerialObject
    {
        typedef CSerialObject Tparent;
    public:
        // constructor
        C_Method(void);
        // destructor
        ~C_Method(void);
    
        // type info
        DECLARE_INTERNAL_TYPE_INFO();
    
        /// units used in display-str to query mapviewer 
        enum EMethod_map_type {
            eMethod_map_type_cyto = 0,
            eMethod_map_type_bp   = 1,
            eMethod_map_type_cM   = 2,
            eMethod_map_type_cR   = 3,
            eMethod_map_type_min  = 4
        };
        
        /// Access to EMethod_map_type's attributes (values, names) as defined in spec
        static const NCBI_NS_NCBI::CEnumeratedTypeValues* ENUM_METHOD_NAME(EMethod_map_type)(void);
        
    
        /// Choice variants.
        enum E_Choice {
            e_not_set = 0,  ///< No variant selected
            e_Proxy,        ///<url to non mapviewer mapviewing resource
            e_Map_type
        };
        /// Maximum+1 value of the choice variant enumerator.
        enum E_ChoiceStopper {
            e_MaxChoice = 3 ///< == e_Map_type+1
        };
    
        /// Reset the whole object
        void Reset(void);
    
        /// Reset the selection (set it to e_not_set).
        void ResetSelection(void);
    
        /// Which variant is currently selected.
        E_Choice Which(void) const;
    
        /// Verify selection, throw exception if it differs from the expected.
        void CheckSelected(E_Choice index) const;
    
        /// Throw 'InvalidSelection' exception.
        NCBI_NORETURN void ThrowInvalidSelection(E_Choice index) const;
    
        /// Retrieve selection name (for diagnostic purposes).
        static string SelectionName(E_Choice index);
    
        /// Select the requested variant if needed.
        void Select(E_Choice index, EResetVariant reset = eDoResetVariant);
        /// Select the requested variant if needed,
        /// allocating CObject variants from memory pool.
        void Select(E_Choice index,
                    EResetVariant reset,
                    CObjectMemoryPool* pool);
    
        // types
        typedef string TProxy;
        typedef EMethod_map_type TMap_type;
    
        // getters
        // setters
    
        // typedef string TProxy
        bool IsProxy(void) const;
        const TProxy& GetProxy(void) const;
        TProxy& SetProxy(void);
        void SetProxy(const TProxy& value);
    
        // typedef EMethod_map_type TMap_type
        bool IsMap_type(void) const;
        TMap_type GetMap_type(void) const;
        TMap_type& SetMap_type(void);
        void SetMap_type(TMap_type value);
    
    
    private:
        // copy constructor and assignment operator
        C_Method(const C_Method& );
        C_Method& operator=(const C_Method& );
        // choice state
        E_Choice m_choice;
        // helper methods
        void DoSelect(E_Choice index, CObjectMemoryPool* pool = 0);
    
        static const char* const sm_SelectionNames[];
        // data
        union {
            TMap_type m_Map_type;
            NCBI_NS_NCBI::CUnionBuffer<NCBI_NS_STD::string> m_string;
            void* m_dummy_pointer_for_alignment;
        };
    };
    // types
    typedef string TDisplay_str;
    typedef C_Method TMethod;

    // member index
    enum class E_memberIndex {
        e__allMandatory = 0,
        e_display_str,
        e_method
    };
    typedef Tparent::CMemberIndex<E_memberIndex, 3> TmemberIndex;

    // getters
    // setters

    /// mandatory
    /// typedef string TDisplay_str
    ///  Check whether the Display_str data member has been assigned a value.
    bool IsSetDisplay_str(void) const;
    /// Check whether it is safe or not to call GetDisplay_str method.
    bool CanGetDisplay_str(void) const;
    void ResetDisplay_str(void);
    const TDisplay_str& GetDisplay_str(void) const;
    void SetDisplay_str(const TDisplay_str& value);
    void SetDisplay_str(TDisplay_str&& value);
    TDisplay_str& SetDisplay_str(void);

    /// mandatory
    /// typedef C_Method TMethod
    ///  Check whether the Method data member has been assigned a value.
    bool IsSetMethod(void) const;
    /// Check whether it is safe or not to call GetMethod method.
    bool CanGetMethod(void) const;
    void ResetMethod(void);
    const TMethod& GetMethod(void) const;
    void SetMethod(TMethod& value);
    TMethod& SetMethod(void);

    /// Reset the whole object
    virtual void Reset(void);


private:
    // Prohibit copy constructor and assignment operator
    CMaps_Base(const CMaps_Base&);
    CMaps_Base& operator=(const CMaps_Base&);

    // data
    Uint4 m_set_State[1];
    string m_Display_str;
    CRef< TMethod > m_Method;
};






///////////////////////////////////////////////////////////
///////////////////// inline methods //////////////////////
///////////////////////////////////////////////////////////
inline
CMaps_Base::C_Method::E_Choice CMaps_Base::C_Method::Which(void) const
{
    return m_choice;
}

inline
void CMaps_Base::C_Method::CheckSelected(E_Choice index) const
{
    if ( m_choice != index )
        ThrowInvalidSelection(index);
}

inline
void CMaps_Base::C_Method::Select(E_Choice index, NCBI_NS_NCBI::EResetVariant reset, NCBI_NS_NCBI::CObjectMemoryPool* pool)
{
    if ( reset == NCBI_NS_NCBI::eDoResetVariant || m_choice != index ) {
        if ( m_choice != e_not_set )
            ResetSelection();
        DoSelect(index, pool);
    }
}

inline
void CMaps_Base::C_Method::Select(E_Choice index, NCBI_NS_NCBI::EResetVariant reset)
{
    Select(index, reset, 0);
}

inline
bool CMaps_Base::C_Method::IsProxy(void) const
{
    return m_choice == e_Proxy;
}

inline
const CMaps_Base::C_Method::TProxy& CMaps_Base::C_Method::GetProxy(void) const
{
    CheckSelected(e_Proxy);
    return *m_string;
}

inline
CMaps_Base::C_Method::TProxy& CMaps_Base::C_Method::SetProxy(void)
{
    Select(e_Proxy, NCBI_NS_NCBI::eDoNotResetVariant);
    return *m_string;
}

inline
bool CMaps_Base::C_Method::IsMap_type(void) const
{
    return m_choice == e_Map_type;
}

inline
CMaps_Base::C_Method::TMap_type CMaps_Base::C_Method::GetMap_type(void) const
{
    CheckSelected(e_Map_type);
    return m_Map_type;
}

inline
CMaps_Base::C_Method::TMap_type& CMaps_Base::C_Method::SetMap_type(void)
{
    Select(e_Map_type, NCBI_NS_NCBI::eDoNotResetVariant);
    return m_Map_type;
}

inline
void CMaps_Base::C_Method::SetMap_type(CMaps_Base::C_Method::TMap_type value)
{
    Select(e_Map_type, NCBI_NS_NCBI::eDoNotResetVariant);
    m_Map_type = value;
}

inline
bool CMaps_Base::IsSetDisplay_str(void) const
{
    return ((m_set_State[0] & 0x3) != 0);
}

inline
bool CMaps_Base::CanGetDisplay_str(void) const
{
    return IsSetDisplay_str();
}

inline
const CMaps_Base::TDisplay_str& CMaps_Base::GetDisplay_str(void) const
{
    if (!CanGetDisplay_str()) {
        ThrowUnassigned(0);
    }
    return m_Display_str;
}

inline
void CMaps_Base::SetDisplay_str(const CMaps_Base::TDisplay_str& value)
{
    m_Display_str = value;
    m_set_State[0] |= 0x3;
}

inline
void CMaps_Base::SetDisplay_str(CMaps_Base::TDisplay_str&& value)
{
    m_Display_str = std::forward<CMaps_Base::TDisplay_str>(value);
    m_set_State[0] |= 0x3;
}

inline
CMaps_Base::TDisplay_str& CMaps_Base::SetDisplay_str(void)
{
#ifdef _DEBUG
    if (!IsSetDisplay_str()) {
        m_Display_str = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x1;
    return m_Display_str;
}

inline
bool CMaps_Base::IsSetMethod(void) const
{
    return m_Method.NotEmpty();
}

inline
bool CMaps_Base::CanGetMethod(void) const
{
    return true;
}

inline
const CMaps_Base::TMethod& CMaps_Base::GetMethod(void) const
{
    if ( !m_Method ) {
        const_cast<CMaps_Base*>(this)->ResetMethod();
    }
    return (*m_Method);
}

inline
CMaps_Base::TMethod& CMaps_Base::SetMethod(void)
{
    if ( !m_Method ) {
        ResetMethod();
    }
    return (*m_Method);
}

///////////////////////////////////////////////////////////
////////////////// end of inline methods //////////////////
///////////////////////////////////////////////////////////





END_objects_SCOPE // namespace ncbi::objects::

END_NCBI_SCOPE


#endif // OBJECTS_ENTREZGENE_MAPS_BASE_HPP
