/* $Id$
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 */

/// @file AbstractProjectItem_.hpp
/// Data storage class.
///
/// This file was generated by application DATATOOL
/// using the following specifications:
/// 'gbproj.asn'.
///
/// ATTENTION:
///   Don't edit or commit this file into CVS as this file will
///   be overridden (by DATATOOL) without warning!

#ifndef OBJECTS_GBPROJ_ABSTRACTPROJECTITEM_BASE_HPP
#define OBJECTS_GBPROJ_ABSTRACTPROJECTITEM_BASE_HPP

// extra headers
#include <objects/gbproj/gbproj_export.h>

// standard includes
#include <serial/serialbase.hpp>

// generated includes
#include <string>
#include <vector>

BEGIN_NCBI_SCOPE

#ifndef BEGIN_objects_SCOPE
#  define BEGIN_objects_SCOPE BEGIN_SCOPE(objects)
#  define END_objects_SCOPE END_SCOPE(objects)
#endif
BEGIN_objects_SCOPE // namespace ncbi::objects::


// generated classes

/////////////////////////////////////////////////////////////////////////////
class NCBI_GBPROJ_EXPORT CAbstractProjectItem_Base : public CSerialObject
{
    typedef CSerialObject Tparent;
public:
    // constructor
    CAbstractProjectItem_Base(void);
    // destructor
    virtual ~CAbstractProjectItem_Base(void);

    // type info
    DECLARE_INTERNAL_TYPE_INFO();

    // types
    typedef string TType;
    typedef vector< char > TData;

    // member index
    enum class E_memberIndex {
        e__allMandatory = 0,
        e_type,
        e_data
    };
    typedef Tparent::CMemberIndex<E_memberIndex, 3> TmemberIndex;

    // getters
    // setters

    /// mandatory
    /// typedef string TType
    ///  Check whether the Type data member has been assigned a value.
    bool IsSetType(void) const;
    /// Check whether it is safe or not to call GetType method.
    bool CanGetType(void) const;
    void ResetType(void);
    const TType& GetType(void) const;
    void SetType(const TType& value);
    void SetType(TType&& value);
    TType& SetType(void);

    /// mandatory
    /// typedef vector< char > TData
    ///  Check whether the Data data member has been assigned a value.
    bool IsSetData(void) const;
    /// Check whether it is safe or not to call GetData method.
    bool CanGetData(void) const;
    void ResetData(void);
    const TData& GetData(void) const;
    TData& SetData(void);

    /// Reset the whole object
    virtual void Reset(void);


private:
    // Prohibit copy constructor and assignment operator
    CAbstractProjectItem_Base(const CAbstractProjectItem_Base&);
    CAbstractProjectItem_Base& operator=(const CAbstractProjectItem_Base&);

    // data
    Uint4 m_set_State[1];
    string m_Type;
    vector< char > m_Data;
};






///////////////////////////////////////////////////////////
///////////////////// inline methods //////////////////////
///////////////////////////////////////////////////////////
inline
bool CAbstractProjectItem_Base::IsSetType(void) const
{
    return ((m_set_State[0] & 0x3) != 0);
}

inline
bool CAbstractProjectItem_Base::CanGetType(void) const
{
    return IsSetType();
}

inline
const CAbstractProjectItem_Base::TType& CAbstractProjectItem_Base::GetType(void) const
{
    if (!CanGetType()) {
        ThrowUnassigned(0);
    }
    return m_Type;
}

inline
void CAbstractProjectItem_Base::SetType(const CAbstractProjectItem_Base::TType& value)
{
    m_Type = value;
    m_set_State[0] |= 0x3;
}

inline
void CAbstractProjectItem_Base::SetType(CAbstractProjectItem_Base::TType&& value)
{
    m_Type = std::forward<CAbstractProjectItem_Base::TType>(value);
    m_set_State[0] |= 0x3;
}

inline
CAbstractProjectItem_Base::TType& CAbstractProjectItem_Base::SetType(void)
{
#ifdef _DEBUG
    if (!IsSetType()) {
        m_Type = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x1;
    return m_Type;
}

inline
bool CAbstractProjectItem_Base::IsSetData(void) const
{
    return ((m_set_State[0] & 0xc) != 0);
}

inline
bool CAbstractProjectItem_Base::CanGetData(void) const
{
    return IsSetData();
}

inline
const CAbstractProjectItem_Base::TData& CAbstractProjectItem_Base::GetData(void) const
{
    if (!CanGetData()) {
        ThrowUnassigned(1);
    }
    return m_Data;
}

inline
CAbstractProjectItem_Base::TData& CAbstractProjectItem_Base::SetData(void)
{
    m_set_State[0] |= 0x4;
    return m_Data;
}

///////////////////////////////////////////////////////////
////////////////// end of inline methods //////////////////
///////////////////////////////////////////////////////////





END_objects_SCOPE // namespace ncbi::objects::

END_NCBI_SCOPE


#endif // OBJECTS_GBPROJ_ABSTRACTPROJECTITEM_BASE_HPP
