/* $Id$
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 */

/// @file FolderInfo_.hpp
/// Data storage class.
///
/// This file was generated by application DATATOOL
/// using the following specifications:
/// 'gbproj.asn'.
///
/// ATTENTION:
///   Don't edit or commit this file into CVS as this file will
///   be overridden (by DATATOOL) without warning!

#ifndef OBJECTS_GBPROJ_FOLDERINFO_BASE_HPP
#define OBJECTS_GBPROJ_FOLDERINFO_BASE_HPP

// extra headers
#include <objects/gbproj/gbproj_export.h>

// standard includes
#include <serial/serialbase.hpp>

// generated includes
#include <list>
#include <string>

BEGIN_NCBI_SCOPE

#ifndef BEGIN_objects_SCOPE
#  define BEGIN_objects_SCOPE BEGIN_SCOPE(objects)
#  define END_objects_SCOPE END_SCOPE(objects)
#endif
BEGIN_objects_SCOPE // namespace ncbi::objects::


// forward declarations
class CAnnotdesc;
class CDate;


// generated classes

/////////////////////////////////////////////////////////////////////////////
class NCBI_GBPROJ_EXPORT CFolderInfo_Base : public CSerialObject
{
    typedef CSerialObject Tparent;
public:
    // constructor
    CFolderInfo_Base(void);
    // destructor
    virtual ~CFolderInfo_Base(void);

    // type info
    DECLARE_INTERNAL_TYPE_INFO();

    // types
    typedef string TTitle;
    typedef CDate TCreate_date;
    typedef string TComment;
    typedef bool TOpen;
    typedef list< CRef< CAnnotdesc > > TAnnot;

    // member index
    enum class E_memberIndex {
        e__allMandatory = 0,
        e_title,
        e_create_date,
        e_comment,
        e_open,
        e_annot
    };
    typedef Tparent::CMemberIndex<E_memberIndex, 6> TmemberIndex;

    // getters
    // setters

    /// mandatory
    /// typedef string TTitle
    ///  Check whether the Title data member has been assigned a value.
    bool IsSetTitle(void) const;
    /// Check whether it is safe or not to call GetTitle method.
    bool CanGetTitle(void) const;
    void ResetTitle(void);
    const TTitle& GetTitle(void) const;
    void SetTitle(const TTitle& value);
    void SetTitle(TTitle&& value);
    TTitle& SetTitle(void);

    /// basic descriptors
    /// mandatory
    /// typedef CDate TCreate_date
    ///  Check whether the Create_date data member has been assigned a value.
    bool IsSetCreate_date(void) const;
    /// Check whether it is safe or not to call GetCreate_date method.
    bool CanGetCreate_date(void) const;
    void ResetCreate_date(void);
    const TCreate_date& GetCreate_date(void) const;
    void SetCreate_date(TCreate_date& value);
    TCreate_date& SetCreate_date(void);

    /// optional comments
    /// optional
    /// typedef string TComment
    ///  Check whether the Comment data member has been assigned a value.
    bool IsSetComment(void) const;
    /// Check whether it is safe or not to call GetComment method.
    bool CanGetComment(void) const;
    void ResetComment(void);
    const TComment& GetComment(void) const;
    void SetComment(const TComment& value);
    void SetComment(TComment&& value);
    TComment& SetComment(void);

    /// "folder open" state
    /// optional
    /// typedef bool TOpen
    ///  Check whether the Open data member has been assigned a value.
    bool IsSetOpen(void) const;
    /// Check whether it is safe or not to call GetOpen method.
    bool CanGetOpen(void) const;
    void ResetOpen(void);
    TOpen GetOpen(void) const;
    void SetOpen(TOpen value);
    TOpen& SetOpen(void);

    /// arbitrary annotations
    /// optional
    /// typedef list< CRef< CAnnotdesc > > TAnnot
    ///  Check whether the Annot data member has been assigned a value.
    bool IsSetAnnot(void) const;
    /// Check whether it is safe or not to call GetAnnot method.
    bool CanGetAnnot(void) const;
    void ResetAnnot(void);
    const TAnnot& GetAnnot(void) const;
    TAnnot& SetAnnot(void);

    /// Reset the whole object
    virtual void Reset(void);


private:
    // Prohibit copy constructor and assignment operator
    CFolderInfo_Base(const CFolderInfo_Base&);
    CFolderInfo_Base& operator=(const CFolderInfo_Base&);

    // data
    Uint4 m_set_State[1];
    string m_Title;
    CRef< TCreate_date > m_Create_date;
    string m_Comment;
    bool m_Open;
    list< CRef< CAnnotdesc > > m_Annot;
};






///////////////////////////////////////////////////////////
///////////////////// inline methods //////////////////////
///////////////////////////////////////////////////////////
inline
bool CFolderInfo_Base::IsSetTitle(void) const
{
    return ((m_set_State[0] & 0x3) != 0);
}

inline
bool CFolderInfo_Base::CanGetTitle(void) const
{
    return IsSetTitle();
}

inline
const CFolderInfo_Base::TTitle& CFolderInfo_Base::GetTitle(void) const
{
    if (!CanGetTitle()) {
        ThrowUnassigned(0);
    }
    return m_Title;
}

inline
void CFolderInfo_Base::SetTitle(const CFolderInfo_Base::TTitle& value)
{
    m_Title = value;
    m_set_State[0] |= 0x3;
}

inline
void CFolderInfo_Base::SetTitle(CFolderInfo_Base::TTitle&& value)
{
    m_Title = std::forward<CFolderInfo_Base::TTitle>(value);
    m_set_State[0] |= 0x3;
}

inline
CFolderInfo_Base::TTitle& CFolderInfo_Base::SetTitle(void)
{
#ifdef _DEBUG
    if (!IsSetTitle()) {
        m_Title = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x1;
    return m_Title;
}

inline
bool CFolderInfo_Base::IsSetCreate_date(void) const
{
    return m_Create_date.NotEmpty();
}

inline
bool CFolderInfo_Base::CanGetCreate_date(void) const
{
    return true;
}

inline
const CFolderInfo_Base::TCreate_date& CFolderInfo_Base::GetCreate_date(void) const
{
    if ( !m_Create_date ) {
        const_cast<CFolderInfo_Base*>(this)->ResetCreate_date();
    }
    return (*m_Create_date);
}

inline
CFolderInfo_Base::TCreate_date& CFolderInfo_Base::SetCreate_date(void)
{
    if ( !m_Create_date ) {
        ResetCreate_date();
    }
    return (*m_Create_date);
}

inline
bool CFolderInfo_Base::IsSetComment(void) const
{
    return ((m_set_State[0] & 0x30) != 0);
}

inline
bool CFolderInfo_Base::CanGetComment(void) const
{
    return IsSetComment();
}

inline
const CFolderInfo_Base::TComment& CFolderInfo_Base::GetComment(void) const
{
    if (!CanGetComment()) {
        ThrowUnassigned(2);
    }
    return m_Comment;
}

inline
void CFolderInfo_Base::SetComment(const CFolderInfo_Base::TComment& value)
{
    m_Comment = value;
    m_set_State[0] |= 0x30;
}

inline
void CFolderInfo_Base::SetComment(CFolderInfo_Base::TComment&& value)
{
    m_Comment = std::forward<CFolderInfo_Base::TComment>(value);
    m_set_State[0] |= 0x30;
}

inline
CFolderInfo_Base::TComment& CFolderInfo_Base::SetComment(void)
{
#ifdef _DEBUG
    if (!IsSetComment()) {
        m_Comment = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x10;
    return m_Comment;
}

inline
bool CFolderInfo_Base::IsSetOpen(void) const
{
    return ((m_set_State[0] & 0xc0) != 0);
}

inline
bool CFolderInfo_Base::CanGetOpen(void) const
{
    return IsSetOpen();
}

inline
void CFolderInfo_Base::ResetOpen(void)
{
    m_Open = 0;
    m_set_State[0] &= ~0xc0;
}

inline
CFolderInfo_Base::TOpen CFolderInfo_Base::GetOpen(void) const
{
    if (!CanGetOpen()) {
        ThrowUnassigned(3);
    }
    return m_Open;
}

inline
void CFolderInfo_Base::SetOpen(CFolderInfo_Base::TOpen value)
{
    m_Open = value;
    m_set_State[0] |= 0xc0;
}

inline
CFolderInfo_Base::TOpen& CFolderInfo_Base::SetOpen(void)
{
#ifdef _DEBUG
    if (!IsSetOpen()) {
        memset(&m_Open,UnassignedByte(),sizeof(m_Open));
    }
#endif
    m_set_State[0] |= 0x40;
    return m_Open;
}

inline
bool CFolderInfo_Base::IsSetAnnot(void) const
{
    return ((m_set_State[0] & 0x300) != 0);
}

inline
bool CFolderInfo_Base::CanGetAnnot(void) const
{
    return true;
}

inline
const CFolderInfo_Base::TAnnot& CFolderInfo_Base::GetAnnot(void) const
{
    return m_Annot;
}

inline
CFolderInfo_Base::TAnnot& CFolderInfo_Base::SetAnnot(void)
{
    m_set_State[0] |= 0x100;
    return m_Annot;
}

///////////////////////////////////////////////////////////
////////////////// end of inline methods //////////////////
///////////////////////////////////////////////////////////





END_objects_SCOPE // namespace ncbi::objects::

END_NCBI_SCOPE


#endif // OBJECTS_GBPROJ_FOLDERINFO_BASE_HPP
