/* $Id$
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 */

/// @file GBStrucCommentItem_.hpp
/// Data storage class.
///
/// This file was generated by application DATATOOL
/// using the following specifications:
/// 'gbseq.asn'.
///
/// ATTENTION:
///   Don't edit or commit this file into CVS as this file will
///   be overridden (by DATATOOL) without warning!

#ifndef OBJECTS_GBSEQ_GBSTRUCCOMMENTITEM_BASE_HPP
#define OBJECTS_GBSEQ_GBSTRUCCOMMENTITEM_BASE_HPP

// standard includes
#include <serial/serialbase.hpp>

// generated includes
#include <string>

BEGIN_NCBI_SCOPE

#ifndef BEGIN_objects_SCOPE
#  define BEGIN_objects_SCOPE BEGIN_SCOPE(objects)
#  define END_objects_SCOPE END_SCOPE(objects)
#endif
BEGIN_objects_SCOPE // namespace ncbi::objects::


// generated classes

/////////////////////////////////////////////////////////////////////////////
class NCBI_GBSEQ_EXPORT CGBStrucCommentItem_Base : public CSerialObject
{
    typedef CSerialObject Tparent;
public:
    // constructor
    CGBStrucCommentItem_Base(void);
    // destructor
    virtual ~CGBStrucCommentItem_Base(void);

    // type info
    DECLARE_INTERNAL_TYPE_INFO();

    // types
    typedef string TTag;
    typedef string TValue;
    typedef string TUrl;

    // member index
    enum class E_memberIndex {
        e__allMandatory = 0,
        e_tag,
        e_value,
        e_url
    };
    typedef Tparent::CMemberIndex<E_memberIndex, 4> TmemberIndex;

    // getters
    // setters

    /// optional
    /// typedef string TTag
    ///  Check whether the Tag data member has been assigned a value.
    bool IsSetTag(void) const;
    /// Check whether it is safe or not to call GetTag method.
    bool CanGetTag(void) const;
    void ResetTag(void);
    const TTag& GetTag(void) const;
    void SetTag(const TTag& value);
    void SetTag(TTag&& value);
    TTag& SetTag(void);

    /// optional
    /// typedef string TValue
    ///  Check whether the Value data member has been assigned a value.
    bool IsSetValue(void) const;
    /// Check whether it is safe or not to call GetValue method.
    bool CanGetValue(void) const;
    void ResetValue(void);
    const TValue& GetValue(void) const;
    void SetValue(const TValue& value);
    void SetValue(TValue&& value);
    TValue& SetValue(void);

    /// optional
    /// typedef string TUrl
    ///  Check whether the Url data member has been assigned a value.
    bool IsSetUrl(void) const;
    /// Check whether it is safe or not to call GetUrl method.
    bool CanGetUrl(void) const;
    void ResetUrl(void);
    const TUrl& GetUrl(void) const;
    void SetUrl(const TUrl& value);
    void SetUrl(TUrl&& value);
    TUrl& SetUrl(void);

    /// Reset the whole object
    virtual void Reset(void);


private:
    // Prohibit copy constructor and assignment operator
    CGBStrucCommentItem_Base(const CGBStrucCommentItem_Base&);
    CGBStrucCommentItem_Base& operator=(const CGBStrucCommentItem_Base&);

    // data
    Uint4 m_set_State[1];
    string m_Tag;
    string m_Value;
    string m_Url;
};






///////////////////////////////////////////////////////////
///////////////////// inline methods //////////////////////
///////////////////////////////////////////////////////////
inline
bool CGBStrucCommentItem_Base::IsSetTag(void) const
{
    return ((m_set_State[0] & 0x3) != 0);
}

inline
bool CGBStrucCommentItem_Base::CanGetTag(void) const
{
    return IsSetTag();
}

inline
const CGBStrucCommentItem_Base::TTag& CGBStrucCommentItem_Base::GetTag(void) const
{
    if (!CanGetTag()) {
        ThrowUnassigned(0);
    }
    return m_Tag;
}

inline
void CGBStrucCommentItem_Base::SetTag(const CGBStrucCommentItem_Base::TTag& value)
{
    m_Tag = value;
    m_set_State[0] |= 0x3;
}

inline
void CGBStrucCommentItem_Base::SetTag(CGBStrucCommentItem_Base::TTag&& value)
{
    m_Tag = std::forward<CGBStrucCommentItem_Base::TTag>(value);
    m_set_State[0] |= 0x3;
}

inline
CGBStrucCommentItem_Base::TTag& CGBStrucCommentItem_Base::SetTag(void)
{
#ifdef _DEBUG
    if (!IsSetTag()) {
        m_Tag = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x1;
    return m_Tag;
}

inline
bool CGBStrucCommentItem_Base::IsSetValue(void) const
{
    return ((m_set_State[0] & 0xc) != 0);
}

inline
bool CGBStrucCommentItem_Base::CanGetValue(void) const
{
    return IsSetValue();
}

inline
const CGBStrucCommentItem_Base::TValue& CGBStrucCommentItem_Base::GetValue(void) const
{
    if (!CanGetValue()) {
        ThrowUnassigned(1);
    }
    return m_Value;
}

inline
void CGBStrucCommentItem_Base::SetValue(const CGBStrucCommentItem_Base::TValue& value)
{
    m_Value = value;
    m_set_State[0] |= 0xc;
}

inline
void CGBStrucCommentItem_Base::SetValue(CGBStrucCommentItem_Base::TValue&& value)
{
    m_Value = std::forward<CGBStrucCommentItem_Base::TValue>(value);
    m_set_State[0] |= 0xc;
}

inline
CGBStrucCommentItem_Base::TValue& CGBStrucCommentItem_Base::SetValue(void)
{
#ifdef _DEBUG
    if (!IsSetValue()) {
        m_Value = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x4;
    return m_Value;
}

inline
bool CGBStrucCommentItem_Base::IsSetUrl(void) const
{
    return ((m_set_State[0] & 0x30) != 0);
}

inline
bool CGBStrucCommentItem_Base::CanGetUrl(void) const
{
    return IsSetUrl();
}

inline
const CGBStrucCommentItem_Base::TUrl& CGBStrucCommentItem_Base::GetUrl(void) const
{
    if (!CanGetUrl()) {
        ThrowUnassigned(2);
    }
    return m_Url;
}

inline
void CGBStrucCommentItem_Base::SetUrl(const CGBStrucCommentItem_Base::TUrl& value)
{
    m_Url = value;
    m_set_State[0] |= 0x30;
}

inline
void CGBStrucCommentItem_Base::SetUrl(CGBStrucCommentItem_Base::TUrl&& value)
{
    m_Url = std::forward<CGBStrucCommentItem_Base::TUrl>(value);
    m_set_State[0] |= 0x30;
}

inline
CGBStrucCommentItem_Base::TUrl& CGBStrucCommentItem_Base::SetUrl(void)
{
#ifdef _DEBUG
    if (!IsSetUrl()) {
        m_Url = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x10;
    return m_Url;
}

///////////////////////////////////////////////////////////
////////////////// end of inline methods //////////////////
///////////////////////////////////////////////////////////





END_objects_SCOPE // namespace ncbi::objects::

END_NCBI_SCOPE


#endif // OBJECTS_GBSEQ_GBSTRUCCOMMENTITEM_BASE_HPP
