/* $Id$
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 */

/// @file Name_std_.hpp
/// Data storage class.
///
/// This file was generated by application DATATOOL
/// using the following specifications:
/// 'general.asn'.
///
/// ATTENTION:
///   Don't edit or commit this file into CVS as this file will
///   be overridden (by DATATOOL) without warning!

#ifndef OBJECTS_GENERAL_NAME_STD_BASE_HPP
#define OBJECTS_GENERAL_NAME_STD_BASE_HPP

// standard includes
#include <serial/serialbase.hpp>

// generated includes
#include <string>

BEGIN_NCBI_SCOPE

#ifndef BEGIN_objects_SCOPE
#  define BEGIN_objects_SCOPE BEGIN_SCOPE(objects)
#  define END_objects_SCOPE END_SCOPE(objects)
#endif
BEGIN_objects_SCOPE // namespace ncbi::objects::


// generated classes

/////////////////////////////////////////////////////////////////////////////
/// Structured names
class NCBI_GENERAL_EXPORT CName_std_Base : public CSerialObject
{
    typedef CSerialObject Tparent;
public:
    // constructor
    CName_std_Base(void);
    // destructor
    virtual ~CName_std_Base(void);

    // type info
    DECLARE_INTERNAL_TYPE_INFO();

    // types
    typedef string TLast;
    typedef string TFirst;
    typedef string TMiddle;
    typedef string TFull;
    typedef string TInitials;
    typedef string TSuffix;
    typedef string TTitle;

    // member index
    enum class E_memberIndex {
        e__allMandatory = 0,
        e_last,
        e_first,
        e_middle,
        e_full,
        e_initials,
        e_suffix,
        e_title
    };
    typedef Tparent::CMemberIndex<E_memberIndex, 8> TmemberIndex;

    // getters
    // setters

    /// mandatory
    /// typedef string TLast
    ///  Check whether the Last data member has been assigned a value.
    bool IsSetLast(void) const;
    /// Check whether it is safe or not to call GetLast method.
    bool CanGetLast(void) const;
    void ResetLast(void);
    const TLast& GetLast(void) const;
    void SetLast(const TLast& value);
    void SetLast(TLast&& value);
    TLast& SetLast(void);

    /// optional
    /// typedef string TFirst
    ///  Check whether the First data member has been assigned a value.
    bool IsSetFirst(void) const;
    /// Check whether it is safe or not to call GetFirst method.
    bool CanGetFirst(void) const;
    void ResetFirst(void);
    const TFirst& GetFirst(void) const;
    void SetFirst(const TFirst& value);
    void SetFirst(TFirst&& value);
    TFirst& SetFirst(void);

    /// optional
    /// typedef string TMiddle
    ///  Check whether the Middle data member has been assigned a value.
    bool IsSetMiddle(void) const;
    /// Check whether it is safe or not to call GetMiddle method.
    bool CanGetMiddle(void) const;
    void ResetMiddle(void);
    const TMiddle& GetMiddle(void) const;
    void SetMiddle(const TMiddle& value);
    void SetMiddle(TMiddle&& value);
    TMiddle& SetMiddle(void);

    /// full name eg. "J. John Smith, Esq"
    /// optional
    /// typedef string TFull
    ///  Check whether the Full data member has been assigned a value.
    bool IsSetFull(void) const;
    /// Check whether it is safe or not to call GetFull method.
    bool CanGetFull(void) const;
    void ResetFull(void);
    const TFull& GetFull(void) const;
    void SetFull(const TFull& value);
    void SetFull(TFull&& value);
    TFull& SetFull(void);

    /// first + middle initials
    /// optional
    /// typedef string TInitials
    ///  Check whether the Initials data member has been assigned a value.
    bool IsSetInitials(void) const;
    /// Check whether it is safe or not to call GetInitials method.
    bool CanGetInitials(void) const;
    void ResetInitials(void);
    const TInitials& GetInitials(void) const;
    void SetInitials(const TInitials& value);
    void SetInitials(TInitials&& value);
    TInitials& SetInitials(void);

    /// Jr, Sr, III
    /// optional
    /// typedef string TSuffix
    ///  Check whether the Suffix data member has been assigned a value.
    bool IsSetSuffix(void) const;
    /// Check whether it is safe or not to call GetSuffix method.
    bool CanGetSuffix(void) const;
    void ResetSuffix(void);
    const TSuffix& GetSuffix(void) const;
    void SetSuffix(const TSuffix& value);
    void SetSuffix(TSuffix&& value);
    TSuffix& SetSuffix(void);

    /// Dr., Sister, etc
    /// optional
    /// typedef string TTitle
    ///  Check whether the Title data member has been assigned a value.
    bool IsSetTitle(void) const;
    /// Check whether it is safe or not to call GetTitle method.
    bool CanGetTitle(void) const;
    void ResetTitle(void);
    const TTitle& GetTitle(void) const;
    void SetTitle(const TTitle& value);
    void SetTitle(TTitle&& value);
    TTitle& SetTitle(void);

    /// Reset the whole object
    virtual void Reset(void);


private:
    // Prohibit copy constructor and assignment operator
    CName_std_Base(const CName_std_Base&);
    CName_std_Base& operator=(const CName_std_Base&);

    // data
    Uint4 m_set_State[1];
    string m_Last;
    string m_First;
    string m_Middle;
    string m_Full;
    string m_Initials;
    string m_Suffix;
    string m_Title;
};






///////////////////////////////////////////////////////////
///////////////////// inline methods //////////////////////
///////////////////////////////////////////////////////////
inline
bool CName_std_Base::IsSetLast(void) const
{
    return ((m_set_State[0] & 0x3) != 0);
}

inline
bool CName_std_Base::CanGetLast(void) const
{
    return IsSetLast();
}

inline
const CName_std_Base::TLast& CName_std_Base::GetLast(void) const
{
    if (!CanGetLast()) {
        ThrowUnassigned(0);
    }
    return m_Last;
}

inline
void CName_std_Base::SetLast(const CName_std_Base::TLast& value)
{
    m_Last = value;
    m_set_State[0] |= 0x3;
}

inline
void CName_std_Base::SetLast(CName_std_Base::TLast&& value)
{
    m_Last = std::forward<CName_std_Base::TLast>(value);
    m_set_State[0] |= 0x3;
}

inline
CName_std_Base::TLast& CName_std_Base::SetLast(void)
{
#ifdef _DEBUG
    if (!IsSetLast()) {
        m_Last = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x1;
    return m_Last;
}

inline
bool CName_std_Base::IsSetFirst(void) const
{
    return ((m_set_State[0] & 0xc) != 0);
}

inline
bool CName_std_Base::CanGetFirst(void) const
{
    return IsSetFirst();
}

inline
const CName_std_Base::TFirst& CName_std_Base::GetFirst(void) const
{
    if (!CanGetFirst()) {
        ThrowUnassigned(1);
    }
    return m_First;
}

inline
void CName_std_Base::SetFirst(const CName_std_Base::TFirst& value)
{
    m_First = value;
    m_set_State[0] |= 0xc;
}

inline
void CName_std_Base::SetFirst(CName_std_Base::TFirst&& value)
{
    m_First = std::forward<CName_std_Base::TFirst>(value);
    m_set_State[0] |= 0xc;
}

inline
CName_std_Base::TFirst& CName_std_Base::SetFirst(void)
{
#ifdef _DEBUG
    if (!IsSetFirst()) {
        m_First = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x4;
    return m_First;
}

inline
bool CName_std_Base::IsSetMiddle(void) const
{
    return ((m_set_State[0] & 0x30) != 0);
}

inline
bool CName_std_Base::CanGetMiddle(void) const
{
    return IsSetMiddle();
}

inline
const CName_std_Base::TMiddle& CName_std_Base::GetMiddle(void) const
{
    if (!CanGetMiddle()) {
        ThrowUnassigned(2);
    }
    return m_Middle;
}

inline
void CName_std_Base::SetMiddle(const CName_std_Base::TMiddle& value)
{
    m_Middle = value;
    m_set_State[0] |= 0x30;
}

inline
void CName_std_Base::SetMiddle(CName_std_Base::TMiddle&& value)
{
    m_Middle = std::forward<CName_std_Base::TMiddle>(value);
    m_set_State[0] |= 0x30;
}

inline
CName_std_Base::TMiddle& CName_std_Base::SetMiddle(void)
{
#ifdef _DEBUG
    if (!IsSetMiddle()) {
        m_Middle = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x10;
    return m_Middle;
}

inline
bool CName_std_Base::IsSetFull(void) const
{
    return ((m_set_State[0] & 0xc0) != 0);
}

inline
bool CName_std_Base::CanGetFull(void) const
{
    return IsSetFull();
}

inline
const CName_std_Base::TFull& CName_std_Base::GetFull(void) const
{
    if (!CanGetFull()) {
        ThrowUnassigned(3);
    }
    return m_Full;
}

inline
void CName_std_Base::SetFull(const CName_std_Base::TFull& value)
{
    m_Full = value;
    m_set_State[0] |= 0xc0;
}

inline
void CName_std_Base::SetFull(CName_std_Base::TFull&& value)
{
    m_Full = std::forward<CName_std_Base::TFull>(value);
    m_set_State[0] |= 0xc0;
}

inline
CName_std_Base::TFull& CName_std_Base::SetFull(void)
{
#ifdef _DEBUG
    if (!IsSetFull()) {
        m_Full = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x40;
    return m_Full;
}

inline
bool CName_std_Base::IsSetInitials(void) const
{
    return ((m_set_State[0] & 0x300) != 0);
}

inline
bool CName_std_Base::CanGetInitials(void) const
{
    return IsSetInitials();
}

inline
const CName_std_Base::TInitials& CName_std_Base::GetInitials(void) const
{
    if (!CanGetInitials()) {
        ThrowUnassigned(4);
    }
    return m_Initials;
}

inline
void CName_std_Base::SetInitials(const CName_std_Base::TInitials& value)
{
    m_Initials = value;
    m_set_State[0] |= 0x300;
}

inline
void CName_std_Base::SetInitials(CName_std_Base::TInitials&& value)
{
    m_Initials = std::forward<CName_std_Base::TInitials>(value);
    m_set_State[0] |= 0x300;
}

inline
CName_std_Base::TInitials& CName_std_Base::SetInitials(void)
{
#ifdef _DEBUG
    if (!IsSetInitials()) {
        m_Initials = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x100;
    return m_Initials;
}

inline
bool CName_std_Base::IsSetSuffix(void) const
{
    return ((m_set_State[0] & 0xc00) != 0);
}

inline
bool CName_std_Base::CanGetSuffix(void) const
{
    return IsSetSuffix();
}

inline
const CName_std_Base::TSuffix& CName_std_Base::GetSuffix(void) const
{
    if (!CanGetSuffix()) {
        ThrowUnassigned(5);
    }
    return m_Suffix;
}

inline
void CName_std_Base::SetSuffix(const CName_std_Base::TSuffix& value)
{
    m_Suffix = value;
    m_set_State[0] |= 0xc00;
}

inline
void CName_std_Base::SetSuffix(CName_std_Base::TSuffix&& value)
{
    m_Suffix = std::forward<CName_std_Base::TSuffix>(value);
    m_set_State[0] |= 0xc00;
}

inline
CName_std_Base::TSuffix& CName_std_Base::SetSuffix(void)
{
#ifdef _DEBUG
    if (!IsSetSuffix()) {
        m_Suffix = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x400;
    return m_Suffix;
}

inline
bool CName_std_Base::IsSetTitle(void) const
{
    return ((m_set_State[0] & 0x3000) != 0);
}

inline
bool CName_std_Base::CanGetTitle(void) const
{
    return IsSetTitle();
}

inline
const CName_std_Base::TTitle& CName_std_Base::GetTitle(void) const
{
    if (!CanGetTitle()) {
        ThrowUnassigned(6);
    }
    return m_Title;
}

inline
void CName_std_Base::SetTitle(const CName_std_Base::TTitle& value)
{
    m_Title = value;
    m_set_State[0] |= 0x3000;
}

inline
void CName_std_Base::SetTitle(CName_std_Base::TTitle&& value)
{
    m_Title = std::forward<CName_std_Base::TTitle>(value);
    m_set_State[0] |= 0x3000;
}

inline
CName_std_Base::TTitle& CName_std_Base::SetTitle(void)
{
#ifdef _DEBUG
    if (!IsSetTitle()) {
        m_Title = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x1000;
    return m_Title;
}

///////////////////////////////////////////////////////////
////////////////// end of inline methods //////////////////
///////////////////////////////////////////////////////////





END_objects_SCOPE // namespace ncbi::objects::

END_NCBI_SCOPE


#endif // OBJECTS_GENERAL_NAME_STD_BASE_HPP
