/* $Id$
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 */

/// @file User_field_.hpp
/// Data storage class.
///
/// This file was generated by application DATATOOL
/// using the following specifications:
/// 'general.asn'.
///
/// ATTENTION:
///   Don't edit or commit this file into CVS as this file will
///   be overridden (by DATATOOL) without warning!

#ifndef OBJECTS_GENERAL_USER_FIELD_BASE_HPP
#define OBJECTS_GENERAL_USER_FIELD_BASE_HPP

// standard includes
#include <serial/serialbase.hpp>

// generated includes
#include <string>
#include <vector>

BEGIN_NCBI_SCOPE

#ifndef BEGIN_objects_SCOPE
#  define BEGIN_objects_SCOPE BEGIN_SCOPE(objects)
#  define END_objects_SCOPE END_SCOPE(objects)
#endif
BEGIN_objects_SCOPE // namespace ncbi::objects::


// forward declarations
class CObject_id;
class CUser_field;
class CUser_object;


// generated classes

/////////////////////////////////////////////////////////////////////////////
class NCBI_GENERAL_EXPORT CUser_field_Base : public CSerialObject
{
    typedef CSerialObject Tparent;
public:
    // constructor
    CUser_field_Base(void);
    // destructor
    virtual ~CUser_field_Base(void);

    // type info
    DECLARE_INTERNAL_TYPE_INFO();

    /////////////////////////////////////////////////////////////////////////////
    /// field contents
    class NCBI_GENERAL_EXPORT C_Data : public CSerialObject
    {
        typedef CSerialObject Tparent;
    public:
        // constructor
        C_Data(void);
        // destructor
        ~C_Data(void);
    
        // type info
        DECLARE_INTERNAL_TYPE_INFO();
    
    
        /// Choice variants.
        enum E_Choice {
            e_not_set = 0,  ///< No variant selected
            e_Str,
            e_Int,
            e_Real,
            e_Bool,
            e_Os,
            e_Object,       ///< for using other definitions
            e_Strs,
            e_Ints,
            e_Reals,
            e_Oss,
            e_Fields,
            e_Objects
        };
        /// Maximum+1 value of the choice variant enumerator.
        enum E_ChoiceStopper {
            e_MaxChoice = 13 ///< == e_Objects+1
        };
    
        /// Reset the whole object
        void Reset(void);
    
        /// Reset the selection (set it to e_not_set).
        void ResetSelection(void);
    
        /// Which variant is currently selected.
        E_Choice Which(void) const;
    
        /// Verify selection, throw exception if it differs from the expected.
        void CheckSelected(E_Choice index) const;
    
        /// Throw 'InvalidSelection' exception.
        NCBI_NORETURN void ThrowInvalidSelection(E_Choice index) const;
    
        /// Retrieve selection name (for diagnostic purposes).
        static string SelectionName(E_Choice index);
    
        /// Select the requested variant if needed.
        void Select(E_Choice index, EResetVariant reset = eDoResetVariant);
        /// Select the requested variant if needed,
        /// allocating CObject variants from memory pool.
        void Select(E_Choice index,
                    EResetVariant reset,
                    CObjectMemoryPool* pool);
    
        // types
        typedef CStringUTF8 TStr;
        typedef int TInt;
        typedef double TReal;
        typedef bool TBool;
        typedef vector< char > TOs;
        typedef CUser_object TObject;
        typedef vector< CStringUTF8 > TStrs;
        typedef vector< int > TInts;
        typedef vector< double > TReals;
        typedef vector< vector< char >* > TOss;
        typedef vector< CRef< CUser_field > > TFields;
        typedef vector< CRef< CUser_object > > TObjects;
    
        // getters
        // setters
    
        // typedef CStringUTF8 TStr
        bool IsStr(void) const;
        const TStr& GetStr(void) const;
        TStr& SetStr(void);
        void SetStr(const TStr& value);
    
        // typedef int TInt
        bool IsInt(void) const;
        TInt GetInt(void) const;
        TInt& SetInt(void);
        void SetInt(TInt value);
    
        // typedef double TReal
        bool IsReal(void) const;
        TReal GetReal(void) const;
        TReal& SetReal(void);
        void SetReal(TReal value);
    
        // typedef bool TBool
        bool IsBool(void) const;
        TBool GetBool(void) const;
        TBool& SetBool(void);
        void SetBool(TBool value);
    
        // typedef vector< char > TOs
        bool IsOs(void) const;
        const TOs& GetOs(void) const;
        TOs& SetOs(void);
    
        // typedef CUser_object TObject
        bool IsObject(void) const;
        const TObject& GetObject(void) const;
        TObject& SetObject(void);
        void SetObject(TObject& value);
    
        // typedef vector< CStringUTF8 > TStrs
        bool IsStrs(void) const;
        const TStrs& GetStrs(void) const;
        TStrs& SetStrs(void);
    
        // typedef vector< int > TInts
        bool IsInts(void) const;
        const TInts& GetInts(void) const;
        TInts& SetInts(void);
    
        // typedef vector< double > TReals
        bool IsReals(void) const;
        const TReals& GetReals(void) const;
        TReals& SetReals(void);
    
        // typedef vector< vector< char >* > TOss
        bool IsOss(void) const;
        const TOss& GetOss(void) const;
        TOss& SetOss(void);
    
        // typedef vector< CRef< CUser_field > > TFields
        bool IsFields(void) const;
        const TFields& GetFields(void) const;
        TFields& SetFields(void);
    
        // typedef vector< CRef< CUser_object > > TObjects
        bool IsObjects(void) const;
        const TObjects& GetObjects(void) const;
        TObjects& SetObjects(void);
    
    
    private:
        // copy constructor and assignment operator
        C_Data(const C_Data& );
        C_Data& operator=(const C_Data& );
        // choice state
        E_Choice m_choice;
        // helper methods
        void DoSelect(E_Choice index, CObjectMemoryPool* pool = 0);
    
        static const char* const sm_SelectionNames[];
        // data
        union {
            TInt m_Int;
            TReal m_Real;
            TBool m_Bool;
            NCBI_NS_NCBI::CUnionBuffer<TOs> m_Os;
            NCBI_NS_NCBI::CUnionBuffer<TStrs> m_Strs;
            NCBI_NS_NCBI::CUnionBuffer<TInts> m_Ints;
            NCBI_NS_NCBI::CUnionBuffer<TReals> m_Reals;
            NCBI_NS_NCBI::CUnionBuffer<TOss> m_Oss;
            NCBI_NS_NCBI::CUnionBuffer<TFields> m_Fields;
            NCBI_NS_NCBI::CUnionBuffer<TObjects> m_Objects;
            NCBI_NS_NCBI::CUnionBuffer<CStringUTF8> m_string_utf8;
            NCBI_NS_NCBI::CSerialObject *m_object;
        };
    };
    // types
    typedef CObject_id TLabel;
    typedef int TNum;
    typedef C_Data TData;

    // member index
    enum class E_memberIndex {
        e__allMandatory = 0,
        e_label,
        e_num,
        e_data
    };
    typedef Tparent::CMemberIndex<E_memberIndex, 4> TmemberIndex;

    // getters
    // setters

    /// field label
    /// mandatory
    /// typedef CObject_id TLabel
    ///  Check whether the Label data member has been assigned a value.
    bool IsSetLabel(void) const;
    /// Check whether it is safe or not to call GetLabel method.
    bool CanGetLabel(void) const;
    void ResetLabel(void);
    const TLabel& GetLabel(void) const;
    void SetLabel(TLabel& value);
    TLabel& SetLabel(void);

    /// required for strs, ints, reals, oss
    /// optional
    /// typedef int TNum
    ///  Check whether the Num data member has been assigned a value.
    bool IsSetNum(void) const;
    /// Check whether it is safe or not to call GetNum method.
    bool CanGetNum(void) const;
    void ResetNum(void);
    TNum GetNum(void) const;
    void SetNum(TNum value);
    TNum& SetNum(void);

    /// mandatory
    /// typedef C_Data TData
    ///  Check whether the Data data member has been assigned a value.
    bool IsSetData(void) const;
    /// Check whether it is safe or not to call GetData method.
    bool CanGetData(void) const;
    void ResetData(void);
    const TData& GetData(void) const;
    void SetData(TData& value);
    TData& SetData(void);

    /// Reset the whole object
    virtual void Reset(void);


private:
    // Prohibit copy constructor and assignment operator
    CUser_field_Base(const CUser_field_Base&);
    CUser_field_Base& operator=(const CUser_field_Base&);

    // data
    Uint4 m_set_State[1];
    CRef< TLabel > m_Label;
    int m_Num;
    CRef< TData > m_Data;
};






///////////////////////////////////////////////////////////
///////////////////// inline methods //////////////////////
///////////////////////////////////////////////////////////
inline
CUser_field_Base::C_Data::E_Choice CUser_field_Base::C_Data::Which(void) const
{
    return m_choice;
}

inline
void CUser_field_Base::C_Data::CheckSelected(E_Choice index) const
{
    if ( m_choice != index )
        ThrowInvalidSelection(index);
}

inline
void CUser_field_Base::C_Data::Select(E_Choice index, NCBI_NS_NCBI::EResetVariant reset, NCBI_NS_NCBI::CObjectMemoryPool* pool)
{
    if ( reset == NCBI_NS_NCBI::eDoResetVariant || m_choice != index ) {
        if ( m_choice != e_not_set )
            ResetSelection();
        DoSelect(index, pool);
    }
}

inline
void CUser_field_Base::C_Data::Select(E_Choice index, NCBI_NS_NCBI::EResetVariant reset)
{
    Select(index, reset, 0);
}

inline
bool CUser_field_Base::C_Data::IsStr(void) const
{
    return m_choice == e_Str;
}

inline
const CUser_field_Base::C_Data::TStr& CUser_field_Base::C_Data::GetStr(void) const
{
    CheckSelected(e_Str);
    return *m_string_utf8;
}

inline
CUser_field_Base::C_Data::TStr& CUser_field_Base::C_Data::SetStr(void)
{
    Select(e_Str, NCBI_NS_NCBI::eDoNotResetVariant);
    return *m_string_utf8;
}

inline
bool CUser_field_Base::C_Data::IsInt(void) const
{
    return m_choice == e_Int;
}

inline
CUser_field_Base::C_Data::TInt CUser_field_Base::C_Data::GetInt(void) const
{
    CheckSelected(e_Int);
    return m_Int;
}

inline
CUser_field_Base::C_Data::TInt& CUser_field_Base::C_Data::SetInt(void)
{
    Select(e_Int, NCBI_NS_NCBI::eDoNotResetVariant);
    return m_Int;
}

inline
void CUser_field_Base::C_Data::SetInt(CUser_field_Base::C_Data::TInt value)
{
    Select(e_Int, NCBI_NS_NCBI::eDoNotResetVariant);
    m_Int = value;
}

inline
bool CUser_field_Base::C_Data::IsReal(void) const
{
    return m_choice == e_Real;
}

inline
CUser_field_Base::C_Data::TReal CUser_field_Base::C_Data::GetReal(void) const
{
    CheckSelected(e_Real);
    return m_Real;
}

inline
CUser_field_Base::C_Data::TReal& CUser_field_Base::C_Data::SetReal(void)
{
    Select(e_Real, NCBI_NS_NCBI::eDoNotResetVariant);
    return m_Real;
}

inline
void CUser_field_Base::C_Data::SetReal(CUser_field_Base::C_Data::TReal value)
{
    Select(e_Real, NCBI_NS_NCBI::eDoNotResetVariant);
    m_Real = value;
}

inline
bool CUser_field_Base::C_Data::IsBool(void) const
{
    return m_choice == e_Bool;
}

inline
CUser_field_Base::C_Data::TBool CUser_field_Base::C_Data::GetBool(void) const
{
    CheckSelected(e_Bool);
    return m_Bool;
}

inline
CUser_field_Base::C_Data::TBool& CUser_field_Base::C_Data::SetBool(void)
{
    Select(e_Bool, NCBI_NS_NCBI::eDoNotResetVariant);
    return m_Bool;
}

inline
void CUser_field_Base::C_Data::SetBool(CUser_field_Base::C_Data::TBool value)
{
    Select(e_Bool, NCBI_NS_NCBI::eDoNotResetVariant);
    m_Bool = value;
}

inline
bool CUser_field_Base::C_Data::IsOs(void) const
{
    return m_choice == e_Os;
}

inline
const CUser_field_Base::C_Data::TOs& CUser_field_Base::C_Data::GetOs(void) const
{
    CheckSelected(e_Os);
    return *m_Os;
}

inline
CUser_field_Base::C_Data::TOs& CUser_field_Base::C_Data::SetOs(void)
{
    Select(e_Os, NCBI_NS_NCBI::eDoNotResetVariant);
    return *m_Os;
}

inline
bool CUser_field_Base::C_Data::IsObject(void) const
{
    return m_choice == e_Object;
}

inline
bool CUser_field_Base::C_Data::IsStrs(void) const
{
    return m_choice == e_Strs;
}

inline
const CUser_field_Base::C_Data::TStrs& CUser_field_Base::C_Data::GetStrs(void) const
{
    CheckSelected(e_Strs);
    return *m_Strs;
}

inline
CUser_field_Base::C_Data::TStrs& CUser_field_Base::C_Data::SetStrs(void)
{
    Select(e_Strs, NCBI_NS_NCBI::eDoNotResetVariant);
    return *m_Strs;
}

inline
bool CUser_field_Base::C_Data::IsInts(void) const
{
    return m_choice == e_Ints;
}

inline
const CUser_field_Base::C_Data::TInts& CUser_field_Base::C_Data::GetInts(void) const
{
    CheckSelected(e_Ints);
    return *m_Ints;
}

inline
CUser_field_Base::C_Data::TInts& CUser_field_Base::C_Data::SetInts(void)
{
    Select(e_Ints, NCBI_NS_NCBI::eDoNotResetVariant);
    return *m_Ints;
}

inline
bool CUser_field_Base::C_Data::IsReals(void) const
{
    return m_choice == e_Reals;
}

inline
const CUser_field_Base::C_Data::TReals& CUser_field_Base::C_Data::GetReals(void) const
{
    CheckSelected(e_Reals);
    return *m_Reals;
}

inline
CUser_field_Base::C_Data::TReals& CUser_field_Base::C_Data::SetReals(void)
{
    Select(e_Reals, NCBI_NS_NCBI::eDoNotResetVariant);
    return *m_Reals;
}

inline
bool CUser_field_Base::C_Data::IsOss(void) const
{
    return m_choice == e_Oss;
}

inline
const CUser_field_Base::C_Data::TOss& CUser_field_Base::C_Data::GetOss(void) const
{
    CheckSelected(e_Oss);
    return *m_Oss;
}

inline
CUser_field_Base::C_Data::TOss& CUser_field_Base::C_Data::SetOss(void)
{
    Select(e_Oss, NCBI_NS_NCBI::eDoNotResetVariant);
    return *m_Oss;
}

inline
bool CUser_field_Base::C_Data::IsFields(void) const
{
    return m_choice == e_Fields;
}

inline
const CUser_field_Base::C_Data::TFields& CUser_field_Base::C_Data::GetFields(void) const
{
    CheckSelected(e_Fields);
    return *m_Fields;
}

inline
CUser_field_Base::C_Data::TFields& CUser_field_Base::C_Data::SetFields(void)
{
    Select(e_Fields, NCBI_NS_NCBI::eDoNotResetVariant);
    return *m_Fields;
}

inline
bool CUser_field_Base::C_Data::IsObjects(void) const
{
    return m_choice == e_Objects;
}

inline
const CUser_field_Base::C_Data::TObjects& CUser_field_Base::C_Data::GetObjects(void) const
{
    CheckSelected(e_Objects);
    return *m_Objects;
}

inline
CUser_field_Base::C_Data::TObjects& CUser_field_Base::C_Data::SetObjects(void)
{
    Select(e_Objects, NCBI_NS_NCBI::eDoNotResetVariant);
    return *m_Objects;
}

inline
bool CUser_field_Base::IsSetLabel(void) const
{
    return m_Label.NotEmpty();
}

inline
bool CUser_field_Base::CanGetLabel(void) const
{
    return true;
}

inline
const CUser_field_Base::TLabel& CUser_field_Base::GetLabel(void) const
{
    if ( !m_Label ) {
        const_cast<CUser_field_Base*>(this)->ResetLabel();
    }
    return (*m_Label);
}

inline
CUser_field_Base::TLabel& CUser_field_Base::SetLabel(void)
{
    if ( !m_Label ) {
        ResetLabel();
    }
    return (*m_Label);
}

inline
bool CUser_field_Base::IsSetNum(void) const
{
    return ((m_set_State[0] & 0xc) != 0);
}

inline
bool CUser_field_Base::CanGetNum(void) const
{
    return IsSetNum();
}

inline
void CUser_field_Base::ResetNum(void)
{
    m_Num = 0;
    m_set_State[0] &= ~0xc;
}

inline
CUser_field_Base::TNum CUser_field_Base::GetNum(void) const
{
    if (!CanGetNum()) {
        ThrowUnassigned(1);
    }
    return m_Num;
}

inline
void CUser_field_Base::SetNum(CUser_field_Base::TNum value)
{
    m_Num = value;
    m_set_State[0] |= 0xc;
}

inline
CUser_field_Base::TNum& CUser_field_Base::SetNum(void)
{
#ifdef _DEBUG
    if (!IsSetNum()) {
        memset(&m_Num,UnassignedByte(),sizeof(m_Num));
    }
#endif
    m_set_State[0] |= 0x4;
    return m_Num;
}

inline
bool CUser_field_Base::IsSetData(void) const
{
    return m_Data.NotEmpty();
}

inline
bool CUser_field_Base::CanGetData(void) const
{
    return true;
}

inline
const CUser_field_Base::TData& CUser_field_Base::GetData(void) const
{
    if ( !m_Data ) {
        const_cast<CUser_field_Base*>(this)->ResetData();
    }
    return (*m_Data);
}

inline
CUser_field_Base::TData& CUser_field_Base::SetData(void)
{
    if ( !m_Data ) {
        ResetData();
    }
    return (*m_Data);
}

///////////////////////////////////////////////////////////
////////////////// end of inline methods //////////////////
///////////////////////////////////////////////////////////





END_objects_SCOPE // namespace ncbi::objects::

END_NCBI_SCOPE


#endif // OBJECTS_GENERAL_USER_FIELD_BASE_HPP
