/* $Id$
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 */

/// @file GCClient_EquivalentAssembl_.hpp
/// Data storage class.
///
/// This file was generated by application DATATOOL
/// using the following specifications:
/// 'gencoll_client.asn'.
///
/// ATTENTION:
///   Don't edit or commit this file into CVS as this file will
///   be overridden (by DATATOOL) without warning!

#ifndef OBJECTS_GENOMECOLL_GCCLIENT_EQUIVALENTASSEMBL_BASE_HPP
#define OBJECTS_GENOMECOLL_GCCLIENT_EQUIVALENTASSEMBL_BASE_HPP

// standard includes
#include <serial/serialbase.hpp>

// generated includes
#include <list>
#include <string>

BEGIN_NCBI_SCOPE

#ifndef BEGIN_objects_SCOPE
#  define BEGIN_objects_SCOPE BEGIN_SCOPE(objects)
#  define END_objects_SCOPE END_SCOPE(objects)
#endif
BEGIN_objects_SCOPE // namespace ncbi::objects::


// generated classes

/////////////////////////////////////////////////////////////////////////////
class CGCClient_EquivalentAssemblies_Base : public CSerialObject
{
    typedef CSerialObject Tparent;
public:
    // constructor
    CGCClient_EquivalentAssemblies_Base(void);
    // destructor
    virtual ~CGCClient_EquivalentAssemblies_Base(void);

    // type info
    DECLARE_INTERNAL_TYPE_INFO();

    /////////////////////////////////////////////////////////////////////////////
    class C_E_Assemblies : public CSerialObject
    {
        typedef CSerialObject Tparent;
    public:
        // constructor
        C_E_Assemblies(void);
        // destructor
        ~C_E_Assemblies(void);
    
        // type info
        DECLARE_INTERNAL_TYPE_INFO();
    
        // types
        typedef string TAccession;
    
        // member index
        enum class E_memberIndex {
            e__allMandatory = 0,
            e_accession
        };
        typedef Tparent::CMemberIndex<E_memberIndex, 2> TmemberIndex;
    
        // getters
        // setters
    
        /// mandatory
        /// typedef string TAccession
        ///  Check whether the Accession data member has been assigned a value.
        bool IsSetAccession(void) const;
        /// Check whether it is safe or not to call GetAccession method.
        bool CanGetAccession(void) const;
        void ResetAccession(void);
        const TAccession& GetAccession(void) const;
        void SetAccession(const TAccession& value);
        void SetAccession(TAccession&& value);
        TAccession& SetAccession(void);
    
        /// Reset the whole object
        void Reset(void);
    
    
    private:
        // Prohibit copy constructor and assignment operator
        C_E_Assemblies(const C_E_Assemblies&);
        C_E_Assemblies& operator=(const C_E_Assemblies&);
    
        // data
        Uint4 m_set_State[1];
        string m_Accession;
    };
    // types
    typedef C_E_Assemblies C_E;
    typedef list< CRef< C_E_Assemblies > > TAssemblies;

    // member index
    enum class E_memberIndex {
        e__allMandatory = 0,
        e_assemblies
    };
    typedef Tparent::CMemberIndex<E_memberIndex, 2> TmemberIndex;

    // getters
    // setters

    /// mandatory
    /// typedef list< CRef< C_E_Assemblies > > TAssemblies
    ///  Check whether the Assemblies data member has been assigned a value.
    bool IsSetAssemblies(void) const;
    /// Check whether it is safe or not to call GetAssemblies method.
    bool CanGetAssemblies(void) const;
    void ResetAssemblies(void);
    const TAssemblies& GetAssemblies(void) const;
    TAssemblies& SetAssemblies(void);

    /// Reset the whole object
    virtual void Reset(void);


private:
    // Prohibit copy constructor and assignment operator
    CGCClient_EquivalentAssemblies_Base(const CGCClient_EquivalentAssemblies_Base&);
    CGCClient_EquivalentAssemblies_Base& operator=(const CGCClient_EquivalentAssemblies_Base&);

    // data
    Uint4 m_set_State[1];
    list< CRef< C_E_Assemblies > > m_Assemblies;
};






///////////////////////////////////////////////////////////
///////////////////// inline methods //////////////////////
///////////////////////////////////////////////////////////
inline
bool CGCClient_EquivalentAssemblies_Base::C_E_Assemblies::IsSetAccession(void) const
{
    return ((m_set_State[0] & 0x3) != 0);
}

inline
bool CGCClient_EquivalentAssemblies_Base::C_E_Assemblies::CanGetAccession(void) const
{
    return IsSetAccession();
}

inline
const CGCClient_EquivalentAssemblies_Base::C_E_Assemblies::TAccession& CGCClient_EquivalentAssemblies_Base::C_E_Assemblies::GetAccession(void) const
{
    if (!CanGetAccession()) {
        ThrowUnassigned(0);
    }
    return m_Accession;
}

inline
void CGCClient_EquivalentAssemblies_Base::C_E_Assemblies::SetAccession(const CGCClient_EquivalentAssemblies_Base::C_E_Assemblies::TAccession& value)
{
    m_Accession = value;
    m_set_State[0] |= 0x3;
}

inline
void CGCClient_EquivalentAssemblies_Base::C_E_Assemblies::SetAccession(CGCClient_EquivalentAssemblies_Base::C_E_Assemblies::TAccession&& value)
{
    m_Accession = std::forward<CGCClient_EquivalentAssemblies_Base::C_E_Assemblies::TAccession>(value);
    m_set_State[0] |= 0x3;
}

inline
CGCClient_EquivalentAssemblies_Base::C_E_Assemblies::TAccession& CGCClient_EquivalentAssemblies_Base::C_E_Assemblies::SetAccession(void)
{
#ifdef _DEBUG
    if (!IsSetAccession()) {
        m_Accession = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x1;
    return m_Accession;
}

inline
bool CGCClient_EquivalentAssemblies_Base::IsSetAssemblies(void) const
{
    return ((m_set_State[0] & 0x3) != 0);
}

inline
bool CGCClient_EquivalentAssemblies_Base::CanGetAssemblies(void) const
{
    return true;
}

inline
const CGCClient_EquivalentAssemblies_Base::TAssemblies& CGCClient_EquivalentAssemblies_Base::GetAssemblies(void) const
{
    return m_Assemblies;
}

inline
CGCClient_EquivalentAssemblies_Base::TAssemblies& CGCClient_EquivalentAssemblies_Base::SetAssemblies(void)
{
    m_set_State[0] |= 0x1;
    return m_Assemblies;
}

///////////////////////////////////////////////////////////
////////////////// end of inline methods //////////////////
///////////////////////////////////////////////////////////





END_objects_SCOPE // namespace ncbi::objects::

END_NCBI_SCOPE


#endif // OBJECTS_GENOMECOLL_GCCLIENT_EQUIVALENTASSEMBL_BASE_HPP
