/* $Id$
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 */

/// @file HG_CommentarySet_.hpp
/// Data storage class.
///
/// This file was generated by application DATATOOL
/// using the following specifications:
/// 'homologene.asn'.
///
/// ATTENTION:
///   Don't edit or commit this file into CVS as this file will
///   be overridden (by DATATOOL) without warning!

#ifndef OBJECTS_HOMOLOGENE_HG_COMMENTARYSET_BASE_HPP
#define OBJECTS_HOMOLOGENE_HG_COMMENTARYSET_BASE_HPP

// standard includes
#include <serial/serialbase.hpp>

// generated includes
#include <list>
#include <string>

BEGIN_NCBI_SCOPE

#ifndef BEGIN_objects_SCOPE
#  define BEGIN_objects_SCOPE BEGIN_SCOPE(objects)
#  define END_objects_SCOPE END_SCOPE(objects)
#endif
BEGIN_objects_SCOPE // namespace ncbi::objects::


// forward declarations
class CHG_Commentary;


// generated classes

/////////////////////////////////////////////////////////////////////////////
class CHG_CommentarySet_Base : public CSerialObject
{
    typedef CSerialObject Tparent;
public:
    // constructor
    CHG_CommentarySet_Base(void);
    // destructor
    virtual ~CHG_CommentarySet_Base(void);

    // type info
    DECLARE_INTERNAL_TYPE_INFO();

    // types
    typedef int THg_id;
    typedef string TTitle;
    typedef list< CRef< CHG_Commentary > > TCommentaries;

    // member index
    enum class E_memberIndex {
        e__allMandatory = 0,
        e_hg_id,
        e_title,
        e_commentaries
    };
    typedef Tparent::CMemberIndex<E_memberIndex, 4> TmemberIndex;

    // getters
    // setters

    /// optional
    /// typedef int THg_id
    ///  Check whether the Hg_id data member has been assigned a value.
    bool IsSetHg_id(void) const;
    /// Check whether it is safe or not to call GetHg_id method.
    bool CanGetHg_id(void) const;
    void ResetHg_id(void);
    THg_id GetHg_id(void) const;
    void SetHg_id(THg_id value);
    THg_id& SetHg_id(void);

    /// mandatory
    /// typedef string TTitle
    ///  Check whether the Title data member has been assigned a value.
    bool IsSetTitle(void) const;
    /// Check whether it is safe or not to call GetTitle method.
    bool CanGetTitle(void) const;
    void ResetTitle(void);
    const TTitle& GetTitle(void) const;
    void SetTitle(const TTitle& value);
    void SetTitle(TTitle&& value);
    TTitle& SetTitle(void);

    /// mandatory
    /// typedef list< CRef< CHG_Commentary > > TCommentaries
    ///  Check whether the Commentaries data member has been assigned a value.
    bool IsSetCommentaries(void) const;
    /// Check whether it is safe or not to call GetCommentaries method.
    bool CanGetCommentaries(void) const;
    void ResetCommentaries(void);
    const TCommentaries& GetCommentaries(void) const;
    TCommentaries& SetCommentaries(void);

    /// Reset the whole object
    virtual void Reset(void);


private:
    // Prohibit copy constructor and assignment operator
    CHG_CommentarySet_Base(const CHG_CommentarySet_Base&);
    CHG_CommentarySet_Base& operator=(const CHG_CommentarySet_Base&);

    // data
    Uint4 m_set_State[1];
    int m_Hg_id;
    string m_Title;
    list< CRef< CHG_Commentary > > m_Commentaries;
};






///////////////////////////////////////////////////////////
///////////////////// inline methods //////////////////////
///////////////////////////////////////////////////////////
inline
bool CHG_CommentarySet_Base::IsSetHg_id(void) const
{
    return ((m_set_State[0] & 0x3) != 0);
}

inline
bool CHG_CommentarySet_Base::CanGetHg_id(void) const
{
    return IsSetHg_id();
}

inline
void CHG_CommentarySet_Base::ResetHg_id(void)
{
    m_Hg_id = 0;
    m_set_State[0] &= ~0x3;
}

inline
CHG_CommentarySet_Base::THg_id CHG_CommentarySet_Base::GetHg_id(void) const
{
    if (!CanGetHg_id()) {
        ThrowUnassigned(0);
    }
    return m_Hg_id;
}

inline
void CHG_CommentarySet_Base::SetHg_id(CHG_CommentarySet_Base::THg_id value)
{
    m_Hg_id = value;
    m_set_State[0] |= 0x3;
}

inline
CHG_CommentarySet_Base::THg_id& CHG_CommentarySet_Base::SetHg_id(void)
{
#ifdef _DEBUG
    if (!IsSetHg_id()) {
        memset(&m_Hg_id,UnassignedByte(),sizeof(m_Hg_id));
    }
#endif
    m_set_State[0] |= 0x1;
    return m_Hg_id;
}

inline
bool CHG_CommentarySet_Base::IsSetTitle(void) const
{
    return ((m_set_State[0] & 0xc) != 0);
}

inline
bool CHG_CommentarySet_Base::CanGetTitle(void) const
{
    return IsSetTitle();
}

inline
const CHG_CommentarySet_Base::TTitle& CHG_CommentarySet_Base::GetTitle(void) const
{
    if (!CanGetTitle()) {
        ThrowUnassigned(1);
    }
    return m_Title;
}

inline
void CHG_CommentarySet_Base::SetTitle(const CHG_CommentarySet_Base::TTitle& value)
{
    m_Title = value;
    m_set_State[0] |= 0xc;
}

inline
void CHG_CommentarySet_Base::SetTitle(CHG_CommentarySet_Base::TTitle&& value)
{
    m_Title = std::forward<CHG_CommentarySet_Base::TTitle>(value);
    m_set_State[0] |= 0xc;
}

inline
CHG_CommentarySet_Base::TTitle& CHG_CommentarySet_Base::SetTitle(void)
{
#ifdef _DEBUG
    if (!IsSetTitle()) {
        m_Title = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x4;
    return m_Title;
}

inline
bool CHG_CommentarySet_Base::IsSetCommentaries(void) const
{
    return ((m_set_State[0] & 0x30) != 0);
}

inline
bool CHG_CommentarySet_Base::CanGetCommentaries(void) const
{
    return true;
}

inline
const CHG_CommentarySet_Base::TCommentaries& CHG_CommentarySet_Base::GetCommentaries(void) const
{
    return m_Commentaries;
}

inline
CHG_CommentarySet_Base::TCommentaries& CHG_CommentarySet_Base::SetCommentaries(void)
{
    m_set_State[0] |= 0x10;
    return m_Commentaries;
}

///////////////////////////////////////////////////////////
////////////////// end of inline methods //////////////////
///////////////////////////////////////////////////////////





END_objects_SCOPE // namespace ncbi::objects::

END_NCBI_SCOPE


#endif // OBJECTS_HOMOLOGENE_HG_COMMENTARYSET_BASE_HPP
