/* $Id$
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 */

/// @file INSDFeatureSet_.hpp
/// Data storage class.
///
/// This file was generated by application DATATOOL
/// using the following specifications:
/// 'insdseq.asn'.
///
/// ATTENTION:
///   Don't edit or commit this file into CVS as this file will
///   be overridden (by DATATOOL) without warning!

#ifndef OBJECTS_INSDSEQ_INSDFEATURESET_BASE_HPP
#define OBJECTS_INSDSEQ_INSDFEATURESET_BASE_HPP

// standard includes
#include <serial/serialbase.hpp>

// generated includes
#include <list>
#include <string>

BEGIN_NCBI_SCOPE

#ifndef BEGIN_objects_SCOPE
#  define BEGIN_objects_SCOPE BEGIN_SCOPE(objects)
#  define END_objects_SCOPE END_SCOPE(objects)
#endif
BEGIN_objects_SCOPE // namespace ncbi::objects::


// forward declarations
class CINSDFeature;


// generated classes

/////////////////////////////////////////////////////////////////////////////
/// INSDFeature_operator contains a string value describing
/// the relationship among a set of INSDInterval within
/// INSDFeature_intervals. The allowable formats are:
///
///   join :  The string literal 'join' indicates that the
///           INSDInterval intervals are biologically joined
///           together into a contiguous molecule.
///
///   order : The string literal 'order' indicates that the
///           INSDInterval intervals are in the presented
///           order, but they are not necessarily contiguous.
///
///   Either 'join' or 'order' is required if INSDFeature_intervals
///   is comprised of more than one INSDInterval .
class NCBI_INSDSEQ_EXPORT CINSDFeatureSet_Base : public CSerialObject
{
    typedef CSerialObject Tparent;
public:
    // constructor
    CINSDFeatureSet_Base(void);
    // destructor
    virtual ~CINSDFeatureSet_Base(void);

    // type info
    DECLARE_INTERNAL_TYPE_INFO();

    // types
    typedef string TAnnot_source;
    typedef list< CRef< CINSDFeature > > TFeatures;

    // member index
    enum class E_memberIndex {
        e__allMandatory = 0,
        e_annot_source,
        e_features
    };
    typedef Tparent::CMemberIndex<E_memberIndex, 3> TmemberIndex;

    // getters
    // setters

    /// optional
    /// typedef string TAnnot_source
    ///  Check whether the Annot_source data member has been assigned a value.
    bool IsSetAnnot_source(void) const;
    /// Check whether it is safe or not to call GetAnnot_source method.
    bool CanGetAnnot_source(void) const;
    void ResetAnnot_source(void);
    const TAnnot_source& GetAnnot_source(void) const;
    void SetAnnot_source(const TAnnot_source& value);
    void SetAnnot_source(TAnnot_source&& value);
    TAnnot_source& SetAnnot_source(void);

    /// mandatory
    /// typedef list< CRef< CINSDFeature > > TFeatures
    ///  Check whether the Features data member has been assigned a value.
    bool IsSetFeatures(void) const;
    /// Check whether it is safe or not to call GetFeatures method.
    bool CanGetFeatures(void) const;
    void ResetFeatures(void);
    const TFeatures& GetFeatures(void) const;
    TFeatures& SetFeatures(void);

    /// Reset the whole object
    virtual void Reset(void);


private:
    // Prohibit copy constructor and assignment operator
    CINSDFeatureSet_Base(const CINSDFeatureSet_Base&);
    CINSDFeatureSet_Base& operator=(const CINSDFeatureSet_Base&);

    // data
    Uint4 m_set_State[1];
    string m_Annot_source;
    list< CRef< CINSDFeature > > m_Features;
};






///////////////////////////////////////////////////////////
///////////////////// inline methods //////////////////////
///////////////////////////////////////////////////////////
inline
bool CINSDFeatureSet_Base::IsSetAnnot_source(void) const
{
    return ((m_set_State[0] & 0x3) != 0);
}

inline
bool CINSDFeatureSet_Base::CanGetAnnot_source(void) const
{
    return IsSetAnnot_source();
}

inline
const CINSDFeatureSet_Base::TAnnot_source& CINSDFeatureSet_Base::GetAnnot_source(void) const
{
    if (!CanGetAnnot_source()) {
        ThrowUnassigned(0);
    }
    return m_Annot_source;
}

inline
void CINSDFeatureSet_Base::SetAnnot_source(const CINSDFeatureSet_Base::TAnnot_source& value)
{
    m_Annot_source = value;
    m_set_State[0] |= 0x3;
}

inline
void CINSDFeatureSet_Base::SetAnnot_source(CINSDFeatureSet_Base::TAnnot_source&& value)
{
    m_Annot_source = std::forward<CINSDFeatureSet_Base::TAnnot_source>(value);
    m_set_State[0] |= 0x3;
}

inline
CINSDFeatureSet_Base::TAnnot_source& CINSDFeatureSet_Base::SetAnnot_source(void)
{
#ifdef _DEBUG
    if (!IsSetAnnot_source()) {
        m_Annot_source = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x1;
    return m_Annot_source;
}

inline
bool CINSDFeatureSet_Base::IsSetFeatures(void) const
{
    return ((m_set_State[0] & 0xc) != 0);
}

inline
bool CINSDFeatureSet_Base::CanGetFeatures(void) const
{
    return true;
}

inline
const CINSDFeatureSet_Base::TFeatures& CINSDFeatureSet_Base::GetFeatures(void) const
{
    return m_Features;
}

inline
CINSDFeatureSet_Base::TFeatures& CINSDFeatureSet_Base::SetFeatures(void)
{
    m_set_State[0] |= 0x4;
    return m_Features;
}

///////////////////////////////////////////////////////////
////////////////// end of inline methods //////////////////
///////////////////////////////////////////////////////////





END_objects_SCOPE // namespace ncbi::objects::

END_NCBI_SCOPE


#endif // OBJECTS_INSDSEQ_INSDFEATURESET_BASE_HPP
