/* $Id$
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 */

/// @file INSDFeature_.hpp
/// Data storage class.
///
/// This file was generated by application DATATOOL
/// using the following specifications:
/// 'insdseq.asn'.
///
/// ATTENTION:
///   Don't edit or commit this file into CVS as this file will
///   be overridden (by DATATOOL) without warning!

#ifndef OBJECTS_INSDSEQ_INSDFEATURE_BASE_HPP
#define OBJECTS_INSDSEQ_INSDFEATURE_BASE_HPP

// standard includes
#include <serial/serialbase.hpp>

// generated includes
#include <list>
#include <string>

BEGIN_NCBI_SCOPE

#ifndef BEGIN_objects_SCOPE
#  define BEGIN_objects_SCOPE BEGIN_SCOPE(objects)
#  define END_objects_SCOPE END_SCOPE(objects)
#endif
BEGIN_objects_SCOPE // namespace ncbi::objects::


// forward declarations
class CINSDInterval;
class CINSDQualifier;
class CINSDXref;


// generated classes

/////////////////////////////////////////////////////////////////////////////
class NCBI_INSDSEQ_EXPORT CINSDFeature_Base : public CSerialObject
{
    typedef CSerialObject Tparent;
public:
    // constructor
    CINSDFeature_Base(void);
    // destructor
    virtual ~CINSDFeature_Base(void);

    // type info
    DECLARE_INTERNAL_TYPE_INFO();

    // types
    typedef string TKey;
    typedef string TLocation;
    typedef list< CRef< CINSDInterval > > TIntervals;
    typedef string TOperator;
    typedef bool TPartial5;
    typedef bool TPartial3;
    typedef list< CRef< CINSDQualifier > > TQuals;
    typedef list< CRef< CINSDXref > > TXrefs;

    // member index
    enum class E_memberIndex {
        e__allMandatory = 0,
        e_key,
        e_location,
        e_intervals,
        e_operator,
        e_partial5,
        e_partial3,
        e_quals,
        e_xrefs
    };
    typedef Tparent::CMemberIndex<E_memberIndex, 9> TmemberIndex;

    // getters
    // setters

    /// mandatory
    /// typedef string TKey
    ///  Check whether the Key data member has been assigned a value.
    bool IsSetKey(void) const;
    /// Check whether it is safe or not to call GetKey method.
    bool CanGetKey(void) const;
    void ResetKey(void);
    const TKey& GetKey(void) const;
    void SetKey(const TKey& value);
    void SetKey(TKey&& value);
    TKey& SetKey(void);

    /// mandatory
    /// typedef string TLocation
    ///  Check whether the Location data member has been assigned a value.
    bool IsSetLocation(void) const;
    /// Check whether it is safe or not to call GetLocation method.
    bool CanGetLocation(void) const;
    void ResetLocation(void);
    const TLocation& GetLocation(void) const;
    void SetLocation(const TLocation& value);
    void SetLocation(TLocation&& value);
    TLocation& SetLocation(void);

    /// optional
    /// typedef list< CRef< CINSDInterval > > TIntervals
    ///  Check whether the Intervals data member has been assigned a value.
    bool IsSetIntervals(void) const;
    /// Check whether it is safe or not to call GetIntervals method.
    bool CanGetIntervals(void) const;
    void ResetIntervals(void);
    const TIntervals& GetIntervals(void) const;
    TIntervals& SetIntervals(void);

    /// optional
    /// typedef string TOperator
    ///  Check whether the Operator data member has been assigned a value.
    bool IsSetOperator(void) const;
    /// Check whether it is safe or not to call GetOperator method.
    bool CanGetOperator(void) const;
    void ResetOperator(void);
    const TOperator& GetOperator(void) const;
    void SetOperator(const TOperator& value);
    void SetOperator(TOperator&& value);
    TOperator& SetOperator(void);

    /// optional
    /// typedef bool TPartial5
    ///  Check whether the Partial5 data member has been assigned a value.
    bool IsSetPartial5(void) const;
    /// Check whether it is safe or not to call GetPartial5 method.
    bool CanGetPartial5(void) const;
    void ResetPartial5(void);
    TPartial5 GetPartial5(void) const;
    void SetPartial5(TPartial5 value);
    TPartial5& SetPartial5(void);

    /// optional
    /// typedef bool TPartial3
    ///  Check whether the Partial3 data member has been assigned a value.
    bool IsSetPartial3(void) const;
    /// Check whether it is safe or not to call GetPartial3 method.
    bool CanGetPartial3(void) const;
    void ResetPartial3(void);
    TPartial3 GetPartial3(void) const;
    void SetPartial3(TPartial3 value);
    TPartial3& SetPartial3(void);

    /// optional
    /// typedef list< CRef< CINSDQualifier > > TQuals
    ///  Check whether the Quals data member has been assigned a value.
    bool IsSetQuals(void) const;
    /// Check whether it is safe or not to call GetQuals method.
    bool CanGetQuals(void) const;
    void ResetQuals(void);
    const TQuals& GetQuals(void) const;
    TQuals& SetQuals(void);

    /// optional
    /// typedef list< CRef< CINSDXref > > TXrefs
    ///  Check whether the Xrefs data member has been assigned a value.
    bool IsSetXrefs(void) const;
    /// Check whether it is safe or not to call GetXrefs method.
    bool CanGetXrefs(void) const;
    void ResetXrefs(void);
    const TXrefs& GetXrefs(void) const;
    TXrefs& SetXrefs(void);

    /// Reset the whole object
    virtual void Reset(void);


private:
    // Prohibit copy constructor and assignment operator
    CINSDFeature_Base(const CINSDFeature_Base&);
    CINSDFeature_Base& operator=(const CINSDFeature_Base&);

    // data
    Uint4 m_set_State[1];
    string m_Key;
    string m_Location;
    list< CRef< CINSDInterval > > m_Intervals;
    string m_Operator;
    bool m_Partial5;
    bool m_Partial3;
    list< CRef< CINSDQualifier > > m_Quals;
    list< CRef< CINSDXref > > m_Xrefs;
};






///////////////////////////////////////////////////////////
///////////////////// inline methods //////////////////////
///////////////////////////////////////////////////////////
inline
bool CINSDFeature_Base::IsSetKey(void) const
{
    return ((m_set_State[0] & 0x3) != 0);
}

inline
bool CINSDFeature_Base::CanGetKey(void) const
{
    return IsSetKey();
}

inline
const CINSDFeature_Base::TKey& CINSDFeature_Base::GetKey(void) const
{
    if (!CanGetKey()) {
        ThrowUnassigned(0);
    }
    return m_Key;
}

inline
void CINSDFeature_Base::SetKey(const CINSDFeature_Base::TKey& value)
{
    m_Key = value;
    m_set_State[0] |= 0x3;
}

inline
void CINSDFeature_Base::SetKey(CINSDFeature_Base::TKey&& value)
{
    m_Key = std::forward<CINSDFeature_Base::TKey>(value);
    m_set_State[0] |= 0x3;
}

inline
CINSDFeature_Base::TKey& CINSDFeature_Base::SetKey(void)
{
#ifdef _DEBUG
    if (!IsSetKey()) {
        m_Key = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x1;
    return m_Key;
}

inline
bool CINSDFeature_Base::IsSetLocation(void) const
{
    return ((m_set_State[0] & 0xc) != 0);
}

inline
bool CINSDFeature_Base::CanGetLocation(void) const
{
    return IsSetLocation();
}

inline
const CINSDFeature_Base::TLocation& CINSDFeature_Base::GetLocation(void) const
{
    if (!CanGetLocation()) {
        ThrowUnassigned(1);
    }
    return m_Location;
}

inline
void CINSDFeature_Base::SetLocation(const CINSDFeature_Base::TLocation& value)
{
    m_Location = value;
    m_set_State[0] |= 0xc;
}

inline
void CINSDFeature_Base::SetLocation(CINSDFeature_Base::TLocation&& value)
{
    m_Location = std::forward<CINSDFeature_Base::TLocation>(value);
    m_set_State[0] |= 0xc;
}

inline
CINSDFeature_Base::TLocation& CINSDFeature_Base::SetLocation(void)
{
#ifdef _DEBUG
    if (!IsSetLocation()) {
        m_Location = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x4;
    return m_Location;
}

inline
bool CINSDFeature_Base::IsSetIntervals(void) const
{
    return ((m_set_State[0] & 0x30) != 0);
}

inline
bool CINSDFeature_Base::CanGetIntervals(void) const
{
    return true;
}

inline
const CINSDFeature_Base::TIntervals& CINSDFeature_Base::GetIntervals(void) const
{
    return m_Intervals;
}

inline
CINSDFeature_Base::TIntervals& CINSDFeature_Base::SetIntervals(void)
{
    m_set_State[0] |= 0x10;
    return m_Intervals;
}

inline
bool CINSDFeature_Base::IsSetOperator(void) const
{
    return ((m_set_State[0] & 0xc0) != 0);
}

inline
bool CINSDFeature_Base::CanGetOperator(void) const
{
    return IsSetOperator();
}

inline
const CINSDFeature_Base::TOperator& CINSDFeature_Base::GetOperator(void) const
{
    if (!CanGetOperator()) {
        ThrowUnassigned(3);
    }
    return m_Operator;
}

inline
void CINSDFeature_Base::SetOperator(const CINSDFeature_Base::TOperator& value)
{
    m_Operator = value;
    m_set_State[0] |= 0xc0;
}

inline
void CINSDFeature_Base::SetOperator(CINSDFeature_Base::TOperator&& value)
{
    m_Operator = std::forward<CINSDFeature_Base::TOperator>(value);
    m_set_State[0] |= 0xc0;
}

inline
CINSDFeature_Base::TOperator& CINSDFeature_Base::SetOperator(void)
{
#ifdef _DEBUG
    if (!IsSetOperator()) {
        m_Operator = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x40;
    return m_Operator;
}

inline
bool CINSDFeature_Base::IsSetPartial5(void) const
{
    return ((m_set_State[0] & 0x300) != 0);
}

inline
bool CINSDFeature_Base::CanGetPartial5(void) const
{
    return IsSetPartial5();
}

inline
void CINSDFeature_Base::ResetPartial5(void)
{
    m_Partial5 = 0;
    m_set_State[0] &= ~0x300;
}

inline
CINSDFeature_Base::TPartial5 CINSDFeature_Base::GetPartial5(void) const
{
    if (!CanGetPartial5()) {
        ThrowUnassigned(4);
    }
    return m_Partial5;
}

inline
void CINSDFeature_Base::SetPartial5(CINSDFeature_Base::TPartial5 value)
{
    m_Partial5 = value;
    m_set_State[0] |= 0x300;
}

inline
CINSDFeature_Base::TPartial5& CINSDFeature_Base::SetPartial5(void)
{
#ifdef _DEBUG
    if (!IsSetPartial5()) {
        memset(&m_Partial5,UnassignedByte(),sizeof(m_Partial5));
    }
#endif
    m_set_State[0] |= 0x100;
    return m_Partial5;
}

inline
bool CINSDFeature_Base::IsSetPartial3(void) const
{
    return ((m_set_State[0] & 0xc00) != 0);
}

inline
bool CINSDFeature_Base::CanGetPartial3(void) const
{
    return IsSetPartial3();
}

inline
void CINSDFeature_Base::ResetPartial3(void)
{
    m_Partial3 = 0;
    m_set_State[0] &= ~0xc00;
}

inline
CINSDFeature_Base::TPartial3 CINSDFeature_Base::GetPartial3(void) const
{
    if (!CanGetPartial3()) {
        ThrowUnassigned(5);
    }
    return m_Partial3;
}

inline
void CINSDFeature_Base::SetPartial3(CINSDFeature_Base::TPartial3 value)
{
    m_Partial3 = value;
    m_set_State[0] |= 0xc00;
}

inline
CINSDFeature_Base::TPartial3& CINSDFeature_Base::SetPartial3(void)
{
#ifdef _DEBUG
    if (!IsSetPartial3()) {
        memset(&m_Partial3,UnassignedByte(),sizeof(m_Partial3));
    }
#endif
    m_set_State[0] |= 0x400;
    return m_Partial3;
}

inline
bool CINSDFeature_Base::IsSetQuals(void) const
{
    return ((m_set_State[0] & 0x3000) != 0);
}

inline
bool CINSDFeature_Base::CanGetQuals(void) const
{
    return true;
}

inline
const CINSDFeature_Base::TQuals& CINSDFeature_Base::GetQuals(void) const
{
    return m_Quals;
}

inline
CINSDFeature_Base::TQuals& CINSDFeature_Base::SetQuals(void)
{
    m_set_State[0] |= 0x1000;
    return m_Quals;
}

inline
bool CINSDFeature_Base::IsSetXrefs(void) const
{
    return ((m_set_State[0] & 0xc000) != 0);
}

inline
bool CINSDFeature_Base::CanGetXrefs(void) const
{
    return true;
}

inline
const CINSDFeature_Base::TXrefs& CINSDFeature_Base::GetXrefs(void) const
{
    return m_Xrefs;
}

inline
CINSDFeature_Base::TXrefs& CINSDFeature_Base::SetXrefs(void)
{
    m_set_State[0] |= 0x4000;
    return m_Xrefs;
}

///////////////////////////////////////////////////////////
////////////////// end of inline methods //////////////////
///////////////////////////////////////////////////////////





END_objects_SCOPE // namespace ncbi::objects::

END_NCBI_SCOPE


#endif // OBJECTS_INSDSEQ_INSDFEATURE_BASE_HPP
