/* $Id$
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 */

/// @file Apply_action_.hpp
/// Data storage class.
///
/// This file was generated by application DATATOOL
/// using the following specifications:
/// 'macro.asn'.
///
/// ATTENTION:
///   Don't edit or commit this file into CVS as this file will
///   be overridden (by DATATOOL) without warning!

#ifndef OBJECTS_MACRO_APPLY_ACTION_BASE_HPP
#define OBJECTS_MACRO_APPLY_ACTION_BASE_HPP

// standard includes
#include <serial/serialbase.hpp>

// generated includes
#include <string>
#include <objects/macro/ExistingTextOption.hpp>

BEGIN_NCBI_SCOPE

#ifndef BEGIN_objects_SCOPE
#  define BEGIN_objects_SCOPE BEGIN_SCOPE(objects)
#  define END_objects_SCOPE END_SCOPE(objects)
#endif
BEGIN_objects_SCOPE // namespace ncbi::objects::


// forward declarations
class CField_type;


// generated classes

/////////////////////////////////////////////////////////////////////////////
class CApply_action_Base : public CSerialObject
{
    typedef CSerialObject Tparent;
public:
    // constructor
    CApply_action_Base(void);
    // destructor
    virtual ~CApply_action_Base(void);

    // type info
    DECLARE_INTERNAL_TYPE_INFO();

    // types
    typedef CField_type TField;
    typedef string TValue;
    typedef EExistingTextOption TExisting_text;

    // member index
    enum class E_memberIndex {
        e__allMandatory = 0,
        e_field,
        e_value,
        e_existing_text
    };
    typedef Tparent::CMemberIndex<E_memberIndex, 4> TmemberIndex;

    // getters
    // setters

    /// mandatory
    /// typedef CField_type TField
    ///  Check whether the Field data member has been assigned a value.
    bool IsSetField(void) const;
    /// Check whether it is safe or not to call GetField method.
    bool CanGetField(void) const;
    void ResetField(void);
    const TField& GetField(void) const;
    void SetField(TField& value);
    TField& SetField(void);

    /// mandatory
    /// typedef string TValue
    ///  Check whether the Value data member has been assigned a value.
    bool IsSetValue(void) const;
    /// Check whether it is safe or not to call GetValue method.
    bool CanGetValue(void) const;
    void ResetValue(void);
    const TValue& GetValue(void) const;
    void SetValue(const TValue& value);
    void SetValue(TValue&& value);
    TValue& SetValue(void);

    /// mandatory
    /// typedef EExistingTextOption TExisting_text
    ///  Check whether the Existing_text data member has been assigned a value.
    bool IsSetExisting_text(void) const;
    /// Check whether it is safe or not to call GetExisting_text method.
    bool CanGetExisting_text(void) const;
    void ResetExisting_text(void);
    TExisting_text GetExisting_text(void) const;
    void SetExisting_text(TExisting_text value);
    TExisting_text& SetExisting_text(void);

    /// Reset the whole object
    virtual void Reset(void);


private:
    // Prohibit copy constructor and assignment operator
    CApply_action_Base(const CApply_action_Base&);
    CApply_action_Base& operator=(const CApply_action_Base&);

    // data
    Uint4 m_set_State[1];
    CRef< TField > m_Field;
    string m_Value;
    EExistingTextOption m_Existing_text;
};






///////////////////////////////////////////////////////////
///////////////////// inline methods //////////////////////
///////////////////////////////////////////////////////////
inline
bool CApply_action_Base::IsSetField(void) const
{
    return m_Field.NotEmpty();
}

inline
bool CApply_action_Base::CanGetField(void) const
{
    return true;
}

inline
const CApply_action_Base::TField& CApply_action_Base::GetField(void) const
{
    if ( !m_Field ) {
        const_cast<CApply_action_Base*>(this)->ResetField();
    }
    return (*m_Field);
}

inline
CApply_action_Base::TField& CApply_action_Base::SetField(void)
{
    if ( !m_Field ) {
        ResetField();
    }
    return (*m_Field);
}

inline
bool CApply_action_Base::IsSetValue(void) const
{
    return ((m_set_State[0] & 0xc) != 0);
}

inline
bool CApply_action_Base::CanGetValue(void) const
{
    return IsSetValue();
}

inline
const CApply_action_Base::TValue& CApply_action_Base::GetValue(void) const
{
    if (!CanGetValue()) {
        ThrowUnassigned(1);
    }
    return m_Value;
}

inline
void CApply_action_Base::SetValue(const CApply_action_Base::TValue& value)
{
    m_Value = value;
    m_set_State[0] |= 0xc;
}

inline
void CApply_action_Base::SetValue(CApply_action_Base::TValue&& value)
{
    m_Value = std::forward<CApply_action_Base::TValue>(value);
    m_set_State[0] |= 0xc;
}

inline
CApply_action_Base::TValue& CApply_action_Base::SetValue(void)
{
#ifdef _DEBUG
    if (!IsSetValue()) {
        m_Value = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x4;
    return m_Value;
}

inline
bool CApply_action_Base::IsSetExisting_text(void) const
{
    return ((m_set_State[0] & 0x30) != 0);
}

inline
bool CApply_action_Base::CanGetExisting_text(void) const
{
    return IsSetExisting_text();
}

inline
void CApply_action_Base::ResetExisting_text(void)
{
    m_Existing_text = (ncbi::objects::EExistingTextOption)(0);
    m_set_State[0] &= ~0x30;
}

inline
CApply_action_Base::TExisting_text CApply_action_Base::GetExisting_text(void) const
{
    if (!CanGetExisting_text()) {
        ThrowUnassigned(2);
    }
    return m_Existing_text;
}

inline
void CApply_action_Base::SetExisting_text(CApply_action_Base::TExisting_text value)
{
    m_Existing_text = value;
    m_set_State[0] |= 0x30;
}

inline
CApply_action_Base::TExisting_text& CApply_action_Base::SetExisting_text(void)
{
#ifdef _DEBUG
    if (!IsSetExisting_text()) {
        memset(&m_Existing_text,UnassignedByte(),sizeof(m_Existing_text));
    }
#endif
    m_set_State[0] |= 0x10;
    return m_Existing_text;
}

///////////////////////////////////////////////////////////
////////////////// end of inline methods //////////////////
///////////////////////////////////////////////////////////





END_objects_SCOPE // namespace ncbi::objects::

END_NCBI_SCOPE


#endif // OBJECTS_MACRO_APPLY_ACTION_BASE_HPP
