/* $Id$
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 */

/// @file Remove_outside_action_.hpp
/// Data storage class.
///
/// This file was generated by application DATATOOL
/// using the following specifications:
/// 'macro.asn'.
///
/// ATTENTION:
///   Don't edit or commit this file into CVS as this file will
///   be overridden (by DATATOOL) without warning!

#ifndef OBJECTS_MACRO_REMOVE_OUTSIDE_ACTION_BASE_HPP
#define OBJECTS_MACRO_REMOVE_OUTSIDE_ACTION_BASE_HPP

// standard includes
#include <serial/serialbase.hpp>
BEGIN_NCBI_SCOPE

#ifndef BEGIN_objects_SCOPE
#  define BEGIN_objects_SCOPE BEGIN_SCOPE(objects)
#  define END_objects_SCOPE END_SCOPE(objects)
#endif
BEGIN_objects_SCOPE // namespace ncbi::objects::


// forward declarations
class CField_type;
class CText_portion;


// generated classes

/////////////////////////////////////////////////////////////////////////////
class CRemove_outside_action_Base : public CSerialObject
{
    typedef CSerialObject Tparent;
public:
    // constructor
    CRemove_outside_action_Base(void);
    // destructor
    virtual ~CRemove_outside_action_Base(void);

    // type info
    DECLARE_INTERNAL_TYPE_INFO();

    // types
    typedef CText_portion TPortion;
    typedef CField_type TField;
    typedef bool TRemove_if_not_found;

    // member index
    enum class E_memberIndex {
        e__allMandatory = 0,
        e_portion,
        e_field,
        e_remove_if_not_found
    };
    typedef Tparent::CMemberIndex<E_memberIndex, 4> TmemberIndex;

    // getters
    // setters

    /// mandatory
    /// typedef CText_portion TPortion
    ///  Check whether the Portion data member has been assigned a value.
    bool IsSetPortion(void) const;
    /// Check whether it is safe or not to call GetPortion method.
    bool CanGetPortion(void) const;
    void ResetPortion(void);
    const TPortion& GetPortion(void) const;
    void SetPortion(TPortion& value);
    TPortion& SetPortion(void);

    /// mandatory
    /// typedef CField_type TField
    ///  Check whether the Field data member has been assigned a value.
    bool IsSetField(void) const;
    /// Check whether it is safe or not to call GetField method.
    bool CanGetField(void) const;
    void ResetField(void);
    const TField& GetField(void) const;
    void SetField(TField& value);
    TField& SetField(void);

    /// optional with default false
    /// typedef bool TRemove_if_not_found
    ///  Check whether the Remove_if_not_found data member has been assigned a value.
    bool IsSetRemove_if_not_found(void) const;
    /// Check whether it is safe or not to call GetRemove_if_not_found method.
    bool CanGetRemove_if_not_found(void) const;
    void ResetRemove_if_not_found(void);
    void SetDefaultRemove_if_not_found(void);
    TRemove_if_not_found GetRemove_if_not_found(void) const;
    void SetRemove_if_not_found(TRemove_if_not_found value);
    TRemove_if_not_found& SetRemove_if_not_found(void);

    /// Reset the whole object
    virtual void Reset(void);


private:
    // Prohibit copy constructor and assignment operator
    CRemove_outside_action_Base(const CRemove_outside_action_Base&);
    CRemove_outside_action_Base& operator=(const CRemove_outside_action_Base&);

    // data
    Uint4 m_set_State[1];
    CRef< TPortion > m_Portion;
    CRef< TField > m_Field;
    bool m_Remove_if_not_found;
};






///////////////////////////////////////////////////////////
///////////////////// inline methods //////////////////////
///////////////////////////////////////////////////////////
inline
bool CRemove_outside_action_Base::IsSetPortion(void) const
{
    return m_Portion.NotEmpty();
}

inline
bool CRemove_outside_action_Base::CanGetPortion(void) const
{
    return true;
}

inline
const CRemove_outside_action_Base::TPortion& CRemove_outside_action_Base::GetPortion(void) const
{
    if ( !m_Portion ) {
        const_cast<CRemove_outside_action_Base*>(this)->ResetPortion();
    }
    return (*m_Portion);
}

inline
CRemove_outside_action_Base::TPortion& CRemove_outside_action_Base::SetPortion(void)
{
    if ( !m_Portion ) {
        ResetPortion();
    }
    return (*m_Portion);
}

inline
bool CRemove_outside_action_Base::IsSetField(void) const
{
    return m_Field.NotEmpty();
}

inline
bool CRemove_outside_action_Base::CanGetField(void) const
{
    return true;
}

inline
const CRemove_outside_action_Base::TField& CRemove_outside_action_Base::GetField(void) const
{
    if ( !m_Field ) {
        const_cast<CRemove_outside_action_Base*>(this)->ResetField();
    }
    return (*m_Field);
}

inline
CRemove_outside_action_Base::TField& CRemove_outside_action_Base::SetField(void)
{
    if ( !m_Field ) {
        ResetField();
    }
    return (*m_Field);
}

inline
bool CRemove_outside_action_Base::IsSetRemove_if_not_found(void) const
{
    return ((m_set_State[0] & 0x30) != 0);
}

inline
bool CRemove_outside_action_Base::CanGetRemove_if_not_found(void) const
{
    return true;
}

inline
void CRemove_outside_action_Base::ResetRemove_if_not_found(void)
{
    m_Remove_if_not_found = false;
    m_set_State[0] &= ~0x30;
}

inline
void CRemove_outside_action_Base::SetDefaultRemove_if_not_found(void)
{
    ResetRemove_if_not_found();
}

inline
CRemove_outside_action_Base::TRemove_if_not_found CRemove_outside_action_Base::GetRemove_if_not_found(void) const
{
    return m_Remove_if_not_found;
}

inline
void CRemove_outside_action_Base::SetRemove_if_not_found(CRemove_outside_action_Base::TRemove_if_not_found value)
{
    m_Remove_if_not_found = value;
    m_set_State[0] |= 0x30;
}

inline
CRemove_outside_action_Base::TRemove_if_not_found& CRemove_outside_action_Base::SetRemove_if_not_found(void)
{
#ifdef _DEBUG
    if (!IsSetRemove_if_not_found()) {
        memset(&m_Remove_if_not_found,UnassignedByte(),sizeof(m_Remove_if_not_found));
    }
#endif
    m_set_State[0] |= 0x10;
    return m_Remove_if_not_found;
}

///////////////////////////////////////////////////////////
////////////////// end of inline methods //////////////////
///////////////////////////////////////////////////////////





END_objects_SCOPE // namespace ncbi::objects::

END_NCBI_SCOPE


#endif // OBJECTS_MACRO_REMOVE_OUTSIDE_ACTION_BASE_HPP
