/* $Id$
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 */

/// @file Medline_rn_.hpp
/// Data storage class.
///
/// This file was generated by application DATATOOL
/// using the following specifications:
/// 'medline.asn'.
///
/// ATTENTION:
///   Don't edit or commit this file into CVS as this file will
///   be overridden (by DATATOOL) without warning!

#ifndef OBJECTS_MEDLINE_MEDLINE_RN_BASE_HPP
#define OBJECTS_MEDLINE_MEDLINE_RN_BASE_HPP

// standard includes
#include <serial/serialbase.hpp>

// generated includes
#include <string>

BEGIN_NCBI_SCOPE

#ifndef BEGIN_objects_SCOPE
#  define BEGIN_objects_SCOPE BEGIN_SCOPE(objects)
#  define END_objects_SCOPE END_SCOPE(objects)
#endif
BEGIN_objects_SCOPE // namespace ncbi::objects::


// generated classes

/////////////////////////////////////////////////////////////////////////////
/// medline substance records
class NCBI_MEDLINE_EXPORT CMedline_rn_Base : public CSerialObject
{
    typedef CSerialObject Tparent;
public:
    // constructor
    CMedline_rn_Base(void);
    // destructor
    virtual ~CMedline_rn_Base(void);

    // type info
    DECLARE_INTERNAL_TYPE_INFO();

    /// type of record
    enum EType {
        eType_nameonly = 0,
        eType_cas      = 1,  ///< CAS number
        eType_ec       = 2  ///< EC number
    };
    
    /// Access to EType's attributes (values, names) as defined in spec
    static const NCBI_NS_NCBI::CEnumeratedTypeValues* ENUM_METHOD_NAME(EType)(void);
    
    // types
    typedef EType TType;
    typedef string TCit;
    typedef string TName;

    // member index
    enum class E_memberIndex {
        e__allMandatory = 0,
        e_type,
        e_cit,
        e_name
    };
    typedef Tparent::CMemberIndex<E_memberIndex, 4> TmemberIndex;

    // getters
    // setters

    /// mandatory
    /// typedef EType TType
    ///  Check whether the Type data member has been assigned a value.
    bool IsSetType(void) const;
    /// Check whether it is safe or not to call GetType method.
    bool CanGetType(void) const;
    void ResetType(void);
    TType GetType(void) const;
    void SetType(TType value);
    TType& SetType(void);

    /// CAS or EC number if present
    /// optional
    /// typedef string TCit
    ///  Check whether the Cit data member has been assigned a value.
    bool IsSetCit(void) const;
    /// Check whether it is safe or not to call GetCit method.
    bool CanGetCit(void) const;
    void ResetCit(void);
    const TCit& GetCit(void) const;
    void SetCit(const TCit& value);
    void SetCit(TCit&& value);
    TCit& SetCit(void);

    /// name (always present)
    /// mandatory
    /// typedef string TName
    ///  Check whether the Name data member has been assigned a value.
    bool IsSetName(void) const;
    /// Check whether it is safe or not to call GetName method.
    bool CanGetName(void) const;
    void ResetName(void);
    const TName& GetName(void) const;
    void SetName(const TName& value);
    void SetName(TName&& value);
    TName& SetName(void);

    /// Reset the whole object
    virtual void Reset(void);


private:
    // Prohibit copy constructor and assignment operator
    CMedline_rn_Base(const CMedline_rn_Base&);
    CMedline_rn_Base& operator=(const CMedline_rn_Base&);

    // data
    Uint4 m_set_State[1];
    EType m_Type;
    string m_Cit;
    string m_Name;
};






///////////////////////////////////////////////////////////
///////////////////// inline methods //////////////////////
///////////////////////////////////////////////////////////
inline
bool CMedline_rn_Base::IsSetType(void) const
{
    return ((m_set_State[0] & 0x3) != 0);
}

inline
bool CMedline_rn_Base::CanGetType(void) const
{
    return IsSetType();
}

inline
void CMedline_rn_Base::ResetType(void)
{
    m_Type = (EType)(0);
    m_set_State[0] &= ~0x3;
}

inline
CMedline_rn_Base::TType CMedline_rn_Base::GetType(void) const
{
    if (!CanGetType()) {
        ThrowUnassigned(0);
    }
    return m_Type;
}

inline
void CMedline_rn_Base::SetType(CMedline_rn_Base::TType value)
{
    m_Type = value;
    m_set_State[0] |= 0x3;
}

inline
CMedline_rn_Base::TType& CMedline_rn_Base::SetType(void)
{
#ifdef _DEBUG
    if (!IsSetType()) {
        memset(&m_Type,UnassignedByte(),sizeof(m_Type));
    }
#endif
    m_set_State[0] |= 0x1;
    return m_Type;
}

inline
bool CMedline_rn_Base::IsSetCit(void) const
{
    return ((m_set_State[0] & 0xc) != 0);
}

inline
bool CMedline_rn_Base::CanGetCit(void) const
{
    return IsSetCit();
}

inline
const CMedline_rn_Base::TCit& CMedline_rn_Base::GetCit(void) const
{
    if (!CanGetCit()) {
        ThrowUnassigned(1);
    }
    return m_Cit;
}

inline
void CMedline_rn_Base::SetCit(const CMedline_rn_Base::TCit& value)
{
    m_Cit = value;
    m_set_State[0] |= 0xc;
}

inline
void CMedline_rn_Base::SetCit(CMedline_rn_Base::TCit&& value)
{
    m_Cit = std::forward<CMedline_rn_Base::TCit>(value);
    m_set_State[0] |= 0xc;
}

inline
CMedline_rn_Base::TCit& CMedline_rn_Base::SetCit(void)
{
#ifdef _DEBUG
    if (!IsSetCit()) {
        m_Cit = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x4;
    return m_Cit;
}

inline
bool CMedline_rn_Base::IsSetName(void) const
{
    return ((m_set_State[0] & 0x30) != 0);
}

inline
bool CMedline_rn_Base::CanGetName(void) const
{
    return IsSetName();
}

inline
const CMedline_rn_Base::TName& CMedline_rn_Base::GetName(void) const
{
    if (!CanGetName()) {
        ThrowUnassigned(2);
    }
    return m_Name;
}

inline
void CMedline_rn_Base::SetName(const CMedline_rn_Base::TName& value)
{
    m_Name = value;
    m_set_State[0] |= 0x30;
}

inline
void CMedline_rn_Base::SetName(CMedline_rn_Base::TName&& value)
{
    m_Name = std::forward<CMedline_rn_Base::TName>(value);
    m_set_State[0] |= 0x30;
}

inline
CMedline_rn_Base::TName& CMedline_rn_Base::SetName(void)
{
#ifdef _DEBUG
    if (!IsSetName()) {
        m_Name = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x10;
    return m_Name;
}

///////////////////////////////////////////////////////////
////////////////// end of inline methods //////////////////
///////////////////////////////////////////////////////////





END_objects_SCOPE // namespace ncbi::objects::

END_NCBI_SCOPE


#endif // OBJECTS_MEDLINE_MEDLINE_RN_BASE_HPP
