/* $Id$
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 */

/// @file Mim_edit_item_.hpp
/// Data storage class.
///
/// This file was generated by application DATATOOL
/// using the following specifications:
/// 'mim.asn'.
///
/// ATTENTION:
///   Don't edit or commit this file into CVS as this file will
///   be overridden (by DATATOOL) without warning!

#ifndef OBJECTS_MIM_MIM_EDIT_ITEM_BASE_HPP
#define OBJECTS_MIM_MIM_EDIT_ITEM_BASE_HPP

// standard includes
#include <serial/serialbase.hpp>

// generated includes
#include <string>

BEGIN_NCBI_SCOPE

#ifndef BEGIN_objects_SCOPE
#  define BEGIN_objects_SCOPE BEGIN_SCOPE(objects)
#  define END_objects_SCOPE END_SCOPE(objects)
#endif
BEGIN_objects_SCOPE // namespace ncbi::objects::


// forward declarations
class CMim_date;


// generated classes

/////////////////////////////////////////////////////////////////////////////
class NCBI_MIM_EXPORT CMim_edit_item_Base : public CSerialObject
{
    typedef CSerialObject Tparent;
public:
    // constructor
    CMim_edit_item_Base(void);
    // destructor
    virtual ~CMim_edit_item_Base(void);

    // type info
    DECLARE_INTERNAL_TYPE_INFO();

    // types
    typedef string TAuthor;
    typedef CMim_date TModDate;

    // member index
    enum class E_memberIndex {
        e__allMandatory = 0,
        e_author,
        e_modDate
    };
    typedef Tparent::CMemberIndex<E_memberIndex, 3> TmemberIndex;

    // getters
    // setters

    /// mandatory
    /// typedef string TAuthor
    ///  Check whether the Author data member has been assigned a value.
    bool IsSetAuthor(void) const;
    /// Check whether it is safe or not to call GetAuthor method.
    bool CanGetAuthor(void) const;
    void ResetAuthor(void);
    const TAuthor& GetAuthor(void) const;
    void SetAuthor(const TAuthor& value);
    void SetAuthor(TAuthor&& value);
    TAuthor& SetAuthor(void);

    /// mandatory
    /// typedef CMim_date TModDate
    ///  Check whether the ModDate data member has been assigned a value.
    bool IsSetModDate(void) const;
    /// Check whether it is safe or not to call GetModDate method.
    bool CanGetModDate(void) const;
    void ResetModDate(void);
    const TModDate& GetModDate(void) const;
    void SetModDate(TModDate& value);
    TModDate& SetModDate(void);

    /// Reset the whole object
    virtual void Reset(void);


private:
    // Prohibit copy constructor and assignment operator
    CMim_edit_item_Base(const CMim_edit_item_Base&);
    CMim_edit_item_Base& operator=(const CMim_edit_item_Base&);

    // data
    Uint4 m_set_State[1];
    string m_Author;
    CRef< TModDate > m_ModDate;
};






///////////////////////////////////////////////////////////
///////////////////// inline methods //////////////////////
///////////////////////////////////////////////////////////
inline
bool CMim_edit_item_Base::IsSetAuthor(void) const
{
    return ((m_set_State[0] & 0x3) != 0);
}

inline
bool CMim_edit_item_Base::CanGetAuthor(void) const
{
    return IsSetAuthor();
}

inline
const CMim_edit_item_Base::TAuthor& CMim_edit_item_Base::GetAuthor(void) const
{
    if (!CanGetAuthor()) {
        ThrowUnassigned(0);
    }
    return m_Author;
}

inline
void CMim_edit_item_Base::SetAuthor(const CMim_edit_item_Base::TAuthor& value)
{
    m_Author = value;
    m_set_State[0] |= 0x3;
}

inline
void CMim_edit_item_Base::SetAuthor(CMim_edit_item_Base::TAuthor&& value)
{
    m_Author = std::forward<CMim_edit_item_Base::TAuthor>(value);
    m_set_State[0] |= 0x3;
}

inline
CMim_edit_item_Base::TAuthor& CMim_edit_item_Base::SetAuthor(void)
{
#ifdef _DEBUG
    if (!IsSetAuthor()) {
        m_Author = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x1;
    return m_Author;
}

inline
bool CMim_edit_item_Base::IsSetModDate(void) const
{
    return m_ModDate.NotEmpty();
}

inline
bool CMim_edit_item_Base::CanGetModDate(void) const
{
    return true;
}

inline
const CMim_edit_item_Base::TModDate& CMim_edit_item_Base::GetModDate(void) const
{
    if ( !m_ModDate ) {
        const_cast<CMim_edit_item_Base*>(this)->ResetModDate();
    }
    return (*m_ModDate);
}

inline
CMim_edit_item_Base::TModDate& CMim_edit_item_Base::SetModDate(void)
{
    if ( !m_ModDate ) {
        ResetModDate();
    }
    return (*m_ModDate);
}

///////////////////////////////////////////////////////////
////////////////// end of inline methods //////////////////
///////////////////////////////////////////////////////////





END_objects_SCOPE // namespace ncbi::objects::

END_NCBI_SCOPE


#endif // OBJECTS_MIM_MIM_EDIT_ITEM_BASE_HPP
