/* $Id$
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 */

/// @file Mim_text_.hpp
/// Data storage class.
///
/// This file was generated by application DATATOOL
/// using the following specifications:
/// 'mim.asn'.
///
/// ATTENTION:
///   Don't edit or commit this file into CVS as this file will
///   be overridden (by DATATOOL) without warning!

#ifndef OBJECTS_MIM_MIM_TEXT_BASE_HPP
#define OBJECTS_MIM_MIM_TEXT_BASE_HPP

// standard includes
#include <serial/serialbase.hpp>

// generated includes
#include <string>

BEGIN_NCBI_SCOPE

#ifndef BEGIN_objects_SCOPE
#  define BEGIN_objects_SCOPE BEGIN_SCOPE(objects)
#  define END_objects_SCOPE END_SCOPE(objects)
#endif
BEGIN_objects_SCOPE // namespace ncbi::objects::


// forward declarations
class CMim_link;


// generated classes

/////////////////////////////////////////////////////////////////////////////
class NCBI_MIM_EXPORT CMim_text_Base : public CSerialObject
{
    typedef CSerialObject Tparent;
public:
    // constructor
    CMim_text_Base(void);
    // destructor
    virtual ~CMim_text_Base(void);

    // type info
    DECLARE_INTERNAL_TYPE_INFO();

    // types
    typedef string TLabel;
    typedef string TText;
    typedef CMim_link TNeighbors;

    // member index
    enum class E_memberIndex {
        e__allMandatory = 0,
        e_label,
        e_text,
        e_neighbors
    };
    typedef Tparent::CMemberIndex<E_memberIndex, 4> TmemberIndex;

    // getters
    // setters

    /// mandatory
    /// typedef string TLabel
    ///  Check whether the Label data member has been assigned a value.
    bool IsSetLabel(void) const;
    /// Check whether it is safe or not to call GetLabel method.
    bool CanGetLabel(void) const;
    void ResetLabel(void);
    const TLabel& GetLabel(void) const;
    void SetLabel(const TLabel& value);
    void SetLabel(TLabel&& value);
    TLabel& SetLabel(void);

    /// mandatory
    /// typedef string TText
    ///  Check whether the Text data member has been assigned a value.
    bool IsSetText(void) const;
    /// Check whether it is safe or not to call GetText method.
    bool CanGetText(void) const;
    void ResetText(void);
    const TText& GetText(void) const;
    void SetText(const TText& value);
    void SetText(TText&& value);
    TText& SetText(void);

    /// optional
    /// typedef CMim_link TNeighbors
    ///  Check whether the Neighbors data member has been assigned a value.
    bool IsSetNeighbors(void) const;
    /// Check whether it is safe or not to call GetNeighbors method.
    bool CanGetNeighbors(void) const;
    void ResetNeighbors(void);
    const TNeighbors& GetNeighbors(void) const;
    void SetNeighbors(TNeighbors& value);
    TNeighbors& SetNeighbors(void);

    /// Reset the whole object
    virtual void Reset(void);


private:
    // Prohibit copy constructor and assignment operator
    CMim_text_Base(const CMim_text_Base&);
    CMim_text_Base& operator=(const CMim_text_Base&);

    // data
    Uint4 m_set_State[1];
    string m_Label;
    string m_Text;
    CRef< TNeighbors > m_Neighbors;
};






///////////////////////////////////////////////////////////
///////////////////// inline methods //////////////////////
///////////////////////////////////////////////////////////
inline
bool CMim_text_Base::IsSetLabel(void) const
{
    return ((m_set_State[0] & 0x3) != 0);
}

inline
bool CMim_text_Base::CanGetLabel(void) const
{
    return IsSetLabel();
}

inline
const CMim_text_Base::TLabel& CMim_text_Base::GetLabel(void) const
{
    if (!CanGetLabel()) {
        ThrowUnassigned(0);
    }
    return m_Label;
}

inline
void CMim_text_Base::SetLabel(const CMim_text_Base::TLabel& value)
{
    m_Label = value;
    m_set_State[0] |= 0x3;
}

inline
void CMim_text_Base::SetLabel(CMim_text_Base::TLabel&& value)
{
    m_Label = std::forward<CMim_text_Base::TLabel>(value);
    m_set_State[0] |= 0x3;
}

inline
CMim_text_Base::TLabel& CMim_text_Base::SetLabel(void)
{
#ifdef _DEBUG
    if (!IsSetLabel()) {
        m_Label = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x1;
    return m_Label;
}

inline
bool CMim_text_Base::IsSetText(void) const
{
    return ((m_set_State[0] & 0xc) != 0);
}

inline
bool CMim_text_Base::CanGetText(void) const
{
    return IsSetText();
}

inline
const CMim_text_Base::TText& CMim_text_Base::GetText(void) const
{
    if (!CanGetText()) {
        ThrowUnassigned(1);
    }
    return m_Text;
}

inline
void CMim_text_Base::SetText(const CMim_text_Base::TText& value)
{
    m_Text = value;
    m_set_State[0] |= 0xc;
}

inline
void CMim_text_Base::SetText(CMim_text_Base::TText&& value)
{
    m_Text = std::forward<CMim_text_Base::TText>(value);
    m_set_State[0] |= 0xc;
}

inline
CMim_text_Base::TText& CMim_text_Base::SetText(void)
{
#ifdef _DEBUG
    if (!IsSetText()) {
        m_Text = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x4;
    return m_Text;
}

inline
bool CMim_text_Base::IsSetNeighbors(void) const
{
    return m_Neighbors.NotEmpty();
}

inline
bool CMim_text_Base::CanGetNeighbors(void) const
{
    return IsSetNeighbors();
}

inline
const CMim_text_Base::TNeighbors& CMim_text_Base::GetNeighbors(void) const
{
    if (!CanGetNeighbors()) {
        ThrowUnassigned(2);
    }
    return (*m_Neighbors);
}

///////////////////////////////////////////////////////////
////////////////// end of inline methods //////////////////
///////////////////////////////////////////////////////////





END_objects_SCOPE // namespace ncbi::objects::

END_NCBI_SCOPE


#endif // OBJECTS_MIM_MIM_TEXT_BASE_HPP
