/* $Id$
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 */

/// @file Atom_.hpp
/// Data storage class.
///
/// This file was generated by application DATATOOL
/// using the following specifications:
/// 'mmdb1.asn'.
///
/// ATTENTION:
///   Don't edit or commit this file into CVS as this file will
///   be overridden (by DATATOOL) without warning!

#ifndef OBJECTS_MMDB1_ATOM_BASE_HPP
#define OBJECTS_MMDB1_ATOM_BASE_HPP

// standard includes
#include <serial/serialbase.hpp>

// generated includes
#include <list>
#include <string>
#include <objects/mmdb1/Atom_id.hpp>

BEGIN_NCBI_SCOPE

#ifndef BEGIN_objects_SCOPE
#  define BEGIN_objects_SCOPE BEGIN_SCOPE(objects)
#  define END_objects_SCOPE END_SCOPE(objects)
#endif
BEGIN_objects_SCOPE // namespace ncbi::objects::


// generated classes

/////////////////////////////////////////////////////////////////////////////
/// Atoms in residue graphs are defined by elemental symbols and names.  PDB-
/// assigned atom names appear here in the name field, except in cases of known 
/// PDB synonyms.  In these cases atom names are mapped to the names used in the
/// MMDB standard dictionary. This occurs primarily for hydrogen atoms, where 
/// PDB practice allows synonyms for several atom types.  For PDB atoms the 
/// elemental symbol is obtained by parsing the PDB atom name field, allowing 
/// for known special-semantics cases where the atom name does not follow the
/// documented encoding rule.  Ionizable protons are identified within standard 
/// residue graphs in the MMDB dictionary, but not within automatically-defined
/// nonstandard graphs.
class NCBI_MMDB1_EXPORT CAtom_Base : public CSerialObject
{
    typedef CSerialObject Tparent;
public:
    // constructor
    CAtom_Base(void);
    // destructor
    virtual ~CAtom_Base(void);

    // type info
    DECLARE_INTERNAL_TYPE_INFO();

    enum EElement {
        eElement_h       =   1,
        eElement_he      =   2,
        eElement_li      =   3,
        eElement_be      =   4,
        eElement_b       =   5,
        eElement_c       =   6,
        eElement_n       =   7,
        eElement_o       =   8,
        eElement_f       =   9,
        eElement_ne      =  10,
        eElement_na      =  11,
        eElement_mg      =  12,
        eElement_al      =  13,
        eElement_si      =  14,
        eElement_p       =  15,
        eElement_s       =  16,
        eElement_cl      =  17,
        eElement_ar      =  18,
        eElement_k       =  19,
        eElement_ca      =  20,
        eElement_sc      =  21,
        eElement_ti      =  22,
        eElement_v       =  23,
        eElement_cr      =  24,
        eElement_mn      =  25,
        eElement_fe      =  26,
        eElement_co      =  27,
        eElement_ni      =  28,
        eElement_cu      =  29,
        eElement_zn      =  30,
        eElement_ga      =  31,
        eElement_ge      =  32,
        eElement_as      =  33,
        eElement_se      =  34,
        eElement_br      =  35,
        eElement_kr      =  36,
        eElement_rb      =  37,
        eElement_sr      =  38,
        eElement_y       =  39,
        eElement_zr      =  40,
        eElement_nb      =  41,
        eElement_mo      =  42,
        eElement_tc      =  43,
        eElement_ru      =  44,
        eElement_rh      =  45,
        eElement_pd      =  46,
        eElement_ag      =  47,
        eElement_cd      =  48,
        eElement_in      =  49,
        eElement_sn      =  50,
        eElement_sb      =  51,
        eElement_te      =  52,
        eElement_i       =  53,
        eElement_xe      =  54,
        eElement_cs      =  55,
        eElement_ba      =  56,
        eElement_la      =  57,
        eElement_ce      =  58,
        eElement_pr      =  59,
        eElement_nd      =  60,
        eElement_pm      =  61,
        eElement_sm      =  62,
        eElement_eu      =  63,
        eElement_gd      =  64,
        eElement_tb      =  65,
        eElement_dy      =  66,
        eElement_ho      =  67,
        eElement_er      =  68,
        eElement_tm      =  69,
        eElement_yb      =  70,
        eElement_lu      =  71,
        eElement_hf      =  72,
        eElement_ta      =  73,
        eElement_w       =  74,
        eElement_re      =  75,
        eElement_os      =  76,
        eElement_ir      =  77,
        eElement_pt      =  78,
        eElement_au      =  79,
        eElement_hg      =  80,
        eElement_tl      =  81,
        eElement_pb      =  82,
        eElement_bi      =  83,
        eElement_po      =  84,
        eElement_at      =  85,
        eElement_rn      =  86,
        eElement_fr      =  87,
        eElement_ra      =  88,
        eElement_ac      =  89,
        eElement_th      =  90,
        eElement_pa      =  91,
        eElement_u       =  92,
        eElement_np      =  93,
        eElement_pu      =  94,
        eElement_am      =  95,
        eElement_cm      =  96,
        eElement_bk      =  97,
        eElement_cf      =  98,
        eElement_es      =  99,
        eElement_fm      = 100,
        eElement_md      = 101,
        eElement_no      = 102,
        eElement_lr      = 103,
        eElement_other   = 254,
        eElement_unknown = 255
    };
    
    /// Access to EElement's attributes (values, names) as defined in spec
    static const NCBI_NS_NCBI::CEnumeratedTypeValues* ENUM_METHOD_NAME(EElement)(void);
    
    enum EIonizable_proton {
        eIonizable_proton_true    =   1,
        eIonizable_proton_false   =   2,
        eIonizable_proton_unknown = 255
    };
    
    /// Access to EIonizable_proton's attributes (values, names) as defined in spec
    static const NCBI_NS_NCBI::CEnumeratedTypeValues* ENUM_METHOD_NAME(EIonizable_proton)(void);
    
    // types
    typedef CAtom_id TId;
    typedef string TName;
    typedef list< string > TIupac_code;
    typedef EElement TElement;
    typedef EIonizable_proton TIonizable_proton;

    // member index
    enum class E_memberIndex {
        e__allMandatory = 0,
        e_id,
        e_name,
        e_iupac_code,
        e_element,
        e_ionizable_proton
    };
    typedef Tparent::CMemberIndex<E_memberIndex, 6> TmemberIndex;

    // getters
    // setters

    /// mandatory
    /// typedef CAtom_id TId
    ///  Check whether the Id data member has been assigned a value.
    bool IsSetId(void) const;
    /// Check whether it is safe or not to call GetId method.
    bool CanGetId(void) const;
    void ResetId(void);
    const TId& GetId(void) const;
    void SetId(const TId& value);
    TId& SetId(void);

    /// optional
    /// typedef string TName
    ///  Check whether the Name data member has been assigned a value.
    bool IsSetName(void) const;
    /// Check whether it is safe or not to call GetName method.
    bool CanGetName(void) const;
    void ResetName(void);
    const TName& GetName(void) const;
    void SetName(const TName& value);
    void SetName(TName&& value);
    TName& SetName(void);

    /// optional
    /// typedef list< string > TIupac_code
    ///  Check whether the Iupac_code data member has been assigned a value.
    bool IsSetIupac_code(void) const;
    /// Check whether it is safe or not to call GetIupac_code method.
    bool CanGetIupac_code(void) const;
    void ResetIupac_code(void);
    const TIupac_code& GetIupac_code(void) const;
    TIupac_code& SetIupac_code(void);

    /// mandatory
    /// typedef EElement TElement
    ///  Check whether the Element data member has been assigned a value.
    bool IsSetElement(void) const;
    /// Check whether it is safe or not to call GetElement method.
    bool CanGetElement(void) const;
    void ResetElement(void);
    TElement GetElement(void) const;
    void SetElement(TElement value);
    TElement& SetElement(void);

    /// optional
    /// typedef EIonizable_proton TIonizable_proton
    ///  Check whether the Ionizable_proton data member has been assigned a value.
    bool IsSetIonizable_proton(void) const;
    /// Check whether it is safe or not to call GetIonizable_proton method.
    bool CanGetIonizable_proton(void) const;
    void ResetIonizable_proton(void);
    TIonizable_proton GetIonizable_proton(void) const;
    void SetIonizable_proton(TIonizable_proton value);
    TIonizable_proton& SetIonizable_proton(void);

    /// Reset the whole object
    virtual void Reset(void);


private:
    // Prohibit copy constructor and assignment operator
    CAtom_Base(const CAtom_Base&);
    CAtom_Base& operator=(const CAtom_Base&);

    // data
    Uint4 m_set_State[1];
    CAtom_id m_Id;
    string m_Name;
    list< string > m_Iupac_code;
    EElement m_Element;
    EIonizable_proton m_Ionizable_proton;
};






///////////////////////////////////////////////////////////
///////////////////// inline methods //////////////////////
///////////////////////////////////////////////////////////
inline
bool CAtom_Base::IsSetId(void) const
{
    return ((m_set_State[0] & 0x3) != 0);
}

inline
bool CAtom_Base::CanGetId(void) const
{
    return IsSetId();
}

inline
void CAtom_Base::ResetId(void)
{
    m_Id = CAtom_id(0);
    m_set_State[0] &= ~0x3;
}

inline
const CAtom_Base::TId& CAtom_Base::GetId(void) const
{
    if (!CanGetId()) {
        ThrowUnassigned(0);
    }
    return m_Id;
}

inline
void CAtom_Base::SetId(const CAtom_Base::TId& value)
{
    m_Id = value;
    m_set_State[0] |= 0x3;
}

inline
CAtom_Base::TId& CAtom_Base::SetId(void)
{
    m_set_State[0] |= 0x1;
    return m_Id;
}

inline
bool CAtom_Base::IsSetName(void) const
{
    return ((m_set_State[0] & 0xc) != 0);
}

inline
bool CAtom_Base::CanGetName(void) const
{
    return IsSetName();
}

inline
const CAtom_Base::TName& CAtom_Base::GetName(void) const
{
    if (!CanGetName()) {
        ThrowUnassigned(1);
    }
    return m_Name;
}

inline
void CAtom_Base::SetName(const CAtom_Base::TName& value)
{
    m_Name = value;
    m_set_State[0] |= 0xc;
}

inline
void CAtom_Base::SetName(CAtom_Base::TName&& value)
{
    m_Name = std::forward<CAtom_Base::TName>(value);
    m_set_State[0] |= 0xc;
}

inline
CAtom_Base::TName& CAtom_Base::SetName(void)
{
#ifdef _DEBUG
    if (!IsSetName()) {
        m_Name = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x4;
    return m_Name;
}

inline
bool CAtom_Base::IsSetIupac_code(void) const
{
    return ((m_set_State[0] & 0x30) != 0);
}

inline
bool CAtom_Base::CanGetIupac_code(void) const
{
    return true;
}

inline
const CAtom_Base::TIupac_code& CAtom_Base::GetIupac_code(void) const
{
    return m_Iupac_code;
}

inline
CAtom_Base::TIupac_code& CAtom_Base::SetIupac_code(void)
{
    m_set_State[0] |= 0x10;
    return m_Iupac_code;
}

inline
bool CAtom_Base::IsSetElement(void) const
{
    return ((m_set_State[0] & 0xc0) != 0);
}

inline
bool CAtom_Base::CanGetElement(void) const
{
    return IsSetElement();
}

inline
void CAtom_Base::ResetElement(void)
{
    m_Element = (EElement)(0);
    m_set_State[0] &= ~0xc0;
}

inline
CAtom_Base::TElement CAtom_Base::GetElement(void) const
{
    if (!CanGetElement()) {
        ThrowUnassigned(3);
    }
    return m_Element;
}

inline
void CAtom_Base::SetElement(CAtom_Base::TElement value)
{
    m_Element = value;
    m_set_State[0] |= 0xc0;
}

inline
CAtom_Base::TElement& CAtom_Base::SetElement(void)
{
#ifdef _DEBUG
    if (!IsSetElement()) {
        memset(&m_Element,UnassignedByte(),sizeof(m_Element));
    }
#endif
    m_set_State[0] |= 0x40;
    return m_Element;
}

inline
bool CAtom_Base::IsSetIonizable_proton(void) const
{
    return ((m_set_State[0] & 0x300) != 0);
}

inline
bool CAtom_Base::CanGetIonizable_proton(void) const
{
    return IsSetIonizable_proton();
}

inline
void CAtom_Base::ResetIonizable_proton(void)
{
    m_Ionizable_proton = (EIonizable_proton)(0);
    m_set_State[0] &= ~0x300;
}

inline
CAtom_Base::TIonizable_proton CAtom_Base::GetIonizable_proton(void) const
{
    if (!CanGetIonizable_proton()) {
        ThrowUnassigned(4);
    }
    return m_Ionizable_proton;
}

inline
void CAtom_Base::SetIonizable_proton(CAtom_Base::TIonizable_proton value)
{
    m_Ionizable_proton = value;
    m_set_State[0] |= 0x300;
}

inline
CAtom_Base::TIonizable_proton& CAtom_Base::SetIonizable_proton(void)
{
#ifdef _DEBUG
    if (!IsSetIonizable_proton()) {
        memset(&m_Ionizable_proton,UnassignedByte(),sizeof(m_Ionizable_proton));
    }
#endif
    m_set_State[0] |= 0x100;
    return m_Ionizable_proton;
}

///////////////////////////////////////////////////////////
////////////////// end of inline methods //////////////////
///////////////////////////////////////////////////////////





END_objects_SCOPE // namespace ncbi::objects::

END_NCBI_SCOPE


#endif // OBJECTS_MMDB1_ATOM_BASE_HPP
