/* $Id$
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 */

/// @file Chem_graph_interaction_.hpp
/// Data storage class.
///
/// This file was generated by application DATATOOL
/// using the following specifications:
/// 'mmdb3.asn'.
///
/// ATTENTION:
///   Don't edit or commit this file into CVS as this file will
///   be overridden (by DATATOOL) without warning!

#ifndef OBJECTS_MMDB3_CHEM_GRAPH_INTERACTION_BASE_HPP
#define OBJECTS_MMDB3_CHEM_GRAPH_INTERACTION_BASE_HPP

// standard includes
#include <serial/serialbase.hpp>

// generated includes
#include <list>

BEGIN_NCBI_SCOPE

#ifndef BEGIN_objects_SCOPE
#  define BEGIN_objects_SCOPE BEGIN_SCOPE(objects)
#  define END_objects_SCOPE END_SCOPE(objects)
#endif
BEGIN_objects_SCOPE // namespace ncbi::objects::


// forward declarations
class CBiostruc_molecule_pntr;
class CChem_graph_pntrs;
class CRealValue;


// generated classes

/////////////////////////////////////////////////////////////////////////////
class NCBI_MMDB3_EXPORT CChem_graph_interaction_Base : public CSerialObject
{
    typedef CSerialObject Tparent;
public:
    // constructor
    CChem_graph_interaction_Base(void);
    // destructor
    virtual ~CChem_graph_interaction_Base(void);

    // type info
    DECLARE_INTERNAL_TYPE_INFO();

    enum EType {
        eType_protein_protein  =   1,
        eType_protein_dna      =   2,
        eType_protein_rna      =   3,
        eType_protein_chemical =   4,
        eType_dna_dna          =   5,
        eType_dna_rna          =   6,
        eType_dna_chemical     =   7,
        eType_rna_rna          =   8,
        eType_rna_chemical     =   9,
        eType_other            = 255
    };
    
    /// Access to EType's attributes (values, names) as defined in spec
    static const NCBI_NS_NCBI::CEnumeratedTypeValues* ENUM_METHOD_NAME(EType)(void);
    
    // types
    typedef int TType;
    typedef CRealValue TDistance_threshold;
    typedef list< CRef< CBiostruc_molecule_pntr > > TInteractors;
    typedef list< CRef< CChem_graph_pntrs > > TResidue_contacts;
    typedef list< CRef< CChem_graph_pntrs > > TAtom_contacts;
    typedef list< CRef< CRealValue > > TAtom_distance;

    // member index
    enum class E_memberIndex {
        e__allMandatory = 0,
        e_type,
        e_distance_threshold,
        e_interactors,
        e_residue_contacts,
        e_atom_contacts,
        e_atom_distance
    };
    typedef Tparent::CMemberIndex<E_memberIndex, 7> TmemberIndex;

    // getters
    // setters

    /// optional
    /// typedef int TType
    ///  Check whether the Type data member has been assigned a value.
    bool IsSetType(void) const;
    /// Check whether it is safe or not to call GetType method.
    bool CanGetType(void) const;
    void ResetType(void);
    TType GetType(void) const;
    void SetType(TType value);
    TType& SetType(void);

    /// optional
    /// typedef CRealValue TDistance_threshold
    ///  Check whether the Distance_threshold data member has been assigned a value.
    bool IsSetDistance_threshold(void) const;
    /// Check whether it is safe or not to call GetDistance_threshold method.
    bool CanGetDistance_threshold(void) const;
    void ResetDistance_threshold(void);
    const TDistance_threshold& GetDistance_threshold(void) const;
    void SetDistance_threshold(TDistance_threshold& value);
    TDistance_threshold& SetDistance_threshold(void);

    /// mandatory
    /// typedef list< CRef< CBiostruc_molecule_pntr > > TInteractors
    ///  Check whether the Interactors data member has been assigned a value.
    bool IsSetInteractors(void) const;
    /// Check whether it is safe or not to call GetInteractors method.
    bool CanGetInteractors(void) const;
    void ResetInteractors(void);
    const TInteractors& GetInteractors(void) const;
    TInteractors& SetInteractors(void);

    /// optional
    /// typedef list< CRef< CChem_graph_pntrs > > TResidue_contacts
    ///  Check whether the Residue_contacts data member has been assigned a value.
    bool IsSetResidue_contacts(void) const;
    /// Check whether it is safe or not to call GetResidue_contacts method.
    bool CanGetResidue_contacts(void) const;
    void ResetResidue_contacts(void);
    const TResidue_contacts& GetResidue_contacts(void) const;
    TResidue_contacts& SetResidue_contacts(void);

    /// optional
    /// typedef list< CRef< CChem_graph_pntrs > > TAtom_contacts
    ///  Check whether the Atom_contacts data member has been assigned a value.
    bool IsSetAtom_contacts(void) const;
    /// Check whether it is safe or not to call GetAtom_contacts method.
    bool CanGetAtom_contacts(void) const;
    void ResetAtom_contacts(void);
    const TAtom_contacts& GetAtom_contacts(void) const;
    TAtom_contacts& SetAtom_contacts(void);

    /// optional
    /// typedef list< CRef< CRealValue > > TAtom_distance
    ///  Check whether the Atom_distance data member has been assigned a value.
    bool IsSetAtom_distance(void) const;
    /// Check whether it is safe or not to call GetAtom_distance method.
    bool CanGetAtom_distance(void) const;
    void ResetAtom_distance(void);
    const TAtom_distance& GetAtom_distance(void) const;
    TAtom_distance& SetAtom_distance(void);

    /// Reset the whole object
    virtual void Reset(void);


private:
    // Prohibit copy constructor and assignment operator
    CChem_graph_interaction_Base(const CChem_graph_interaction_Base&);
    CChem_graph_interaction_Base& operator=(const CChem_graph_interaction_Base&);

    // data
    Uint4 m_set_State[1];
    int m_Type;
    CRef< TDistance_threshold > m_Distance_threshold;
    list< CRef< CBiostruc_molecule_pntr > > m_Interactors;
    list< CRef< CChem_graph_pntrs > > m_Residue_contacts;
    list< CRef< CChem_graph_pntrs > > m_Atom_contacts;
    list< CRef< CRealValue > > m_Atom_distance;
};






///////////////////////////////////////////////////////////
///////////////////// inline methods //////////////////////
///////////////////////////////////////////////////////////
inline
bool CChem_graph_interaction_Base::IsSetType(void) const
{
    return ((m_set_State[0] & 0x3) != 0);
}

inline
bool CChem_graph_interaction_Base::CanGetType(void) const
{
    return IsSetType();
}

inline
void CChem_graph_interaction_Base::ResetType(void)
{
    m_Type = (EType)(0);
    m_set_State[0] &= ~0x3;
}

inline
CChem_graph_interaction_Base::TType CChem_graph_interaction_Base::GetType(void) const
{
    if (!CanGetType()) {
        ThrowUnassigned(0);
    }
    return m_Type;
}

inline
void CChem_graph_interaction_Base::SetType(CChem_graph_interaction_Base::TType value)
{
    m_Type = value;
    m_set_State[0] |= 0x3;
}

inline
CChem_graph_interaction_Base::TType& CChem_graph_interaction_Base::SetType(void)
{
#ifdef _DEBUG
    if (!IsSetType()) {
        memset(&m_Type,UnassignedByte(),sizeof(m_Type));
    }
#endif
    m_set_State[0] |= 0x1;
    return m_Type;
}

inline
bool CChem_graph_interaction_Base::IsSetDistance_threshold(void) const
{
    return m_Distance_threshold.NotEmpty();
}

inline
bool CChem_graph_interaction_Base::CanGetDistance_threshold(void) const
{
    return IsSetDistance_threshold();
}

inline
const CChem_graph_interaction_Base::TDistance_threshold& CChem_graph_interaction_Base::GetDistance_threshold(void) const
{
    if (!CanGetDistance_threshold()) {
        ThrowUnassigned(1);
    }
    return (*m_Distance_threshold);
}

inline
bool CChem_graph_interaction_Base::IsSetInteractors(void) const
{
    return ((m_set_State[0] & 0x30) != 0);
}

inline
bool CChem_graph_interaction_Base::CanGetInteractors(void) const
{
    return true;
}

inline
const CChem_graph_interaction_Base::TInteractors& CChem_graph_interaction_Base::GetInteractors(void) const
{
    return m_Interactors;
}

inline
CChem_graph_interaction_Base::TInteractors& CChem_graph_interaction_Base::SetInteractors(void)
{
    m_set_State[0] |= 0x10;
    return m_Interactors;
}

inline
bool CChem_graph_interaction_Base::IsSetResidue_contacts(void) const
{
    return ((m_set_State[0] & 0xc0) != 0);
}

inline
bool CChem_graph_interaction_Base::CanGetResidue_contacts(void) const
{
    return true;
}

inline
const CChem_graph_interaction_Base::TResidue_contacts& CChem_graph_interaction_Base::GetResidue_contacts(void) const
{
    return m_Residue_contacts;
}

inline
CChem_graph_interaction_Base::TResidue_contacts& CChem_graph_interaction_Base::SetResidue_contacts(void)
{
    m_set_State[0] |= 0x40;
    return m_Residue_contacts;
}

inline
bool CChem_graph_interaction_Base::IsSetAtom_contacts(void) const
{
    return ((m_set_State[0] & 0x300) != 0);
}

inline
bool CChem_graph_interaction_Base::CanGetAtom_contacts(void) const
{
    return true;
}

inline
const CChem_graph_interaction_Base::TAtom_contacts& CChem_graph_interaction_Base::GetAtom_contacts(void) const
{
    return m_Atom_contacts;
}

inline
CChem_graph_interaction_Base::TAtom_contacts& CChem_graph_interaction_Base::SetAtom_contacts(void)
{
    m_set_State[0] |= 0x100;
    return m_Atom_contacts;
}

inline
bool CChem_graph_interaction_Base::IsSetAtom_distance(void) const
{
    return ((m_set_State[0] & 0xc00) != 0);
}

inline
bool CChem_graph_interaction_Base::CanGetAtom_distance(void) const
{
    return true;
}

inline
const CChem_graph_interaction_Base::TAtom_distance& CChem_graph_interaction_Base::GetAtom_distance(void) const
{
    return m_Atom_distance;
}

inline
CChem_graph_interaction_Base::TAtom_distance& CChem_graph_interaction_Base::SetAtom_distance(void)
{
    m_set_State[0] |= 0x400;
    return m_Atom_distance;
}

///////////////////////////////////////////////////////////
////////////////// end of inline methods //////////////////
///////////////////////////////////////////////////////////





END_objects_SCOPE // namespace ncbi::objects::

END_NCBI_SCOPE


#endif // OBJECTS_MMDB3_CHEM_GRAPH_INTERACTION_BASE_HPP
