/* $Id$
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 */

/// @file MSImmonium_.hpp
/// Data storage class.
///
/// This file was generated by application DATATOOL
/// using the following specifications:
/// 'omssa.asn'.
///
/// ATTENTION:
///   Don't edit or commit this file into CVS as this file will
///   be overridden (by DATATOOL) without warning!

#ifndef OBJECTS_OMSSA_MSIMMONIUM_BASE_HPP
#define OBJECTS_OMSSA_MSIMMONIUM_BASE_HPP

// standard includes
#include <serial/serialbase.hpp>

// generated includes
#include <string>

BEGIN_NCBI_SCOPE

#ifndef BEGIN_objects_SCOPE
#  define BEGIN_objects_SCOPE BEGIN_SCOPE(objects)
#  define END_objects_SCOPE END_SCOPE(objects)
#endif
BEGIN_objects_SCOPE // namespace ncbi::objects::


// generated classes

/////////////////////////////////////////////////////////////////////////////
/// type of immonium ion
class NCBI_OMSSA_EXPORT CMSImmonium_Base : public CSerialObject
{
    typedef CSerialObject Tparent;
public:
    // constructor
    CMSImmonium_Base(void);
    // destructor
    virtual ~CMSImmonium_Base(void);

    // type info
    DECLARE_INTERNAL_TYPE_INFO();

    // types
    typedef string TParent;
    typedef string TProduct;

    // member index
    enum class E_memberIndex {
        e__allMandatory = 0,
        e_parent,
        e_product
    };
    typedef Tparent::CMemberIndex<E_memberIndex, 3> TmemberIndex;

    // getters
    // setters

    /// parent amino acid
    /// mandatory
    /// typedef string TParent
    ///  Check whether the Parent data member has been assigned a value.
    bool IsSetParent(void) const;
    /// Check whether it is safe or not to call GetParent method.
    bool CanGetParent(void) const;
    void ResetParent(void);
    const TParent& GetParent(void) const;
    void SetParent(const TParent& value);
    void SetParent(TParent&& value);
    TParent& SetParent(void);

    /// product ion code
    /// optional
    /// typedef string TProduct
    ///  Check whether the Product data member has been assigned a value.
    bool IsSetProduct(void) const;
    /// Check whether it is safe or not to call GetProduct method.
    bool CanGetProduct(void) const;
    void ResetProduct(void);
    const TProduct& GetProduct(void) const;
    void SetProduct(const TProduct& value);
    void SetProduct(TProduct&& value);
    TProduct& SetProduct(void);

    /// Reset the whole object
    virtual void Reset(void);


private:
    // Prohibit copy constructor and assignment operator
    CMSImmonium_Base(const CMSImmonium_Base&);
    CMSImmonium_Base& operator=(const CMSImmonium_Base&);

    // data
    Uint4 m_set_State[1];
    string m_Parent;
    string m_Product;
};






///////////////////////////////////////////////////////////
///////////////////// inline methods //////////////////////
///////////////////////////////////////////////////////////
inline
bool CMSImmonium_Base::IsSetParent(void) const
{
    return ((m_set_State[0] & 0x3) != 0);
}

inline
bool CMSImmonium_Base::CanGetParent(void) const
{
    return IsSetParent();
}

inline
const CMSImmonium_Base::TParent& CMSImmonium_Base::GetParent(void) const
{
    if (!CanGetParent()) {
        ThrowUnassigned(0);
    }
    return m_Parent;
}

inline
void CMSImmonium_Base::SetParent(const CMSImmonium_Base::TParent& value)
{
    m_Parent = value;
    m_set_State[0] |= 0x3;
}

inline
void CMSImmonium_Base::SetParent(CMSImmonium_Base::TParent&& value)
{
    m_Parent = std::forward<CMSImmonium_Base::TParent>(value);
    m_set_State[0] |= 0x3;
}

inline
CMSImmonium_Base::TParent& CMSImmonium_Base::SetParent(void)
{
#ifdef _DEBUG
    if (!IsSetParent()) {
        m_Parent = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x1;
    return m_Parent;
}

inline
bool CMSImmonium_Base::IsSetProduct(void) const
{
    return ((m_set_State[0] & 0xc) != 0);
}

inline
bool CMSImmonium_Base::CanGetProduct(void) const
{
    return IsSetProduct();
}

inline
const CMSImmonium_Base::TProduct& CMSImmonium_Base::GetProduct(void) const
{
    if (!CanGetProduct()) {
        ThrowUnassigned(1);
    }
    return m_Product;
}

inline
void CMSImmonium_Base::SetProduct(const CMSImmonium_Base::TProduct& value)
{
    m_Product = value;
    m_set_State[0] |= 0xc;
}

inline
void CMSImmonium_Base::SetProduct(CMSImmonium_Base::TProduct&& value)
{
    m_Product = std::forward<CMSImmonium_Base::TProduct>(value);
    m_set_State[0] |= 0xc;
}

inline
CMSImmonium_Base::TProduct& CMSImmonium_Base::SetProduct(void)
{
#ifdef _DEBUG
    if (!IsSetProduct()) {
        m_Product = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x4;
    return m_Product;
}

///////////////////////////////////////////////////////////
////////////////// end of inline methods //////////////////
///////////////////////////////////////////////////////////





END_objects_SCOPE // namespace ncbi::objects::

END_NCBI_SCOPE


#endif // OBJECTS_OMSSA_MSIMMONIUM_BASE_HPP
