/* $Id$
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 */

/// @file MSRequest_.hpp
/// Data storage class.
///
/// This file was generated by application DATATOOL
/// using the following specifications:
/// 'omssa.asn'.
///
/// ATTENTION:
///   Don't edit or commit this file into CVS as this file will
///   be overridden (by DATATOOL) without warning!

#ifndef OBJECTS_OMSSA_MSREQUEST_BASE_HPP
#define OBJECTS_OMSSA_MSREQUEST_BASE_HPP

// standard includes
#include <serial/serialbase.hpp>

// generated includes
#include <string>

BEGIN_NCBI_SCOPE

#ifndef BEGIN_objects_SCOPE
#  define BEGIN_objects_SCOPE BEGIN_SCOPE(objects)
#  define END_objects_SCOPE END_SCOPE(objects)
#endif
BEGIN_objects_SCOPE // namespace ncbi::objects::


// forward declarations
class CMSModSpecSet;
class CMSSearchSettings;
class CMSSearchSettingsSet;
class CMSSpectrumset;


// generated classes

/////////////////////////////////////////////////////////////////////////////
/// The search request that is given to the OMSSA algorithm
class NCBI_OMSSA_EXPORT CMSRequest_Base : public CSerialObject
{
    typedef CSerialObject Tparent;
public:
    // constructor
    CMSRequest_Base(void);
    // destructor
    virtual ~CMSRequest_Base(void);

    // type info
    DECLARE_INTERNAL_TYPE_INFO();

    // types
    typedef CMSSpectrumset TSpectra;
    typedef CMSSearchSettings TSettings;
    typedef string TRid;
    typedef CMSSearchSettingsSet TMoresettings;
    typedef CMSModSpecSet TModset;

    // member index
    enum class E_memberIndex {
        e__allMandatory = 0,
        e_spectra,
        e_settings,
        e_rid,
        e_moresettings,
        e_modset
    };
    typedef Tparent::CMemberIndex<E_memberIndex, 6> TmemberIndex;

    // getters
    // setters

    /// the set of spectra
    /// mandatory
    /// typedef CMSSpectrumset TSpectra
    ///  Check whether the Spectra data member has been assigned a value.
    bool IsSetSpectra(void) const;
    /// Check whether it is safe or not to call GetSpectra method.
    bool CanGetSpectra(void) const;
    void ResetSpectra(void);
    const TSpectra& GetSpectra(void) const;
    void SetSpectra(TSpectra& value);
    TSpectra& SetSpectra(void);

    /// the search settings
    /// mandatory
    /// typedef CMSSearchSettings TSettings
    ///  Check whether the Settings data member has been assigned a value.
    bool IsSetSettings(void) const;
    /// Check whether it is safe or not to call GetSettings method.
    bool CanGetSettings(void) const;
    void ResetSettings(void);
    const TSettings& GetSettings(void) const;
    void SetSettings(TSettings& value);
    TSettings& SetSettings(void);

    /// request id
    /// optional
    /// typedef string TRid
    ///  Check whether the Rid data member has been assigned a value.
    bool IsSetRid(void) const;
    /// Check whether it is safe or not to call GetRid method.
    bool CanGetRid(void) const;
    void ResetRid(void);
    const TRid& GetRid(void) const;
    void SetRid(const TRid& value);
    void SetRid(TRid&& value);
    TRid& SetRid(void);

    /// additional search runs
    /// optional
    /// typedef CMSSearchSettingsSet TMoresettings
    ///  Check whether the Moresettings data member has been assigned a value.
    bool IsSetMoresettings(void) const;
    /// Check whether it is safe or not to call GetMoresettings method.
    bool CanGetMoresettings(void) const;
    void ResetMoresettings(void);
    const TMoresettings& GetMoresettings(void) const;
    void SetMoresettings(TMoresettings& value);
    TMoresettings& SetMoresettings(void);

    /// list of mods that can be used in search
    /// optional
    /// typedef CMSModSpecSet TModset
    ///  Check whether the Modset data member has been assigned a value.
    bool IsSetModset(void) const;
    /// Check whether it is safe or not to call GetModset method.
    bool CanGetModset(void) const;
    void ResetModset(void);
    const TModset& GetModset(void) const;
    void SetModset(TModset& value);
    TModset& SetModset(void);

    /// Reset the whole object
    virtual void Reset(void);


private:
    // Prohibit copy constructor and assignment operator
    CMSRequest_Base(const CMSRequest_Base&);
    CMSRequest_Base& operator=(const CMSRequest_Base&);

    // data
    Uint4 m_set_State[1];
    CRef< TSpectra > m_Spectra;
    CRef< TSettings > m_Settings;
    string m_Rid;
    CRef< TMoresettings > m_Moresettings;
    CRef< TModset > m_Modset;
};






///////////////////////////////////////////////////////////
///////////////////// inline methods //////////////////////
///////////////////////////////////////////////////////////
inline
bool CMSRequest_Base::IsSetSpectra(void) const
{
    return m_Spectra.NotEmpty();
}

inline
bool CMSRequest_Base::CanGetSpectra(void) const
{
    return true;
}

inline
const CMSRequest_Base::TSpectra& CMSRequest_Base::GetSpectra(void) const
{
    if ( !m_Spectra ) {
        const_cast<CMSRequest_Base*>(this)->ResetSpectra();
    }
    return (*m_Spectra);
}

inline
CMSRequest_Base::TSpectra& CMSRequest_Base::SetSpectra(void)
{
    if ( !m_Spectra ) {
        ResetSpectra();
    }
    return (*m_Spectra);
}

inline
bool CMSRequest_Base::IsSetSettings(void) const
{
    return m_Settings.NotEmpty();
}

inline
bool CMSRequest_Base::CanGetSettings(void) const
{
    return true;
}

inline
const CMSRequest_Base::TSettings& CMSRequest_Base::GetSettings(void) const
{
    if ( !m_Settings ) {
        const_cast<CMSRequest_Base*>(this)->ResetSettings();
    }
    return (*m_Settings);
}

inline
CMSRequest_Base::TSettings& CMSRequest_Base::SetSettings(void)
{
    if ( !m_Settings ) {
        ResetSettings();
    }
    return (*m_Settings);
}

inline
bool CMSRequest_Base::IsSetRid(void) const
{
    return ((m_set_State[0] & 0x30) != 0);
}

inline
bool CMSRequest_Base::CanGetRid(void) const
{
    return IsSetRid();
}

inline
const CMSRequest_Base::TRid& CMSRequest_Base::GetRid(void) const
{
    if (!CanGetRid()) {
        ThrowUnassigned(2);
    }
    return m_Rid;
}

inline
void CMSRequest_Base::SetRid(const CMSRequest_Base::TRid& value)
{
    m_Rid = value;
    m_set_State[0] |= 0x30;
}

inline
void CMSRequest_Base::SetRid(CMSRequest_Base::TRid&& value)
{
    m_Rid = std::forward<CMSRequest_Base::TRid>(value);
    m_set_State[0] |= 0x30;
}

inline
CMSRequest_Base::TRid& CMSRequest_Base::SetRid(void)
{
#ifdef _DEBUG
    if (!IsSetRid()) {
        m_Rid = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x10;
    return m_Rid;
}

inline
bool CMSRequest_Base::IsSetMoresettings(void) const
{
    return m_Moresettings.NotEmpty();
}

inline
bool CMSRequest_Base::CanGetMoresettings(void) const
{
    return IsSetMoresettings();
}

inline
const CMSRequest_Base::TMoresettings& CMSRequest_Base::GetMoresettings(void) const
{
    if (!CanGetMoresettings()) {
        ThrowUnassigned(3);
    }
    return (*m_Moresettings);
}

inline
bool CMSRequest_Base::IsSetModset(void) const
{
    return m_Modset.NotEmpty();
}

inline
bool CMSRequest_Base::CanGetModset(void) const
{
    return IsSetModset();
}

inline
const CMSRequest_Base::TModset& CMSRequest_Base::GetModset(void) const
{
    if (!CanGetModset()) {
        ThrowUnassigned(4);
    }
    return (*m_Modset);
}

///////////////////////////////////////////////////////////
////////////////// end of inline methods //////////////////
///////////////////////////////////////////////////////////





END_objects_SCOPE // namespace ncbi::objects::

END_NCBI_SCOPE


#endif // OBJECTS_OMSSA_MSREQUEST_BASE_HPP
