/* $Id$
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 */

/// @file PC_AssayDRAttr_.hpp
/// Data storage class.
///
/// This file was generated by application DATATOOL
/// using the following specifications:
/// 'pcassay.asn'.
///
/// ATTENTION:
///   Don't edit or commit this file into CVS as this file will
///   be overridden (by DATATOOL) without warning!

#ifndef OBJECTS_PCASSAY_PC_ASSAYDRATTR_BASE_HPP
#define OBJECTS_PCASSAY_PC_ASSAYDRATTR_BASE_HPP

// standard includes
#include <serial/serialbase.hpp>

// generated includes
#include <string>

BEGIN_NCBI_SCOPE

#ifndef BEGIN_objects_SCOPE
#  define BEGIN_objects_SCOPE BEGIN_SCOPE(objects)
#  define END_objects_SCOPE END_SCOPE(objects)
#endif
BEGIN_objects_SCOPE // namespace ncbi::objects::


// generated classes

/////////////////////////////////////////////////////////////////////////////
///  Assay Dose-response attribute information used to define a set of readouts
///    as being part of a dose-response curve (for curve plotting/analysis)
class NCBI_PCASSAY_EXPORT CPC_AssayDRAttr_Base : public CSerialObject
{
    typedef CSerialObject Tparent;
public:
    // constructor
    CPC_AssayDRAttr_Base(void);
    // destructor
    virtual ~CPC_AssayDRAttr_Base(void);

    // type info
    DECLARE_INTERNAL_TYPE_INFO();

    enum EType {
        eType_experimental = 0,  ///< dose-response data points measured directly by experiment
        eType_calculated   = 1  ///< dose-response data points derived from fitted curve
    };
    
    /// Access to EType's attributes (values, names) as defined in spec
    static const NCBI_NS_NCBI::CEnumeratedTypeValues* ENUM_METHOD_NAME(EType)(void);
    
    // types
    typedef int TId;
    typedef string TDescr;
    typedef string TDn;
    typedef string TRn;
    typedef int TType;

    // member index
    enum class E_memberIndex {
        e__allMandatory = 0,
        e_id,
        e_descr,
        e_dn,
        e_rn,
        e_type
    };
    typedef Tparent::CMemberIndex<E_memberIndex, 6> TmemberIndex;

    // getters
    // setters

    /// Unique dose-response test set identifier
    ///   Note: A valid ID is greater than "0"
    /// mandatory
    /// typedef int TId
    ///  Check whether the Id data member has been assigned a value.
    bool IsSetId(void) const;
    /// Check whether it is safe or not to call GetId method.
    bool CanGetId(void) const;
    void ResetId(void);
    TId GetId(void) const;
    void SetId(TId value);
    TId& SetId(void);

    /// Dose-Response Curve Description (used as curve title)
    /// optional
    /// typedef string TDescr
    ///  Check whether the Descr data member has been assigned a value.
    bool IsSetDescr(void) const;
    /// Check whether it is safe or not to call GetDescr method.
    bool CanGetDescr(void) const;
    void ResetDescr(void);
    const TDescr& GetDescr(void) const;
    void SetDescr(const TDescr& value);
    void SetDescr(TDescr&& value);
    TDescr& SetDescr(void);

    /// Dose Axis Description (used as axis name)
    /// optional
    /// typedef string TDn
    ///  Check whether the Dn data member has been assigned a value.
    bool IsSetDn(void) const;
    /// Check whether it is safe or not to call GetDn method.
    bool CanGetDn(void) const;
    void ResetDn(void);
    const TDn& GetDn(void) const;
    void SetDn(const TDn& value);
    void SetDn(TDn&& value);
    TDn& SetDn(void);

    /// Response Axis Description (used as axis name)
    /// optional
    /// typedef string TRn
    ///  Check whether the Rn data member has been assigned a value.
    bool IsSetRn(void) const;
    /// Check whether it is safe or not to call GetRn method.
    bool CanGetRn(void) const;
    void ResetRn(void);
    const TRn& GetRn(void) const;
    void SetRn(const TRn& value);
    void SetRn(TRn&& value);
    TRn& SetRn(void);

    /// optional
    /// typedef int TType
    ///  Check whether the Type data member has been assigned a value.
    bool IsSetType(void) const;
    /// Check whether it is safe or not to call GetType method.
    bool CanGetType(void) const;
    void ResetType(void);
    TType GetType(void) const;
    void SetType(TType value);
    TType& SetType(void);

    /// Reset the whole object
    virtual void Reset(void);


private:
    // Prohibit copy constructor and assignment operator
    CPC_AssayDRAttr_Base(const CPC_AssayDRAttr_Base&);
    CPC_AssayDRAttr_Base& operator=(const CPC_AssayDRAttr_Base&);

    // data
    Uint4 m_set_State[1];
    int m_Id;
    string m_Descr;
    string m_Dn;
    string m_Rn;
    int m_Type;
};






///////////////////////////////////////////////////////////
///////////////////// inline methods //////////////////////
///////////////////////////////////////////////////////////
inline
bool CPC_AssayDRAttr_Base::IsSetId(void) const
{
    return ((m_set_State[0] & 0x3) != 0);
}

inline
bool CPC_AssayDRAttr_Base::CanGetId(void) const
{
    return IsSetId();
}

inline
void CPC_AssayDRAttr_Base::ResetId(void)
{
    m_Id = 0;
    m_set_State[0] &= ~0x3;
}

inline
CPC_AssayDRAttr_Base::TId CPC_AssayDRAttr_Base::GetId(void) const
{
    if (!CanGetId()) {
        ThrowUnassigned(0);
    }
    return m_Id;
}

inline
void CPC_AssayDRAttr_Base::SetId(CPC_AssayDRAttr_Base::TId value)
{
    m_Id = value;
    m_set_State[0] |= 0x3;
}

inline
CPC_AssayDRAttr_Base::TId& CPC_AssayDRAttr_Base::SetId(void)
{
#ifdef _DEBUG
    if (!IsSetId()) {
        memset(&m_Id,UnassignedByte(),sizeof(m_Id));
    }
#endif
    m_set_State[0] |= 0x1;
    return m_Id;
}

inline
bool CPC_AssayDRAttr_Base::IsSetDescr(void) const
{
    return ((m_set_State[0] & 0xc) != 0);
}

inline
bool CPC_AssayDRAttr_Base::CanGetDescr(void) const
{
    return IsSetDescr();
}

inline
const CPC_AssayDRAttr_Base::TDescr& CPC_AssayDRAttr_Base::GetDescr(void) const
{
    if (!CanGetDescr()) {
        ThrowUnassigned(1);
    }
    return m_Descr;
}

inline
void CPC_AssayDRAttr_Base::SetDescr(const CPC_AssayDRAttr_Base::TDescr& value)
{
    m_Descr = value;
    m_set_State[0] |= 0xc;
}

inline
void CPC_AssayDRAttr_Base::SetDescr(CPC_AssayDRAttr_Base::TDescr&& value)
{
    m_Descr = std::forward<CPC_AssayDRAttr_Base::TDescr>(value);
    m_set_State[0] |= 0xc;
}

inline
CPC_AssayDRAttr_Base::TDescr& CPC_AssayDRAttr_Base::SetDescr(void)
{
#ifdef _DEBUG
    if (!IsSetDescr()) {
        m_Descr = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x4;
    return m_Descr;
}

inline
bool CPC_AssayDRAttr_Base::IsSetDn(void) const
{
    return ((m_set_State[0] & 0x30) != 0);
}

inline
bool CPC_AssayDRAttr_Base::CanGetDn(void) const
{
    return IsSetDn();
}

inline
const CPC_AssayDRAttr_Base::TDn& CPC_AssayDRAttr_Base::GetDn(void) const
{
    if (!CanGetDn()) {
        ThrowUnassigned(2);
    }
    return m_Dn;
}

inline
void CPC_AssayDRAttr_Base::SetDn(const CPC_AssayDRAttr_Base::TDn& value)
{
    m_Dn = value;
    m_set_State[0] |= 0x30;
}

inline
void CPC_AssayDRAttr_Base::SetDn(CPC_AssayDRAttr_Base::TDn&& value)
{
    m_Dn = std::forward<CPC_AssayDRAttr_Base::TDn>(value);
    m_set_State[0] |= 0x30;
}

inline
CPC_AssayDRAttr_Base::TDn& CPC_AssayDRAttr_Base::SetDn(void)
{
#ifdef _DEBUG
    if (!IsSetDn()) {
        m_Dn = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x10;
    return m_Dn;
}

inline
bool CPC_AssayDRAttr_Base::IsSetRn(void) const
{
    return ((m_set_State[0] & 0xc0) != 0);
}

inline
bool CPC_AssayDRAttr_Base::CanGetRn(void) const
{
    return IsSetRn();
}

inline
const CPC_AssayDRAttr_Base::TRn& CPC_AssayDRAttr_Base::GetRn(void) const
{
    if (!CanGetRn()) {
        ThrowUnassigned(3);
    }
    return m_Rn;
}

inline
void CPC_AssayDRAttr_Base::SetRn(const CPC_AssayDRAttr_Base::TRn& value)
{
    m_Rn = value;
    m_set_State[0] |= 0xc0;
}

inline
void CPC_AssayDRAttr_Base::SetRn(CPC_AssayDRAttr_Base::TRn&& value)
{
    m_Rn = std::forward<CPC_AssayDRAttr_Base::TRn>(value);
    m_set_State[0] |= 0xc0;
}

inline
CPC_AssayDRAttr_Base::TRn& CPC_AssayDRAttr_Base::SetRn(void)
{
#ifdef _DEBUG
    if (!IsSetRn()) {
        m_Rn = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x40;
    return m_Rn;
}

inline
bool CPC_AssayDRAttr_Base::IsSetType(void) const
{
    return ((m_set_State[0] & 0x300) != 0);
}

inline
bool CPC_AssayDRAttr_Base::CanGetType(void) const
{
    return IsSetType();
}

inline
void CPC_AssayDRAttr_Base::ResetType(void)
{
    m_Type = (EType)(0);
    m_set_State[0] &= ~0x300;
}

inline
CPC_AssayDRAttr_Base::TType CPC_AssayDRAttr_Base::GetType(void) const
{
    if (!CanGetType()) {
        ThrowUnassigned(4);
    }
    return m_Type;
}

inline
void CPC_AssayDRAttr_Base::SetType(CPC_AssayDRAttr_Base::TType value)
{
    m_Type = value;
    m_set_State[0] |= 0x300;
}

inline
CPC_AssayDRAttr_Base::TType& CPC_AssayDRAttr_Base::SetType(void)
{
#ifdef _DEBUG
    if (!IsSetType()) {
        memset(&m_Type,UnassignedByte(),sizeof(m_Type));
    }
#endif
    m_set_State[0] |= 0x100;
    return m_Type;
}

///////////////////////////////////////////////////////////
////////////////// end of inline methods //////////////////
///////////////////////////////////////////////////////////





END_objects_SCOPE // namespace ncbi::objects::

END_NCBI_SCOPE


#endif // OBJECTS_PCASSAY_PC_ASSAYDRATTR_BASE_HPP
