/* $Id$
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 */

/// @file PC_AssayResults_.hpp
/// Data storage class.
///
/// This file was generated by application DATATOOL
/// using the following specifications:
/// 'pcassay.asn'.
///
/// ATTENTION:
///   Don't edit or commit this file into CVS as this file will
///   be overridden (by DATATOOL) without warning!

#ifndef OBJECTS_PCASSAY_PC_ASSAYRESULTS_BASE_HPP
#define OBJECTS_PCASSAY_PC_ASSAYRESULTS_BASE_HPP

// standard includes
#include <serial/serialbase.hpp>

// generated includes
#include <list>
#include <string>
#include <vector>

BEGIN_NCBI_SCOPE

#ifndef BEGIN_objects_SCOPE
#  define BEGIN_objects_SCOPE BEGIN_SCOPE(objects)
#  define END_objects_SCOPE END_SCOPE(objects)
#endif
BEGIN_objects_SCOPE // namespace ncbi::objects::


// forward declarations
class CDate;
class CPC_AnnotatedXRef;
class CPC_AssayData;
class CPC_Source;


// generated classes

/////////////////////////////////////////////////////////////////////////////
/// Container for multiple Assay Result Sets
/// PC-AssayResultsSet ::= SEQUENCE OF PC-AssayResults
/// Assay Results provided for a given Substance tested, with respect to the results types defined in the 
///   referenced Assay Description
class NCBI_PCASSAY_EXPORT CPC_AssayResults_Base : public CSerialObject
{
    typedef CSerialObject Tparent;
public:
    // constructor
    CPC_AssayResults_Base(void);
    // destructor
    virtual ~CPC_AssayResults_Base(void);

    // type info
    DECLARE_INTERNAL_TYPE_INFO();

    /// Assay Result Data for this Sample
    ///   Note: Users need populate only those "tid"s, for which there is data, in any order.
    /// Assay Outcome
    enum EOutcome {
        eOutcome_inactive     = 1,  ///<   Substance is considered Inactive
        eOutcome_active       = 2,  ///<   Substance is considered Active
        eOutcome_inconclusive = 3,  ///<   Substance is Inconclusive
        eOutcome_unspecified  = 4,  ///<   Substance Outcome is Unspecified
        eOutcome_probe        = 5  ///<   Substance Outcome is Unspecified
    };
    
    /// Access to EOutcome's attributes (values, names) as defined in spec
    static const NCBI_NS_NCBI::CEnumeratedTypeValues* ENUM_METHOD_NAME(EOutcome)(void);
    
    // types
    typedef int TSid;
    typedef CPC_Source TSid_source;
    typedef int TVersion;
    typedef string TComment;
    typedef int TOutcome;
    typedef int TRank;
    typedef vector< CRef< CPC_AssayData > > TData;
    typedef string TUrl;
    typedef list< CRef< CPC_AnnotatedXRef > > TXref;
    typedef CDate TDate;

    // member index
    enum class E_memberIndex {
        e__allMandatory = 0,
        e_sid,
        e_sid_source,
        e_version,
        e_comment,
        e_outcome,
        e_rank,
        e_data,
        e_url,
        e_xref,
        e_date
    };
    typedef Tparent::CMemberIndex<E_memberIndex, 11> TmemberIndex;

    // getters
    // setters

    /// Internal/External Tracking Information
    /// Tested Substance ID/Version  [Either valid ID or, 
    ///   if "sid-source" is used, this is a "0" value]
    ///   Note: A valid ID is greater than "0"
    /// mandatory
    /// typedef int TSid
    ///  Check whether the Sid data member has been assigned a value.
    bool IsSetSid(void) const;
    /// Check whether it is safe or not to call GetSid method.
    bool CanGetSid(void) const;
    void ResetSid(void);
    TSid GetSid(void) const;
    void SetSid(TSid value);
    TSid& SetSid(void);

    /// External Identifier for this Substance
    ///   Note: May be used in-lieu of "sid"
    ///   Note: This is non-optional if "sid" is "0"
    /// optional
    /// typedef CPC_Source TSid_source
    ///  Check whether the Sid_source data member has been assigned a value.
    bool IsSetSid_source(void) const;
    /// Check whether it is safe or not to call GetSid_source method.
    bool CanGetSid_source(void) const;
    void ResetSid_source(void);
    const TSid_source& GetSid_source(void) const;
    void SetSid_source(TSid_source& value);
    TSid_source& SetSid_source(void);

    /// Version identifier for this AID-SID Result
    ///   Note: Incoming data should set this to be "0"
    /// optional
    /// typedef int TVersion
    ///  Check whether the Version data member has been assigned a value.
    bool IsSetVersion(void) const;
    /// Check whether it is safe or not to call GetVersion method.
    bool CanGetVersion(void) const;
    void ResetVersion(void);
    TVersion GetVersion(void) const;
    void SetVersion(TVersion value);
    TVersion& SetVersion(void);

    /// Data Annotation/Qualifier and URL to further Depositor Information
    /// Annotation or qualifier for this Result
    /// optional
    /// typedef string TComment
    ///  Check whether the Comment data member has been assigned a value.
    bool IsSetComment(void) const;
    /// Check whether it is safe or not to call GetComment method.
    bool CanGetComment(void) const;
    void ResetComment(void);
    const TComment& GetComment(void) const;
    void SetComment(const TComment& value);
    void SetComment(TComment&& value);
    TComment& SetComment(void);

    /// optional with default eOutcome_unspecified
    /// typedef int TOutcome
    ///  Check whether the Outcome data member has been assigned a value.
    bool IsSetOutcome(void) const;
    /// Check whether it is safe or not to call GetOutcome method.
    bool CanGetOutcome(void) const;
    void ResetOutcome(void);
    void SetDefaultOutcome(void);
    TOutcome GetOutcome(void) const;
    void SetOutcome(TOutcome value);
    TOutcome& SetOutcome(void);

    /// Rank of Assay Outcome (for result ordering)
    ///   Note: Larger numbers are more active
    /// optional
    /// typedef int TRank
    ///  Check whether the Rank data member has been assigned a value.
    bool IsSetRank(void) const;
    /// Check whether it is safe or not to call GetRank method.
    bool CanGetRank(void) const;
    void ResetRank(void);
    TRank GetRank(void) const;
    void SetRank(TRank value);
    TRank& SetRank(void);

    /// Assay Data Reported for this SID (vector)
    /// optional
    /// typedef vector< CRef< CPC_AssayData > > TData
    ///  Check whether the Data data member has been assigned a value.
    bool IsSetData(void) const;
    /// Check whether it is safe or not to call GetData method.
    bool CanGetData(void) const;
    void ResetData(void);
    const TData& GetData(void) const;
    TData& SetData(void);

    /// Depositor provided URL for this Result
    /// optional
    /// typedef string TUrl
    ///  Check whether the Url data member has been assigned a value.
    bool IsSetUrl(void) const;
    /// Check whether it is safe or not to call GetUrl method.
    bool CanGetUrl(void) const;
    void ResetUrl(void);
    const TUrl& GetUrl(void) const;
    void SetUrl(const TUrl& value);
    void SetUrl(TUrl&& value);
    TUrl& SetUrl(void);

    /// annotated Cross-Reference Information
    /// to be removed, 
    /// instead regulard TID will be generated
    /// which are then annotated by xref type
    /// optional
    /// typedef list< CRef< CPC_AnnotatedXRef > > TXref
    ///  Check whether the Xref data member has been assigned a value.
    bool IsSetXref(void) const;
    /// Check whether it is safe or not to call GetXref method.
    bool CanGetXref(void) const;
    void ResetXref(void);
    const TXref& GetXref(void) const;
    TXref& SetXref(void);

    /// Pubchem Release Date
    /// optional
    /// typedef CDate TDate
    ///  Check whether the Date data member has been assigned a value.
    bool IsSetDate(void) const;
    /// Check whether it is safe or not to call GetDate method.
    bool CanGetDate(void) const;
    void ResetDate(void);
    const TDate& GetDate(void) const;
    void SetDate(TDate& value);
    TDate& SetDate(void);

    /// Reset the whole object
    virtual void Reset(void);


private:
    // Prohibit copy constructor and assignment operator
    CPC_AssayResults_Base(const CPC_AssayResults_Base&);
    CPC_AssayResults_Base& operator=(const CPC_AssayResults_Base&);

    // data
    Uint4 m_set_State[1];
    int m_Sid;
    CRef< TSid_source > m_Sid_source;
    int m_Version;
    string m_Comment;
    int m_Outcome;
    int m_Rank;
    vector< CRef< CPC_AssayData > > m_Data;
    string m_Url;
    list< CRef< CPC_AnnotatedXRef > > m_Xref;
    CRef< TDate > m_Date;
};






///////////////////////////////////////////////////////////
///////////////////// inline methods //////////////////////
///////////////////////////////////////////////////////////
inline
bool CPC_AssayResults_Base::IsSetSid(void) const
{
    return ((m_set_State[0] & 0x3) != 0);
}

inline
bool CPC_AssayResults_Base::CanGetSid(void) const
{
    return IsSetSid();
}

inline
void CPC_AssayResults_Base::ResetSid(void)
{
    m_Sid = 0;
    m_set_State[0] &= ~0x3;
}

inline
CPC_AssayResults_Base::TSid CPC_AssayResults_Base::GetSid(void) const
{
    if (!CanGetSid()) {
        ThrowUnassigned(0);
    }
    return m_Sid;
}

inline
void CPC_AssayResults_Base::SetSid(CPC_AssayResults_Base::TSid value)
{
    m_Sid = value;
    m_set_State[0] |= 0x3;
}

inline
CPC_AssayResults_Base::TSid& CPC_AssayResults_Base::SetSid(void)
{
#ifdef _DEBUG
    if (!IsSetSid()) {
        memset(&m_Sid,UnassignedByte(),sizeof(m_Sid));
    }
#endif
    m_set_State[0] |= 0x1;
    return m_Sid;
}

inline
bool CPC_AssayResults_Base::IsSetSid_source(void) const
{
    return m_Sid_source.NotEmpty();
}

inline
bool CPC_AssayResults_Base::CanGetSid_source(void) const
{
    return IsSetSid_source();
}

inline
const CPC_AssayResults_Base::TSid_source& CPC_AssayResults_Base::GetSid_source(void) const
{
    if (!CanGetSid_source()) {
        ThrowUnassigned(1);
    }
    return (*m_Sid_source);
}

inline
bool CPC_AssayResults_Base::IsSetVersion(void) const
{
    return ((m_set_State[0] & 0x30) != 0);
}

inline
bool CPC_AssayResults_Base::CanGetVersion(void) const
{
    return IsSetVersion();
}

inline
void CPC_AssayResults_Base::ResetVersion(void)
{
    m_Version = 0;
    m_set_State[0] &= ~0x30;
}

inline
CPC_AssayResults_Base::TVersion CPC_AssayResults_Base::GetVersion(void) const
{
    if (!CanGetVersion()) {
        ThrowUnassigned(2);
    }
    return m_Version;
}

inline
void CPC_AssayResults_Base::SetVersion(CPC_AssayResults_Base::TVersion value)
{
    m_Version = value;
    m_set_State[0] |= 0x30;
}

inline
CPC_AssayResults_Base::TVersion& CPC_AssayResults_Base::SetVersion(void)
{
#ifdef _DEBUG
    if (!IsSetVersion()) {
        memset(&m_Version,UnassignedByte(),sizeof(m_Version));
    }
#endif
    m_set_State[0] |= 0x10;
    return m_Version;
}

inline
bool CPC_AssayResults_Base::IsSetComment(void) const
{
    return ((m_set_State[0] & 0xc0) != 0);
}

inline
bool CPC_AssayResults_Base::CanGetComment(void) const
{
    return IsSetComment();
}

inline
const CPC_AssayResults_Base::TComment& CPC_AssayResults_Base::GetComment(void) const
{
    if (!CanGetComment()) {
        ThrowUnassigned(3);
    }
    return m_Comment;
}

inline
void CPC_AssayResults_Base::SetComment(const CPC_AssayResults_Base::TComment& value)
{
    m_Comment = value;
    m_set_State[0] |= 0xc0;
}

inline
void CPC_AssayResults_Base::SetComment(CPC_AssayResults_Base::TComment&& value)
{
    m_Comment = std::forward<CPC_AssayResults_Base::TComment>(value);
    m_set_State[0] |= 0xc0;
}

inline
CPC_AssayResults_Base::TComment& CPC_AssayResults_Base::SetComment(void)
{
#ifdef _DEBUG
    if (!IsSetComment()) {
        m_Comment = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x40;
    return m_Comment;
}

inline
bool CPC_AssayResults_Base::IsSetOutcome(void) const
{
    return ((m_set_State[0] & 0x300) != 0);
}

inline
bool CPC_AssayResults_Base::CanGetOutcome(void) const
{
    return true;
}

inline
void CPC_AssayResults_Base::ResetOutcome(void)
{
    m_Outcome = eOutcome_unspecified;
    m_set_State[0] &= ~0x300;
}

inline
void CPC_AssayResults_Base::SetDefaultOutcome(void)
{
    ResetOutcome();
}

inline
CPC_AssayResults_Base::TOutcome CPC_AssayResults_Base::GetOutcome(void) const
{
    return m_Outcome;
}

inline
void CPC_AssayResults_Base::SetOutcome(CPC_AssayResults_Base::TOutcome value)
{
    m_Outcome = value;
    m_set_State[0] |= 0x300;
}

inline
CPC_AssayResults_Base::TOutcome& CPC_AssayResults_Base::SetOutcome(void)
{
#ifdef _DEBUG
    if (!IsSetOutcome()) {
        memset(&m_Outcome,UnassignedByte(),sizeof(m_Outcome));
    }
#endif
    m_set_State[0] |= 0x100;
    return m_Outcome;
}

inline
bool CPC_AssayResults_Base::IsSetRank(void) const
{
    return ((m_set_State[0] & 0xc00) != 0);
}

inline
bool CPC_AssayResults_Base::CanGetRank(void) const
{
    return IsSetRank();
}

inline
void CPC_AssayResults_Base::ResetRank(void)
{
    m_Rank = 0;
    m_set_State[0] &= ~0xc00;
}

inline
CPC_AssayResults_Base::TRank CPC_AssayResults_Base::GetRank(void) const
{
    if (!CanGetRank()) {
        ThrowUnassigned(5);
    }
    return m_Rank;
}

inline
void CPC_AssayResults_Base::SetRank(CPC_AssayResults_Base::TRank value)
{
    m_Rank = value;
    m_set_State[0] |= 0xc00;
}

inline
CPC_AssayResults_Base::TRank& CPC_AssayResults_Base::SetRank(void)
{
#ifdef _DEBUG
    if (!IsSetRank()) {
        memset(&m_Rank,UnassignedByte(),sizeof(m_Rank));
    }
#endif
    m_set_State[0] |= 0x400;
    return m_Rank;
}

inline
bool CPC_AssayResults_Base::IsSetData(void) const
{
    return ((m_set_State[0] & 0x3000) != 0);
}

inline
bool CPC_AssayResults_Base::CanGetData(void) const
{
    return true;
}

inline
const CPC_AssayResults_Base::TData& CPC_AssayResults_Base::GetData(void) const
{
    return m_Data;
}

inline
CPC_AssayResults_Base::TData& CPC_AssayResults_Base::SetData(void)
{
    m_set_State[0] |= 0x1000;
    return m_Data;
}

inline
bool CPC_AssayResults_Base::IsSetUrl(void) const
{
    return ((m_set_State[0] & 0xc000) != 0);
}

inline
bool CPC_AssayResults_Base::CanGetUrl(void) const
{
    return IsSetUrl();
}

inline
const CPC_AssayResults_Base::TUrl& CPC_AssayResults_Base::GetUrl(void) const
{
    if (!CanGetUrl()) {
        ThrowUnassigned(7);
    }
    return m_Url;
}

inline
void CPC_AssayResults_Base::SetUrl(const CPC_AssayResults_Base::TUrl& value)
{
    m_Url = value;
    m_set_State[0] |= 0xc000;
}

inline
void CPC_AssayResults_Base::SetUrl(CPC_AssayResults_Base::TUrl&& value)
{
    m_Url = std::forward<CPC_AssayResults_Base::TUrl>(value);
    m_set_State[0] |= 0xc000;
}

inline
CPC_AssayResults_Base::TUrl& CPC_AssayResults_Base::SetUrl(void)
{
#ifdef _DEBUG
    if (!IsSetUrl()) {
        m_Url = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x4000;
    return m_Url;
}

inline
bool CPC_AssayResults_Base::IsSetXref(void) const
{
    return ((m_set_State[0] & 0x30000) != 0);
}

inline
bool CPC_AssayResults_Base::CanGetXref(void) const
{
    return true;
}

inline
const CPC_AssayResults_Base::TXref& CPC_AssayResults_Base::GetXref(void) const
{
    return m_Xref;
}

inline
CPC_AssayResults_Base::TXref& CPC_AssayResults_Base::SetXref(void)
{
    m_set_State[0] |= 0x10000;
    return m_Xref;
}

inline
bool CPC_AssayResults_Base::IsSetDate(void) const
{
    return m_Date.NotEmpty();
}

inline
bool CPC_AssayResults_Base::CanGetDate(void) const
{
    return IsSetDate();
}

inline
const CPC_AssayResults_Base::TDate& CPC_AssayResults_Base::GetDate(void) const
{
    if (!CanGetDate()) {
        ThrowUnassigned(9);
    }
    return (*m_Date);
}

///////////////////////////////////////////////////////////
////////////////// end of inline methods //////////////////
///////////////////////////////////////////////////////////





END_objects_SCOPE // namespace ncbi::objects::

END_NCBI_SCOPE


#endif // OBJECTS_PCASSAY_PC_ASSAYRESULTS_BASE_HPP
