/* $Id$
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 */

/// @file PC_ResultType_.hpp
/// Data storage class.
///
/// This file was generated by application DATATOOL
/// using the following specifications:
/// 'pcassay.asn'.
///
/// ATTENTION:
///   Don't edit or commit this file into CVS as this file will
///   be overridden (by DATATOOL) without warning!

#ifndef OBJECTS_PCASSAY_PC_RESULTTYPE_BASE_HPP
#define OBJECTS_PCASSAY_PC_RESULTTYPE_BASE_HPP

// standard includes
#include <serial/serialbase.hpp>

// generated includes
#include <list>
#include <string>

BEGIN_NCBI_SCOPE

#ifndef BEGIN_objects_SCOPE
#  define BEGIN_objects_SCOPE BEGIN_SCOPE(objects)
#  define END_objects_SCOPE END_SCOPE(objects)
#endif
BEGIN_objects_SCOPE // namespace ncbi::objects::


// forward declarations
class CPC_AssayPanelTestResult;
class CPC_ConcentrationAttr;
class CPC_IntegerMinMax;
class CPC_RealMinMax;


// generated classes

/////////////////////////////////////////////////////////////////////////////
/// Definition of Allowed Result Types for a given Assay
class NCBI_PCASSAY_EXPORT CPC_ResultType_Base : public CSerialObject
{
    typedef CSerialObject Tparent;
public:
    // constructor
    CPC_ResultType_Base(void);
    // destructor
    virtual ~CPC_ResultType_Base(void);

    // type info
    DECLARE_INTERNAL_TYPE_INFO();

    /// Result Data Type and Validation Information
    /// Result Data Type
    enum EType {
        eType_float  = 1,
        eType_int    = 2,
        eType_bool   = 3,
        eType_string = 4
    };
    
    /// Access to EType's attributes (values, names) as defined in spec
    static const NCBI_NS_NCBI::CEnumeratedTypeValues* ENUM_METHOD_NAME(EType)(void);
    
    /////////////////////////////////////////////////////////////////////////////
    /// Allowed Values, used for validating incoming data
    /// If type is "float"
    class NCBI_PCASSAY_EXPORT C_Constraints : public CSerialObject
    {
        typedef CSerialObject Tparent;
    public:
        // constructor
        C_Constraints(void);
        // destructor
        ~C_Constraints(void);
    
        // type info
        DECLARE_INTERNAL_TYPE_INFO();
    
    
        /// Choice variants.
        enum E_Choice {
            e_not_set = 0,  ///< No variant selected
            e_Fset,         ///<   Allowed values must be equal to one of these
            e_Fmin,         ///<   Allowed values (x) must be [ fmin <= x ]
            e_Fmax,         ///<   Allowed values (x) must be [ x <= fmax ]
            e_Frange,       ///<   Minimum/Maximum Range [ min <= x <= max ]
            e_Iset,         ///< If type is "int"    Allowed values must be equal to one of these
            e_Imin,         ///<   Allowed values (x) must be [ imin <= x ]
            e_Imax,         ///<   Allowed values (x) must be [ x <= imax ]
            e_Irange,       ///<   Minimum/Maximum Range [ min <= x <= max ]
            e_Sset          ///< If type is "string"    Allowed values must be equal to one of these
        };
        /// Maximum+1 value of the choice variant enumerator.
        enum E_ChoiceStopper {
            e_MaxChoice = 10 ///< == e_Sset+1
        };
    
        /// Reset the whole object
        void Reset(void);
    
        /// Reset the selection (set it to e_not_set).
        void ResetSelection(void);
    
        /// Which variant is currently selected.
        E_Choice Which(void) const;
    
        /// Verify selection, throw exception if it differs from the expected.
        void CheckSelected(E_Choice index) const;
    
        /// Throw 'InvalidSelection' exception.
        NCBI_NORETURN void ThrowInvalidSelection(E_Choice index) const;
    
        /// Retrieve selection name (for diagnostic purposes).
        static string SelectionName(E_Choice index);
    
        /// Select the requested variant if needed.
        void Select(E_Choice index, EResetVariant reset = eDoResetVariant);
        /// Select the requested variant if needed,
        /// allocating CObject variants from memory pool.
        void Select(E_Choice index,
                    EResetVariant reset,
                    CObjectMemoryPool* pool);
    
        // types
        typedef list< double > TFset;
        typedef double TFmin;
        typedef double TFmax;
        typedef CPC_RealMinMax TFrange;
        typedef list< int > TIset;
        typedef int TImin;
        typedef int TImax;
        typedef CPC_IntegerMinMax TIrange;
        typedef list< string > TSset;
    
        // getters
        // setters
    
        // typedef list< double > TFset
        bool IsFset(void) const;
        const TFset& GetFset(void) const;
        TFset& SetFset(void);
    
        // typedef double TFmin
        bool IsFmin(void) const;
        TFmin GetFmin(void) const;
        TFmin& SetFmin(void);
        void SetFmin(TFmin value);
    
        // typedef double TFmax
        bool IsFmax(void) const;
        TFmax GetFmax(void) const;
        TFmax& SetFmax(void);
        void SetFmax(TFmax value);
    
        // typedef CPC_RealMinMax TFrange
        bool IsFrange(void) const;
        const TFrange& GetFrange(void) const;
        TFrange& SetFrange(void);
        void SetFrange(TFrange& value);
    
        // typedef list< int > TIset
        bool IsIset(void) const;
        const TIset& GetIset(void) const;
        TIset& SetIset(void);
    
        // typedef int TImin
        bool IsImin(void) const;
        TImin GetImin(void) const;
        TImin& SetImin(void);
        void SetImin(TImin value);
    
        // typedef int TImax
        bool IsImax(void) const;
        TImax GetImax(void) const;
        TImax& SetImax(void);
        void SetImax(TImax value);
    
        // typedef CPC_IntegerMinMax TIrange
        bool IsIrange(void) const;
        const TIrange& GetIrange(void) const;
        TIrange& SetIrange(void);
        void SetIrange(TIrange& value);
    
        // typedef list< string > TSset
        bool IsSset(void) const;
        const TSset& GetSset(void) const;
        TSset& SetSset(void);
    
    
    private:
        // copy constructor and assignment operator
        C_Constraints(const C_Constraints& );
        C_Constraints& operator=(const C_Constraints& );
        // choice state
        E_Choice m_choice;
        // helper methods
        void DoSelect(E_Choice index, CObjectMemoryPool* pool = 0);
    
        static const char* const sm_SelectionNames[];
        // data
        union {
            NCBI_NS_NCBI::CUnionBuffer<TFset> m_Fset;
            TFmin m_Fmin;
            TFmax m_Fmax;
            NCBI_NS_NCBI::CUnionBuffer<TIset> m_Iset;
            TImin m_Imin;
            TImax m_Imax;
            NCBI_NS_NCBI::CUnionBuffer<TSset> m_Sset;
            NCBI_NS_NCBI::CSerialObject *m_object;
        };
    };
    /// Unit information provides the units for the values reported for this TID.  For example, if the values 
    ///   reported for this TID are a concentration, e.g., micro-molar, setting the unit "um" allows PubChem to 
    ///   know that the value, e.g., "1.3", is actually "1.3 uM".  This also allows PubChem to properly report the 
    ///   units when displaying the reported values for this TID.  If the enumerated units provided below are 
    ///   insufficient, you may represent the units as a string in the optional "sunit" field (see below).
    /// Units for Value
    enum EUnit {
        eUnit_ppt         =   1,  ///< Parts per Thousand
        eUnit_ppm         =   2,  ///< Parts per Million
        eUnit_ppb         =   3,  ///< Parts per Billion
        eUnit_mm          =   4,  ///< milliM
        eUnit_um          =   5,  ///< microM
        eUnit_nm          =   6,  ///< nanoM
        eUnit_pm          =   7,  ///< picoM
        eUnit_fm          =   8,  ///< femtoM
        eUnit_mgml        =   9,  ///< milligrams per mL
        eUnit_ugml        =  10,  ///< micrograms per mL
        eUnit_ngml        =  11,  ///< nanograms per mL
        eUnit_pgml        =  12,  ///< picograms per mL
        eUnit_fgml        =  13,  ///< femtograms per mL
        eUnit_m           =  14,  ///< Molar
        eUnit_percent     =  15,  ///< Percent
        eUnit_ratio       =  16,  ///< Ratio
        eUnit_sec         =  17,  ///< Seconds
        eUnit_rsec        =  18,  ///< Reciprocal Seconds
        eUnit_min         =  19,  ///< Minutes
        eUnit_rmin        =  20,  ///< Reciprocal Minutes
        eUnit_day         =  21,  ///< Days
        eUnit_rday        =  22,  ///< Reciprocal Days
        eUnit_ml_min_kg   =  23,  ///< milliliter / minute / kilogram
        eUnit_l_kg        =  24,  ///< liter / kilogram
        eUnit_hr_ng_ml    =  25,  ///< hour * nanogram / milliliter
        eUnit_cm_sec      =  26,  ///< centimeter / second
        eUnit_mg_kg       =  27,  ///< milligram / kilogram
        eUnit_none        = 254,
        eUnit_unspecified = 255
    };
    
    /// Access to EUnit's attributes (values, names) as defined in spec
    static const NCBI_NS_NCBI::CEnumeratedTypeValues* ENUM_METHOD_NAME(EUnit)(void);
    
    /// Value Transform information qualifies the values reported for this TID.  For example, if the values
    ///   reported for this TID are "-Log10 GI50", you may want to consider setting
    ///   the "nlog" value below.  In doing so, PubChem would know that the value, e.g., "5.0" 
    ///   is actually "1.0e-5".  If the transformation applied is not listed, you may represent
    ///   this transformation as a string in the "stransform" (see below) for eventual inclusion 
    ///   in the enumerated transform list below.
    ///
    ///
    /// ATTENTION: transform field is DEPRECATED. It is no longer
    ///            supported and remains for legacy data only.
    /// Value Type Details
    enum ETransform {
        eTransform_linear     = 1,  ///< Linear Scale (x)
        eTransform_ln         = 2,  ///< Natural Log Scale (ln x)
        eTransform_log        = 3,  ///< Log Base 10 Scale (log10 x)
        eTransform_reciprocal = 4,  ///< Reciprocal Scale (1/x)
        eTransform_negative   = 5,  ///< Negative Linear Scale (-x)
        eTransform_nlog       = 6,  ///< Negative Log Base 10 Scale (-log10 x)
        eTransform_nln        = 7  ///< Negative Natural Log Scane (-ln x)
    };
    
    /// Access to ETransform's attributes (values, names) as defined in spec
    static const NCBI_NS_NCBI::CEnumeratedTypeValues* ENUM_METHOD_NAME(ETransform)(void);
    
    enum EAnnot {
        eAnnot_pmid                     =  1,  ///< PubMed ID
        eAnnot_mmdb                     =  2,  ///< MMDB ID
        eAnnot_url                      =  3,  ///< indicate  TID data is a url that provides supplementary information
        eAnnot_protein_gi               =  4,  ///< GenBank General ID (GI) for a Protein
        eAnnot_nucleotide_gi            =  5,  ///< GenBank General ID (GI) for a Nucleotide 
        eAnnot_taxonomy                 =  6,  ///< Taxonomy ID for an Organism
        eAnnot_mim                      =  7,  ///< MIM, Mendelian Inheritance in Man, ID 
        eAnnot_gene                     =  8,  ///< Entrez Gene ID
        eAnnot_probe                    =  9,  ///< Entrez Probe ID
        eAnnot_aid                      = 10,  ///< PubChem BioAssay ID, may be used in 'Summary' assay
        eAnnot_sid                      = 11,  ///< PubChem Substance ID, may be used in 'Summary' assay 
        eAnnot_cid                      = 12,  ///< PubChem Compound ID 
        eAnnot_protein_target_gi        = 13,  ///< GenBank General ID (GI) for a Protein target
        eAnnot_biosystems_target_id     = 14,  ///< NCBI BioSystems ID 
        eAnnot_target_name              = 15,  ///< target name
        eAnnot_target_descr             = 16,  ///< brief target description 
        eAnnot_target_tax_id            = 17,  ///< NCBI Taxonomy ID for target molecule 
        eAnnot_gene_target_id           = 18,  ///< NCBI Gene ID for a gene target 
        eAnnot_dna_nucleotide_target_gi = 19,  ///< GenBank General ID (GI) for a DNA Nucleotide target 
        eAnnot_rna_nucleotide_target_gi = 20  ///< GenBank General ID (GI) for a RNA Nucleotide target 
    };
    
    /// Access to EAnnot's attributes (values, names) as defined in spec
    static const NCBI_NS_NCBI::CEnumeratedTypeValues* ENUM_METHOD_NAME(EAnnot)(void);
    
    // types
    typedef int TTid;
    typedef string TName;
    typedef list< string > TDescription;
    typedef int TType;
    typedef C_Constraints TConstraints;
    typedef int TUnit;
    typedef string TSunit;
    typedef int TTransform;
    typedef string TStransform;
    typedef CPC_ConcentrationAttr TTc;
    typedef bool TAc;
    typedef CPC_AssayPanelTestResult TPanel_info;
    typedef int TAnnot;

    // member index
    enum class E_memberIndex {
        e__allMandatory = 0,
        e_tid,
        e_name,
        e_description,
        e_type,
        e_constraints,
        e_unit,
        e_sunit,
        e_transform,
        e_stransform,
        e_tc,
        e_ac,
        e_panel_info,
        e_annot
    };
    typedef Tparent::CMemberIndex<E_memberIndex, 14> TmemberIndex;

    // getters
    // setters

    /// Tracking or Description Information
    /// Assay Result Field Type ID (TID)
    /// mandatory
    /// typedef int TTid
    ///  Check whether the Tid data member has been assigned a value.
    bool IsSetTid(void) const;
    /// Check whether it is safe or not to call GetTid method.
    bool CanGetTid(void) const;
    void ResetTid(void);
    TTid GetTid(void) const;
    void SetTid(TTid value);
    TTid& SetTid(void);

    /// Result Field Name (short name for display)
    /// mandatory
    /// typedef string TName
    ///  Check whether the Name data member has been assigned a value.
    bool IsSetName(void) const;
    /// Check whether it is safe or not to call GetName method.
    bool CanGetName(void) const;
    void ResetName(void);
    const TName& GetName(void) const;
    void SetName(const TName& value);
    void SetName(TName&& value);
    TName& SetName(void);

    /// Result Field Description
    /// optional
    /// typedef list< string > TDescription
    ///  Check whether the Description data member has been assigned a value.
    bool IsSetDescription(void) const;
    /// Check whether it is safe or not to call GetDescription method.
    bool CanGetDescription(void) const;
    void ResetDescription(void);
    const TDescription& GetDescription(void) const;
    TDescription& SetDescription(void);

    /// mandatory
    /// typedef int TType
    ///  Check whether the Type data member has been assigned a value.
    bool IsSetType(void) const;
    /// Check whether it is safe or not to call GetType method.
    bool CanGetType(void) const;
    void ResetType(void);
    TType GetType(void) const;
    void SetType(TType value);
    TType& SetType(void);

    /// optional
    /// typedef C_Constraints TConstraints
    ///  Check whether the Constraints data member has been assigned a value.
    bool IsSetConstraints(void) const;
    /// Check whether it is safe or not to call GetConstraints method.
    bool CanGetConstraints(void) const;
    void ResetConstraints(void);
    const TConstraints& GetConstraints(void) const;
    void SetConstraints(TConstraints& value);
    TConstraints& SetConstraints(void);

    /// optional
    /// typedef int TUnit
    ///  Check whether the Unit data member has been assigned a value.
    bool IsSetUnit(void) const;
    /// Check whether it is safe or not to call GetUnit method.
    bool CanGetUnit(void) const;
    void ResetUnit(void);
    TUnit GetUnit(void) const;
    void SetUnit(TUnit value);
    TUnit& SetUnit(void);

    /// ATTENTION: sunit field is DEPRECATED. It is no longer
    ///            supported and remains for legacy data only.
    /// Unit Type (as a String)
    /// optional
    /// typedef string TSunit
    ///  Check whether the Sunit data member has been assigned a value.
    bool IsSetSunit(void) const;
    /// Check whether it is safe or not to call GetSunit method.
    bool CanGetSunit(void) const;
    void ResetSunit(void);
    const TSunit& GetSunit(void) const;
    void SetSunit(const TSunit& value);
    void SetSunit(TSunit&& value);
    TSunit& SetSunit(void);

    /// optional
    /// typedef int TTransform
    ///  Check whether the Transform data member has been assigned a value.
    bool IsSetTransform(void) const;
    /// Check whether it is safe or not to call GetTransform method.
    bool CanGetTransform(void) const;
    void ResetTransform(void);
    TTransform GetTransform(void) const;
    void SetTransform(TTransform value);
    TTransform& SetTransform(void);

    /// ATTENTION: stransform field is DEPRECATED. It is no longer
    ///            supported and remains for legacy data only.
    /// Value Transform Type (as a String)
    /// optional
    /// typedef string TStransform
    ///  Check whether the Stransform data member has been assigned a value.
    bool IsSetStransform(void) const;
    /// Check whether it is safe or not to call GetStransform method.
    bool CanGetStransform(void) const;
    void ResetStransform(void);
    const TStransform& GetStransform(void) const;
    void SetStransform(const TStransform& value);
    void SetStransform(TStransform&& value);
    TStransform& SetStransform(void);

    /// Tested concentration attribute
    /// optional
    /// typedef CPC_ConcentrationAttr TTc
    ///  Check whether the Tc data member has been assigned a value.
    bool IsSetTc(void) const;
    /// Check whether it is safe or not to call GetTc method.
    bool CanGetTc(void) const;
    void ResetTc(void);
    const TTc& GetTc(void) const;
    void SetTc(TTc& value);
    TTc& SetTc(void);

    /// if true, indicates that this TID field 
    /// provides active concentration summary by 
    /// reporting the concentration which produces 
    /// 50% of the maximum possible biological response
    /// such as IC50, EC50, AC50, GI50 etc. 
    /// or by reporting constant parameters such as Ki, 
    /// that based on which the activity outcome in this assay is called   
    /// optional
    /// typedef bool TAc
    ///  Check whether the Ac data member has been assigned a value.
    bool IsSetAc(void) const;
    /// Check whether it is safe or not to call GetAc method.
    bool CanGetAc(void) const;
    void ResetAc(void);
    TAc GetAc(void) const;
    void SetAc(TAc value);
    TAc& SetAc(void);

    /// needed for panel assay only
    /// each panel member may have a number of TID columns reported
    /// such TIDs are grouped by panel member ID, see PC-AssayPanelMemberInfo
    /// optional
    /// typedef CPC_AssayPanelTestResult TPanel_info
    ///  Check whether the Panel_info data member has been assigned a value.
    bool IsSetPanel_info(void) const;
    /// Check whether it is safe or not to call GetPanel_info method.
    bool CanGetPanel_info(void) const;
    void ResetPanel_info(void);
    const TPanel_info& GetPanel_info(void) const;
    void SetPanel_info(TPanel_info& value);
    TPanel_info& SetPanel_info(void);

    /// treat substance associated cross-reference as regular TID
    /// web servers would make a link 
    /// to the corresponding record in Entrez databases
    /// treat substance associated target information as regular TID
    /// for example, for RNAi screening data, each 'substance' may
    /// correspond to a specific gene target
    /// optional
    /// typedef int TAnnot
    ///  Check whether the Annot data member has been assigned a value.
    bool IsSetAnnot(void) const;
    /// Check whether it is safe or not to call GetAnnot method.
    bool CanGetAnnot(void) const;
    void ResetAnnot(void);
    TAnnot GetAnnot(void) const;
    void SetAnnot(TAnnot value);
    TAnnot& SetAnnot(void);

    /// Reset the whole object
    virtual void Reset(void);


private:
    // Prohibit copy constructor and assignment operator
    CPC_ResultType_Base(const CPC_ResultType_Base&);
    CPC_ResultType_Base& operator=(const CPC_ResultType_Base&);

    // data
    Uint4 m_set_State[1];
    int m_Tid;
    string m_Name;
    list< string > m_Description;
    int m_Type;
    CRef< TConstraints > m_Constraints;
    int m_Unit;
    string m_Sunit;
    int m_Transform;
    string m_Stransform;
    CRef< TTc > m_Tc;
    bool m_Ac;
    CRef< TPanel_info > m_Panel_info;
    int m_Annot;
};






///////////////////////////////////////////////////////////
///////////////////// inline methods //////////////////////
///////////////////////////////////////////////////////////
inline
CPC_ResultType_Base::C_Constraints::E_Choice CPC_ResultType_Base::C_Constraints::Which(void) const
{
    return m_choice;
}

inline
void CPC_ResultType_Base::C_Constraints::CheckSelected(E_Choice index) const
{
    if ( m_choice != index )
        ThrowInvalidSelection(index);
}

inline
void CPC_ResultType_Base::C_Constraints::Select(E_Choice index, NCBI_NS_NCBI::EResetVariant reset, NCBI_NS_NCBI::CObjectMemoryPool* pool)
{
    if ( reset == NCBI_NS_NCBI::eDoResetVariant || m_choice != index ) {
        if ( m_choice != e_not_set )
            ResetSelection();
        DoSelect(index, pool);
    }
}

inline
void CPC_ResultType_Base::C_Constraints::Select(E_Choice index, NCBI_NS_NCBI::EResetVariant reset)
{
    Select(index, reset, 0);
}

inline
bool CPC_ResultType_Base::C_Constraints::IsFset(void) const
{
    return m_choice == e_Fset;
}

inline
const CPC_ResultType_Base::C_Constraints::TFset& CPC_ResultType_Base::C_Constraints::GetFset(void) const
{
    CheckSelected(e_Fset);
    return *m_Fset;
}

inline
CPC_ResultType_Base::C_Constraints::TFset& CPC_ResultType_Base::C_Constraints::SetFset(void)
{
    Select(e_Fset, NCBI_NS_NCBI::eDoNotResetVariant);
    return *m_Fset;
}

inline
bool CPC_ResultType_Base::C_Constraints::IsFmin(void) const
{
    return m_choice == e_Fmin;
}

inline
CPC_ResultType_Base::C_Constraints::TFmin CPC_ResultType_Base::C_Constraints::GetFmin(void) const
{
    CheckSelected(e_Fmin);
    return m_Fmin;
}

inline
CPC_ResultType_Base::C_Constraints::TFmin& CPC_ResultType_Base::C_Constraints::SetFmin(void)
{
    Select(e_Fmin, NCBI_NS_NCBI::eDoNotResetVariant);
    return m_Fmin;
}

inline
void CPC_ResultType_Base::C_Constraints::SetFmin(CPC_ResultType_Base::C_Constraints::TFmin value)
{
    Select(e_Fmin, NCBI_NS_NCBI::eDoNotResetVariant);
    m_Fmin = value;
}

inline
bool CPC_ResultType_Base::C_Constraints::IsFmax(void) const
{
    return m_choice == e_Fmax;
}

inline
CPC_ResultType_Base::C_Constraints::TFmax CPC_ResultType_Base::C_Constraints::GetFmax(void) const
{
    CheckSelected(e_Fmax);
    return m_Fmax;
}

inline
CPC_ResultType_Base::C_Constraints::TFmax& CPC_ResultType_Base::C_Constraints::SetFmax(void)
{
    Select(e_Fmax, NCBI_NS_NCBI::eDoNotResetVariant);
    return m_Fmax;
}

inline
void CPC_ResultType_Base::C_Constraints::SetFmax(CPC_ResultType_Base::C_Constraints::TFmax value)
{
    Select(e_Fmax, NCBI_NS_NCBI::eDoNotResetVariant);
    m_Fmax = value;
}

inline
bool CPC_ResultType_Base::C_Constraints::IsFrange(void) const
{
    return m_choice == e_Frange;
}

inline
bool CPC_ResultType_Base::C_Constraints::IsIset(void) const
{
    return m_choice == e_Iset;
}

inline
const CPC_ResultType_Base::C_Constraints::TIset& CPC_ResultType_Base::C_Constraints::GetIset(void) const
{
    CheckSelected(e_Iset);
    return *m_Iset;
}

inline
CPC_ResultType_Base::C_Constraints::TIset& CPC_ResultType_Base::C_Constraints::SetIset(void)
{
    Select(e_Iset, NCBI_NS_NCBI::eDoNotResetVariant);
    return *m_Iset;
}

inline
bool CPC_ResultType_Base::C_Constraints::IsImin(void) const
{
    return m_choice == e_Imin;
}

inline
CPC_ResultType_Base::C_Constraints::TImin CPC_ResultType_Base::C_Constraints::GetImin(void) const
{
    CheckSelected(e_Imin);
    return m_Imin;
}

inline
CPC_ResultType_Base::C_Constraints::TImin& CPC_ResultType_Base::C_Constraints::SetImin(void)
{
    Select(e_Imin, NCBI_NS_NCBI::eDoNotResetVariant);
    return m_Imin;
}

inline
void CPC_ResultType_Base::C_Constraints::SetImin(CPC_ResultType_Base::C_Constraints::TImin value)
{
    Select(e_Imin, NCBI_NS_NCBI::eDoNotResetVariant);
    m_Imin = value;
}

inline
bool CPC_ResultType_Base::C_Constraints::IsImax(void) const
{
    return m_choice == e_Imax;
}

inline
CPC_ResultType_Base::C_Constraints::TImax CPC_ResultType_Base::C_Constraints::GetImax(void) const
{
    CheckSelected(e_Imax);
    return m_Imax;
}

inline
CPC_ResultType_Base::C_Constraints::TImax& CPC_ResultType_Base::C_Constraints::SetImax(void)
{
    Select(e_Imax, NCBI_NS_NCBI::eDoNotResetVariant);
    return m_Imax;
}

inline
void CPC_ResultType_Base::C_Constraints::SetImax(CPC_ResultType_Base::C_Constraints::TImax value)
{
    Select(e_Imax, NCBI_NS_NCBI::eDoNotResetVariant);
    m_Imax = value;
}

inline
bool CPC_ResultType_Base::C_Constraints::IsIrange(void) const
{
    return m_choice == e_Irange;
}

inline
bool CPC_ResultType_Base::C_Constraints::IsSset(void) const
{
    return m_choice == e_Sset;
}

inline
const CPC_ResultType_Base::C_Constraints::TSset& CPC_ResultType_Base::C_Constraints::GetSset(void) const
{
    CheckSelected(e_Sset);
    return *m_Sset;
}

inline
CPC_ResultType_Base::C_Constraints::TSset& CPC_ResultType_Base::C_Constraints::SetSset(void)
{
    Select(e_Sset, NCBI_NS_NCBI::eDoNotResetVariant);
    return *m_Sset;
}

inline
bool CPC_ResultType_Base::IsSetTid(void) const
{
    return ((m_set_State[0] & 0x3) != 0);
}

inline
bool CPC_ResultType_Base::CanGetTid(void) const
{
    return IsSetTid();
}

inline
void CPC_ResultType_Base::ResetTid(void)
{
    m_Tid = 0;
    m_set_State[0] &= ~0x3;
}

inline
CPC_ResultType_Base::TTid CPC_ResultType_Base::GetTid(void) const
{
    if (!CanGetTid()) {
        ThrowUnassigned(0);
    }
    return m_Tid;
}

inline
void CPC_ResultType_Base::SetTid(CPC_ResultType_Base::TTid value)
{
    m_Tid = value;
    m_set_State[0] |= 0x3;
}

inline
CPC_ResultType_Base::TTid& CPC_ResultType_Base::SetTid(void)
{
#ifdef _DEBUG
    if (!IsSetTid()) {
        memset(&m_Tid,UnassignedByte(),sizeof(m_Tid));
    }
#endif
    m_set_State[0] |= 0x1;
    return m_Tid;
}

inline
bool CPC_ResultType_Base::IsSetName(void) const
{
    return ((m_set_State[0] & 0xc) != 0);
}

inline
bool CPC_ResultType_Base::CanGetName(void) const
{
    return IsSetName();
}

inline
const CPC_ResultType_Base::TName& CPC_ResultType_Base::GetName(void) const
{
    if (!CanGetName()) {
        ThrowUnassigned(1);
    }
    return m_Name;
}

inline
void CPC_ResultType_Base::SetName(const CPC_ResultType_Base::TName& value)
{
    m_Name = value;
    m_set_State[0] |= 0xc;
}

inline
void CPC_ResultType_Base::SetName(CPC_ResultType_Base::TName&& value)
{
    m_Name = std::forward<CPC_ResultType_Base::TName>(value);
    m_set_State[0] |= 0xc;
}

inline
CPC_ResultType_Base::TName& CPC_ResultType_Base::SetName(void)
{
#ifdef _DEBUG
    if (!IsSetName()) {
        m_Name = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x4;
    return m_Name;
}

inline
bool CPC_ResultType_Base::IsSetDescription(void) const
{
    return ((m_set_State[0] & 0x30) != 0);
}

inline
bool CPC_ResultType_Base::CanGetDescription(void) const
{
    return true;
}

inline
const CPC_ResultType_Base::TDescription& CPC_ResultType_Base::GetDescription(void) const
{
    return m_Description;
}

inline
CPC_ResultType_Base::TDescription& CPC_ResultType_Base::SetDescription(void)
{
    m_set_State[0] |= 0x10;
    return m_Description;
}

inline
bool CPC_ResultType_Base::IsSetType(void) const
{
    return ((m_set_State[0] & 0xc0) != 0);
}

inline
bool CPC_ResultType_Base::CanGetType(void) const
{
    return IsSetType();
}

inline
void CPC_ResultType_Base::ResetType(void)
{
    m_Type = (EType)(0);
    m_set_State[0] &= ~0xc0;
}

inline
CPC_ResultType_Base::TType CPC_ResultType_Base::GetType(void) const
{
    if (!CanGetType()) {
        ThrowUnassigned(3);
    }
    return m_Type;
}

inline
void CPC_ResultType_Base::SetType(CPC_ResultType_Base::TType value)
{
    m_Type = value;
    m_set_State[0] |= 0xc0;
}

inline
CPC_ResultType_Base::TType& CPC_ResultType_Base::SetType(void)
{
#ifdef _DEBUG
    if (!IsSetType()) {
        memset(&m_Type,UnassignedByte(),sizeof(m_Type));
    }
#endif
    m_set_State[0] |= 0x40;
    return m_Type;
}

inline
bool CPC_ResultType_Base::IsSetConstraints(void) const
{
    return m_Constraints.NotEmpty();
}

inline
bool CPC_ResultType_Base::CanGetConstraints(void) const
{
    return IsSetConstraints();
}

inline
const CPC_ResultType_Base::TConstraints& CPC_ResultType_Base::GetConstraints(void) const
{
    if (!CanGetConstraints()) {
        ThrowUnassigned(4);
    }
    return (*m_Constraints);
}

inline
bool CPC_ResultType_Base::IsSetUnit(void) const
{
    return ((m_set_State[0] & 0xc00) != 0);
}

inline
bool CPC_ResultType_Base::CanGetUnit(void) const
{
    return IsSetUnit();
}

inline
void CPC_ResultType_Base::ResetUnit(void)
{
    m_Unit = (EUnit)(0);
    m_set_State[0] &= ~0xc00;
}

inline
CPC_ResultType_Base::TUnit CPC_ResultType_Base::GetUnit(void) const
{
    if (!CanGetUnit()) {
        ThrowUnassigned(5);
    }
    return m_Unit;
}

inline
void CPC_ResultType_Base::SetUnit(CPC_ResultType_Base::TUnit value)
{
    m_Unit = value;
    m_set_State[0] |= 0xc00;
}

inline
CPC_ResultType_Base::TUnit& CPC_ResultType_Base::SetUnit(void)
{
#ifdef _DEBUG
    if (!IsSetUnit()) {
        memset(&m_Unit,UnassignedByte(),sizeof(m_Unit));
    }
#endif
    m_set_State[0] |= 0x400;
    return m_Unit;
}

inline
bool CPC_ResultType_Base::IsSetSunit(void) const
{
    return ((m_set_State[0] & 0x3000) != 0);
}

inline
bool CPC_ResultType_Base::CanGetSunit(void) const
{
    return IsSetSunit();
}

inline
const CPC_ResultType_Base::TSunit& CPC_ResultType_Base::GetSunit(void) const
{
    if (!CanGetSunit()) {
        ThrowUnassigned(6);
    }
    return m_Sunit;
}

inline
void CPC_ResultType_Base::SetSunit(const CPC_ResultType_Base::TSunit& value)
{
    m_Sunit = value;
    m_set_State[0] |= 0x3000;
}

inline
void CPC_ResultType_Base::SetSunit(CPC_ResultType_Base::TSunit&& value)
{
    m_Sunit = std::forward<CPC_ResultType_Base::TSunit>(value);
    m_set_State[0] |= 0x3000;
}

inline
CPC_ResultType_Base::TSunit& CPC_ResultType_Base::SetSunit(void)
{
#ifdef _DEBUG
    if (!IsSetSunit()) {
        m_Sunit = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x1000;
    return m_Sunit;
}

inline
bool CPC_ResultType_Base::IsSetTransform(void) const
{
    return ((m_set_State[0] & 0xc000) != 0);
}

inline
bool CPC_ResultType_Base::CanGetTransform(void) const
{
    return IsSetTransform();
}

inline
void CPC_ResultType_Base::ResetTransform(void)
{
    m_Transform = (ETransform)(0);
    m_set_State[0] &= ~0xc000;
}

inline
CPC_ResultType_Base::TTransform CPC_ResultType_Base::GetTransform(void) const
{
    if (!CanGetTransform()) {
        ThrowUnassigned(7);
    }
    return m_Transform;
}

inline
void CPC_ResultType_Base::SetTransform(CPC_ResultType_Base::TTransform value)
{
    m_Transform = value;
    m_set_State[0] |= 0xc000;
}

inline
CPC_ResultType_Base::TTransform& CPC_ResultType_Base::SetTransform(void)
{
#ifdef _DEBUG
    if (!IsSetTransform()) {
        memset(&m_Transform,UnassignedByte(),sizeof(m_Transform));
    }
#endif
    m_set_State[0] |= 0x4000;
    return m_Transform;
}

inline
bool CPC_ResultType_Base::IsSetStransform(void) const
{
    return ((m_set_State[0] & 0x30000) != 0);
}

inline
bool CPC_ResultType_Base::CanGetStransform(void) const
{
    return IsSetStransform();
}

inline
const CPC_ResultType_Base::TStransform& CPC_ResultType_Base::GetStransform(void) const
{
    if (!CanGetStransform()) {
        ThrowUnassigned(8);
    }
    return m_Stransform;
}

inline
void CPC_ResultType_Base::SetStransform(const CPC_ResultType_Base::TStransform& value)
{
    m_Stransform = value;
    m_set_State[0] |= 0x30000;
}

inline
void CPC_ResultType_Base::SetStransform(CPC_ResultType_Base::TStransform&& value)
{
    m_Stransform = std::forward<CPC_ResultType_Base::TStransform>(value);
    m_set_State[0] |= 0x30000;
}

inline
CPC_ResultType_Base::TStransform& CPC_ResultType_Base::SetStransform(void)
{
#ifdef _DEBUG
    if (!IsSetStransform()) {
        m_Stransform = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x10000;
    return m_Stransform;
}

inline
bool CPC_ResultType_Base::IsSetTc(void) const
{
    return m_Tc.NotEmpty();
}

inline
bool CPC_ResultType_Base::CanGetTc(void) const
{
    return IsSetTc();
}

inline
const CPC_ResultType_Base::TTc& CPC_ResultType_Base::GetTc(void) const
{
    if (!CanGetTc()) {
        ThrowUnassigned(9);
    }
    return (*m_Tc);
}

inline
bool CPC_ResultType_Base::IsSetAc(void) const
{
    return ((m_set_State[0] & 0x300000) != 0);
}

inline
bool CPC_ResultType_Base::CanGetAc(void) const
{
    return IsSetAc();
}

inline
void CPC_ResultType_Base::ResetAc(void)
{
    m_Ac = 0;
    m_set_State[0] &= ~0x300000;
}

inline
CPC_ResultType_Base::TAc CPC_ResultType_Base::GetAc(void) const
{
    if (!CanGetAc()) {
        ThrowUnassigned(10);
    }
    return m_Ac;
}

inline
void CPC_ResultType_Base::SetAc(CPC_ResultType_Base::TAc value)
{
    m_Ac = value;
    m_set_State[0] |= 0x300000;
}

inline
CPC_ResultType_Base::TAc& CPC_ResultType_Base::SetAc(void)
{
#ifdef _DEBUG
    if (!IsSetAc()) {
        memset(&m_Ac,UnassignedByte(),sizeof(m_Ac));
    }
#endif
    m_set_State[0] |= 0x100000;
    return m_Ac;
}

inline
bool CPC_ResultType_Base::IsSetPanel_info(void) const
{
    return m_Panel_info.NotEmpty();
}

inline
bool CPC_ResultType_Base::CanGetPanel_info(void) const
{
    return IsSetPanel_info();
}

inline
const CPC_ResultType_Base::TPanel_info& CPC_ResultType_Base::GetPanel_info(void) const
{
    if (!CanGetPanel_info()) {
        ThrowUnassigned(11);
    }
    return (*m_Panel_info);
}

inline
bool CPC_ResultType_Base::IsSetAnnot(void) const
{
    return ((m_set_State[0] & 0x3000000) != 0);
}

inline
bool CPC_ResultType_Base::CanGetAnnot(void) const
{
    return IsSetAnnot();
}

inline
void CPC_ResultType_Base::ResetAnnot(void)
{
    m_Annot = (EAnnot)(0);
    m_set_State[0] &= ~0x3000000;
}

inline
CPC_ResultType_Base::TAnnot CPC_ResultType_Base::GetAnnot(void) const
{
    if (!CanGetAnnot()) {
        ThrowUnassigned(12);
    }
    return m_Annot;
}

inline
void CPC_ResultType_Base::SetAnnot(CPC_ResultType_Base::TAnnot value)
{
    m_Annot = value;
    m_set_State[0] |= 0x3000000;
}

inline
CPC_ResultType_Base::TAnnot& CPC_ResultType_Base::SetAnnot(void)
{
#ifdef _DEBUG
    if (!IsSetAnnot()) {
        memset(&m_Annot,UnassignedByte(),sizeof(m_Annot));
    }
#endif
    m_set_State[0] |= 0x1000000;
    return m_Annot;
}

///////////////////////////////////////////////////////////
////////////////// end of inline methods //////////////////
///////////////////////////////////////////////////////////





END_objects_SCOPE // namespace ncbi::objects::

END_NCBI_SCOPE


#endif // OBJECTS_PCASSAY_PC_RESULTTYPE_BASE_HPP
