/* $Id$
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 */

/// @file PC_AtomRadical_.hpp
/// Data storage class.
///
/// This file was generated by application DATATOOL
/// using the following specifications:
/// 'pcsubstance.asn'.
///
/// ATTENTION:
///   Don't edit or commit this file into CVS as this file will
///   be overridden (by DATATOOL) without warning!

#ifndef OBJECTS_PCSUBSTANCE_PC_ATOMRADICAL_BASE_HPP
#define OBJECTS_PCSUBSTANCE_PC_ATOMRADICAL_BASE_HPP

// standard includes
#include <serial/serialbase.hpp>
BEGIN_NCBI_SCOPE

#ifndef BEGIN_objects_SCOPE
#  define BEGIN_objects_SCOPE BEGIN_SCOPE(objects)
#  define END_objects_SCOPE END_SCOPE(objects)
#endif
BEGIN_objects_SCOPE // namespace ncbi::objects::


// generated classes

/////////////////////////////////////////////////////////////////////////////
/// Rudimentary Atom Electronic Configuration Designation
class NCBI_PCSUBSTANCE_EXPORT CPC_AtomRadical_Base : public CSerialObject
{
    typedef CSerialObject Tparent;
public:
    // constructor
    CPC_AtomRadical_Base(void);
    // destructor
    virtual ~CPC_AtomRadical_Base(void);

    // type info
    DECLARE_INTERNAL_TYPE_INFO();

    /// Type of Atom Radical
    enum EType {
        eType_singlet =   1,  ///< Open-Shell Singlet
        eType_doublet =   2,  ///< Open-Shell Doublet
        eType_triplet =   3,  ///< Open-Shell Triplet
        eType_quartet =   4,  ///< Open-Shell Quartet
        eType_quintet =   5,  ///< Open-Shell Quintet
        eType_hextet  =   6,  ///< Open-Shell Hextet
        eType_heptet  =   7,  ///< Open-Shell Quintet
        eType_octet   =   8,  ///< Open-Shell Octet
        eType_none    = 255  ///< Closed-Shell Singlet
    };
    
    /// Access to EType's attributes (values, names) as defined in spec
    static const NCBI_NS_NCBI::CEnumeratedTypeValues* ENUM_METHOD_NAME(EType)(void);
    
    // types
    typedef int TAid;
    typedef int TType;

    // member index
    enum class E_memberIndex {
        e__allMandatory = 0,
        e_aid,
        e_type
    };
    typedef Tparent::CMemberIndex<E_memberIndex, 3> TmemberIndex;

    // getters
    // setters

    /// Atom Identifier for the Value
    ///   Note: Atom ID's must be greater than "0"
    /// mandatory
    /// typedef int TAid
    ///  Check whether the Aid data member has been assigned a value.
    bool IsSetAid(void) const;
    /// Check whether it is safe or not to call GetAid method.
    bool CanGetAid(void) const;
    void ResetAid(void);
    TAid GetAid(void) const;
    void SetAid(TAid value);
    TAid& SetAid(void);

    /// mandatory
    /// typedef int TType
    ///  Check whether the Type data member has been assigned a value.
    bool IsSetType(void) const;
    /// Check whether it is safe or not to call GetType method.
    bool CanGetType(void) const;
    void ResetType(void);
    TType GetType(void) const;
    void SetType(TType value);
    TType& SetType(void);

    /// Reset the whole object
    virtual void Reset(void);


private:
    // Prohibit copy constructor and assignment operator
    CPC_AtomRadical_Base(const CPC_AtomRadical_Base&);
    CPC_AtomRadical_Base& operator=(const CPC_AtomRadical_Base&);

    // data
    Uint4 m_set_State[1];
    int m_Aid;
    int m_Type;
};






///////////////////////////////////////////////////////////
///////////////////// inline methods //////////////////////
///////////////////////////////////////////////////////////
inline
bool CPC_AtomRadical_Base::IsSetAid(void) const
{
    return ((m_set_State[0] & 0x3) != 0);
}

inline
bool CPC_AtomRadical_Base::CanGetAid(void) const
{
    return IsSetAid();
}

inline
void CPC_AtomRadical_Base::ResetAid(void)
{
    m_Aid = 0;
    m_set_State[0] &= ~0x3;
}

inline
CPC_AtomRadical_Base::TAid CPC_AtomRadical_Base::GetAid(void) const
{
    if (!CanGetAid()) {
        ThrowUnassigned(0);
    }
    return m_Aid;
}

inline
void CPC_AtomRadical_Base::SetAid(CPC_AtomRadical_Base::TAid value)
{
    m_Aid = value;
    m_set_State[0] |= 0x3;
}

inline
CPC_AtomRadical_Base::TAid& CPC_AtomRadical_Base::SetAid(void)
{
#ifdef _DEBUG
    if (!IsSetAid()) {
        memset(&m_Aid,UnassignedByte(),sizeof(m_Aid));
    }
#endif
    m_set_State[0] |= 0x1;
    return m_Aid;
}

inline
bool CPC_AtomRadical_Base::IsSetType(void) const
{
    return ((m_set_State[0] & 0xc) != 0);
}

inline
bool CPC_AtomRadical_Base::CanGetType(void) const
{
    return IsSetType();
}

inline
void CPC_AtomRadical_Base::ResetType(void)
{
    m_Type = (EType)(0);
    m_set_State[0] &= ~0xc;
}

inline
CPC_AtomRadical_Base::TType CPC_AtomRadical_Base::GetType(void) const
{
    if (!CanGetType()) {
        ThrowUnassigned(1);
    }
    return m_Type;
}

inline
void CPC_AtomRadical_Base::SetType(CPC_AtomRadical_Base::TType value)
{
    m_Type = value;
    m_set_State[0] |= 0xc;
}

inline
CPC_AtomRadical_Base::TType& CPC_AtomRadical_Base::SetType(void)
{
#ifdef _DEBUG
    if (!IsSetType()) {
        memset(&m_Type,UnassignedByte(),sizeof(m_Type));
    }
#endif
    m_set_State[0] |= 0x4;
    return m_Type;
}

///////////////////////////////////////////////////////////
////////////////// end of inline methods //////////////////
///////////////////////////////////////////////////////////





END_objects_SCOPE // namespace ncbi::objects::

END_NCBI_SCOPE


#endif // OBJECTS_PCSUBSTANCE_PC_ATOMRADICAL_BASE_HPP
