/* $Id$
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 */

/// @file PC_BondAnnotation_.hpp
/// Data storage class.
///
/// This file was generated by application DATATOOL
/// using the following specifications:
/// 'pcsubstance.asn'.
///
/// ATTENTION:
///   Don't edit or commit this file into CVS as this file will
///   be overridden (by DATATOOL) without warning!

#ifndef OBJECTS_PCSUBSTANCE_PC_BONDANNOTATION_BASE_HPP
#define OBJECTS_PCSUBSTANCE_PC_BONDANNOTATION_BASE_HPP

// standard includes
#include <serial/serialbase.hpp>
BEGIN_NCBI_SCOPE

#ifndef BEGIN_objects_SCOPE
#  define BEGIN_objects_SCOPE BEGIN_SCOPE(objects)
#  define END_objects_SCOPE END_SCOPE(objects)
#endif
BEGIN_objects_SCOPE // namespace ncbi::objects::


// generated classes

/// Atom-Atom Annotation Information
enum EPC_BondAnnotation {
    ePC_BondAnnotation_crossed      =   1,  ///< Double Bond that can be both Cis/Trans
    ePC_BondAnnotation_dashed       =   2,  ///< Hydrogen-Bond (3D Only?)
    ePC_BondAnnotation_wavy         =   3,  ///< Unknown Stereochemistry
    ePC_BondAnnotation_dotted       =   4,  ///< Complex/Fractional
    ePC_BondAnnotation_wedge_up     =   5,  ///< Above-Plane
    ePC_BondAnnotation_wedge_down   =   6,  ///< Below-Plane
    ePC_BondAnnotation_arrow        =   7,  ///< Dative
    ePC_BondAnnotation_aromatic     =   8,  ///< Aromatic
    ePC_BondAnnotation_resonance    =   9,  ///< Resonance
    ePC_BondAnnotation_bold         =  10,  ///< Fat Bond (Non-Specific User Interpreted Information)
    ePC_BondAnnotation_fischer      =  11,  ///< Interpret Bond Stereo using Fischer Conventions
    ePC_BondAnnotation_closeContact =  12,  ///< Identification of Atom-Atom Close Contacts (3D Only)
    ePC_BondAnnotation_unknown      = 255  ///< Unspecified or Unknown Atom-Atom Annotation
};

/// Access to EPC_BondAnnotation's attributes (values, names) as defined in spec
NCBI_PCSUBSTANCE_EXPORT const NCBI_NS_NCBI::CEnumeratedTypeValues* ENUM_METHOD_NAME(EPC_BondAnnotation)(void);


END_objects_SCOPE // namespace ncbi::objects::

END_NCBI_SCOPE


#endif // OBJECTS_PCSUBSTANCE_PC_BONDANNOTATION_BASE_HPP
