/* $Id$
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 */

/// @file PC_StereoPlanar_.hpp
/// Data storage class.
///
/// This file was generated by application DATATOOL
/// using the following specifications:
/// 'pcsubstance.asn'.
///
/// ATTENTION:
///   Don't edit or commit this file into CVS as this file will
///   be overridden (by DATATOOL) without warning!

#ifndef OBJECTS_PCSUBSTANCE_PC_STEREOPLANAR_BASE_HPP
#define OBJECTS_PCSUBSTANCE_PC_STEREOPLANAR_BASE_HPP

// standard includes
#include <serial/serialbase.hpp>
BEGIN_NCBI_SCOPE

#ifndef BEGIN_objects_SCOPE
#  define BEGIN_objects_SCOPE BEGIN_SCOPE(objects)
#  define END_objects_SCOPE END_SCOPE(objects)
#endif
BEGIN_objects_SCOPE // namespace ncbi::objects::


// generated classes

/////////////////////////////////////////////////////////////////////////////
/// SP2 Planar Stereogenic Center, Cumulenic StereoCenter (Linear systems on an odd
///   number of double bonds present planar stereochemistry)
///   [Using IUPAC Stereogenic Center recommendations and terminology]
///   [Note: "-1" can be used for the Atom Identifier to represent a lone-pair or implicit hydrogen]
class NCBI_PCSUBSTANCE_EXPORT CPC_StereoPlanar_Base : public CSerialObject
{
    typedef CSerialObject Tparent;
public:
    // constructor
    CPC_StereoPlanar_Base(void);
    // destructor
    virtual ~CPC_StereoPlanar_Base(void);

    // type info
    DECLARE_INTERNAL_TYPE_INFO();

    /// StereoCenter Designation
    enum EParity {
        eParity_same     =   1,
        eParity_opposite =   2,
        eParity_any      =   3,
        eParity_unknown  = 255
    };
    
    /// Access to EParity's attributes (values, names) as defined in spec
    static const NCBI_NS_NCBI::CEnumeratedTypeValues* ENUM_METHOD_NAME(EParity)(void);
    
    /// Type of StereoCenter, SP2 Planar, if not specified
    enum EType {
        eType_planar    = 1,  ///< SP2 Planar StereoCenter
        eType_cumulenic = 2  ///< Cumulenic StereoCenter
    };
    
    /// Access to EType's attributes (values, names) as defined in spec
    static const NCBI_NS_NCBI::CEnumeratedTypeValues* ENUM_METHOD_NAME(EType)(void);
    
    // types
    typedef int TLeft;
    typedef int TLtop;
    typedef int TLbottom;
    typedef int TRight;
    typedef int TRtop;
    typedef int TRbottom;
    typedef int TParity;
    typedef int TType;

    // member index
    enum class E_memberIndex {
        e__allMandatory = 0,
        e_left,
        e_ltop,
        e_lbottom,
        e_right,
        e_rtop,
        e_rbottom,
        e_parity,
        e_type
    };
    typedef Tparent::CMemberIndex<E_memberIndex, 9> TmemberIndex;

    // getters
    // setters

    /// Atom ID of Left Double Bond Atom
    ///   Note: Atom ID's must be greater than "0"
    /// mandatory
    /// typedef int TLeft
    ///  Check whether the Left data member has been assigned a value.
    bool IsSetLeft(void) const;
    /// Check whether it is safe or not to call GetLeft method.
    bool CanGetLeft(void) const;
    void ResetLeft(void);
    TLeft GetLeft(void) const;
    void SetLeft(TLeft value);
    TLeft& SetLeft(void);

    /// Atom ID of Top Atom attached to the Left Double Bond Atom
    ///   Note: Atom ID's must be greater than "0"
    /// mandatory
    /// typedef int TLtop
    ///  Check whether the Ltop data member has been assigned a value.
    bool IsSetLtop(void) const;
    /// Check whether it is safe or not to call GetLtop method.
    bool CanGetLtop(void) const;
    void ResetLtop(void);
    TLtop GetLtop(void) const;
    void SetLtop(TLtop value);
    TLtop& SetLtop(void);

    /// Atom ID of Bottom Atom attached to the Left Double Bond Atom
    ///   Note: Atom ID's must be greater than "0"
    /// mandatory
    /// typedef int TLbottom
    ///  Check whether the Lbottom data member has been assigned a value.
    bool IsSetLbottom(void) const;
    /// Check whether it is safe or not to call GetLbottom method.
    bool CanGetLbottom(void) const;
    void ResetLbottom(void);
    TLbottom GetLbottom(void) const;
    void SetLbottom(TLbottom value);
    TLbottom& SetLbottom(void);

    /// Atom ID of Right Double Bond Atom
    ///   Note: Atom ID's must be greater than "0"
    /// mandatory
    /// typedef int TRight
    ///  Check whether the Right data member has been assigned a value.
    bool IsSetRight(void) const;
    /// Check whether it is safe or not to call GetRight method.
    bool CanGetRight(void) const;
    void ResetRight(void);
    TRight GetRight(void) const;
    void SetRight(TRight value);
    TRight& SetRight(void);

    /// Atom ID of Top Atom attached to the Right Double Bond Atom
    ///   Note: Atom ID's must be greater than "0"
    /// mandatory
    /// typedef int TRtop
    ///  Check whether the Rtop data member has been assigned a value.
    bool IsSetRtop(void) const;
    /// Check whether it is safe or not to call GetRtop method.
    bool CanGetRtop(void) const;
    void ResetRtop(void);
    TRtop GetRtop(void) const;
    void SetRtop(TRtop value);
    TRtop& SetRtop(void);

    /// Atom ID of Bottom Atom attached to the Right Double Bond Atom
    ///   Note: Atom ID's must be greater than "0"
    /// mandatory
    /// typedef int TRbottom
    ///  Check whether the Rbottom data member has been assigned a value.
    bool IsSetRbottom(void) const;
    /// Check whether it is safe or not to call GetRbottom method.
    bool CanGetRbottom(void) const;
    void ResetRbottom(void);
    TRbottom GetRbottom(void) const;
    void SetRbottom(TRbottom value);
    TRbottom& SetRbottom(void);

    /// optional
    /// typedef int TParity
    ///  Check whether the Parity data member has been assigned a value.
    bool IsSetParity(void) const;
    /// Check whether it is safe or not to call GetParity method.
    bool CanGetParity(void) const;
    void ResetParity(void);
    TParity GetParity(void) const;
    void SetParity(TParity value);
    TParity& SetParity(void);

    /// optional
    /// typedef int TType
    ///  Check whether the Type data member has been assigned a value.
    bool IsSetType(void) const;
    /// Check whether it is safe or not to call GetType method.
    bool CanGetType(void) const;
    void ResetType(void);
    TType GetType(void) const;
    void SetType(TType value);
    TType& SetType(void);

    /// Reset the whole object
    virtual void Reset(void);


private:
    // Prohibit copy constructor and assignment operator
    CPC_StereoPlanar_Base(const CPC_StereoPlanar_Base&);
    CPC_StereoPlanar_Base& operator=(const CPC_StereoPlanar_Base&);

    // data
    Uint4 m_set_State[1];
    int m_Left;
    int m_Ltop;
    int m_Lbottom;
    int m_Right;
    int m_Rtop;
    int m_Rbottom;
    int m_Parity;
    int m_Type;
};






///////////////////////////////////////////////////////////
///////////////////// inline methods //////////////////////
///////////////////////////////////////////////////////////
inline
bool CPC_StereoPlanar_Base::IsSetLeft(void) const
{
    return ((m_set_State[0] & 0x3) != 0);
}

inline
bool CPC_StereoPlanar_Base::CanGetLeft(void) const
{
    return IsSetLeft();
}

inline
void CPC_StereoPlanar_Base::ResetLeft(void)
{
    m_Left = 0;
    m_set_State[0] &= ~0x3;
}

inline
CPC_StereoPlanar_Base::TLeft CPC_StereoPlanar_Base::GetLeft(void) const
{
    if (!CanGetLeft()) {
        ThrowUnassigned(0);
    }
    return m_Left;
}

inline
void CPC_StereoPlanar_Base::SetLeft(CPC_StereoPlanar_Base::TLeft value)
{
    m_Left = value;
    m_set_State[0] |= 0x3;
}

inline
CPC_StereoPlanar_Base::TLeft& CPC_StereoPlanar_Base::SetLeft(void)
{
#ifdef _DEBUG
    if (!IsSetLeft()) {
        memset(&m_Left,UnassignedByte(),sizeof(m_Left));
    }
#endif
    m_set_State[0] |= 0x1;
    return m_Left;
}

inline
bool CPC_StereoPlanar_Base::IsSetLtop(void) const
{
    return ((m_set_State[0] & 0xc) != 0);
}

inline
bool CPC_StereoPlanar_Base::CanGetLtop(void) const
{
    return IsSetLtop();
}

inline
void CPC_StereoPlanar_Base::ResetLtop(void)
{
    m_Ltop = 0;
    m_set_State[0] &= ~0xc;
}

inline
CPC_StereoPlanar_Base::TLtop CPC_StereoPlanar_Base::GetLtop(void) const
{
    if (!CanGetLtop()) {
        ThrowUnassigned(1);
    }
    return m_Ltop;
}

inline
void CPC_StereoPlanar_Base::SetLtop(CPC_StereoPlanar_Base::TLtop value)
{
    m_Ltop = value;
    m_set_State[0] |= 0xc;
}

inline
CPC_StereoPlanar_Base::TLtop& CPC_StereoPlanar_Base::SetLtop(void)
{
#ifdef _DEBUG
    if (!IsSetLtop()) {
        memset(&m_Ltop,UnassignedByte(),sizeof(m_Ltop));
    }
#endif
    m_set_State[0] |= 0x4;
    return m_Ltop;
}

inline
bool CPC_StereoPlanar_Base::IsSetLbottom(void) const
{
    return ((m_set_State[0] & 0x30) != 0);
}

inline
bool CPC_StereoPlanar_Base::CanGetLbottom(void) const
{
    return IsSetLbottom();
}

inline
void CPC_StereoPlanar_Base::ResetLbottom(void)
{
    m_Lbottom = 0;
    m_set_State[0] &= ~0x30;
}

inline
CPC_StereoPlanar_Base::TLbottom CPC_StereoPlanar_Base::GetLbottom(void) const
{
    if (!CanGetLbottom()) {
        ThrowUnassigned(2);
    }
    return m_Lbottom;
}

inline
void CPC_StereoPlanar_Base::SetLbottom(CPC_StereoPlanar_Base::TLbottom value)
{
    m_Lbottom = value;
    m_set_State[0] |= 0x30;
}

inline
CPC_StereoPlanar_Base::TLbottom& CPC_StereoPlanar_Base::SetLbottom(void)
{
#ifdef _DEBUG
    if (!IsSetLbottom()) {
        memset(&m_Lbottom,UnassignedByte(),sizeof(m_Lbottom));
    }
#endif
    m_set_State[0] |= 0x10;
    return m_Lbottom;
}

inline
bool CPC_StereoPlanar_Base::IsSetRight(void) const
{
    return ((m_set_State[0] & 0xc0) != 0);
}

inline
bool CPC_StereoPlanar_Base::CanGetRight(void) const
{
    return IsSetRight();
}

inline
void CPC_StereoPlanar_Base::ResetRight(void)
{
    m_Right = 0;
    m_set_State[0] &= ~0xc0;
}

inline
CPC_StereoPlanar_Base::TRight CPC_StereoPlanar_Base::GetRight(void) const
{
    if (!CanGetRight()) {
        ThrowUnassigned(3);
    }
    return m_Right;
}

inline
void CPC_StereoPlanar_Base::SetRight(CPC_StereoPlanar_Base::TRight value)
{
    m_Right = value;
    m_set_State[0] |= 0xc0;
}

inline
CPC_StereoPlanar_Base::TRight& CPC_StereoPlanar_Base::SetRight(void)
{
#ifdef _DEBUG
    if (!IsSetRight()) {
        memset(&m_Right,UnassignedByte(),sizeof(m_Right));
    }
#endif
    m_set_State[0] |= 0x40;
    return m_Right;
}

inline
bool CPC_StereoPlanar_Base::IsSetRtop(void) const
{
    return ((m_set_State[0] & 0x300) != 0);
}

inline
bool CPC_StereoPlanar_Base::CanGetRtop(void) const
{
    return IsSetRtop();
}

inline
void CPC_StereoPlanar_Base::ResetRtop(void)
{
    m_Rtop = 0;
    m_set_State[0] &= ~0x300;
}

inline
CPC_StereoPlanar_Base::TRtop CPC_StereoPlanar_Base::GetRtop(void) const
{
    if (!CanGetRtop()) {
        ThrowUnassigned(4);
    }
    return m_Rtop;
}

inline
void CPC_StereoPlanar_Base::SetRtop(CPC_StereoPlanar_Base::TRtop value)
{
    m_Rtop = value;
    m_set_State[0] |= 0x300;
}

inline
CPC_StereoPlanar_Base::TRtop& CPC_StereoPlanar_Base::SetRtop(void)
{
#ifdef _DEBUG
    if (!IsSetRtop()) {
        memset(&m_Rtop,UnassignedByte(),sizeof(m_Rtop));
    }
#endif
    m_set_State[0] |= 0x100;
    return m_Rtop;
}

inline
bool CPC_StereoPlanar_Base::IsSetRbottom(void) const
{
    return ((m_set_State[0] & 0xc00) != 0);
}

inline
bool CPC_StereoPlanar_Base::CanGetRbottom(void) const
{
    return IsSetRbottom();
}

inline
void CPC_StereoPlanar_Base::ResetRbottom(void)
{
    m_Rbottom = 0;
    m_set_State[0] &= ~0xc00;
}

inline
CPC_StereoPlanar_Base::TRbottom CPC_StereoPlanar_Base::GetRbottom(void) const
{
    if (!CanGetRbottom()) {
        ThrowUnassigned(5);
    }
    return m_Rbottom;
}

inline
void CPC_StereoPlanar_Base::SetRbottom(CPC_StereoPlanar_Base::TRbottom value)
{
    m_Rbottom = value;
    m_set_State[0] |= 0xc00;
}

inline
CPC_StereoPlanar_Base::TRbottom& CPC_StereoPlanar_Base::SetRbottom(void)
{
#ifdef _DEBUG
    if (!IsSetRbottom()) {
        memset(&m_Rbottom,UnassignedByte(),sizeof(m_Rbottom));
    }
#endif
    m_set_State[0] |= 0x400;
    return m_Rbottom;
}

inline
bool CPC_StereoPlanar_Base::IsSetParity(void) const
{
    return ((m_set_State[0] & 0x3000) != 0);
}

inline
bool CPC_StereoPlanar_Base::CanGetParity(void) const
{
    return IsSetParity();
}

inline
void CPC_StereoPlanar_Base::ResetParity(void)
{
    m_Parity = (EParity)(0);
    m_set_State[0] &= ~0x3000;
}

inline
CPC_StereoPlanar_Base::TParity CPC_StereoPlanar_Base::GetParity(void) const
{
    if (!CanGetParity()) {
        ThrowUnassigned(6);
    }
    return m_Parity;
}

inline
void CPC_StereoPlanar_Base::SetParity(CPC_StereoPlanar_Base::TParity value)
{
    m_Parity = value;
    m_set_State[0] |= 0x3000;
}

inline
CPC_StereoPlanar_Base::TParity& CPC_StereoPlanar_Base::SetParity(void)
{
#ifdef _DEBUG
    if (!IsSetParity()) {
        memset(&m_Parity,UnassignedByte(),sizeof(m_Parity));
    }
#endif
    m_set_State[0] |= 0x1000;
    return m_Parity;
}

inline
bool CPC_StereoPlanar_Base::IsSetType(void) const
{
    return ((m_set_State[0] & 0xc000) != 0);
}

inline
bool CPC_StereoPlanar_Base::CanGetType(void) const
{
    return IsSetType();
}

inline
void CPC_StereoPlanar_Base::ResetType(void)
{
    m_Type = (EType)(0);
    m_set_State[0] &= ~0xc000;
}

inline
CPC_StereoPlanar_Base::TType CPC_StereoPlanar_Base::GetType(void) const
{
    if (!CanGetType()) {
        ThrowUnassigned(7);
    }
    return m_Type;
}

inline
void CPC_StereoPlanar_Base::SetType(CPC_StereoPlanar_Base::TType value)
{
    m_Type = value;
    m_set_State[0] |= 0xc000;
}

inline
CPC_StereoPlanar_Base::TType& CPC_StereoPlanar_Base::SetType(void)
{
#ifdef _DEBUG
    if (!IsSetType()) {
        memset(&m_Type,UnassignedByte(),sizeof(m_Type));
    }
#endif
    m_set_State[0] |= 0x4000;
    return m_Type;
}

///////////////////////////////////////////////////////////
////////////////// end of inline methods //////////////////
///////////////////////////////////////////////////////////





END_objects_SCOPE // namespace ncbi::objects::

END_NCBI_SCOPE


#endif // OBJECTS_PCSUBSTANCE_PC_STEREOPLANAR_BASE_HPP
