/* $Id$
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 */

/// @file FormatRpsDbParameters_.hpp
/// Data storage class.
///
/// This file was generated by application DATATOOL
/// using the following specifications:
/// 'scoremat.asn'.
///
/// ATTENTION:
///   Don't edit or commit this file into CVS as this file will
///   be overridden (by DATATOOL) without warning!

#ifndef OBJECTS_SCOREMAT_FORMATRPSDBPARAMETERS_BASE_HPP
#define OBJECTS_SCOREMAT_FORMATRPSDBPARAMETERS_BASE_HPP

// standard includes
#include <serial/serialbase.hpp>

// generated includes
#include <string>

BEGIN_NCBI_SCOPE

#ifndef BEGIN_objects_SCOPE
#  define BEGIN_objects_SCOPE BEGIN_SCOPE(objects)
#  define END_objects_SCOPE END_SCOPE(objects)
#endif
BEGIN_objects_SCOPE // namespace ncbi::objects::


// generated classes

/////////////////////////////////////////////////////////////////////////////
/// This structure is used to create the RPS-BLAST database auxiliary file 
/// (*.aux) and it contains parameters set at creation time of the PSSM.
/// Also, the matrixName field is used by formatrpsdb to build a PSSM from 
/// a Pssm structure which only contains PssmIntermediateData.
class NCBI_SCOREMAT_EXPORT CFormatRpsDbParameters_Base : public CSerialObject
{
    typedef CSerialObject Tparent;
public:
    // constructor
    CFormatRpsDbParameters_Base(void);
    // destructor
    virtual ~CFormatRpsDbParameters_Base(void);

    // type info
    DECLARE_INTERNAL_TYPE_INFO();

    // types
    typedef string TMatrixName;
    typedef int TGapOpen;
    typedef int TGapExtend;

    // member index
    enum class E_memberIndex {
        e__allMandatory = 0,
        e_matrixName,
        e_gapOpen,
        e_gapExtend
    };
    typedef Tparent::CMemberIndex<E_memberIndex, 4> TmemberIndex;

    // getters
    // setters

    /// name of the underlying score matrix whose frequency ratios were
    /// used in PSSM construction (e.g.: BLOSUM62)
    /// mandatory
    /// typedef string TMatrixName
    ///  Check whether the MatrixName data member has been assigned a value.
    bool IsSetMatrixName(void) const;
    /// Check whether it is safe or not to call GetMatrixName method.
    bool CanGetMatrixName(void) const;
    void ResetMatrixName(void);
    const TMatrixName& GetMatrixName(void) const;
    void SetMatrixName(const TMatrixName& value);
    void SetMatrixName(TMatrixName&& value);
    TMatrixName& SetMatrixName(void);

    /// gap opening penalty corresponding to the matrix above
    /// optional
    /// typedef int TGapOpen
    ///  Check whether the GapOpen data member has been assigned a value.
    bool IsSetGapOpen(void) const;
    /// Check whether it is safe or not to call GetGapOpen method.
    bool CanGetGapOpen(void) const;
    void ResetGapOpen(void);
    TGapOpen GetGapOpen(void) const;
    void SetGapOpen(TGapOpen value);
    TGapOpen& SetGapOpen(void);

    /// gap extension penalty corresponding to the matrix above
    /// optional
    /// typedef int TGapExtend
    ///  Check whether the GapExtend data member has been assigned a value.
    bool IsSetGapExtend(void) const;
    /// Check whether it is safe or not to call GetGapExtend method.
    bool CanGetGapExtend(void) const;
    void ResetGapExtend(void);
    TGapExtend GetGapExtend(void) const;
    void SetGapExtend(TGapExtend value);
    TGapExtend& SetGapExtend(void);

    /// Reset the whole object
    virtual void Reset(void);


private:
    // Prohibit copy constructor and assignment operator
    CFormatRpsDbParameters_Base(const CFormatRpsDbParameters_Base&);
    CFormatRpsDbParameters_Base& operator=(const CFormatRpsDbParameters_Base&);

    // data
    Uint4 m_set_State[1];
    string m_MatrixName;
    int m_GapOpen;
    int m_GapExtend;
};






///////////////////////////////////////////////////////////
///////////////////// inline methods //////////////////////
///////////////////////////////////////////////////////////
inline
bool CFormatRpsDbParameters_Base::IsSetMatrixName(void) const
{
    return ((m_set_State[0] & 0x3) != 0);
}

inline
bool CFormatRpsDbParameters_Base::CanGetMatrixName(void) const
{
    return IsSetMatrixName();
}

inline
const CFormatRpsDbParameters_Base::TMatrixName& CFormatRpsDbParameters_Base::GetMatrixName(void) const
{
    if (!CanGetMatrixName()) {
        ThrowUnassigned(0);
    }
    return m_MatrixName;
}

inline
void CFormatRpsDbParameters_Base::SetMatrixName(const CFormatRpsDbParameters_Base::TMatrixName& value)
{
    m_MatrixName = value;
    m_set_State[0] |= 0x3;
}

inline
void CFormatRpsDbParameters_Base::SetMatrixName(CFormatRpsDbParameters_Base::TMatrixName&& value)
{
    m_MatrixName = std::forward<CFormatRpsDbParameters_Base::TMatrixName>(value);
    m_set_State[0] |= 0x3;
}

inline
CFormatRpsDbParameters_Base::TMatrixName& CFormatRpsDbParameters_Base::SetMatrixName(void)
{
#ifdef _DEBUG
    if (!IsSetMatrixName()) {
        m_MatrixName = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x1;
    return m_MatrixName;
}

inline
bool CFormatRpsDbParameters_Base::IsSetGapOpen(void) const
{
    return ((m_set_State[0] & 0xc) != 0);
}

inline
bool CFormatRpsDbParameters_Base::CanGetGapOpen(void) const
{
    return IsSetGapOpen();
}

inline
void CFormatRpsDbParameters_Base::ResetGapOpen(void)
{
    m_GapOpen = 0;
    m_set_State[0] &= ~0xc;
}

inline
CFormatRpsDbParameters_Base::TGapOpen CFormatRpsDbParameters_Base::GetGapOpen(void) const
{
    if (!CanGetGapOpen()) {
        ThrowUnassigned(1);
    }
    return m_GapOpen;
}

inline
void CFormatRpsDbParameters_Base::SetGapOpen(CFormatRpsDbParameters_Base::TGapOpen value)
{
    m_GapOpen = value;
    m_set_State[0] |= 0xc;
}

inline
CFormatRpsDbParameters_Base::TGapOpen& CFormatRpsDbParameters_Base::SetGapOpen(void)
{
#ifdef _DEBUG
    if (!IsSetGapOpen()) {
        memset(&m_GapOpen,UnassignedByte(),sizeof(m_GapOpen));
    }
#endif
    m_set_State[0] |= 0x4;
    return m_GapOpen;
}

inline
bool CFormatRpsDbParameters_Base::IsSetGapExtend(void) const
{
    return ((m_set_State[0] & 0x30) != 0);
}

inline
bool CFormatRpsDbParameters_Base::CanGetGapExtend(void) const
{
    return IsSetGapExtend();
}

inline
void CFormatRpsDbParameters_Base::ResetGapExtend(void)
{
    m_GapExtend = 0;
    m_set_State[0] &= ~0x30;
}

inline
CFormatRpsDbParameters_Base::TGapExtend CFormatRpsDbParameters_Base::GetGapExtend(void) const
{
    if (!CanGetGapExtend()) {
        ThrowUnassigned(2);
    }
    return m_GapExtend;
}

inline
void CFormatRpsDbParameters_Base::SetGapExtend(CFormatRpsDbParameters_Base::TGapExtend value)
{
    m_GapExtend = value;
    m_set_State[0] |= 0x30;
}

inline
CFormatRpsDbParameters_Base::TGapExtend& CFormatRpsDbParameters_Base::SetGapExtend(void)
{
#ifdef _DEBUG
    if (!IsSetGapExtend()) {
        memset(&m_GapExtend,UnassignedByte(),sizeof(m_GapExtend));
    }
#endif
    m_set_State[0] |= 0x10;
    return m_GapExtend;
}

///////////////////////////////////////////////////////////
////////////////// end of inline methods //////////////////
///////////////////////////////////////////////////////////





END_objects_SCOPE // namespace ncbi::objects::

END_NCBI_SCOPE


#endif // OBJECTS_SCOREMAT_FORMATRPSDBPARAMETERS_BASE_HPP
