/* $Id$
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 */

/// @file Num_ref_.hpp
/// Data storage class.
///
/// This file was generated by application DATATOOL
/// using the following specifications:
/// 'seq.asn'.
///
/// ATTENTION:
///   Don't edit or commit this file into CVS as this file will
///   be overridden (by DATATOOL) without warning!

#ifndef OBJECTS_SEQ_NUM_REF_BASE_HPP
#define OBJECTS_SEQ_NUM_REF_BASE_HPP

// standard includes
#include <serial/serialbase.hpp>
BEGIN_NCBI_SCOPE

#ifndef BEGIN_objects_SCOPE
#  define BEGIN_objects_SCOPE BEGIN_SCOPE(objects)
#  define END_objects_SCOPE END_SCOPE(objects)
#endif
BEGIN_objects_SCOPE // namespace ncbi::objects::


// forward declarations
class CSeq_align;


// generated classes

/////////////////////////////////////////////////////////////////////////////
/// by reference to other sequences
class NCBI_SEQ_EXPORT CNum_ref_Base : public CSerialObject
{
    typedef CSerialObject Tparent;
public:
    // constructor
    CNum_ref_Base(void);
    // destructor
    virtual ~CNum_ref_Base(void);

    // type info
    DECLARE_INTERNAL_TYPE_INFO();

    /// type of reference
    enum EType {
        eType_not_set = 0,
        eType_sources = 1,  ///< by segmented or const seq sources
        eType_aligns  = 2  ///< by alignments given below
    };
    
    /// Access to EType's attributes (values, names) as defined in spec
    static const NCBI_NS_NCBI::CEnumeratedTypeValues* ENUM_METHOD_NAME(EType)(void);
    
    // types
    typedef EType TType;
    typedef CSeq_align TAligns;

    // member index
    enum class E_memberIndex {
        e__allMandatory = 0,
        e_type,
        e_aligns
    };
    typedef Tparent::CMemberIndex<E_memberIndex, 3> TmemberIndex;

    // getters
    // setters

    /// mandatory
    /// typedef EType TType
    ///  Check whether the Type data member has been assigned a value.
    bool IsSetType(void) const;
    /// Check whether it is safe or not to call GetType method.
    bool CanGetType(void) const;
    void ResetType(void);
    TType GetType(void) const;
    void SetType(TType value);
    TType& SetType(void);

    /// optional
    /// typedef CSeq_align TAligns
    ///  Check whether the Aligns data member has been assigned a value.
    bool IsSetAligns(void) const;
    /// Check whether it is safe or not to call GetAligns method.
    bool CanGetAligns(void) const;
    void ResetAligns(void);
    const TAligns& GetAligns(void) const;
    void SetAligns(TAligns& value);
    TAligns& SetAligns(void);

    /// Reset the whole object
    virtual void Reset(void);


private:
    // Prohibit copy constructor and assignment operator
    CNum_ref_Base(const CNum_ref_Base&);
    CNum_ref_Base& operator=(const CNum_ref_Base&);

    // data
    Uint4 m_set_State[1];
    EType m_Type;
    CRef< TAligns > m_Aligns;
};






///////////////////////////////////////////////////////////
///////////////////// inline methods //////////////////////
///////////////////////////////////////////////////////////
inline
bool CNum_ref_Base::IsSetType(void) const
{
    return ((m_set_State[0] & 0x3) != 0);
}

inline
bool CNum_ref_Base::CanGetType(void) const
{
    return IsSetType();
}

inline
void CNum_ref_Base::ResetType(void)
{
    m_Type = (EType)(0);
    m_set_State[0] &= ~0x3;
}

inline
CNum_ref_Base::TType CNum_ref_Base::GetType(void) const
{
    if (!CanGetType()) {
        ThrowUnassigned(0);
    }
    return m_Type;
}

inline
void CNum_ref_Base::SetType(CNum_ref_Base::TType value)
{
    m_Type = value;
    m_set_State[0] |= 0x3;
}

inline
CNum_ref_Base::TType& CNum_ref_Base::SetType(void)
{
#ifdef _DEBUG
    if (!IsSetType()) {
        memset(&m_Type,UnassignedByte(),sizeof(m_Type));
    }
#endif
    m_set_State[0] |= 0x1;
    return m_Type;
}

inline
bool CNum_ref_Base::IsSetAligns(void) const
{
    return m_Aligns.NotEmpty();
}

inline
bool CNum_ref_Base::CanGetAligns(void) const
{
    return IsSetAligns();
}

inline
const CNum_ref_Base::TAligns& CNum_ref_Base::GetAligns(void) const
{
    if (!CanGetAligns()) {
        ThrowUnassigned(1);
    }
    return (*m_Aligns);
}

///////////////////////////////////////////////////////////
////////////////// end of inline methods //////////////////
///////////////////////////////////////////////////////////





END_objects_SCOPE // namespace ncbi::objects::

END_NCBI_SCOPE


#endif // OBJECTS_SEQ_NUM_REF_BASE_HPP
