/* $Id$
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 */

/// @file Seq_align_.hpp
/// Data storage class.
///
/// This file was generated by application DATATOOL
/// using the following specifications:
/// 'seqalign.asn'.
///
/// ATTENTION:
///   Don't edit or commit this file into CVS as this file will
///   be overridden (by DATATOOL) without warning!

#ifndef OBJECTS_SEQALIGN_SEQ_ALIGN_BASE_HPP
#define OBJECTS_SEQALIGN_SEQ_ALIGN_BASE_HPP

// standard includes
#include <serial/serialbase.hpp>

// generated includes
#include <list>
#include <vector>

BEGIN_NCBI_SCOPE

#ifndef BEGIN_objects_SCOPE
#  define BEGIN_objects_SCOPE BEGIN_SCOPE(objects)
#  define END_objects_SCOPE END_SCOPE(objects)
#endif
BEGIN_objects_SCOPE // namespace ncbi::objects::


// forward declarations
class CDense_diag;
class CDense_seg;
class CObject_id;
class CPacked_seg;
class CScore;
class CSeq_align_set;
class CSeq_loc;
class CSparse_seg;
class CSpliced_seg;
class CStd_seg;
class CUser_object;


// generated classes

/////////////////////////////////////////////////////////////////////////////
class NCBI_SEQALIGN_EXPORT CSeq_align_Base : public CSerialObject
{
    typedef CSerialObject Tparent;
public:
    // constructor
    CSeq_align_Base(void);
    // destructor
    virtual ~CSeq_align_Base(void);

    // type info
    DECLARE_INTERNAL_TYPE_INFO();

    enum EType {
        eType_not_set =   0,
        eType_global  =   1,
        eType_diags   =   2,  ///< unbroken, but not ordered, diagonals
        eType_partial =   3,  ///< mapping pieces together
        eType_disc    =   4,  ///< discontinuous alignment
        eType_other   = 255
    };
    
    /// Access to EType's attributes (values, names) as defined in spec
    static const NCBI_NS_NCBI::CEnumeratedTypeValues* ENUM_METHOD_NAME(EType)(void);
    
    /////////////////////////////////////////////////////////////////////////////
    /// alignment data
    class NCBI_SEQALIGN_EXPORT C_Segs : public CSerialObject
    {
        typedef CSerialObject Tparent;
    public:
        // constructor
        C_Segs(void);
        // destructor
        ~C_Segs(void);
    
        // type info
        DECLARE_INTERNAL_TYPE_INFO();
    
    
        /// Choice variants.
        enum E_Choice {
            e_not_set = 0,  ///< No variant selected
            e_Dendiag,
            e_Denseg,
            e_Std,
            e_Packed,
            e_Disc,
            e_Spliced,
            e_Sparse
        };
        /// Maximum+1 value of the choice variant enumerator.
        enum E_ChoiceStopper {
            e_MaxChoice = 8 ///< == e_Sparse+1
        };
    
        /// Reset the whole object
        void Reset(void);
    
        /// Reset the selection (set it to e_not_set).
        void ResetSelection(void);
    
        /// Which variant is currently selected.
        E_Choice Which(void) const;
    
        /// Verify selection, throw exception if it differs from the expected.
        void CheckSelected(E_Choice index) const;
    
        /// Throw 'InvalidSelection' exception.
        NCBI_NORETURN void ThrowInvalidSelection(E_Choice index) const;
    
        /// Retrieve selection name (for diagnostic purposes).
        static string SelectionName(E_Choice index);
    
        /// Select the requested variant if needed.
        void Select(E_Choice index, EResetVariant reset = eDoResetVariant);
        /// Select the requested variant if needed,
        /// allocating CObject variants from memory pool.
        void Select(E_Choice index,
                    EResetVariant reset,
                    CObjectMemoryPool* pool);
    
        // types
        typedef list< CRef< CDense_diag > > TDendiag;
        typedef CDense_seg TDenseg;
        typedef list< CRef< CStd_seg > > TStd;
        typedef CPacked_seg TPacked;
        typedef CSeq_align_set TDisc;
        typedef CSpliced_seg TSpliced;
        typedef CSparse_seg TSparse;
    
        // getters
        // setters
    
        // typedef list< CRef< CDense_diag > > TDendiag
        bool IsDendiag(void) const;
        const TDendiag& GetDendiag(void) const;
        TDendiag& SetDendiag(void);
    
        // typedef CDense_seg TDenseg
        bool IsDenseg(void) const;
        const TDenseg& GetDenseg(void) const;
        TDenseg& SetDenseg(void);
        void SetDenseg(TDenseg& value);
    
        // typedef list< CRef< CStd_seg > > TStd
        bool IsStd(void) const;
        const TStd& GetStd(void) const;
        TStd& SetStd(void);
    
        // typedef CPacked_seg TPacked
        bool IsPacked(void) const;
        const TPacked& GetPacked(void) const;
        TPacked& SetPacked(void);
        void SetPacked(TPacked& value);
    
        // typedef CSeq_align_set TDisc
        bool IsDisc(void) const;
        const TDisc& GetDisc(void) const;
        TDisc& SetDisc(void);
        void SetDisc(TDisc& value);
    
        // typedef CSpliced_seg TSpliced
        bool IsSpliced(void) const;
        const TSpliced& GetSpliced(void) const;
        TSpliced& SetSpliced(void);
        void SetSpliced(TSpliced& value);
    
        // typedef CSparse_seg TSparse
        bool IsSparse(void) const;
        const TSparse& GetSparse(void) const;
        TSparse& SetSparse(void);
        void SetSparse(TSparse& value);
    
    
    private:
        // copy constructor and assignment operator
        C_Segs(const C_Segs& );
        C_Segs& operator=(const C_Segs& );
        // choice state
        E_Choice m_choice;
        // helper methods
        void DoSelect(E_Choice index, CObjectMemoryPool* pool = 0);
    
        static const char* const sm_SelectionNames[];
        // data
        union {
            NCBI_NS_NCBI::CUnionBuffer<TDendiag> m_Dendiag;
            NCBI_NS_NCBI::CUnionBuffer<TStd> m_Std;
            NCBI_NS_NCBI::CSerialObject *m_object;
        };
    };
    // types
    typedef EType TType;
    typedef int TDim;
    typedef vector< CRef< CScore > > TScore;
    typedef C_Segs TSegs;
    typedef list< CRef< CSeq_loc > > TBounds;
    typedef list< CRef< CObject_id > > TId;
    typedef list< CRef< CUser_object > > TExt;

    // member index
    enum class E_memberIndex {
        e__allMandatory = 0,
        e_type,
        e_dim,
        e_score,
        e_segs,
        e_bounds,
        e_id,
        e_ext
    };
    typedef Tparent::CMemberIndex<E_memberIndex, 8> TmemberIndex;

    // getters
    // setters

    /// mandatory
    /// typedef EType TType
    ///  Check whether the Type data member has been assigned a value.
    bool IsSetType(void) const;
    /// Check whether it is safe or not to call GetType method.
    bool CanGetType(void) const;
    void ResetType(void);
    TType GetType(void) const;
    void SetType(TType value);
    TType& SetType(void);

    /// dimensionality
    /// optional
    /// typedef int TDim
    ///  Check whether the Dim data member has been assigned a value.
    bool IsSetDim(void) const;
    /// Check whether it is safe or not to call GetDim method.
    bool CanGetDim(void) const;
    void ResetDim(void);
    TDim GetDim(void) const;
    void SetDim(TDim value);
    TDim& SetDim(void);

    /// for whole alignment
    /// optional
    /// typedef vector< CRef< CScore > > TScore
    ///  Check whether the Score data member has been assigned a value.
    bool IsSetScore(void) const;
    /// Check whether it is safe or not to call GetScore method.
    bool CanGetScore(void) const;
    void ResetScore(void);
    const TScore& GetScore(void) const;
    TScore& SetScore(void);

    /// mandatory
    /// typedef C_Segs TSegs
    ///  Check whether the Segs data member has been assigned a value.
    bool IsSetSegs(void) const;
    /// Check whether it is safe or not to call GetSegs method.
    bool CanGetSegs(void) const;
    void ResetSegs(void);
    const TSegs& GetSegs(void) const;
    void SetSegs(TSegs& value);
    TSegs& SetSegs(void);

    /// regions of sequence over which align
    ///  was computed
    /// optional
    /// typedef list< CRef< CSeq_loc > > TBounds
    ///  Check whether the Bounds data member has been assigned a value.
    bool IsSetBounds(void) const;
    /// Check whether it is safe or not to call GetBounds method.
    bool CanGetBounds(void) const;
    void ResetBounds(void);
    const TBounds& GetBounds(void) const;
    TBounds& SetBounds(void);

    /// alignment id
    /// optional
    /// typedef list< CRef< CObject_id > > TId
    ///  Check whether the Id data member has been assigned a value.
    bool IsSetId(void) const;
    /// Check whether it is safe or not to call GetId method.
    bool CanGetId(void) const;
    void ResetId(void);
    const TId& GetId(void) const;
    TId& SetId(void);

    ///extra info
    /// optional
    /// typedef list< CRef< CUser_object > > TExt
    ///  Check whether the Ext data member has been assigned a value.
    bool IsSetExt(void) const;
    /// Check whether it is safe or not to call GetExt method.
    bool CanGetExt(void) const;
    void ResetExt(void);
    const TExt& GetExt(void) const;
    TExt& SetExt(void);

    /// Reset the whole object
    virtual void Reset(void);


private:
    // Prohibit copy constructor and assignment operator
    CSeq_align_Base(const CSeq_align_Base&);
    CSeq_align_Base& operator=(const CSeq_align_Base&);

    // data
    Uint4 m_set_State[1];
    EType m_Type;
    int m_Dim;
    vector< CRef< CScore > > m_Score;
    CRef< TSegs > m_Segs;
    list< CRef< CSeq_loc > > m_Bounds;
    list< CRef< CObject_id > > m_Id;
    list< CRef< CUser_object > > m_Ext;
};






///////////////////////////////////////////////////////////
///////////////////// inline methods //////////////////////
///////////////////////////////////////////////////////////
inline
CSeq_align_Base::C_Segs::E_Choice CSeq_align_Base::C_Segs::Which(void) const
{
    return m_choice;
}

inline
void CSeq_align_Base::C_Segs::CheckSelected(E_Choice index) const
{
    if ( m_choice != index )
        ThrowInvalidSelection(index);
}

inline
void CSeq_align_Base::C_Segs::Select(E_Choice index, NCBI_NS_NCBI::EResetVariant reset, NCBI_NS_NCBI::CObjectMemoryPool* pool)
{
    if ( reset == NCBI_NS_NCBI::eDoResetVariant || m_choice != index ) {
        if ( m_choice != e_not_set )
            ResetSelection();
        DoSelect(index, pool);
    }
}

inline
void CSeq_align_Base::C_Segs::Select(E_Choice index, NCBI_NS_NCBI::EResetVariant reset)
{
    Select(index, reset, 0);
}

inline
bool CSeq_align_Base::C_Segs::IsDendiag(void) const
{
    return m_choice == e_Dendiag;
}

inline
const CSeq_align_Base::C_Segs::TDendiag& CSeq_align_Base::C_Segs::GetDendiag(void) const
{
    CheckSelected(e_Dendiag);
    return *m_Dendiag;
}

inline
CSeq_align_Base::C_Segs::TDendiag& CSeq_align_Base::C_Segs::SetDendiag(void)
{
    Select(e_Dendiag, NCBI_NS_NCBI::eDoNotResetVariant);
    return *m_Dendiag;
}

inline
bool CSeq_align_Base::C_Segs::IsDenseg(void) const
{
    return m_choice == e_Denseg;
}

inline
bool CSeq_align_Base::C_Segs::IsStd(void) const
{
    return m_choice == e_Std;
}

inline
const CSeq_align_Base::C_Segs::TStd& CSeq_align_Base::C_Segs::GetStd(void) const
{
    CheckSelected(e_Std);
    return *m_Std;
}

inline
CSeq_align_Base::C_Segs::TStd& CSeq_align_Base::C_Segs::SetStd(void)
{
    Select(e_Std, NCBI_NS_NCBI::eDoNotResetVariant);
    return *m_Std;
}

inline
bool CSeq_align_Base::C_Segs::IsPacked(void) const
{
    return m_choice == e_Packed;
}

inline
bool CSeq_align_Base::C_Segs::IsDisc(void) const
{
    return m_choice == e_Disc;
}

inline
bool CSeq_align_Base::C_Segs::IsSpliced(void) const
{
    return m_choice == e_Spliced;
}

inline
bool CSeq_align_Base::C_Segs::IsSparse(void) const
{
    return m_choice == e_Sparse;
}

inline
bool CSeq_align_Base::IsSetType(void) const
{
    return ((m_set_State[0] & 0x3) != 0);
}

inline
bool CSeq_align_Base::CanGetType(void) const
{
    return IsSetType();
}

inline
void CSeq_align_Base::ResetType(void)
{
    m_Type = (EType)(0);
    m_set_State[0] &= ~0x3;
}

inline
CSeq_align_Base::TType CSeq_align_Base::GetType(void) const
{
    if (!CanGetType()) {
        ThrowUnassigned(0);
    }
    return m_Type;
}

inline
void CSeq_align_Base::SetType(CSeq_align_Base::TType value)
{
    m_Type = value;
    m_set_State[0] |= 0x3;
}

inline
CSeq_align_Base::TType& CSeq_align_Base::SetType(void)
{
#ifdef _DEBUG
    if (!IsSetType()) {
        memset(&m_Type,UnassignedByte(),sizeof(m_Type));
    }
#endif
    m_set_State[0] |= 0x1;
    return m_Type;
}

inline
bool CSeq_align_Base::IsSetDim(void) const
{
    return ((m_set_State[0] & 0xc) != 0);
}

inline
bool CSeq_align_Base::CanGetDim(void) const
{
    return IsSetDim();
}

inline
void CSeq_align_Base::ResetDim(void)
{
    m_Dim = 0;
    m_set_State[0] &= ~0xc;
}

inline
CSeq_align_Base::TDim CSeq_align_Base::GetDim(void) const
{
    if (!CanGetDim()) {
        ThrowUnassigned(1);
    }
    return m_Dim;
}

inline
void CSeq_align_Base::SetDim(CSeq_align_Base::TDim value)
{
    m_Dim = value;
    m_set_State[0] |= 0xc;
}

inline
CSeq_align_Base::TDim& CSeq_align_Base::SetDim(void)
{
#ifdef _DEBUG
    if (!IsSetDim()) {
        memset(&m_Dim,UnassignedByte(),sizeof(m_Dim));
    }
#endif
    m_set_State[0] |= 0x4;
    return m_Dim;
}

inline
bool CSeq_align_Base::IsSetScore(void) const
{
    return ((m_set_State[0] & 0x30) != 0);
}

inline
bool CSeq_align_Base::CanGetScore(void) const
{
    return true;
}

inline
const CSeq_align_Base::TScore& CSeq_align_Base::GetScore(void) const
{
    return m_Score;
}

inline
CSeq_align_Base::TScore& CSeq_align_Base::SetScore(void)
{
    m_set_State[0] |= 0x10;
    return m_Score;
}

inline
bool CSeq_align_Base::IsSetSegs(void) const
{
    return m_Segs.NotEmpty();
}

inline
bool CSeq_align_Base::CanGetSegs(void) const
{
    return true;
}

inline
const CSeq_align_Base::TSegs& CSeq_align_Base::GetSegs(void) const
{
    if ( !m_Segs ) {
        const_cast<CSeq_align_Base*>(this)->ResetSegs();
    }
    return (*m_Segs);
}

inline
CSeq_align_Base::TSegs& CSeq_align_Base::SetSegs(void)
{
    if ( !m_Segs ) {
        ResetSegs();
    }
    return (*m_Segs);
}

inline
bool CSeq_align_Base::IsSetBounds(void) const
{
    return ((m_set_State[0] & 0x300) != 0);
}

inline
bool CSeq_align_Base::CanGetBounds(void) const
{
    return true;
}

inline
const CSeq_align_Base::TBounds& CSeq_align_Base::GetBounds(void) const
{
    return m_Bounds;
}

inline
CSeq_align_Base::TBounds& CSeq_align_Base::SetBounds(void)
{
    m_set_State[0] |= 0x100;
    return m_Bounds;
}

inline
bool CSeq_align_Base::IsSetId(void) const
{
    return ((m_set_State[0] & 0xc00) != 0);
}

inline
bool CSeq_align_Base::CanGetId(void) const
{
    return true;
}

inline
const CSeq_align_Base::TId& CSeq_align_Base::GetId(void) const
{
    return m_Id;
}

inline
CSeq_align_Base::TId& CSeq_align_Base::SetId(void)
{
    m_set_State[0] |= 0x400;
    return m_Id;
}

inline
bool CSeq_align_Base::IsSetExt(void) const
{
    return ((m_set_State[0] & 0x3000) != 0);
}

inline
bool CSeq_align_Base::CanGetExt(void) const
{
    return true;
}

inline
const CSeq_align_Base::TExt& CSeq_align_Base::GetExt(void) const
{
    return m_Ext;
}

inline
CSeq_align_Base::TExt& CSeq_align_Base::SetExt(void)
{
    m_set_State[0] |= 0x1000;
    return m_Ext;
}

///////////////////////////////////////////////////////////
////////////////// end of inline methods //////////////////
///////////////////////////////////////////////////////////





END_objects_SCOPE // namespace ncbi::objects::

END_NCBI_SCOPE


#endif // OBJECTS_SEQALIGN_SEQ_ALIGN_BASE_HPP
