/* $Id$
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 */

/// @file Spliced_exon_.hpp
/// Data storage class.
///
/// This file was generated by application DATATOOL
/// using the following specifications:
/// 'seqalign.asn'.
///
/// ATTENTION:
///   Don't edit or commit this file into CVS as this file will
///   be overridden (by DATATOOL) without warning!

#ifndef OBJECTS_SEQALIGN_SPLICED_EXON_BASE_HPP
#define OBJECTS_SEQALIGN_SPLICED_EXON_BASE_HPP

// standard includes
#include <serial/serialbase.hpp>

// generated includes
#include <list>
#include <objects/seqloc/Na_strand.hpp>

BEGIN_NCBI_SCOPE

#ifndef BEGIN_objects_SCOPE
#  define BEGIN_objects_SCOPE BEGIN_SCOPE(objects)
#  define END_objects_SCOPE END_SCOPE(objects)
#endif
BEGIN_objects_SCOPE // namespace ncbi::objects::


// forward declarations
class CProduct_pos;
class CScore_set;
class CSeq_id;
class CSplice_site;
class CSpliced_exon_chunk;
class CUser_object;


// generated classes

/////////////////////////////////////////////////////////////////////////////
/// complete or partial exon
/// two consecutive Spliced-exons may belong to one exon
class NCBI_SEQALIGN_EXPORT CSpliced_exon_Base : public CSerialObject
{
    typedef CSerialObject Tparent;
public:
    // constructor
    CSpliced_exon_Base(void);
    // destructor
    virtual ~CSpliced_exon_Base(void);

    // type info
    DECLARE_INTERNAL_TYPE_INFO();

    // types
    typedef CProduct_pos TProduct_start;
    typedef CProduct_pos TProduct_end;
    typedef TSeqPos TGenomic_start;
    typedef TSeqPos TGenomic_end;
    typedef CSeq_id TProduct_id;
    typedef CSeq_id TGenomic_id;
    typedef ENa_strand TProduct_strand;
    typedef ENa_strand TGenomic_strand;
    typedef list< CRef< CSpliced_exon_chunk > > TParts;
    typedef CScore_set TScores;
    typedef CSplice_site TAcceptor_before_exon;
    typedef CSplice_site TDonor_after_exon;
    typedef bool TPartial;
    typedef list< CRef< CUser_object > > TExt;

    // member index
    enum class E_memberIndex {
        e__allMandatory = 0,
        e_product_start,
        e_product_end,
        e_genomic_start,
        e_genomic_end,
        e_product_id,
        e_genomic_id,
        e_product_strand,
        e_genomic_strand,
        e_parts,
        e_scores,
        e_acceptor_before_exon,
        e_donor_after_exon,
        e_partial,
        e_ext
    };
    typedef Tparent::CMemberIndex<E_memberIndex, 15> TmemberIndex;

    // getters
    // setters

    /// product-end >= product-start
    /// mandatory
    /// typedef CProduct_pos TProduct_start
    ///  Check whether the Product_start data member has been assigned a value.
    bool IsSetProduct_start(void) const;
    /// Check whether it is safe or not to call GetProduct_start method.
    bool CanGetProduct_start(void) const;
    void ResetProduct_start(void);
    const TProduct_start& GetProduct_start(void) const;
    void SetProduct_start(TProduct_start& value);
    TProduct_start& SetProduct_start(void);

    /// mandatory
    /// typedef CProduct_pos TProduct_end
    ///  Check whether the Product_end data member has been assigned a value.
    bool IsSetProduct_end(void) const;
    /// Check whether it is safe or not to call GetProduct_end method.
    bool CanGetProduct_end(void) const;
    void ResetProduct_end(void);
    const TProduct_end& GetProduct_end(void) const;
    void SetProduct_end(TProduct_end& value);
    TProduct_end& SetProduct_end(void);

    /// genomic-end >= genomic-start
    /// mandatory
    /// typedef TSeqPos TGenomic_start
    ///  Check whether the Genomic_start data member has been assigned a value.
    bool IsSetGenomic_start(void) const;
    /// Check whether it is safe or not to call GetGenomic_start method.
    bool CanGetGenomic_start(void) const;
    void ResetGenomic_start(void);
    TGenomic_start GetGenomic_start(void) const;
    void SetGenomic_start(TGenomic_start value);
    TGenomic_start& SetGenomic_start(void);

    /// mandatory
    /// typedef TSeqPos TGenomic_end
    ///  Check whether the Genomic_end data member has been assigned a value.
    bool IsSetGenomic_end(void) const;
    /// Check whether it is safe or not to call GetGenomic_end method.
    bool CanGetGenomic_end(void) const;
    void ResetGenomic_end(void);
    TGenomic_end GetGenomic_end(void) const;
    void SetGenomic_end(TGenomic_end value);
    TGenomic_end& SetGenomic_end(void);

    /// product is either protein or transcript (cDNA)
    /// optional
    /// typedef CSeq_id TProduct_id
    ///  Check whether the Product_id data member has been assigned a value.
    bool IsSetProduct_id(void) const;
    /// Check whether it is safe or not to call GetProduct_id method.
    bool CanGetProduct_id(void) const;
    void ResetProduct_id(void);
    const TProduct_id& GetProduct_id(void) const;
    void SetProduct_id(TProduct_id& value);
    TProduct_id& SetProduct_id(void);

    /// optional
    /// typedef CSeq_id TGenomic_id
    ///  Check whether the Genomic_id data member has been assigned a value.
    bool IsSetGenomic_id(void) const;
    /// Check whether it is safe or not to call GetGenomic_id method.
    bool CanGetGenomic_id(void) const;
    void ResetGenomic_id(void);
    const TGenomic_id& GetGenomic_id(void) const;
    void SetGenomic_id(TGenomic_id& value);
    TGenomic_id& SetGenomic_id(void);

    /// should be 'plus' or 'minus'
    /// optional
    /// typedef ENa_strand TProduct_strand
    ///  Check whether the Product_strand data member has been assigned a value.
    bool IsSetProduct_strand(void) const;
    /// Check whether it is safe or not to call GetProduct_strand method.
    bool CanGetProduct_strand(void) const;
    void ResetProduct_strand(void);
    TProduct_strand GetProduct_strand(void) const;
    void SetProduct_strand(TProduct_strand value);
    TProduct_strand& SetProduct_strand(void);

    /// genomic-strand represents the strand of translation
    /// optional
    /// typedef ENa_strand TGenomic_strand
    ///  Check whether the Genomic_strand data member has been assigned a value.
    bool IsSetGenomic_strand(void) const;
    /// Check whether it is safe or not to call GetGenomic_strand method.
    bool CanGetGenomic_strand(void) const;
    void ResetGenomic_strand(void);
    TGenomic_strand GetGenomic_strand(void) const;
    void SetGenomic_strand(TGenomic_strand value);
    TGenomic_strand& SetGenomic_strand(void);

    /// basic seqments always are in biologic order
    /// optional
    /// typedef list< CRef< CSpliced_exon_chunk > > TParts
    ///  Check whether the Parts data member has been assigned a value.
    bool IsSetParts(void) const;
    /// Check whether it is safe or not to call GetParts method.
    bool CanGetParts(void) const;
    void ResetParts(void);
    const TParts& GetParts(void) const;
    TParts& SetParts(void);

    /// scores for this exon
    /// optional
    /// typedef CScore_set TScores
    ///  Check whether the Scores data member has been assigned a value.
    bool IsSetScores(void) const;
    /// Check whether it is safe or not to call GetScores method.
    bool CanGetScores(void) const;
    void ResetScores(void);
    const TScores& GetScores(void) const;
    void SetScores(TScores& value);
    TScores& SetScores(void);

    /// splice sites
    /// optional
    /// typedef CSplice_site TAcceptor_before_exon
    ///  Check whether the Acceptor_before_exon data member has been assigned a value.
    bool IsSetAcceptor_before_exon(void) const;
    /// Check whether it is safe or not to call GetAcceptor_before_exon method.
    bool CanGetAcceptor_before_exon(void) const;
    void ResetAcceptor_before_exon(void);
    const TAcceptor_before_exon& GetAcceptor_before_exon(void) const;
    void SetAcceptor_before_exon(TAcceptor_before_exon& value);
    TAcceptor_before_exon& SetAcceptor_before_exon(void);

    /// optional
    /// typedef CSplice_site TDonor_after_exon
    ///  Check whether the Donor_after_exon data member has been assigned a value.
    bool IsSetDonor_after_exon(void) const;
    /// Check whether it is safe or not to call GetDonor_after_exon method.
    bool CanGetDonor_after_exon(void) const;
    void ResetDonor_after_exon(void);
    const TDonor_after_exon& GetDonor_after_exon(void) const;
    void SetDonor_after_exon(TDonor_after_exon& value);
    TDonor_after_exon& SetDonor_after_exon(void);

    /// flag: is this exon complete or partial?
    /// optional
    /// typedef bool TPartial
    ///  Check whether the Partial data member has been assigned a value.
    bool IsSetPartial(void) const;
    /// Check whether it is safe or not to call GetPartial method.
    bool CanGetPartial(void) const;
    void ResetPartial(void);
    TPartial GetPartial(void) const;
    void SetPartial(TPartial value);
    TPartial& SetPartial(void);

    ///extra info
    /// optional
    /// typedef list< CRef< CUser_object > > TExt
    ///  Check whether the Ext data member has been assigned a value.
    bool IsSetExt(void) const;
    /// Check whether it is safe or not to call GetExt method.
    bool CanGetExt(void) const;
    void ResetExt(void);
    const TExt& GetExt(void) const;
    TExt& SetExt(void);

    /// Reset the whole object
    virtual void Reset(void);


private:
    // Prohibit copy constructor and assignment operator
    CSpliced_exon_Base(const CSpliced_exon_Base&);
    CSpliced_exon_Base& operator=(const CSpliced_exon_Base&);

    // data
    Uint4 m_set_State[1];
    CRef< TProduct_start > m_Product_start;
    CRef< TProduct_end > m_Product_end;
    TSeqPos m_Genomic_start;
    TSeqPos m_Genomic_end;
    CRef< TProduct_id > m_Product_id;
    CRef< TGenomic_id > m_Genomic_id;
    ENa_strand m_Product_strand;
    ENa_strand m_Genomic_strand;
    list< CRef< CSpliced_exon_chunk > > m_Parts;
    CRef< TScores > m_Scores;
    CRef< TAcceptor_before_exon > m_Acceptor_before_exon;
    CRef< TDonor_after_exon > m_Donor_after_exon;
    bool m_Partial;
    list< CRef< CUser_object > > m_Ext;
};






///////////////////////////////////////////////////////////
///////////////////// inline methods //////////////////////
///////////////////////////////////////////////////////////
inline
bool CSpliced_exon_Base::IsSetProduct_start(void) const
{
    return m_Product_start.NotEmpty();
}

inline
bool CSpliced_exon_Base::CanGetProduct_start(void) const
{
    return true;
}

inline
const CSpliced_exon_Base::TProduct_start& CSpliced_exon_Base::GetProduct_start(void) const
{
    if ( !m_Product_start ) {
        const_cast<CSpliced_exon_Base*>(this)->ResetProduct_start();
    }
    return (*m_Product_start);
}

inline
CSpliced_exon_Base::TProduct_start& CSpliced_exon_Base::SetProduct_start(void)
{
    if ( !m_Product_start ) {
        ResetProduct_start();
    }
    return (*m_Product_start);
}

inline
bool CSpliced_exon_Base::IsSetProduct_end(void) const
{
    return m_Product_end.NotEmpty();
}

inline
bool CSpliced_exon_Base::CanGetProduct_end(void) const
{
    return true;
}

inline
const CSpliced_exon_Base::TProduct_end& CSpliced_exon_Base::GetProduct_end(void) const
{
    if ( !m_Product_end ) {
        const_cast<CSpliced_exon_Base*>(this)->ResetProduct_end();
    }
    return (*m_Product_end);
}

inline
CSpliced_exon_Base::TProduct_end& CSpliced_exon_Base::SetProduct_end(void)
{
    if ( !m_Product_end ) {
        ResetProduct_end();
    }
    return (*m_Product_end);
}

inline
bool CSpliced_exon_Base::IsSetGenomic_start(void) const
{
    return ((m_set_State[0] & 0x30) != 0);
}

inline
bool CSpliced_exon_Base::CanGetGenomic_start(void) const
{
    return IsSetGenomic_start();
}

inline
void CSpliced_exon_Base::ResetGenomic_start(void)
{
    m_Genomic_start = 0;
    m_set_State[0] &= ~0x30;
}

inline
CSpliced_exon_Base::TGenomic_start CSpliced_exon_Base::GetGenomic_start(void) const
{
    if (!CanGetGenomic_start()) {
        ThrowUnassigned(2);
    }
    return m_Genomic_start;
}

inline
void CSpliced_exon_Base::SetGenomic_start(CSpliced_exon_Base::TGenomic_start value)
{
    m_Genomic_start = value;
    m_set_State[0] |= 0x30;
}

inline
CSpliced_exon_Base::TGenomic_start& CSpliced_exon_Base::SetGenomic_start(void)
{
#ifdef _DEBUG
    if (!IsSetGenomic_start()) {
        memset(&m_Genomic_start,UnassignedByte(),sizeof(m_Genomic_start));
    }
#endif
    m_set_State[0] |= 0x10;
    return m_Genomic_start;
}

inline
bool CSpliced_exon_Base::IsSetGenomic_end(void) const
{
    return ((m_set_State[0] & 0xc0) != 0);
}

inline
bool CSpliced_exon_Base::CanGetGenomic_end(void) const
{
    return IsSetGenomic_end();
}

inline
void CSpliced_exon_Base::ResetGenomic_end(void)
{
    m_Genomic_end = 0;
    m_set_State[0] &= ~0xc0;
}

inline
CSpliced_exon_Base::TGenomic_end CSpliced_exon_Base::GetGenomic_end(void) const
{
    if (!CanGetGenomic_end()) {
        ThrowUnassigned(3);
    }
    return m_Genomic_end;
}

inline
void CSpliced_exon_Base::SetGenomic_end(CSpliced_exon_Base::TGenomic_end value)
{
    m_Genomic_end = value;
    m_set_State[0] |= 0xc0;
}

inline
CSpliced_exon_Base::TGenomic_end& CSpliced_exon_Base::SetGenomic_end(void)
{
#ifdef _DEBUG
    if (!IsSetGenomic_end()) {
        memset(&m_Genomic_end,UnassignedByte(),sizeof(m_Genomic_end));
    }
#endif
    m_set_State[0] |= 0x40;
    return m_Genomic_end;
}

inline
bool CSpliced_exon_Base::IsSetProduct_id(void) const
{
    return m_Product_id.NotEmpty();
}

inline
bool CSpliced_exon_Base::CanGetProduct_id(void) const
{
    return IsSetProduct_id();
}

inline
const CSpliced_exon_Base::TProduct_id& CSpliced_exon_Base::GetProduct_id(void) const
{
    if (!CanGetProduct_id()) {
        ThrowUnassigned(4);
    }
    return (*m_Product_id);
}

inline
bool CSpliced_exon_Base::IsSetGenomic_id(void) const
{
    return m_Genomic_id.NotEmpty();
}

inline
bool CSpliced_exon_Base::CanGetGenomic_id(void) const
{
    return IsSetGenomic_id();
}

inline
const CSpliced_exon_Base::TGenomic_id& CSpliced_exon_Base::GetGenomic_id(void) const
{
    if (!CanGetGenomic_id()) {
        ThrowUnassigned(5);
    }
    return (*m_Genomic_id);
}

inline
bool CSpliced_exon_Base::IsSetProduct_strand(void) const
{
    return ((m_set_State[0] & 0x3000) != 0);
}

inline
bool CSpliced_exon_Base::CanGetProduct_strand(void) const
{
    return IsSetProduct_strand();
}

inline
void CSpliced_exon_Base::ResetProduct_strand(void)
{
    m_Product_strand = (ncbi::objects::ENa_strand)(0);
    m_set_State[0] &= ~0x3000;
}

inline
CSpliced_exon_Base::TProduct_strand CSpliced_exon_Base::GetProduct_strand(void) const
{
    if (!CanGetProduct_strand()) {
        ThrowUnassigned(6);
    }
    return m_Product_strand;
}

inline
void CSpliced_exon_Base::SetProduct_strand(CSpliced_exon_Base::TProduct_strand value)
{
    m_Product_strand = value;
    m_set_State[0] |= 0x3000;
}

inline
CSpliced_exon_Base::TProduct_strand& CSpliced_exon_Base::SetProduct_strand(void)
{
#ifdef _DEBUG
    if (!IsSetProduct_strand()) {
        memset(&m_Product_strand,UnassignedByte(),sizeof(m_Product_strand));
    }
#endif
    m_set_State[0] |= 0x1000;
    return m_Product_strand;
}

inline
bool CSpliced_exon_Base::IsSetGenomic_strand(void) const
{
    return ((m_set_State[0] & 0xc000) != 0);
}

inline
bool CSpliced_exon_Base::CanGetGenomic_strand(void) const
{
    return IsSetGenomic_strand();
}

inline
void CSpliced_exon_Base::ResetGenomic_strand(void)
{
    m_Genomic_strand = (ncbi::objects::ENa_strand)(0);
    m_set_State[0] &= ~0xc000;
}

inline
CSpliced_exon_Base::TGenomic_strand CSpliced_exon_Base::GetGenomic_strand(void) const
{
    if (!CanGetGenomic_strand()) {
        ThrowUnassigned(7);
    }
    return m_Genomic_strand;
}

inline
void CSpliced_exon_Base::SetGenomic_strand(CSpliced_exon_Base::TGenomic_strand value)
{
    m_Genomic_strand = value;
    m_set_State[0] |= 0xc000;
}

inline
CSpliced_exon_Base::TGenomic_strand& CSpliced_exon_Base::SetGenomic_strand(void)
{
#ifdef _DEBUG
    if (!IsSetGenomic_strand()) {
        memset(&m_Genomic_strand,UnassignedByte(),sizeof(m_Genomic_strand));
    }
#endif
    m_set_State[0] |= 0x4000;
    return m_Genomic_strand;
}

inline
bool CSpliced_exon_Base::IsSetParts(void) const
{
    return ((m_set_State[0] & 0x30000) != 0);
}

inline
bool CSpliced_exon_Base::CanGetParts(void) const
{
    return true;
}

inline
const CSpliced_exon_Base::TParts& CSpliced_exon_Base::GetParts(void) const
{
    return m_Parts;
}

inline
CSpliced_exon_Base::TParts& CSpliced_exon_Base::SetParts(void)
{
    m_set_State[0] |= 0x10000;
    return m_Parts;
}

inline
bool CSpliced_exon_Base::IsSetScores(void) const
{
    return m_Scores.NotEmpty();
}

inline
bool CSpliced_exon_Base::CanGetScores(void) const
{
    return IsSetScores();
}

inline
const CSpliced_exon_Base::TScores& CSpliced_exon_Base::GetScores(void) const
{
    if (!CanGetScores()) {
        ThrowUnassigned(9);
    }
    return (*m_Scores);
}

inline
bool CSpliced_exon_Base::IsSetAcceptor_before_exon(void) const
{
    return m_Acceptor_before_exon.NotEmpty();
}

inline
bool CSpliced_exon_Base::CanGetAcceptor_before_exon(void) const
{
    return IsSetAcceptor_before_exon();
}

inline
const CSpliced_exon_Base::TAcceptor_before_exon& CSpliced_exon_Base::GetAcceptor_before_exon(void) const
{
    if (!CanGetAcceptor_before_exon()) {
        ThrowUnassigned(10);
    }
    return (*m_Acceptor_before_exon);
}

inline
bool CSpliced_exon_Base::IsSetDonor_after_exon(void) const
{
    return m_Donor_after_exon.NotEmpty();
}

inline
bool CSpliced_exon_Base::CanGetDonor_after_exon(void) const
{
    return IsSetDonor_after_exon();
}

inline
const CSpliced_exon_Base::TDonor_after_exon& CSpliced_exon_Base::GetDonor_after_exon(void) const
{
    if (!CanGetDonor_after_exon()) {
        ThrowUnassigned(11);
    }
    return (*m_Donor_after_exon);
}

inline
bool CSpliced_exon_Base::IsSetPartial(void) const
{
    return ((m_set_State[0] & 0x3000000) != 0);
}

inline
bool CSpliced_exon_Base::CanGetPartial(void) const
{
    return IsSetPartial();
}

inline
void CSpliced_exon_Base::ResetPartial(void)
{
    m_Partial = 0;
    m_set_State[0] &= ~0x3000000;
}

inline
CSpliced_exon_Base::TPartial CSpliced_exon_Base::GetPartial(void) const
{
    if (!CanGetPartial()) {
        ThrowUnassigned(12);
    }
    return m_Partial;
}

inline
void CSpliced_exon_Base::SetPartial(CSpliced_exon_Base::TPartial value)
{
    m_Partial = value;
    m_set_State[0] |= 0x3000000;
}

inline
CSpliced_exon_Base::TPartial& CSpliced_exon_Base::SetPartial(void)
{
#ifdef _DEBUG
    if (!IsSetPartial()) {
        memset(&m_Partial,UnassignedByte(),sizeof(m_Partial));
    }
#endif
    m_set_State[0] |= 0x1000000;
    return m_Partial;
}

inline
bool CSpliced_exon_Base::IsSetExt(void) const
{
    return ((m_set_State[0] & 0xc000000) != 0);
}

inline
bool CSpliced_exon_Base::CanGetExt(void) const
{
    return true;
}

inline
const CSpliced_exon_Base::TExt& CSpliced_exon_Base::GetExt(void) const
{
    return m_Ext;
}

inline
CSpliced_exon_Base::TExt& CSpliced_exon_Base::SetExt(void)
{
    m_set_State[0] |= 0x4000000;
    return m_Ext;
}

///////////////////////////////////////////////////////////
////////////////// end of inline methods //////////////////
///////////////////////////////////////////////////////////





END_objects_SCOPE // namespace ncbi::objects::

END_NCBI_SCOPE


#endif // OBJECTS_SEQALIGN_SPLICED_EXON_BASE_HPP
