/* $Id$
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 */

/// @file PDB_block_.hpp
/// Data storage class.
///
/// This file was generated by application DATATOOL
/// using the following specifications:
/// 'seqblock.asn'.
///
/// ATTENTION:
///   Don't edit or commit this file into CVS as this file will
///   be overridden (by DATATOOL) without warning!

#ifndef OBJECTS_SEQBLOCK_PDB_BLOCK_BASE_HPP
#define OBJECTS_SEQBLOCK_PDB_BLOCK_BASE_HPP

// standard includes
#include <serial/serialbase.hpp>

// generated includes
#include <list>
#include <string>

BEGIN_NCBI_SCOPE

#ifndef BEGIN_objects_SCOPE
#  define BEGIN_objects_SCOPE BEGIN_SCOPE(objects)
#  define END_objects_SCOPE END_SCOPE(objects)
#endif
BEGIN_objects_SCOPE // namespace ncbi::objects::


// forward declarations
class CDate;
class CPDB_replace;


// generated classes

/////////////////////////////////////////////////////////////////////////////
/// PDB specific descriptions
class NCBI_SEQBLOCK_EXPORT CPDB_block_Base : public CSerialObject
{
    typedef CSerialObject Tparent;
public:
    // constructor
    CPDB_block_Base(void);
    // destructor
    virtual ~CPDB_block_Base(void);

    // type info
    DECLARE_INTERNAL_TYPE_INFO();

    // types
    typedef CDate TDeposition;
    typedef string TClass;
    typedef list< string > TCompound;
    typedef list< string > TSource;
    typedef string TExp_method;
    typedef CPDB_replace TReplace;

    // member index
    enum class E_memberIndex {
        e__allMandatory = 0,
        e_deposition,
        e_class,
        e_compound,
        e_source,
        e_exp_method,
        e_replace
    };
    typedef Tparent::CMemberIndex<E_memberIndex, 7> TmemberIndex;

    // getters
    // setters

    /// deposition date  month,year
    /// mandatory
    /// typedef CDate TDeposition
    ///  Check whether the Deposition data member has been assigned a value.
    bool IsSetDeposition(void) const;
    /// Check whether it is safe or not to call GetDeposition method.
    bool CanGetDeposition(void) const;
    void ResetDeposition(void);
    const TDeposition& GetDeposition(void) const;
    void SetDeposition(TDeposition& value);
    TDeposition& SetDeposition(void);

    /// mandatory
    /// typedef string TClass
    ///  Check whether the Class data member has been assigned a value.
    bool IsSetClass(void) const;
    /// Check whether it is safe or not to call GetClass method.
    bool CanGetClass(void) const;
    void ResetClass(void);
    const TClass& GetClass(void) const;
    void SetClass(const TClass& value);
    void SetClass(TClass&& value);
    TClass& SetClass(void);

    /// mandatory
    /// typedef list< string > TCompound
    ///  Check whether the Compound data member has been assigned a value.
    bool IsSetCompound(void) const;
    /// Check whether it is safe or not to call GetCompound method.
    bool CanGetCompound(void) const;
    void ResetCompound(void);
    const TCompound& GetCompound(void) const;
    TCompound& SetCompound(void);

    /// mandatory
    /// typedef list< string > TSource
    ///  Check whether the Source data member has been assigned a value.
    bool IsSetSource(void) const;
    /// Check whether it is safe or not to call GetSource method.
    bool CanGetSource(void) const;
    void ResetSource(void);
    const TSource& GetSource(void) const;
    TSource& SetSource(void);

    /// present if NOT X-ray diffraction
    /// optional
    /// typedef string TExp_method
    ///  Check whether the Exp_method data member has been assigned a value.
    bool IsSetExp_method(void) const;
    /// Check whether it is safe or not to call GetExp_method method.
    bool CanGetExp_method(void) const;
    void ResetExp_method(void);
    const TExp_method& GetExp_method(void) const;
    void SetExp_method(const TExp_method& value);
    void SetExp_method(TExp_method&& value);
    TExp_method& SetExp_method(void);

    /// replacement history
    /// optional
    /// typedef CPDB_replace TReplace
    ///  Check whether the Replace data member has been assigned a value.
    bool IsSetReplace(void) const;
    /// Check whether it is safe or not to call GetReplace method.
    bool CanGetReplace(void) const;
    void ResetReplace(void);
    const TReplace& GetReplace(void) const;
    void SetReplace(TReplace& value);
    TReplace& SetReplace(void);

    /// Reset the whole object
    virtual void Reset(void);


private:
    // Prohibit copy constructor and assignment operator
    CPDB_block_Base(const CPDB_block_Base&);
    CPDB_block_Base& operator=(const CPDB_block_Base&);

    // data
    Uint4 m_set_State[1];
    CRef< TDeposition > m_Deposition;
    string m_Class;
    list< string > m_Compound;
    list< string > m_Source;
    string m_Exp_method;
    CRef< TReplace > m_Replace;
};






///////////////////////////////////////////////////////////
///////////////////// inline methods //////////////////////
///////////////////////////////////////////////////////////
inline
bool CPDB_block_Base::IsSetDeposition(void) const
{
    return m_Deposition.NotEmpty();
}

inline
bool CPDB_block_Base::CanGetDeposition(void) const
{
    return true;
}

inline
const CPDB_block_Base::TDeposition& CPDB_block_Base::GetDeposition(void) const
{
    if ( !m_Deposition ) {
        const_cast<CPDB_block_Base*>(this)->ResetDeposition();
    }
    return (*m_Deposition);
}

inline
CPDB_block_Base::TDeposition& CPDB_block_Base::SetDeposition(void)
{
    if ( !m_Deposition ) {
        ResetDeposition();
    }
    return (*m_Deposition);
}

inline
bool CPDB_block_Base::IsSetClass(void) const
{
    return ((m_set_State[0] & 0xc) != 0);
}

inline
bool CPDB_block_Base::CanGetClass(void) const
{
    return IsSetClass();
}

inline
const CPDB_block_Base::TClass& CPDB_block_Base::GetClass(void) const
{
    if (!CanGetClass()) {
        ThrowUnassigned(1);
    }
    return m_Class;
}

inline
void CPDB_block_Base::SetClass(const CPDB_block_Base::TClass& value)
{
    m_Class = value;
    m_set_State[0] |= 0xc;
}

inline
void CPDB_block_Base::SetClass(CPDB_block_Base::TClass&& value)
{
    m_Class = std::forward<CPDB_block_Base::TClass>(value);
    m_set_State[0] |= 0xc;
}

inline
CPDB_block_Base::TClass& CPDB_block_Base::SetClass(void)
{
#ifdef _DEBUG
    if (!IsSetClass()) {
        m_Class = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x4;
    return m_Class;
}

inline
bool CPDB_block_Base::IsSetCompound(void) const
{
    return ((m_set_State[0] & 0x30) != 0);
}

inline
bool CPDB_block_Base::CanGetCompound(void) const
{
    return true;
}

inline
const CPDB_block_Base::TCompound& CPDB_block_Base::GetCompound(void) const
{
    return m_Compound;
}

inline
CPDB_block_Base::TCompound& CPDB_block_Base::SetCompound(void)
{
    m_set_State[0] |= 0x10;
    return m_Compound;
}

inline
bool CPDB_block_Base::IsSetSource(void) const
{
    return ((m_set_State[0] & 0xc0) != 0);
}

inline
bool CPDB_block_Base::CanGetSource(void) const
{
    return true;
}

inline
const CPDB_block_Base::TSource& CPDB_block_Base::GetSource(void) const
{
    return m_Source;
}

inline
CPDB_block_Base::TSource& CPDB_block_Base::SetSource(void)
{
    m_set_State[0] |= 0x40;
    return m_Source;
}

inline
bool CPDB_block_Base::IsSetExp_method(void) const
{
    return ((m_set_State[0] & 0x300) != 0);
}

inline
bool CPDB_block_Base::CanGetExp_method(void) const
{
    return IsSetExp_method();
}

inline
const CPDB_block_Base::TExp_method& CPDB_block_Base::GetExp_method(void) const
{
    if (!CanGetExp_method()) {
        ThrowUnassigned(4);
    }
    return m_Exp_method;
}

inline
void CPDB_block_Base::SetExp_method(const CPDB_block_Base::TExp_method& value)
{
    m_Exp_method = value;
    m_set_State[0] |= 0x300;
}

inline
void CPDB_block_Base::SetExp_method(CPDB_block_Base::TExp_method&& value)
{
    m_Exp_method = std::forward<CPDB_block_Base::TExp_method>(value);
    m_set_State[0] |= 0x300;
}

inline
CPDB_block_Base::TExp_method& CPDB_block_Base::SetExp_method(void)
{
#ifdef _DEBUG
    if (!IsSetExp_method()) {
        m_Exp_method = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x100;
    return m_Exp_method;
}

inline
bool CPDB_block_Base::IsSetReplace(void) const
{
    return m_Replace.NotEmpty();
}

inline
bool CPDB_block_Base::CanGetReplace(void) const
{
    return IsSetReplace();
}

inline
const CPDB_block_Base::TReplace& CPDB_block_Base::GetReplace(void) const
{
    if (!CanGetReplace()) {
        ThrowUnassigned(5);
    }
    return (*m_Replace);
}

///////////////////////////////////////////////////////////
////////////////// end of inline methods //////////////////
///////////////////////////////////////////////////////////





END_objects_SCOPE // namespace ncbi::objects::

END_NCBI_SCOPE


#endif // OBJECTS_SEQBLOCK_PDB_BLOCK_BASE_HPP
