/* $Id$
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 */

/// @file SeqEdit_Cmd_ChangeSeqAttr_.hpp
/// Data storage class.
///
/// This file was generated by application DATATOOL
/// using the following specifications:
/// 'seqedit.asn'.
///
/// ATTENTION:
///   Don't edit or commit this file into CVS as this file will
///   be overridden (by DATATOOL) without warning!

#ifndef OBJECTS_SEQEDIT_SEQEDIT_CMD_CHANGESEQATTR_BASE_HPP
#define OBJECTS_SEQEDIT_SEQEDIT_CMD_CHANGESEQATTR_BASE_HPP

// standard includes
#include <serial/serialbase.hpp>
BEGIN_NCBI_SCOPE

#ifndef BEGIN_objects_SCOPE
#  define BEGIN_objects_SCOPE BEGIN_SCOPE(objects)
#  define END_objects_SCOPE END_SCOPE(objects)
#endif
BEGIN_objects_SCOPE // namespace ncbi::objects::


// forward declarations
class CInt_fuzz;
class CSeqEdit_Id;
class CSeq_data;
class CSeq_ext;
class CSeq_hist;
class CSeq_inst;


// generated classes

/////////////////////////////////////////////////////////////////////////////
/// Change bioseq's attribure
class NCBI_SEQEDIT_EXPORT CSeqEdit_Cmd_ChangeSeqAttr_Base : public CSerialObject
{
    typedef CSerialObject Tparent;
public:
    // constructor
    CSeqEdit_Cmd_ChangeSeqAttr_Base(void);
    // destructor
    virtual ~CSeqEdit_Cmd_ChangeSeqAttr_Base(void);

    // type info
    DECLARE_INTERNAL_TYPE_INFO();

    /////////////////////////////////////////////////////////////////////////////
    class NCBI_SEQEDIT_EXPORT C_Data : public CSerialObject
    {
        typedef CSerialObject Tparent;
    public:
        // constructor
        C_Data(void);
        // destructor
        ~C_Data(void);
    
        // type info
        DECLARE_INTERNAL_TYPE_INFO();
    
    
        /// Choice variants.
        enum E_Choice {
            e_not_set = 0,  ///< No variant selected
            e_Inst,         ///< whole seq-inst object
            e_Repr,         ///< repr field of seq-inst object
            e_Mol,          ///< mol field of seq-inst object
            e_Length,       ///< length field of seq-inst object
            e_Fuzz,         ///< fuzz field of seq-inst object
            e_Topology,     ///< topology field of seq-inst object
            e_Strand,       ///< strand field of seq-inst object
            e_Ext,          ///< extr field of seq-inst object
            e_Hist,         ///< hist field of seq-inst object
            e_Seq_data      ///< seq-data field of seq-inst object
        };
        /// Maximum+1 value of the choice variant enumerator.
        enum E_ChoiceStopper {
            e_MaxChoice = 11 ///< == e_Seq_data+1
        };
    
        /// Reset the whole object
        void Reset(void);
    
        /// Reset the selection (set it to e_not_set).
        void ResetSelection(void);
    
        /// Which variant is currently selected.
        E_Choice Which(void) const;
    
        /// Verify selection, throw exception if it differs from the expected.
        void CheckSelected(E_Choice index) const;
    
        /// Throw 'InvalidSelection' exception.
        NCBI_NORETURN void ThrowInvalidSelection(E_Choice index) const;
    
        /// Retrieve selection name (for diagnostic purposes).
        static string SelectionName(E_Choice index);
    
        /// Select the requested variant if needed.
        void Select(E_Choice index, EResetVariant reset = eDoResetVariant);
        /// Select the requested variant if needed,
        /// allocating CObject variants from memory pool.
        void Select(E_Choice index,
                    EResetVariant reset,
                    CObjectMemoryPool* pool);
    
        // types
        typedef CSeq_inst TInst;
        typedef int TRepr;
        typedef int TMol;
        typedef int TLength;
        typedef CInt_fuzz TFuzz;
        typedef int TTopology;
        typedef int TStrand;
        typedef CSeq_ext TExt;
        typedef CSeq_hist THist;
        typedef CSeq_data TSeq_data;
    
        // getters
        // setters
    
        // typedef CSeq_inst TInst
        bool IsInst(void) const;
        const TInst& GetInst(void) const;
        TInst& SetInst(void);
        void SetInst(TInst& value);
    
        // typedef int TRepr
        bool IsRepr(void) const;
        TRepr GetRepr(void) const;
        TRepr& SetRepr(void);
        void SetRepr(TRepr value);
    
        // typedef int TMol
        bool IsMol(void) const;
        TMol GetMol(void) const;
        TMol& SetMol(void);
        void SetMol(TMol value);
    
        // typedef int TLength
        bool IsLength(void) const;
        TLength GetLength(void) const;
        TLength& SetLength(void);
        void SetLength(TLength value);
    
        // typedef CInt_fuzz TFuzz
        bool IsFuzz(void) const;
        const TFuzz& GetFuzz(void) const;
        TFuzz& SetFuzz(void);
        void SetFuzz(TFuzz& value);
    
        // typedef int TTopology
        bool IsTopology(void) const;
        TTopology GetTopology(void) const;
        TTopology& SetTopology(void);
        void SetTopology(TTopology value);
    
        // typedef int TStrand
        bool IsStrand(void) const;
        TStrand GetStrand(void) const;
        TStrand& SetStrand(void);
        void SetStrand(TStrand value);
    
        // typedef CSeq_ext TExt
        bool IsExt(void) const;
        const TExt& GetExt(void) const;
        TExt& SetExt(void);
        void SetExt(TExt& value);
    
        // typedef CSeq_hist THist
        bool IsHist(void) const;
        const THist& GetHist(void) const;
        THist& SetHist(void);
        void SetHist(THist& value);
    
        // typedef CSeq_data TSeq_data
        bool IsSeq_data(void) const;
        const TSeq_data& GetSeq_data(void) const;
        TSeq_data& SetSeq_data(void);
        void SetSeq_data(TSeq_data& value);
    
    
    private:
        // copy constructor and assignment operator
        C_Data(const C_Data& );
        C_Data& operator=(const C_Data& );
        // choice state
        E_Choice m_choice;
        // helper methods
        void DoSelect(E_Choice index, CObjectMemoryPool* pool = 0);
    
        static const char* const sm_SelectionNames[];
        // data
        union {
            TRepr m_Repr;
            TMol m_Mol;
            TLength m_Length;
            TTopology m_Topology;
            TStrand m_Strand;
            NCBI_NS_NCBI::CSerialObject *m_object;
        };
    };
    // types
    typedef CSeqEdit_Id TId;
    typedef C_Data TData;

    // member index
    enum class E_memberIndex {
        e__allMandatory = 0,
        e_id,
        e_data
    };
    typedef Tparent::CMemberIndex<E_memberIndex, 3> TmemberIndex;

    // getters
    // setters

    /// Bioseq id
    /// mandatory
    /// typedef CSeqEdit_Id TId
    ///  Check whether the Id data member has been assigned a value.
    bool IsSetId(void) const;
    /// Check whether it is safe or not to call GetId method.
    bool CanGetId(void) const;
    void ResetId(void);
    const TId& GetId(void) const;
    void SetId(TId& value);
    TId& SetId(void);

    /// mandatory
    /// typedef C_Data TData
    ///  Check whether the Data data member has been assigned a value.
    bool IsSetData(void) const;
    /// Check whether it is safe or not to call GetData method.
    bool CanGetData(void) const;
    void ResetData(void);
    const TData& GetData(void) const;
    void SetData(TData& value);
    TData& SetData(void);

    /// Reset the whole object
    virtual void Reset(void);


private:
    // Prohibit copy constructor and assignment operator
    CSeqEdit_Cmd_ChangeSeqAttr_Base(const CSeqEdit_Cmd_ChangeSeqAttr_Base&);
    CSeqEdit_Cmd_ChangeSeqAttr_Base& operator=(const CSeqEdit_Cmd_ChangeSeqAttr_Base&);

    // data
    Uint4 m_set_State[1];
    CRef< TId > m_Id;
    CRef< TData > m_Data;
};






///////////////////////////////////////////////////////////
///////////////////// inline methods //////////////////////
///////////////////////////////////////////////////////////
inline
CSeqEdit_Cmd_ChangeSeqAttr_Base::C_Data::E_Choice CSeqEdit_Cmd_ChangeSeqAttr_Base::C_Data::Which(void) const
{
    return m_choice;
}

inline
void CSeqEdit_Cmd_ChangeSeqAttr_Base::C_Data::CheckSelected(E_Choice index) const
{
    if ( m_choice != index )
        ThrowInvalidSelection(index);
}

inline
void CSeqEdit_Cmd_ChangeSeqAttr_Base::C_Data::Select(E_Choice index, NCBI_NS_NCBI::EResetVariant reset, NCBI_NS_NCBI::CObjectMemoryPool* pool)
{
    if ( reset == NCBI_NS_NCBI::eDoResetVariant || m_choice != index ) {
        if ( m_choice != e_not_set )
            ResetSelection();
        DoSelect(index, pool);
    }
}

inline
void CSeqEdit_Cmd_ChangeSeqAttr_Base::C_Data::Select(E_Choice index, NCBI_NS_NCBI::EResetVariant reset)
{
    Select(index, reset, 0);
}

inline
bool CSeqEdit_Cmd_ChangeSeqAttr_Base::C_Data::IsInst(void) const
{
    return m_choice == e_Inst;
}

inline
bool CSeqEdit_Cmd_ChangeSeqAttr_Base::C_Data::IsRepr(void) const
{
    return m_choice == e_Repr;
}

inline
CSeqEdit_Cmd_ChangeSeqAttr_Base::C_Data::TRepr CSeqEdit_Cmd_ChangeSeqAttr_Base::C_Data::GetRepr(void) const
{
    CheckSelected(e_Repr);
    return m_Repr;
}

inline
CSeqEdit_Cmd_ChangeSeqAttr_Base::C_Data::TRepr& CSeqEdit_Cmd_ChangeSeqAttr_Base::C_Data::SetRepr(void)
{
    Select(e_Repr, NCBI_NS_NCBI::eDoNotResetVariant);
    return m_Repr;
}

inline
void CSeqEdit_Cmd_ChangeSeqAttr_Base::C_Data::SetRepr(CSeqEdit_Cmd_ChangeSeqAttr_Base::C_Data::TRepr value)
{
    Select(e_Repr, NCBI_NS_NCBI::eDoNotResetVariant);
    m_Repr = value;
}

inline
bool CSeqEdit_Cmd_ChangeSeqAttr_Base::C_Data::IsMol(void) const
{
    return m_choice == e_Mol;
}

inline
CSeqEdit_Cmd_ChangeSeqAttr_Base::C_Data::TMol CSeqEdit_Cmd_ChangeSeqAttr_Base::C_Data::GetMol(void) const
{
    CheckSelected(e_Mol);
    return m_Mol;
}

inline
CSeqEdit_Cmd_ChangeSeqAttr_Base::C_Data::TMol& CSeqEdit_Cmd_ChangeSeqAttr_Base::C_Data::SetMol(void)
{
    Select(e_Mol, NCBI_NS_NCBI::eDoNotResetVariant);
    return m_Mol;
}

inline
void CSeqEdit_Cmd_ChangeSeqAttr_Base::C_Data::SetMol(CSeqEdit_Cmd_ChangeSeqAttr_Base::C_Data::TMol value)
{
    Select(e_Mol, NCBI_NS_NCBI::eDoNotResetVariant);
    m_Mol = value;
}

inline
bool CSeqEdit_Cmd_ChangeSeqAttr_Base::C_Data::IsLength(void) const
{
    return m_choice == e_Length;
}

inline
CSeqEdit_Cmd_ChangeSeqAttr_Base::C_Data::TLength CSeqEdit_Cmd_ChangeSeqAttr_Base::C_Data::GetLength(void) const
{
    CheckSelected(e_Length);
    return m_Length;
}

inline
CSeqEdit_Cmd_ChangeSeqAttr_Base::C_Data::TLength& CSeqEdit_Cmd_ChangeSeqAttr_Base::C_Data::SetLength(void)
{
    Select(e_Length, NCBI_NS_NCBI::eDoNotResetVariant);
    return m_Length;
}

inline
void CSeqEdit_Cmd_ChangeSeqAttr_Base::C_Data::SetLength(CSeqEdit_Cmd_ChangeSeqAttr_Base::C_Data::TLength value)
{
    Select(e_Length, NCBI_NS_NCBI::eDoNotResetVariant);
    m_Length = value;
}

inline
bool CSeqEdit_Cmd_ChangeSeqAttr_Base::C_Data::IsFuzz(void) const
{
    return m_choice == e_Fuzz;
}

inline
bool CSeqEdit_Cmd_ChangeSeqAttr_Base::C_Data::IsTopology(void) const
{
    return m_choice == e_Topology;
}

inline
CSeqEdit_Cmd_ChangeSeqAttr_Base::C_Data::TTopology CSeqEdit_Cmd_ChangeSeqAttr_Base::C_Data::GetTopology(void) const
{
    CheckSelected(e_Topology);
    return m_Topology;
}

inline
CSeqEdit_Cmd_ChangeSeqAttr_Base::C_Data::TTopology& CSeqEdit_Cmd_ChangeSeqAttr_Base::C_Data::SetTopology(void)
{
    Select(e_Topology, NCBI_NS_NCBI::eDoNotResetVariant);
    return m_Topology;
}

inline
void CSeqEdit_Cmd_ChangeSeqAttr_Base::C_Data::SetTopology(CSeqEdit_Cmd_ChangeSeqAttr_Base::C_Data::TTopology value)
{
    Select(e_Topology, NCBI_NS_NCBI::eDoNotResetVariant);
    m_Topology = value;
}

inline
bool CSeqEdit_Cmd_ChangeSeqAttr_Base::C_Data::IsStrand(void) const
{
    return m_choice == e_Strand;
}

inline
CSeqEdit_Cmd_ChangeSeqAttr_Base::C_Data::TStrand CSeqEdit_Cmd_ChangeSeqAttr_Base::C_Data::GetStrand(void) const
{
    CheckSelected(e_Strand);
    return m_Strand;
}

inline
CSeqEdit_Cmd_ChangeSeqAttr_Base::C_Data::TStrand& CSeqEdit_Cmd_ChangeSeqAttr_Base::C_Data::SetStrand(void)
{
    Select(e_Strand, NCBI_NS_NCBI::eDoNotResetVariant);
    return m_Strand;
}

inline
void CSeqEdit_Cmd_ChangeSeqAttr_Base::C_Data::SetStrand(CSeqEdit_Cmd_ChangeSeqAttr_Base::C_Data::TStrand value)
{
    Select(e_Strand, NCBI_NS_NCBI::eDoNotResetVariant);
    m_Strand = value;
}

inline
bool CSeqEdit_Cmd_ChangeSeqAttr_Base::C_Data::IsExt(void) const
{
    return m_choice == e_Ext;
}

inline
bool CSeqEdit_Cmd_ChangeSeqAttr_Base::C_Data::IsHist(void) const
{
    return m_choice == e_Hist;
}

inline
bool CSeqEdit_Cmd_ChangeSeqAttr_Base::C_Data::IsSeq_data(void) const
{
    return m_choice == e_Seq_data;
}

inline
bool CSeqEdit_Cmd_ChangeSeqAttr_Base::IsSetId(void) const
{
    return m_Id.NotEmpty();
}

inline
bool CSeqEdit_Cmd_ChangeSeqAttr_Base::CanGetId(void) const
{
    return true;
}

inline
const CSeqEdit_Cmd_ChangeSeqAttr_Base::TId& CSeqEdit_Cmd_ChangeSeqAttr_Base::GetId(void) const
{
    if ( !m_Id ) {
        const_cast<CSeqEdit_Cmd_ChangeSeqAttr_Base*>(this)->ResetId();
    }
    return (*m_Id);
}

inline
CSeqEdit_Cmd_ChangeSeqAttr_Base::TId& CSeqEdit_Cmd_ChangeSeqAttr_Base::SetId(void)
{
    if ( !m_Id ) {
        ResetId();
    }
    return (*m_Id);
}

inline
bool CSeqEdit_Cmd_ChangeSeqAttr_Base::IsSetData(void) const
{
    return m_Data.NotEmpty();
}

inline
bool CSeqEdit_Cmd_ChangeSeqAttr_Base::CanGetData(void) const
{
    return true;
}

inline
const CSeqEdit_Cmd_ChangeSeqAttr_Base::TData& CSeqEdit_Cmd_ChangeSeqAttr_Base::GetData(void) const
{
    if ( !m_Data ) {
        const_cast<CSeqEdit_Cmd_ChangeSeqAttr_Base*>(this)->ResetData();
    }
    return (*m_Data);
}

inline
CSeqEdit_Cmd_ChangeSeqAttr_Base::TData& CSeqEdit_Cmd_ChangeSeqAttr_Base::SetData(void)
{
    if ( !m_Data ) {
        ResetData();
    }
    return (*m_Data);
}

///////////////////////////////////////////////////////////
////////////////// end of inline methods //////////////////
///////////////////////////////////////////////////////////





END_objects_SCOPE // namespace ncbi::objects::

END_NCBI_SCOPE


#endif // OBJECTS_SEQEDIT_SEQEDIT_CMD_CHANGESEQATTR_BASE_HPP
