/* $Id$
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 */

/// @file Delta_item_.hpp
/// Data storage class.
///
/// This file was generated by application DATATOOL
/// using the following specifications:
/// 'seqfeat.asn'.
///
/// ATTENTION:
///   Don't edit or commit this file into CVS as this file will
///   be overridden (by DATATOOL) without warning!

#ifndef OBJECTS_SEQFEAT_DELTA_ITEM_BASE_HPP
#define OBJECTS_SEQFEAT_DELTA_ITEM_BASE_HPP

// standard includes
#include <serial/serialbase.hpp>
BEGIN_NCBI_SCOPE

#ifndef BEGIN_objects_SCOPE
#  define BEGIN_objects_SCOPE BEGIN_SCOPE(objects)
#  define END_objects_SCOPE END_SCOPE(objects)
#endif
BEGIN_objects_SCOPE // namespace ncbi::objects::


// forward declarations
class CInt_fuzz;
class CSeq_literal;
class CSeq_loc;


// generated classes

/////////////////////////////////////////////////////////////////////////////
class NCBI_SEQFEAT_EXPORT CDelta_item_Base : public CSerialObject
{
    typedef CSerialObject Tparent;
public:
    // constructor
    CDelta_item_Base(void);
    // destructor
    virtual ~CDelta_item_Base(void);

    // type info
    DECLARE_INTERNAL_TYPE_INFO();

    /////////////////////////////////////////////////////////////////////////////
    class NCBI_SEQFEAT_EXPORT C_Seq : public CSerialObject
    {
        typedef CSerialObject Tparent;
    public:
        // constructor
        C_Seq(void);
        // destructor
        ~C_Seq(void);
    
        // type info
        DECLARE_INTERNAL_TYPE_INFO();
    
    
        /// Choice variants.
        enum E_Choice {
            e_not_set = 0,  ///< No variant selected
            e_Literal,
            e_Loc,
            e_This          ///<same location as variation-ref itself
        };
        /// Maximum+1 value of the choice variant enumerator.
        enum E_ChoiceStopper {
            e_MaxChoice = 4 ///< == e_This+1
        };
    
        /// Reset the whole object
        void Reset(void);
    
        /// Reset the selection (set it to e_not_set).
        void ResetSelection(void);
    
        /// Which variant is currently selected.
        E_Choice Which(void) const;
    
        /// Verify selection, throw exception if it differs from the expected.
        void CheckSelected(E_Choice index) const;
    
        /// Throw 'InvalidSelection' exception.
        NCBI_NORETURN void ThrowInvalidSelection(E_Choice index) const;
    
        /// Retrieve selection name (for diagnostic purposes).
        static string SelectionName(E_Choice index);
    
        /// Select the requested variant if needed.
        void Select(E_Choice index, EResetVariant reset = eDoResetVariant);
        /// Select the requested variant if needed,
        /// allocating CObject variants from memory pool.
        void Select(E_Choice index,
                    EResetVariant reset,
                    CObjectMemoryPool* pool);
    
        // types
        typedef CSeq_literal TLiteral;
        typedef CSeq_loc TLoc;
    
        // getters
        // setters
    
        // typedef CSeq_literal TLiteral
        bool IsLiteral(void) const;
        const TLiteral& GetLiteral(void) const;
        TLiteral& SetLiteral(void);
        void SetLiteral(TLiteral& value);
    
        // typedef CSeq_loc TLoc
        bool IsLoc(void) const;
        const TLoc& GetLoc(void) const;
        TLoc& SetLoc(void);
        void SetLoc(TLoc& value);
    
    
        bool IsThis(void) const;
        void SetThis(void);
    
    
    private:
        // copy constructor and assignment operator
        C_Seq(const C_Seq& );
        C_Seq& operator=(const C_Seq& );
        // choice state
        E_Choice m_choice;
        // helper methods
        void DoSelect(E_Choice index, CObjectMemoryPool* pool = 0);
    
        static const char* const sm_SelectionNames[];
        // data
        union {
            NCBI_NS_NCBI::CSerialObject *m_object;
        };
    };
    enum EAction {
        eAction_morph      = 0,  ///< replace len(seq) positions starting with location.start with seq
        eAction_offset     = 1,  ///< go downstream by distance specified by multiplier (upstream if < 0),  in genomic context.
        eAction_del_at     = 2,  ///< excise sequence at location  if multiplier is specified, delete len(location)*multiplier  positions downstream
        eAction_ins_before = 3  ///< insert seq before the location.start
    };
    
    /// Access to EAction's attributes (values, names) as defined in spec
    static const NCBI_NS_NCBI::CEnumeratedTypeValues* ENUM_METHOD_NAME(EAction)(void);
    
    // types
    typedef C_Seq TSeq;
    typedef int TMultiplier;
    typedef CInt_fuzz TMultiplier_fuzz;
    typedef int TAction;

    // member index
    enum class E_memberIndex {
        e__allMandatory = 0,
        e_seq,
        e_multiplier,
        e_multiplier_fuzz,
        e_action
    };
    typedef Tparent::CMemberIndex<E_memberIndex, 5> TmemberIndex;

    // getters
    // setters

    /// optional
    /// typedef C_Seq TSeq
    ///  Check whether the Seq data member has been assigned a value.
    bool IsSetSeq(void) const;
    /// Check whether it is safe or not to call GetSeq method.
    bool CanGetSeq(void) const;
    void ResetSeq(void);
    const TSeq& GetSeq(void) const;
    void SetSeq(TSeq& value);
    TSeq& SetSeq(void);

    /// Multiplier allows representing a tandem, e.g.  ATATAT as AT*3
    /// This allows describing CNV/SSR where delta=self  with a
    /// multiplier which specifies the count of the repeat unit.
    ///assumed 1 if not specified.
    /// optional
    /// typedef int TMultiplier
    ///  Check whether the Multiplier data member has been assigned a value.
    bool IsSetMultiplier(void) const;
    /// Check whether it is safe or not to call GetMultiplier method.
    bool CanGetMultiplier(void) const;
    void ResetMultiplier(void);
    TMultiplier GetMultiplier(void) const;
    void SetMultiplier(TMultiplier value);
    TMultiplier& SetMultiplier(void);

    /// optional
    /// typedef CInt_fuzz TMultiplier_fuzz
    ///  Check whether the Multiplier_fuzz data member has been assigned a value.
    bool IsSetMultiplier_fuzz(void) const;
    /// Check whether it is safe or not to call GetMultiplier_fuzz method.
    bool CanGetMultiplier_fuzz(void) const;
    void ResetMultiplier_fuzz(void);
    const TMultiplier_fuzz& GetMultiplier_fuzz(void) const;
    void SetMultiplier_fuzz(TMultiplier_fuzz& value);
    TMultiplier_fuzz& SetMultiplier_fuzz(void);

    /// optional with default eAction_morph
    /// typedef int TAction
    ///  Check whether the Action data member has been assigned a value.
    bool IsSetAction(void) const;
    /// Check whether it is safe or not to call GetAction method.
    bool CanGetAction(void) const;
    void ResetAction(void);
    void SetDefaultAction(void);
    TAction GetAction(void) const;
    void SetAction(TAction value);
    TAction& SetAction(void);

    /// Reset the whole object
    virtual void Reset(void);


private:
    // Prohibit copy constructor and assignment operator
    CDelta_item_Base(const CDelta_item_Base&);
    CDelta_item_Base& operator=(const CDelta_item_Base&);

    // data
    Uint4 m_set_State[1];
    CRef< TSeq > m_Seq;
    int m_Multiplier;
    CRef< TMultiplier_fuzz > m_Multiplier_fuzz;
    int m_Action;
};






///////////////////////////////////////////////////////////
///////////////////// inline methods //////////////////////
///////////////////////////////////////////////////////////
inline
CDelta_item_Base::C_Seq::E_Choice CDelta_item_Base::C_Seq::Which(void) const
{
    return m_choice;
}

inline
void CDelta_item_Base::C_Seq::CheckSelected(E_Choice index) const
{
    if ( m_choice != index )
        ThrowInvalidSelection(index);
}

inline
void CDelta_item_Base::C_Seq::Select(E_Choice index, NCBI_NS_NCBI::EResetVariant reset, NCBI_NS_NCBI::CObjectMemoryPool* pool)
{
    if ( reset == NCBI_NS_NCBI::eDoResetVariant || m_choice != index ) {
        if ( m_choice != e_not_set )
            ResetSelection();
        DoSelect(index, pool);
    }
}

inline
void CDelta_item_Base::C_Seq::Select(E_Choice index, NCBI_NS_NCBI::EResetVariant reset)
{
    Select(index, reset, 0);
}

inline
bool CDelta_item_Base::C_Seq::IsLiteral(void) const
{
    return m_choice == e_Literal;
}

inline
bool CDelta_item_Base::C_Seq::IsLoc(void) const
{
    return m_choice == e_Loc;
}

inline
bool CDelta_item_Base::C_Seq::IsThis(void) const
{
    return m_choice == e_This;
}

inline
void CDelta_item_Base::C_Seq::SetThis(void)
{
    Select(e_This, NCBI_NS_NCBI::eDoNotResetVariant);
}

inline
bool CDelta_item_Base::IsSetSeq(void) const
{
    return m_Seq.NotEmpty();
}

inline
bool CDelta_item_Base::CanGetSeq(void) const
{
    return IsSetSeq();
}

inline
const CDelta_item_Base::TSeq& CDelta_item_Base::GetSeq(void) const
{
    if (!CanGetSeq()) {
        ThrowUnassigned(0);
    }
    return (*m_Seq);
}

inline
bool CDelta_item_Base::IsSetMultiplier(void) const
{
    return ((m_set_State[0] & 0xc) != 0);
}

inline
bool CDelta_item_Base::CanGetMultiplier(void) const
{
    return IsSetMultiplier();
}

inline
void CDelta_item_Base::ResetMultiplier(void)
{
    m_Multiplier = 0;
    m_set_State[0] &= ~0xc;
}

inline
CDelta_item_Base::TMultiplier CDelta_item_Base::GetMultiplier(void) const
{
    if (!CanGetMultiplier()) {
        ThrowUnassigned(1);
    }
    return m_Multiplier;
}

inline
void CDelta_item_Base::SetMultiplier(CDelta_item_Base::TMultiplier value)
{
    m_Multiplier = value;
    m_set_State[0] |= 0xc;
}

inline
CDelta_item_Base::TMultiplier& CDelta_item_Base::SetMultiplier(void)
{
#ifdef _DEBUG
    if (!IsSetMultiplier()) {
        memset(&m_Multiplier,UnassignedByte(),sizeof(m_Multiplier));
    }
#endif
    m_set_State[0] |= 0x4;
    return m_Multiplier;
}

inline
bool CDelta_item_Base::IsSetMultiplier_fuzz(void) const
{
    return m_Multiplier_fuzz.NotEmpty();
}

inline
bool CDelta_item_Base::CanGetMultiplier_fuzz(void) const
{
    return IsSetMultiplier_fuzz();
}

inline
const CDelta_item_Base::TMultiplier_fuzz& CDelta_item_Base::GetMultiplier_fuzz(void) const
{
    if (!CanGetMultiplier_fuzz()) {
        ThrowUnassigned(2);
    }
    return (*m_Multiplier_fuzz);
}

inline
bool CDelta_item_Base::IsSetAction(void) const
{
    return ((m_set_State[0] & 0xc0) != 0);
}

inline
bool CDelta_item_Base::CanGetAction(void) const
{
    return true;
}

inline
void CDelta_item_Base::ResetAction(void)
{
    m_Action = eAction_morph;
    m_set_State[0] &= ~0xc0;
}

inline
void CDelta_item_Base::SetDefaultAction(void)
{
    ResetAction();
}

inline
CDelta_item_Base::TAction CDelta_item_Base::GetAction(void) const
{
    return m_Action;
}

inline
void CDelta_item_Base::SetAction(CDelta_item_Base::TAction value)
{
    m_Action = value;
    m_set_State[0] |= 0xc0;
}

inline
CDelta_item_Base::TAction& CDelta_item_Base::SetAction(void)
{
#ifdef _DEBUG
    if (!IsSetAction()) {
        memset(&m_Action,UnassignedByte(),sizeof(m_Action));
    }
#endif
    m_set_State[0] |= 0x40;
    return m_Action;
}

///////////////////////////////////////////////////////////
////////////////// end of inline methods //////////////////
///////////////////////////////////////////////////////////





END_objects_SCOPE // namespace ncbi::objects::

END_NCBI_SCOPE


#endif // OBJECTS_SEQFEAT_DELTA_ITEM_BASE_HPP
